/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.util;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneDvr;
import com.tridium.nmilestone.messages.MilestoneCameraGetTimeRequest;
import com.tridium.nmilestone.messages.MilestoneVideoStreamReq;
import com.tridium.nmilestone.util.MilestoneHttpUtil;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import org.baja.ffmpeg.enums.BCodecIdEnum;

public class MilestoneVideoStreamUtil {
    public static void sendStreamRequest(NMessage nMessage, BMilestoneCamera bMilestoneCamera, BMilestoneDvr bMilestoneDvr) {
        if (!bMilestoneCamera.getEnabled()) {
            return;
        }
        if (nMessage instanceof MilestoneVideoStreamReq) {
            try {
                MilestoneVideoStreamUtil.establishVideoFeed((MilestoneVideoStreamReq)nMessage, bMilestoneDvr, bMilestoneCamera);
            }
            catch (Exception exception) {
                System.out.println("Unable to establish Milestone live video feed.");
                exception.printStackTrace();
            }
        } else if (nMessage instanceof MilestoneCameraGetTimeRequest) {
            try {
                MilestoneVideoStreamUtil.determineCameraTime((MilestoneCameraGetTimeRequest)nMessage, bMilestoneDvr, bMilestoneCamera);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void establishVideoFeed(MilestoneVideoStreamReq milestoneVideoStreamReq, BMilestoneDvr bMilestoneDvr, BMilestoneCamera bMilestoneCamera) throws Exception {
        Object object;
        try {
            if (bMilestoneDvr != null) {
                object = new EstablishVideoConnection(milestoneVideoStreamReq, bMilestoneCamera);
                ((Thread)object).start();
                ((Thread)object).join(30000L);
                if (((Thread)object).isAlive()) {
                    ((Thread)object).interrupt();
                }
                if (((EstablishVideoConnection)object).success) {
                    milestoneVideoStreamReq.setVideoSocket(((EstablishVideoConnection)object).liveVideoSocket);
                } else {
                    milestoneVideoStreamReq.getVideoDestination().videoStreamTimeout();
                    if (((EstablishVideoConnection)object).liveVideoSocket != null) {
                        ((EstablishVideoConnection)object).liveVideoSocket.close();
                    }
                }
            }
        }
        finally {
            object = milestoneVideoStreamReq;
            synchronized (object) {
                ((Object)((Object)milestoneVideoStreamReq)).notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void determineCameraTime(MilestoneCameraGetTimeRequest milestoneCameraGetTimeRequest, BMilestoneDvr bMilestoneDvr, BMilestoneCamera bMilestoneCamera) throws Exception {
        Object object;
        try {
            if (bMilestoneDvr != null) {
                milestoneCameraGetTimeRequest.setVideoSource((BIVideoSource)bMilestoneCamera);
                milestoneCameraGetTimeRequest.setPlaybackParams(new BPlaybackParams());
                object = new GetCameraTimeHack(milestoneCameraGetTimeRequest, bMilestoneCamera);
                ((Thread)object).start();
                ((Thread)object).join(30000L);
                if (((Thread)object).isAlive()) {
                    ((Thread)object).interrupt();
                }
                ((GetCameraTimeHack)object).liveVideoSocket.close();
            }
        }
        finally {
            object = milestoneCameraGetTimeRequest;
            synchronized (object) {
                ((Object)((Object)milestoneCameraGetTimeRequest)).notifyAll();
            }
        }
    }

    public static class GetCameraTimeHack
    extends EstablishVideoConnection {
        MilestoneCameraGetTimeRequest getMilestoneCameraTimeReq;

        public GetCameraTimeHack(MilestoneCameraGetTimeRequest milestoneCameraGetTimeRequest, BMilestoneCamera bMilestoneCamera) {
            super(milestoneCameraGetTimeRequest, bMilestoneCamera);
            this.getMilestoneCameraTimeReq = milestoneCameraGetTimeRequest;
        }

        protected void establishTcpConnection() throws IOException {
            super.establishTcpConnection();
        }

        protected boolean receiveMilestoneVideoRsp() throws IOException {
            String string = this.readLineFromSocket();
            try {
                ByteBuffer byteBuffer = new ByteBuffer(string.getBytes(), string.getBytes().length);
                XElem xElem = MilestoneReqUtil.getElem(byteBuffer.getInputStream(), "livepackage");
                XElem xElem2 = MilestoneReqUtil.getElem(xElem, "status");
                String string2 = MilestoneReqUtil.getText(xElem2, "statustime");
                this.getMilestoneCameraTimeReq.setCameraTime(string2);
                this.liveVideoSocket.close();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class EstablishVideoConnection
    extends Thread {
        MilestoneVideoStreamReq videoStreamReq;
        public BMilestoneDvr dvr;
        public BMilestoneCamera milestoneCamera;
        Socket liveVideoSocket;
        OutputStream tcpOut;
        InputStream tcpIn;
        public boolean success;

        public EstablishVideoConnection(MilestoneVideoStreamReq milestoneVideoStreamReq, BMilestoneCamera bMilestoneCamera) {
            super("LiveVideo.Camera" + milestoneVideoStreamReq.getMilestoneCameraId());
            this.videoStreamReq = milestoneVideoStreamReq;
            this.dvr = bMilestoneCamera.getMilestoneDvr();
            this.milestoneCamera = bMilestoneCamera;
        }

        protected void establishTcpConnection() throws IOException {
            this.dvr.lease(2);
            this.liveVideoSocket = new Socket(this.dvr.getMilestoneEngineIpAddress(), this.dvr.getMilestoneImageServerPort());
            this.tcpOut = this.liveVideoSocket.getOutputStream();
            this.tcpIn = this.liveVideoSocket.getInputStream();
        }

        protected void sendMilestoneConnectReq() throws IOException {
            boolean bl = this.videoStreamReq.getPlaybackParams().getCompression() != BVideoCompressionEnum.high && this.videoStreamReq.getPlaybackParams().getPlaybackType() != BPlaybackTypeEnum.live || this.milestoneCamera.getHighCompressionCodec() == BCodecIdEnum.ffmpeg_CODEC_ID_NONE;
            String string = this.videoStreamReq.getLiveConnectXml(this.dvr.getCredentials().getUsername(), this.dvr.getCredentials().getPassword().getString(), bl);
            this.tcpOut.write(string.getBytes());
            this.tcpOut.flush();
        }

        protected boolean receiveMilestoneConnectReply() throws Exception {
            XParser xParser = XParser.make((InputStream)this.tcpIn);
            XElem xElem = xParser.parse(false);
            if (xElem != null) {
                return MilestoneHttpUtil.receiveMilestoneConnectReply(xElem);
            }
            throw new IllegalStateException("No reply from ImageServer!");
        }

        protected void sendMilestoneVideoReq() throws IOException {
            byte[] byArray = this.videoStreamReq.toByteArray();
            this.tcpOut.write(byArray);
            this.tcpOut.flush();
        }

        protected String readLineFromSocket() throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = -1;
            while (!bl) {
                int n2 = this.tcpIn.read();
                if (n2 == -1) {
                    bl = true;
                    continue;
                }
                stringBuffer.append((char)n2);
                bl = n2 == 10 && n == 13;
                n = n2;
            }
            String string = stringBuffer.toString();
            if (string.length() > 2) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }

        protected boolean receiveMilestoneVideoRsp() throws IOException {
            String string = this.readLineFromSocket();
            while (string != null && string.length() > 0 && !"ImageResponse".equals(string)) {
                string = this.readLineFromSocket();
            }
            return true;
        }

        public void run() {
            try {
                this.establishTcpConnection();
                this.sendMilestoneConnectReq();
                this.receiveMilestoneConnectReply();
                this.sendMilestoneVideoReq();
                this.success = this.receiveMilestoneVideoRsp();
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
            catch (Exception exception) {
                this.success = false;
                exception.printStackTrace();
            }
        }
    }
}

