/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.util;

import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneCameraDiscoveryLeaf;
import com.tridium.nmilestone.util.BMilestoneImageServerUserNameAndPassword;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.util.EscUtil;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XElem;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

public class MilestoneHttpUtil {
    static /* synthetic */ Class class$com$tridium$nmilestone$BMilestoneCameraDiscoveryLeaf;

    public static void getDvrStatus(HttpComm httpComm, BIpAddress bIpAddress, BMilestoneImageServerUserNameAndPassword bMilestoneImageServerUserNameAndPassword) throws Exception {
        String string = "/systeminfo.xml";
        NHttpResponse nHttpResponse = MilestoneHttpUtil.get(httpComm, bIpAddress, string, bMilestoneImageServerUserNameAndPassword);
        byte[] byArray = nHttpResponse.getData();
        ByteBuffer byteBuffer = new ByteBuffer(byArray, byArray.length);
        try {
            boolean bl = false;
            XElem xElem = MilestoneReqUtil.getMilestoneMethodResponseElem(byteBuffer.getInputStream());
            XElem xElem2 = MilestoneReqUtil.getElem(xElem, "engines");
            XElem[] xElemArray = xElem2.elems("engine");
            for (int i = 0; i < xElemArray.length; ++i) {
                XElem xElem3 = xElemArray[i];
                XElem xElem4 = xElem3.elem("cameras");
                if (xElem4 == null) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new Exception("DVR is not reachable.");
            }
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static void getCamStatus(BMilestoneCamera bMilestoneCamera, HttpComm httpComm, BIpAddress bIpAddress, BMilestoneImageServerUserNameAndPassword bMilestoneImageServerUserNameAndPassword) throws Exception {
        String string = "/systeminfo.xml";
        NHttpResponse nHttpResponse = MilestoneHttpUtil.get(httpComm, bIpAddress, string, bMilestoneImageServerUserNameAndPassword);
        String string2 = bMilestoneCamera.getCameraId();
        byte[] byArray = nHttpResponse.getData();
        ByteBuffer byteBuffer = new ByteBuffer(byArray, byArray.length);
        try {
            boolean bl = false;
            XElem xElem = MilestoneReqUtil.getMilestoneMethodResponseElem(byteBuffer.getInputStream());
            XElem xElem2 = MilestoneReqUtil.getElem(xElem, "engines");
            XElem[] xElemArray = xElem2.elems("engine");
            block2: for (int i = 0; i < xElemArray.length; ++i) {
                XElem xElem3 = xElemArray[i];
                XElem xElem4 = xElem3.elem("cameras");
                if (xElem4 == null) continue;
                XElem[] xElemArray2 = xElem4.elems("camera");
                for (int j = 0; j < xElemArray2.length; ++j) {
                    String string3;
                    String string4 = string3 = xElemArray2[j].get("cameraid");
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    bl = true;
                    bMilestoneCamera.setMilestoneDatabaseId(string4);
                    String string5 = MilestoneReqUtil.getText(xElemArray2[j], "guid");
                    if (string5 != null && string5.length() > 0) {
                        bMilestoneCamera.setMilestoneGuid(string5);
                    }
                    if (!bMilestoneCamera.getAutoSetPtzSupport()) break block2;
                    MilestoneHttpUtil.configureCameraControls(bMilestoneCamera, xElemArray2[j]);
                    break block2;
                }
            }
            if (!bl) {
                throw new Exception("Camera id does not exist in Milestone ImageServer: " + string2);
            }
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static void configureCameraControls(BMilestoneCamera bMilestoneCamera, XElem xElem) {
        String[] stringArray;
        Object object;
        BVideoCameraInfo bVideoCameraInfo = bMilestoneCamera.getCameraInfo();
        bVideoCameraInfo.setSupportsFocus(false);
        bVideoCameraInfo.setSupportsIris(false);
        bVideoCameraInfo.setSupportsStorePreset(false);
        XElem xElem2 = xElem.elem("ptz");
        XElem xElem3 = xElem.elem("userrights");
        XElem xElem4 = xElem.elem("presets");
        if (xElem4 != null && (object = xElem4.elems("preset")) != null && ((XElem[])object).length > 0) {
            stringArray = new String[((XElem[])object).length];
            for (int i = 0; i < ((XElem[])object).length; ++i) {
                stringArray[i] = EscUtil.slot.escape(MilestoneReqUtil.getText(object[i]));
            }
            bMilestoneCamera.setPresetText(BEnumRange.make((String[])stringArray));
        }
        if (xElem2 != null && xElem3 != null) {
            object = MilestoneReqUtil.getText(xElem3, "ptz");
            stringArray = MilestoneReqUtil.getText(xElem2, "pan");
            String string = MilestoneReqUtil.getText(xElem2, "tilt");
            String string2 = MilestoneReqUtil.getText(xElem2, "zoom");
            if ("yes".equals(object)) {
                bVideoCameraInfo.setSupportsPanTilt(!"none".equals(stringArray) && !"none".equals(string));
                bVideoCameraInfo.setSupportsZoom(!"none".equals(string2));
            } else {
                bVideoCameraInfo.setSupportsPanTilt(false);
                bVideoCameraInfo.setSupportsZoom(false);
            }
        }
    }

    public static BMilestoneCameraDiscoveryLeaf[] discoverCameras(HttpComm httpComm, BIpAddress bIpAddress, BMilestoneImageServerUserNameAndPassword bMilestoneImageServerUserNameAndPassword) throws Exception {
        String string = "/systeminfo.xml";
        NHttpResponse nHttpResponse = MilestoneHttpUtil.get(httpComm, bIpAddress, string, bMilestoneImageServerUserNameAndPassword);
        byte[] byArray = nHttpResponse.getData();
        ByteBuffer byteBuffer = new ByteBuffer(byArray, byArray.length);
        Array array = new Array(class$com$tridium$nmilestone$BMilestoneCameraDiscoveryLeaf == null ? (class$com$tridium$nmilestone$BMilestoneCameraDiscoveryLeaf = MilestoneHttpUtil.class$("com.tridium.nmilestone.BMilestoneCameraDiscoveryLeaf")) : class$com$tridium$nmilestone$BMilestoneCameraDiscoveryLeaf);
        XElem xElem = MilestoneReqUtil.getMilestoneMethodResponseElem(byteBuffer.getInputStream());
        String string2 = MilestoneReqUtil.getText(xElem, "userok");
        if ("yes".equals(string2)) {
            XElem xElem2 = MilestoneReqUtil.getElem(xElem, "engines");
            XElem[] xElemArray = xElem2.elems("engine");
            for (int i = 0; i < xElemArray.length; ++i) {
                XElem xElem3 = xElemArray[i];
                XElem xElem4 = xElem3.elem("cameras");
                if (xElem4 == null) continue;
                XElem[] xElemArray2 = xElem4.elems("camera");
                for (int j = 0; j < xElemArray2.length; ++j) {
                    String string3;
                    String string4 = string3 = xElemArray2[j].get("cameraid");
                    BMilestoneCameraDiscoveryLeaf bMilestoneCameraDiscoveryLeaf = new BMilestoneCameraDiscoveryLeaf();
                    bMilestoneCameraDiscoveryLeaf.getId().setCameraId(string3);
                    bMilestoneCameraDiscoveryLeaf.getId().setDescription(string4);
                    array.add((Object)bMilestoneCameraDiscoveryLeaf);
                }
            }
        } else {
            throw new Exception("Milestone ImageServer denied the Username and/or Password.");
        }
        BMilestoneCameraDiscoveryLeaf[] bMilestoneCameraDiscoveryLeafArray = (BMilestoneCameraDiscoveryLeaf[])array.trim();
        return bMilestoneCameraDiscoveryLeafArray;
    }

    public static long getControlTimeStampUtc(BPlaybackParams bPlaybackParams) {
        BAbsTime bAbsTime = null;
        long l = -1L;
        if (!bPlaybackParams.getTimeIndex().isNull()) {
            bAbsTime = bPlaybackParams.getTimeIndex();
            l = bAbsTime.getMillis() / 1000L;
        }
        return l;
    }

    public static NHttpResponse get(HttpComm httpComm, BIpAddress bIpAddress, String string, BMilestoneImageServerUserNameAndPassword bMilestoneImageServerUserNameAndPassword) throws Exception {
        String string2 = "GET";
        NHttpRequest nHttpRequest = new NHttpRequest(bIpAddress, string2, string);
        nHttpRequest.addBasicAuthorization(bMilestoneImageServerUserNameAndPassword.getUsername(), bMilestoneImageServerUserNameAndPassword.getPassword().getString());
        nHttpRequest.setAddress((BAddress)bIpAddress);
        return httpComm.sendRequest(nHttpRequest);
    }

    public static boolean receiveMilestoneConnectReply(XElem xElem) throws IOException {
        String string = xElem.name();
        if (string.equals("methodresponse")) {
            XElem xElem2 = xElem.elem("connected");
            if (xElem2 != null) {
                XText xText = xElem2.text();
                if (xText != null) {
                    String string2 = xText.string();
                    if (string2.equals("yes")) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
                        xElem.write(xWriter, 2);
                        xWriter.flush();
                        return true;
                    }
                    if (string2.equals("no")) {
                        throw new BajaRuntimeException("ImageServer connection was denied.");
                    }
                    throw new IllegalStateException("Unrecognized ImageServer connection string in reply: " + string2);
                }
                throw new IllegalStateException("No text inside <connected>...</connected> elem!");
            }
            throw new IllegalStateException("No <connected>...</connected> elem under <methodresposne>...</methodresponse>!");
        }
        throw new IllegalStateException("Expected <methodresponse> reply from ImageServer but received <" + string + "> instead!");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

