/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.messages;

import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.event.BMilestoneEventPointId;
import com.tridium.nmilestone.messages.MilestoneCameraConnectReq;
import com.tridium.nmilestone.messages.MilestoneReq;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BRetrieveActionParam;
import com.tridium.videoDriver.event.BVideoEvent;
import java.io.InputStream;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class MilestoneEventRefreshReq
extends MilestoneReq {
    protected BVideoEvent[] milestoneEvents;
    protected MilestoneCameraConnectReq cameraConnectReq;
    protected long earlierTime = -1L;
    protected long laterTime = -1L;
    protected long dbEarliestTime = -1L;
    public static final long ONE_HOUR = 3600000L;
    protected Array alarmsSoFar = new Array(class$com$tridium$videoDriver$event$BVideoEvent == null ? (class$com$tridium$videoDriver$event$BVideoEvent = MilestoneEventRefreshReq.class$("com.tridium.videoDriver.event.BVideoEvent")) : class$com$tridium$videoDriver$event$BVideoEvent);
    protected BRetrieveActionParam retrieveActionParam;
    static /* synthetic */ Class class$com$tridium$videoDriver$event$BVideoEvent;

    public void processReceiveEvents(InputStream inputStream) throws Exception {
        int n = this.alarmsSoFar.size() > 20 ? 20 : this.alarmsSoFar.size();
        BVideoEvent[] bVideoEventArray = new BVideoEvent[n];
        for (int i = 0; i < n; ++i) {
            bVideoEventArray[i] = (BVideoEvent)this.alarmsSoFar.get(i);
        }
    }

    public boolean isResponse() {
        return false;
    }

    public Object getTag() {
        return "EventRefresh";
    }

    public void fromInputStream(InputStream inputStream) throws Exception {
        long l = MilestoneEventRefreshReq.getEarliestTime(inputStream);
        long l2 = MilestoneEventRefreshReq.getLatestTime(inputStream);
        System.out.println("Earliest in db = " + BAbsTime.make((long)l));
        System.out.println("Latest in db = " + BAbsTime.make((long)l2));
        this.alarmsSoFar.addAll((Object[])MilestoneEventRefreshReq.getEventsFor(inputStream));
        if (this.alarmsSoFar.size() >= 20 || this.getRetrieveActionParam().getNumEvents() < 0 && this.earlierTime < l || this.getRetrieveActionParam().getNumEvents() > 0 && this.laterTime > l2) {
            this.processReceiveEvents(inputStream);
        }
    }

    public byte[] toByteArray() {
        this.laterTime = this.laterTime == -1L ? (this.getRetrieveActionParam().getNumEvents() < 0 ? this.getRetrieveActionParam().getTimeIndex().getMillis() : this.getRetrieveActionParam().getTimeIndex().getMillis() + 3600000L) : (this.getRetrieveActionParam().getNumEvents() < 0 ? (this.laterTime -= 3600000L) : (this.laterTime += 3600000L));
        this.earlierTime = this.laterTime - 3600000L;
        System.out.println("earlierTime = " + BAbsTime.make((long)this.earlierTime));
        System.out.println("laterTime   = " + BAbsTime.make((long)this.laterTime));
        return new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodcall><requestid>" + BMilestoneCamera.getNextVideoRequestId() + "</requestid>" + "<methodname>alarms</methodname>" + "<starttime>" + this.earlierTime + "</starttime>" + "<stoptime>" + this.laterTime + "</stoptime>" + "</methodcall>\r\n\r\n").getBytes();
    }

    public static long getLatestTime(InputStream inputStream) throws Exception {
        XElem xElem = MilestoneReqUtil.getMilestoneMethodResponseElem(inputStream);
        String string = MilestoneReqUtil.getText(xElem, "methodname");
        if (string.length() > 0) {
            if ("alarms".equals(string)) {
                XElem xElem2 = MilestoneReqUtil.getElem(xElem, "dblimit");
                try {
                    return xElem2.getl("endTime");
                }
                catch (XException xException) {
                    throw new Exception(xException);
                }
            }
            throw new Exception("<methodname>...</methodname> text = " + string + " expected \"getalarmsaround\"");
        }
        throw new Exception("No <methodname>...</methodname> in reply.");
    }

    public static long getEarliestTime(InputStream inputStream) throws Exception {
        XElem xElem = MilestoneReqUtil.getMilestoneMethodResponseElem(inputStream);
        String string = MilestoneReqUtil.getText(xElem, "methodname");
        if (string.length() > 0) {
            if ("alarms".equals(string)) {
                XElem xElem2 = MilestoneReqUtil.getElem(xElem, "dblimit");
                try {
                    return xElem2.getl("startTime");
                }
                catch (XException xException) {
                    throw new Exception(xException);
                }
            }
            throw new Exception("<methodname>...</methodname> text = " + string + " expected \"getalarmsaround\"");
        }
        throw new Exception("No <methodname>...</methodname> in reply.");
    }

    public static BVideoEvent[] getEventsFor(InputStream inputStream) throws Exception {
        XElem xElem = MilestoneReqUtil.getMilestoneMethodResponseElem(inputStream);
        String string = MilestoneReqUtil.getText(xElem, "methodname");
        if (string.length() > 0) {
            if ("alarms".equals(string)) {
                XElem xElem2 = MilestoneReqUtil.getElem(xElem, "alarms");
                XElem[] xElemArray = xElem2.elems("alarm");
                if (xElemArray == null || xElemArray.length == 0) {
                    return new BVideoEvent[0];
                }
                BVideoEvent[] bVideoEventArray = new BVideoEvent[xElemArray.length];
                for (int i = 0; i < xElemArray.length; ++i) {
                    bVideoEventArray[i] = BVideoEvent.makeOffNormalEvent();
                    bVideoEventArray[i].setDescription(BMilestoneEventPointId.LEX.getText("MilestoneRecording"));
                    bVideoEventArray[i].setEventType(BVideoEventTypesEnum.customEvent);
                    try {
                        long l = xElemArray[i].getl("startTime");
                        long l2 = xElemArray[i].getl("alarmTime");
                        long l3 = xElemArray[i].getl("endTime");
                        bVideoEventArray[i].setTimestamp(BAbsTime.make((long)l));
                        bVideoEventArray[i].setMetaData(BFacets.make((String)"milestoneStartTime", (BIDataValue)BLong.make((long)l), (String)"milestoneAlarmTime", (BIDataValue)BLong.make((long)l2), (String)"milestoneEndTime", (BIDataValue)BLong.make((long)l3)));
                        continue;
                    }
                    catch (XException xException) {
                        xException.printStackTrace();
                    }
                }
                return bVideoEventArray;
            }
            throw new Exception("<methodname>...</methodname> text = " + string + " expected \"getalarmsaround\"");
        }
        throw new Exception("No <methodname>...</methodname> in reply.");
    }

    public BVideoEvent[] getVideoEvents() {
        return this.milestoneEvents;
    }

    public byte[] getBytes() {
        return this.toByteArray();
    }

    public boolean isComplete() {
        return false;
    }

    public BRetrieveActionParam getRetrieveActionParam() {
        return this.retrieveActionParam;
    }

    public void setRetrieveActionParam(BRetrieveActionParam bRetrieveActionParam) {
        this.retrieveActionParam = bRetrieveActionParam;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

