/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.messages;

import com.tridium.nmilestone.event.BMilestoneEventPointId;
import com.tridium.nmilestone.messages.MilestoneEventRefreshAroundReq;
import com.tridium.nmilestone.messages.MilestoneRsp;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Comparator;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class MilestoneEventRefreshAroundRsp
extends MilestoneRsp {
    protected BVideoEvent[] videoEvents;
    protected int numEvents;
    InputStream in;

    public MilestoneEventRefreshAroundRsp(InputStream inputStream) {
        this.in = inputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fromInputStream(int n) throws Exception {
        int n2 = Math.abs(n);
        Object[] objectArray = this.getEventsFor(this.in);
        SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                BVideoEvent bVideoEvent = (BVideoEvent)object;
                BVideoEvent bVideoEvent2 = (BVideoEvent)object2;
                return bVideoEvent.getTimestamp().compareTo((Object)bVideoEvent2.getTimestamp());
            }
        });
        if (objectArray.length > n2) {
            if (n > 0) {
                this.videoEvents = new BVideoEvent[n];
                System.arraycopy(objectArray, objectArray.length - n - 1, this.videoEvents, 0, n);
                return;
            } else {
                if (n >= 0) throw new IllegalStateException("Assummed that numEvents would not be = 0. ");
                this.videoEvents = new BVideoEvent[n2];
                System.arraycopy(objectArray, 0, this.videoEvents, 0, n2);
            }
            return;
        } else {
            this.videoEvents = objectArray;
        }
    }

    public Object getTag() {
        return MilestoneEventRefreshAroundReq.EVENT_REFRESH_OBJ;
    }

    public BVideoEvent[] getVideoEvents() {
        return this.videoEvents;
    }

    public BVideoEvent[] getEventsFor(InputStream inputStream) throws Exception {
        inputStream.reset();
        byte[] byArray = new byte[inputStream.available()];
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            inputStream.read(byArray);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        XElem xElem = MilestoneReqUtil.getMilestoneMethodResponseElem(byteArrayInputStream);
        String string = MilestoneReqUtil.getText(xElem, "methodname");
        if (string.length() > 0) {
            if ("alarms".equals(string)) {
                XElem xElem2 = MilestoneReqUtil.getElem(xElem, "alarms");
                XElem[] xElemArray = xElem2.elems("alarm");
                if (xElemArray == null || xElemArray.length == 0) {
                    return new BVideoEvent[0];
                }
                BVideoEvent[] bVideoEventArray = new BVideoEvent[xElemArray.length];
                for (int i = 0; i < xElemArray.length; ++i) {
                    bVideoEventArray[i] = BVideoEvent.makeOffNormalEvent();
                    bVideoEventArray[i].setDescription(BMilestoneEventPointId.LEX.getText("MilestoneRecording"));
                    bVideoEventArray[i].setEventType(BVideoEventTypesEnum.customEvent);
                    try {
                        long l = xElemArray[i].getl("startTime");
                        long l2 = xElemArray[i].getl("alarmTime");
                        long l3 = xElemArray[i].getl("endTime");
                        bVideoEventArray[i].setTimestamp(BAbsTime.make((long)l));
                        bVideoEventArray[i].setMetaData(BFacets.make((String)"milestoneStartTime", (BIDataValue)BLong.make((long)l), (String)"milestoneAlarmTime", (BIDataValue)BLong.make((long)l2), (String)"milestoneEndTime", (BIDataValue)BLong.make((long)l3)));
                        continue;
                    }
                    catch (XException xException) {
                        xException.printStackTrace();
                    }
                }
                return bVideoEventArray;
            }
            throw new Exception("<methodname>...</methodname> text = " + string + " expected \"getalarmsaround\"");
        }
        throw new Exception("No <methodname>...</methodname> in reply.");
    }
}

