/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.messages;

import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.messages.MilestoneCameraConnectReq;
import com.tridium.nmilestone.messages.MilestoneRsp;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.baja.xml.XElem;

public class MilestoneCameraConnectRsp
extends MilestoneRsp {
    BMilestoneCamera camera;
    public InputStream in;

    public MilestoneCameraConnectRsp(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setMilestoneCamera(BMilestoneCamera bMilestoneCamera) {
        this.camera = bMilestoneCamera;
    }

    public synchronized void fromInputStream(InputStream inputStream) throws Exception {
        inputStream.reset();
        byte[] byArray = new byte[inputStream.available()];
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            inputStream.read(byArray);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        inputStream.reset();
        try {
            XElem xElem = MilestoneReqUtil.getElem(byteArrayInputStream, "methodresponse");
            String string = MilestoneReqUtil.getText(xElem, "connected");
            String string2 = MilestoneReqUtil.getText(xElem, "alwaysstdjpeg");
            if (string.equals("yes")) {
                this.camera.setMilestonePtzConnectionEstablished(true);
                if (string2.equals("no")) {
                    // empty if block
                }
                return;
            }
            this.camera.setMilestonePtzConnectionEstablished(false);
            throw new Exception("Milestone Camera Connection Was Denied: \"" + string + "\"");
        }
        catch (Exception exception) {
            this.camera.setMilestonePtzConnectionEstablished(false);
            throw new Exception("Error Parsing Milestone Camera Connection Response", exception);
        }
    }

    public Object getTag() {
        return MilestoneCameraConnectReq.CAMERA_CONNECT_OBJ;
    }
}

