/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.comm;

import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneDvr;
import com.tridium.nmilestone.BMilestoneNetwork;
import com.tridium.nmilestone.event.BMilestoneEventCameraExt;
import com.tridium.nmilestone.event.BMilestoneEventPointId;
import com.tridium.nmilestone.event.BMilestoneEventProxyExt;
import com.tridium.nmilestone.event.BMilestoneEventTypeEnum;
import com.tridium.nmilestone.messages.MilestoneCentralLoginReq;
import com.tridium.nmilestone.messages.MilestoneCentralReq;
import com.tridium.nmilestone.messages.MilestoneUnsolicitedMessage;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import java.io.InputStream;
import javax.baja.control.BControlPoint;
import javax.baja.log.Log;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.xml.XElem;

public class MilestoneTcpListener
implements ICommListener {
    public static final int CHECK_USER_NAME_AND_PASSWORD = 0;
    public static final int REQUEST_STATUS_LIST_CONDENSER_OBJECT = 1;
    public static final int RECEIVE_STATUS_LIST_CONDENSER_OBJECT = 1;
    public static final int REQUEST_STATUS_LIST = 2;
    public static final int RECEIVE_STATUS_LIST = 2;
    public static final int DONE = 3;
    protected int state = 0;
    public String xmlSimpleReplyId;
    protected static final Log log = Log.getLog((String)"milestone.tcpUnsolMgr");
    protected int aliveInterval;
    protected Clock.Ticket aliveIntervalTicket;
    BMilestoneNetwork network;
    BMilestoneDvr dvr;

    public MilestoneTcpListener(BMilestoneDvr bMilestoneDvr) {
        this.dvr = bMilestoneDvr;
        this.network = bMilestoneDvr.getMilestoneNetwork();
    }

    public void receiveMessage(NMessage nMessage) {
        block17: {
            Object object;
            try {
                object = new byte[((MilestoneUnsolicitedMessage)nMessage).in.available()];
                ((MilestoneUnsolicitedMessage)nMessage).in.read((byte[])object);
                ((MilestoneUnsolicitedMessage)nMessage).in.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object = MilestoneReqUtil.getElem(((MilestoneUnsolicitedMessage)nMessage).in, "milestoneSurveillance");
                XElem xElem = object.elem("reply");
                if (xElem == null) {
                    XElem xElem2 = object.elem("bubble");
                    if (xElem2 == null) {
                        XElem xElem3 = object.elem("alive");
                        if (xElem3 != null) {
                            this.processAlive(xElem3);
                        }
                    } else {
                        this.processBubble(xElem2);
                    }
                    break block17;
                }
                try {
                    String string = xElem.get("token", "");
                    if ("197001".equals(string) || "1337".equals(string) || "197002".equals(string) || "197003".equals(string)) {
                        ((MilestoneUnsolicitedMessage)nMessage).in.reset();
                        this.processCentralLoginRsp(((MilestoneUnsolicitedMessage)nMessage).in);
                        byte[] byArray = this.getBytes();
                        if (byArray != null) {
                            MilestoneCentralReq milestoneCentralReq = new MilestoneCentralReq(byArray);
                            milestoneCentralReq.setAddress((BAddress)this.dvr.tcpAddress());
                            this.dvr.getTcpCpSession().sendMessage(milestoneCentralReq);
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    this.processReply(xElem);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (this.isConnectErrorMsg(((MilestoneUnsolicitedMessage)nMessage).in)) {
                    System.out.println("You Must connect first. Ping the Camera");
                    BIVideoCamera[] bIVideoCameraArray = this.dvr.getCameras().getAllCameras();
                    for (int i = 0; i < bIVideoCameraArray.length; ++i) {
                        BMilestoneCamera bMilestoneCamera = (BMilestoneCamera)bIVideoCameraArray[i];
                        bMilestoneCamera.doPing();
                    }
                }
                if (this.isPtzRsp(((MilestoneUnsolicitedMessage)nMessage).in)) {
                    // empty if block
                }
            }
        }
    }

    boolean isConnectErrorMsg(InputStream inputStream) {
        try {
            inputStream.reset();
            XElem xElem = MilestoneReqUtil.getElem(inputStream, "methodresponse");
            String string = MilestoneReqUtil.getText(xElem, "errorreason");
            if (string.equalsIgnoreCase("You must connect first")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean isPtzRsp(InputStream inputStream) {
        try {
            inputStream.reset();
            XElem xElem = MilestoneReqUtil.getElem(inputStream, "methodresponse");
            String string = MilestoneReqUtil.getText(xElem, "methodname");
            if (string.equalsIgnoreCase("ptz")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void processAlive(XElem xElem) {
        this.resetAlarmIntervalExpirationTimer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processReply(XElem xElem) throws Exception {
        String string = MilestoneReqUtil.getText(xElem, "base");
        if (!"XMLSimpleReply".equals(string)) throw new Exception("Unrecognized 'base' in reply: base=" + (string.trim().length() > 0 ? string : "<null>"));
        XElem xElem2 = MilestoneReqUtil.getElem(xElem, "object");
        String string2 = MilestoneReqUtil.getText(xElem2, "classification");
        if (!"UserLoginManager".equals(string2)) throw new Exception("Unrecognized 'classification' in reply: classification=" + (string2.trim().length() > 0 ? string2 : "<null>"));
        String string3 = MilestoneReqUtil.getText(xElem2, "status");
        if (!"Enabled".equals(string3)) {
            throw new Exception("Unrecognized 'status' in reply: status=" + (string3.trim().length() > 0 ? string3 : "<null>"));
        }
        int n = Integer.parseInt(MilestoneReqUtil.getText(xElem2, "id"));
        MilestoneCentralLoginReq milestoneCentralLoginReq = new MilestoneCentralLoginReq(this, n, this.dvr.getMilestoneCentralCredentials().getUsername(), this.dvr.getMilestoneCentralCredentials().getPassword().getString());
        milestoneCentralLoginReq.setAddress((BAddress)this.dvr.tcpAddress());
        this.dvr.getTcpCpSession().sendMessage(milestoneCentralLoginReq);
    }

    public void aliveIntervalReceived(int n) {
        this.aliveInterval = n;
        this.resetAlarmIntervalExpirationTimer();
    }

    protected void resetAlarmIntervalExpirationTimer() {
        if (this.aliveIntervalTicket != null) {
            this.aliveIntervalTicket.cancel();
        }
        if (this.aliveInterval > 0) {
            // empty if block
        }
    }

    protected void processExternalEvent(XElem xElem, String string, String string2, String string3) throws Exception {
        BAbsTime bAbsTime = MilestoneReqUtil.getTime(xElem, "spawnTime");
        BIVideoCamera[] bIVideoCameraArray = this.dvr.getCameras().getAllCameras();
        for (int i = 0; i < bIVideoCameraArray.length; ++i) {
            BMilestoneCamera bMilestoneCamera = (BMilestoneCamera)bIVideoCameraArray[i];
            BMilestoneEventCameraExt bMilestoneEventCameraExt = (BMilestoneEventCameraExt)bMilestoneCamera.getEvents();
            BControlPoint[] bControlPointArray = bMilestoneEventCameraExt.getPoints();
            for (int j = 0; j < bControlPointArray.length; ++j) {
                BMilestoneEventProxyExt bMilestoneEventProxyExt = (BMilestoneEventProxyExt)bControlPointArray[j].getProxyExt();
                BMilestoneEventPointId bMilestoneEventPointId = bMilestoneEventProxyExt.getPointId();
                if (bMilestoneEventPointId.getMilestoneEventType() != BMilestoneEventTypeEnum.external || !bMilestoneEventPointId.getMilestoneEventName().equals(string2) || !bMilestoneEventPointId.getMilestoneEventId().equals(string) || !bMilestoneEventPointId.getMilestoneEventStatus().equals(string3)) continue;
                BVideoEvent bVideoEvent = BVideoEvent.makeOffNormalEvent();
                bVideoEvent.setEventType(BVideoEventTypesEnum.customEvent);
                bVideoEvent.setDescription(string + ':' + string2 + ':' + string3);
                bVideoEvent.setTimestamp(bAbsTime);
                bMilestoneEventProxyExt.readOk((BStatusValue)new BVideoEventStatus(bVideoEvent));
            }
        }
    }

    protected void updateMotionDetectedPointInCamera(XElem xElem, String string) throws Exception {
        if (string != null && string.length() > 0) {
            BAbsTime bAbsTime = MilestoneReqUtil.getTime(xElem, "spawnTime");
            BIVideoCamera[] bIVideoCameraArray = this.dvr.getCameras().getAllCameras();
            for (int i = 0; i < bIVideoCameraArray.length; ++i) {
                String string2;
                BMilestoneCamera bMilestoneCamera = (BMilestoneCamera)bIVideoCameraArray[i];
                if (!bMilestoneCamera.getStatus().isValid()) continue;
                if (!bMilestoneCamera.getHasPingedAtLeastOnce()) {
                    bMilestoneCamera.ping();
                }
                if (!string.equals(string2 = bMilestoneCamera.getMilestoneGuid())) continue;
                BMilestoneEventCameraExt bMilestoneEventCameraExt = (BMilestoneEventCameraExt)bMilestoneCamera.getEvents();
                BControlPoint[] bControlPointArray = bMilestoneEventCameraExt.getPoints();
                for (int j = 0; j < bControlPointArray.length; ++j) {
                    BMilestoneEventProxyExt bMilestoneEventProxyExt = (BMilestoneEventProxyExt)bControlPointArray[j].getProxyExt();
                    BMilestoneEventPointId bMilestoneEventPointId = bMilestoneEventProxyExt.getPointId();
                    if (bMilestoneEventPointId.getMilestoneEventType() != BMilestoneEventTypeEnum.motionDetected) continue;
                    BVideoEvent bVideoEvent = BVideoEvent.makeMotionStarted();
                    bVideoEvent.setTimestamp(bAbsTime);
                    bMilestoneEventProxyExt.readOk((BStatusValue)new BVideoEventStatus(bVideoEvent));
                }
            }
        }
    }

    protected void processBubble(XElem xElem) throws Exception {
        XElem xElem2 = MilestoneReqUtil.getElem(xElem, "source");
        XElem xElem3 = MilestoneReqUtil.getElem(xElem2, "object");
        String string = MilestoneReqUtil.getText(xElem3, "classification");
        if ("EngineElement".equals(string)) {
            string = MilestoneReqUtil.getText(xElem3 = MilestoneReqUtil.getElem(xElem3, "object"), "classification");
            if ("CameraElement".equals(string)) {
                String string2 = MilestoneReqUtil.getText(xElem3, "guid");
                this.updateMotionDetectedPointInCamera(xElem, string2);
            } else {
                String string3 = MilestoneReqUtil.getText(xElem3, "id");
                String string4 = MilestoneReqUtil.getText(xElem3, "name");
                String string5 = MilestoneReqUtil.getText(xElem3, "status");
                this.processExternalEvent(xElem, string3, string4, string5);
            }
        }
    }

    public void processCentralLoginRsp(InputStream inputStream) throws Exception {
        try {
            if (this.state == 0) {
                this.checkUserNameAndPassword(inputStream);
            } else if (this.state == 1) {
                this.receiveStatusListObject(inputStream);
            } else if (this.state == 2) {
                this.receiveStatusList(inputStream);
            }
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public void checkUserNameAndPassword(InputStream inputStream) throws Exception {
        boolean bl = true;
        try {
            XElem xElem = MilestoneReqUtil.getElem(inputStream, "milestoneSurveillance");
            XElem xElem2 = MilestoneReqUtil.getElem(xElem, "reply");
            String string = xElem2.get("token", "");
            if ("197001".equals(string) || "1337".equals(string)) {
                String string2 = MilestoneReqUtil.getText(xElem2, "base");
                if ("XMLSimpleReply".equals(string2)) {
                    XElem xElem3 = MilestoneReqUtil.getElem(xElem2, "object");
                    String string3 = MilestoneReqUtil.getText(xElem3, "classification");
                    if ("User".equals(string3)) {
                        String string4 = MilestoneReqUtil.getText(xElem3, "status");
                        if ("Enabled".equals(string4)) {
                            this.xmlSimpleReplyId = MilestoneReqUtil.getText(xElem3, "id");
                            this.state = 1;
                            return;
                        }
                        bl = false;
                    }
                } else if ("Error".equals(string2)) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            this.state = 3;
            throw new Exception("The Milestone engine is not accepting Milestone Central commands from the Milestone UserName that is specified in this station therefore Milestone motion detection is not available to Niagara.");
        }
    }

    public void receiveStatusListObject(InputStream inputStream) throws Exception {
        boolean bl = true;
        try {
            XElem xElem;
            String string;
            String string2;
            XElem xElem2 = MilestoneReqUtil.getElem(inputStream, "milestoneSurveillance");
            XElem xElem3 = MilestoneReqUtil.getElem(xElem2, "reply");
            String string3 = xElem3.get("token", "");
            if ("197002".equals(string3) && "XMLSimpleReply".equals(string2 = MilestoneReqUtil.getText(xElem3, "base")) && "StatusList".equals(string = MilestoneReqUtil.getText(xElem = MilestoneReqUtil.getElem(xElem3, "object"), "classification"))) {
                String string4 = MilestoneReqUtil.getText(xElem, "status");
                if ("Enabled".equals(string4)) {
                    bl = true;
                    this.xmlSimpleReplyId = MilestoneReqUtil.getText(xElem, "id");
                    this.state = 2;
                    return;
                }
                bl = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            throw new Exception("The status list object is not enabled in the Milestone engine. Milestone motion detection is not available to Niagara.");
        }
    }

    public void receiveStatusList(InputStream inputStream) throws Exception {
        boolean bl = true;
        boolean bl2 = true;
        try {
            XElem xElem;
            String string;
            String string2;
            XElem xElem2 = MilestoneReqUtil.getElem(inputStream, "milestoneSurveillance");
            XElem xElem3 = MilestoneReqUtil.getElem(xElem2, "reply");
            String string3 = xElem3.get("token", "");
            if ("197003".equals(string3) && "XMLStatus".equals(string2 = MilestoneReqUtil.getText(xElem3, "base")) && "StatusList".equals(string = MilestoneReqUtil.getText(xElem = MilestoneReqUtil.getElem(xElem3, "object"), "classification"))) {
                String string4 = MilestoneReqUtil.getText(xElem, "status");
                if ("Enabled".equals(string4)) {
                    bl = true;
                    String string5 = MilestoneReqUtil.getText(xElem, "id");
                    if (this.xmlSimpleReplyId.equals(string5)) {
                        XElem xElem4 = MilestoneReqUtil.getElem(xElem, "statuslist");
                        string = MilestoneReqUtil.getText(xElem = MilestoneReqUtil.getElem(xElem4, "object"), "classification");
                        if ("EngineElement".equals(string)) {
                            String string6 = MilestoneReqUtil.getText(xElem, "aliveinterval");
                            this.state = 3;
                            this.aliveIntervalReceived(Integer.parseInt(string6));
                            return;
                        }
                    } else {
                        bl2 = false;
                    }
                } else {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            throw new Exception("The status list is not enabled in the Milestone engine. Milestone motion detection is not available to Niagara.");
        }
        if (!bl2) {
            throw new Exception("The milestone engine returned the wrong status id for the status list. Milestone motion detection is not available to Niagara.");
        }
    }

    public byte[] getBytesToRequestStatusListCondenserObject() {
        return new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><milestoneSurveillance protocolVersion=\"2.0\"><command token=\"197002\"><base>XMLSimpleCommand</base><action><commandName>Request Status Condenser</commandName><destinations><object><classification>User</classification><id>" + this.xmlSimpleReplyId + "</id>" + "</object>" + "</destinations>" + "</action>" + "</command>" + "</milestoneSurveillance>\r\n\r\n").getBytes();
    }

    public byte[] getBytesToRequestStatusList() {
        return new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><milestoneSurveillance protocolVersion=\"2.0\"><command token=\"197003\"><base>XMLSimpleCommand</base><action><commandName>Request Status</commandName><destinations><object><classification>StatusList</classification><id>" + this.xmlSimpleReplyId + "</id>" + "</object>" + "</destinations>" + "</action>" + "</command>" + "</milestoneSurveillance>\r\n\r\n").getBytes();
    }

    public byte[] getBytes() {
        if (this.state == 1) {
            return this.getBytesToRequestStatusListCondenserObject();
        }
        if (this.state == 2) {
            return this.getBytesToRequestStatusList();
        }
        if (this.state == 3) {
            return null;
        }
        return null;
    }

    public boolean isComplete() {
        return this.state == 3;
    }
}

