/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone;

import com.tridium.ndriver.comm.ICommFilter;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.tcp.ITcpEventListener;
import com.tridium.ndriver.comm.tcp.TcpLinkLayer;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneCameraDeviceExt;
import com.tridium.nmilestone.BMilestoneNetwork;
import com.tridium.nmilestone.comm.MilestoneTcpListener;
import com.tridium.nmilestone.messages.MilestoneCentralReq;
import com.tridium.nmilestone.util.BMilestoneImageServerUserNameAndPassword;
import com.tridium.nmilestone.util.MilestoneHttpUtil;
import com.tridium.nvideo.camera.BCameraDeviceExt;
import com.tridium.nvideo.dvr.BVideoDvr;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import java.util.StringTokenizer;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

public class BMilestoneDvr
extends BVideoDvr
implements ITcpEventListener {
    public static final Property cameras = BMilestoneDvr.newProperty((int)0, (BValue)new BMilestoneCameraDeviceExt(), null);
    public static final Property milestoneEngineIpAddress = BMilestoneDvr.newProperty((int)0, (String)"###.###.###.###", (BFacets)SfUtil.incl((String)"ed"));
    public static final Property milestoneImageServerPort = BMilestoneDvr.newProperty((int)0, (int)80, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property milestoneCentralPort = BMilestoneDvr.newProperty((int)0, (int)1237, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property uploadEventsPort = BMilestoneDvr.newProperty((int)0, (int)1234, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property credentials = BMilestoneDvr.newProperty((int)0, (BValue)new BUsernameAndPassword(), (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property milestoneCentralCredentials = BMilestoneDvr.newProperty((int)0, (BValue)new BMilestoneImageServerUserNameAndPassword(), (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property recentSessionIds = BMilestoneDvr.newProperty((int)4, (String)"", null);
    public static final Property maxRecentSessionsToClose = BMilestoneDvr.newProperty((int)4, (int)100, null);
    public static final Action startSession = BMilestoneDvr.newAction((int)0, null);
    public static final Action stopSession = BMilestoneDvr.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$nmilestone$BMilestoneDvr == null ? (class$com$tridium$nmilestone$BMilestoneDvr = BMilestoneDvr.class$("com.tridium.nmilestone.BMilestoneDvr")) : class$com$tridium$nmilestone$BMilestoneDvr));
    protected Object sessionTracking = new Object();
    static final int SESSION_INIT = 0;
    static final int SESSION_STARTING = 1;
    static final int SESSION_ACTIVE = 2;
    static final int SESSION_FAULT = 4;
    static final int SESSION_STOPPED = 5;
    public static int nextSessionPingTimerId = 1;
    public String milestoneSessionId = null;
    protected boolean milestoneSessionFailure1 = false;
    protected Object access = new Object();
    protected SessionPingTimer sessionPingTimer = null;
    public static final long FORTY_FIVE_SECONDS = 45000L;
    protected Object commSynchronizer = new Object();
    BMilestoneNetwork network;
    MilestoneTcpListener listener;
    private MilestoneTcpSession tcpIsSession;
    private MilestoneTcpSession tcpCpSession;
    static /* synthetic */ Class class$com$tridium$nmilestone$BMilestoneDvr;

    public BCameraDeviceExt getCameras() {
        return (BCameraDeviceExt)this.get(cameras);
    }

    public void setCameras(BCameraDeviceExt bCameraDeviceExt) {
        this.set(cameras, (BValue)bCameraDeviceExt, null);
    }

    public String getMilestoneEngineIpAddress() {
        return this.getString(milestoneEngineIpAddress);
    }

    public void setMilestoneEngineIpAddress(String string) {
        this.setString(milestoneEngineIpAddress, string, null);
    }

    public int getMilestoneImageServerPort() {
        return this.getInt(milestoneImageServerPort);
    }

    public void setMilestoneImageServerPort(int n) {
        this.setInt(milestoneImageServerPort, n, null);
    }

    public int getMilestoneCentralPort() {
        return this.getInt(milestoneCentralPort);
    }

    public void setMilestoneCentralPort(int n) {
        this.setInt(milestoneCentralPort, n, null);
    }

    public int getUploadEventsPort() {
        return this.getInt(uploadEventsPort);
    }

    public void setUploadEventsPort(int n) {
        this.setInt(uploadEventsPort, n, null);
    }

    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    public void setCredentials(BUsernameAndPassword bUsernameAndPassword) {
        this.set(credentials, (BValue)bUsernameAndPassword, null);
    }

    public BMilestoneImageServerUserNameAndPassword getMilestoneCentralCredentials() {
        return (BMilestoneImageServerUserNameAndPassword)this.get(milestoneCentralCredentials);
    }

    public void setMilestoneCentralCredentials(BMilestoneImageServerUserNameAndPassword bMilestoneImageServerUserNameAndPassword) {
        this.set(milestoneCentralCredentials, (BValue)bMilestoneImageServerUserNameAndPassword, null);
    }

    public String getRecentSessionIds() {
        return this.getString(recentSessionIds);
    }

    public void setRecentSessionIds(String string) {
        this.setString(recentSessionIds, string, null);
    }

    public int getMaxRecentSessionsToClose() {
        return this.getInt(maxRecentSessionsToClose);
    }

    public void setMaxRecentSessionsToClose(int n) {
        this.setInt(maxRecentSessionsToClose, n, null);
    }

    public void startSession() {
        this.invoke(startSession, null, null);
    }

    public void stopSession() {
        this.invoke(stopSession, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void videoDvrStarted() throws Exception {
        this.setRecentSessionIds("");
        this.postAsync(new Runnable(){

            public void run() {
                BMilestoneDvr.this.milestoneDvrStarted();
            }
        });
        super.videoDvrStarted();
    }

    public void milestoneDvrStarted() {
        try {
            System.out.println("Milestone DVR started....");
            ((TcpLinkLayer)this.getMilestoneNetwork().tcpcomm().getLinkLayer()).registerTcpEvenListener((ITcpEventListener)this);
            this.listener = new MilestoneTcpListener(this);
            this.getMilestoneNetwork().tcpcomm().registerCommListener((ICommListener)this.listener, this.getFilter(), false);
            this.startTcpIsSession();
            this.startTcpCpSession();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BajaRuntimeException((Throwable)exception);
        }
        this.postAsync(new Runnable(){

            public void run() {
                BMilestoneDvr.this.doStartSession();
            }
        });
    }

    public void startTcpIsSession() throws Exception {
        this.tcpIsSession = new MilestoneTcpSession(this.httpAddress());
        this.tcpIsSession.start();
    }

    public void startTcpCpSession() throws Exception {
        this.tcpCpSession = new MilestoneTcpSession(this.tcpAddress());
        this.tcpCpSession.start();
        MilestoneCentralReq milestoneCentralReq = new MilestoneCentralReq("\r\n\r\n".getBytes());
        this.tcpCpSession.sendMessage(milestoneCentralReq);
    }

    ICommFilter getFilter() {
        return new ICommFilter(){

            public boolean accept(NMessage nMessage) {
                return true;
            }
        };
    }

    public void stopped() throws Exception {
        try {
            this.getMilestoneNetwork().tcpcomm().unregisterCommListener((ICommListener)this.listener, null);
            this.milestoneDvrStopped();
            super.stopped();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void milestoneDvrStopped() throws Exception {
        this.stopCommunicating();
        this.tcpIsSession.stop();
        this.tcpCpSession.stop();
    }

    public void stopCommunicating() {
        if (this.sessionPingTimer != null) {
            this.sessionPingTimer.stopPingTimer();
        }
        if (this.milestoneSessionId != null) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Sending stop...");
            }
            this.doStopSession(this.milestoneSessionId);
        }
    }

    public BMilestoneNetwork getMilestoneNetwork() {
        if (this.network != null) {
            return this.network;
        }
        BDeviceNetwork bDeviceNetwork = null;
        for (BComplex bComplex = this.getParent(); bComplex != null; bComplex = bComplex.getParent()) {
            if (!(bComplex instanceof BDeviceNetwork)) continue;
            bDeviceNetwork = (BDeviceNetwork)bComplex;
            break;
        }
        this.network = (BMilestoneNetwork)bDeviceNetwork;
        return this.network;
    }

    public boolean supportsMultistream() {
        return false;
    }

    public Type getVideoCameraType() {
        return BMilestoneCamera.TYPE;
    }

    public void initPlaybackParams(BPlaybackParams bPlaybackParams, IVideoSession iVideoSession) {
    }

    public Type getNetworkType() {
        return BMilestoneNetwork.TYPE;
    }

    public void streamToDestination(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
    }

    public void doPing() {
        if (!this.isRunning()) {
            return;
        }
        try {
            MilestoneHttpUtil.getDvrStatus(this.getMilestoneNetwork().hcomm(), this.httpAddress(), this.getMilestoneCentralCredentials());
            this.pingOk();
        }
        catch (Exception exception) {
            this.pingFail(exception.getLocalizedMessage());
        }
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams bPlaybackParams) {
        return null;
    }

    public void doStartSession() {
        this.postAsync(new Runnable(){

            public void run() {
                BMilestoneDvr.this.closeRecentMilestoneSessions();
                BMilestoneDvr.this.doStartSessionSync();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rememberMilestoneSession(String string) {
        Object object = this.sessionTracking;
        synchronized (object) {
            int n = this.getMaxRecentSessionsToClose();
            String string2 = this.getRecentSessionIds();
            String string3 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens() && ++n2 < n) {
                string3 = stringTokenizer.nextToken() + ';' + string3;
            }
            string3 = string + ';' + string3;
            this.setRecentSessionIds(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeRecentMilestoneSessions() {
        Object object = this.sessionTracking;
        synchronized (object) {
            int n = this.getMaxRecentSessionsToClose();
            String string = this.getRecentSessionIds();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens() && n2++ < n) {
                String string2 = stringTokenizer.nextToken();
                this.doStopSessionSync(string2);
            }
            this.setRecentSessionIds("");
        }
    }

    public boolean doStartSessionSync() {
        if (this.isRunning()) {
            return this.doSessionStartSync();
        }
        return false;
    }

    public void doStopSession() {
        this.doStopSession(this.milestoneSessionId);
    }

    public void doStopSession(final String string) {
        this.postAsync(new Runnable(){

            public void run() {
                BMilestoneDvr.this.doStopSessionSync(string);
            }
        });
    }

    public boolean doStopSessionSync(String string) {
        try {
            String string2 = "GET";
            String string3 = "/sessionhandler.xml?command=sessionend&sessionid=" + string;
            NHttpRequest nHttpRequest = new NHttpRequest(new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneImageServerPort()), string2, string3);
            nHttpRequest.addBasicAuthorization(this.getMilestoneCentralCredentials().getUsername(), this.getMilestoneCentralCredentials().getPassword().getString());
            nHttpRequest.setAddress((BAddress)this.httpAddress());
            byte[] byArray = this.getMilestoneNetwork().hcomm().sendRequest(nHttpRequest).getData();
            String string4 = "";
            XParser xParser = null;
            XElem xElem = null;
            try {
                xParser = XParser.make((String)new String(byArray, 0, byArray.length));
                xElem = xParser.parse();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Exception("Unable to parse the expected XML response", exception);
            }
            if (xElem == null) {
                throw new Exception("SessionStop - No <methodresponse> tag.");
            }
            return "ok".equals(string4);
        }
        catch (Exception exception) {
            System.out.println("Error in Milestone Session Stop");
            exception.printStackTrace();
            return false;
        }
    }

    public boolean doSessionStartSync() {
        boolean bl = false;
        try {
            String string = "GET";
            String string2 = "/sessionhandler.xml?command=sessionstart";
            NHttpRequest nHttpRequest = new NHttpRequest(new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneImageServerPort()), string, string2);
            nHttpRequest.addBasicAuthorization(this.getMilestoneCentralCredentials().getUsername(), this.getMilestoneCentralCredentials().getPassword().getString());
            nHttpRequest.setAddress((BAddress)this.httpAddress());
            byte[] byArray = this.getMilestoneNetwork().hcomm().sendRequest(nHttpRequest).getData();
            if (this.isSuccessfulSessionStart(byArray)) {
                if (bl) {
                    this.configOk();
                    bl = false;
                }
                this.rememberMilestoneSession(this.milestoneSessionId);
                this.sessionPingTimer = new SessionPingTimer();
                this.sessionPingTimer.start();
                return true;
            }
            bl = true;
            this.milestoneSessionId = null;
            try {
                Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)45000L), (Action)startSession, null);
            }
            catch (NotRunningException notRunningException) {
                // empty catch block
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("Error in Milestone Session Start");
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isSuccessfulSessionStart(byte[] byArray) throws Exception {
        String string = "";
        XParser xParser = null;
        XElem xElem = null;
        try {
            xParser = XParser.make((String)new String(byArray, 0, byArray.length));
            xElem = xParser.parse();
        }
        catch (Exception exception) {
            throw new Exception("Unable to parse the expected XML response", exception);
        }
        if (xElem != null) {
            XElem xElem2 = xElem.elem("result");
            if (xElem2 != null) {
                XText xText = xElem2.text();
                if (xText != null) {
                    string = xText.string();
                    if ("ok".equals(string)) {
                        XElem xElem3 = xElem.elem("sessionid");
                        if (xElem3 != null) {
                            XText xText2 = xElem3.text();
                            if (xText2 != null) {
                                String string2 = xText2.string().trim();
                                if (string2.length() > 0) {
                                    this.milestoneSessionId = string2;
                                    return true;
                                }
                                throw new Exception("Milestone sessionid string is an empty string.");
                            }
                            throw new Exception("SesionStart - <sessionid> ... </sessionid> tag contains no text.");
                        }
                        throw new Exception("SesionStart - No <sessionid> tag.");
                    }
                    throw new Exception("SesionStart - <result> ... </result> tag contains bad result: " + string);
                }
                throw new Exception("SesionStart - No <result> tag.");
            }
            throw new Exception("SesionStart - No <result> tag.");
        }
        throw new Exception("SesionStart - No <methodresponse> tag.");
    }

    public BBoolean doPingSession() {
        try {
            String string = "GET";
            String string2 = "/sessionhandler.xml?command=sessionping&sessionid=" + this.milestoneSessionId;
            NHttpRequest nHttpRequest = new NHttpRequest(new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneImageServerPort()), string, string2);
            nHttpRequest.addBasicAuthorization(this.getMilestoneCentralCredentials().getUsername(), this.getMilestoneCentralCredentials().getPassword().getString());
            nHttpRequest.setAddress((BAddress)this.httpAddress());
            byte[] byArray = this.getMilestoneNetwork().hcomm().sendRequest(nHttpRequest).getData();
            if (this.isSuccessfulPingResponse(byArray)) {
                return BBoolean.TRUE;
            }
            return BBoolean.FALSE;
        }
        catch (Exception exception) {
            System.out.println("Error in Milestone Session Ping");
            exception.printStackTrace();
            return BBoolean.FALSE;
        }
    }

    public boolean isSuccessfulPingResponse(byte[] byArray) {
        String string = "";
        XParser xParser = null;
        XElem xElem = null;
        try {
            xParser = XParser.make((String)new String(byArray, 0, byArray.length));
            xElem = xParser.parse();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (xElem != null) {
            XElem xElem2 = xElem.elem("result");
            if (xElem2 != null) {
                XText xText = xElem2.text();
                if (xText != null) {
                    string = xText.string();
                    if ("ok".equals(string)) {
                        XElem xElem3 = xElem.elem("sessionid");
                        if (xElem3 != null) {
                            XText xText2 = xElem3.text();
                            if (xText2 != null) {
                                String string2 = xText2.string().trim();
                                if (string2.length() > 0) {
                                    this.milestoneSessionId = string2;
                                    return true;
                                }
                                System.out.println("Milestone sessionid string is an empty string.  ");
                                return false;
                            }
                            System.out.println("SessionPing - <sessionid> ... </sessionid> tag contains no text.  ");
                            return false;
                        }
                        return true;
                    }
                    System.out.println("SessionPing - <result> ... </result> tag contains bad result: " + string + ".  ");
                    return false;
                }
                System.out.println("SessionPing - No <result> tag.  ");
                return false;
            }
            System.out.println("SessionPing - No <result> tag.  ");
            return false;
        }
        System.out.println("SessionPing - No <methodresponse> tag.  ");
        return false;
    }

    public String getMilestoneSessionId() {
        return this.milestoneSessionId;
    }

    public BIpAddress httpAddress() {
        return new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneImageServerPort());
    }

    public BIpAddress tcpAddress() {
        return new BIpAddress(this.getMilestoneEngineIpAddress(), this.getMilestoneCentralPort());
    }

    private TcpLinkLayer link() {
        return (TcpLinkLayer)this.getMilestoneNetwork().tcpcomm().getLinkLayer();
    }

    public void socketTerminated(BIpAddress bIpAddress, boolean bl) {
        int n = bIpAddress.getSessionId();
        if (n < 0) {
            return;
        }
        if (this.tcpIsSession.getLinkSessionId() == n) {
            this.tcpIsSession.sessionTerminated();
        }
        if (this.tcpCpSession.getLinkSessionId() == n) {
            this.tcpCpSession.sessionTerminated();
        }
    }

    public MilestoneTcpSession getTcpIsSession() throws Exception {
        if (this.tcpIsSession == null) {
            this.startTcpIsSession();
        }
        if (!this.tcpIsSession.isActive()) {
            this.tcpIsSession.start();
        }
        return this.tcpIsSession;
    }

    public MilestoneTcpSession getTcpCpSession() throws Exception {
        if (this.tcpCpSession == null) {
            this.startTcpIsSession();
        }
        if (!this.tcpCpSession.isActive()) {
            this.tcpCpSession.start();
        }
        return this.tcpCpSession;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class MilestoneTcpSession
    extends MilestoneSession {
        public MilestoneTcpSession(BIpAddress bIpAddress) {
            super(bIpAddress);
        }
    }

    public class MilestoneSession {
        BIpAddress adr;
        int state = 0;
        String status = "";

        public MilestoneSession(BIpAddress bIpAddress) {
            this.adr = bIpAddress;
        }

        synchronized void init() throws Exception {
            this.adr.setSessionId(BMilestoneDvr.this.link().createSession(this.adr));
        }

        synchronized void sessionTerminated() {
            if (this.state == 2) {
                try {
                    this.start();
                }
                catch (Exception exception) {}
            } else {
                this.adr = null;
                this.state = 5;
            }
        }

        synchronized void stop() throws Exception {
            if (this.adr == null) {
                return;
            }
            BMilestoneDvr.this.link().closeSession(this.adr.getSessionId());
            this.adr = null;
            this.state = 5;
        }

        public synchronized void sendMessage(NMessage nMessage) throws Exception {
            if (this.adr == null) {
                this.init();
            }
            nMessage.setAddress((BAddress)this.adr);
            BMilestoneDvr.this.getMilestoneNetwork().tcpcomm().sendMessage(nMessage);
        }

        public synchronized NMessage sendRequest(NMessage nMessage) throws Exception {
            if (this.adr == null) {
                this.init();
            }
            nMessage.setAddress((BAddress)this.adr);
            return BMilestoneDvr.this.getMilestoneNetwork().tcpcomm().sendRequest(nMessage);
        }

        public void restart() throws Exception {
            if (this.adr != null) {
                this.stop();
            }
            this.start();
        }

        public boolean isActive() {
            return this.state == 2;
        }

        synchronized void start() throws Exception {
            try {
                this.state = 1;
                this.init();
                this.state = 2;
            }
            catch (Exception exception) {
                this.state = 4;
                throw exception;
            }
        }

        synchronized int getLinkSessionId() {
            if (this.adr == null) {
                return -1;
            }
            return this.adr.getSessionId();
        }
    }

    public class SessionPingTimer
    extends Thread {
        public boolean running = true;
        BMilestoneDvr dvr;

        public SessionPingTimer() {
            super("milestone.sessionPing." + nextSessionPingTimerId++);
        }

        public void run() {
            try {
                while (this.running) {
                    Thread.sleep(45000L);
                    BMilestoneDvr.this.doPingSession();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void stopPingTimer() {
            this.running = false;
            this.interrupt();
        }
    }
}

