/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone;

import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nmilestone.BMilestoneCameraDeviceId;
import com.tridium.nmilestone.BMilestoneDvr;
import com.tridium.nmilestone.BMilestoneNetwork;
import com.tridium.nmilestone.BMilestoneVideoSourcePreferences;
import com.tridium.nmilestone.MilestoneFfmpegMpeg4Decoder;
import com.tridium.nmilestone.MilestoneMjpegVideoDecoder;
import com.tridium.nmilestone.comm.BMilestoneTcpCommConfig;
import com.tridium.nmilestone.enums.BMilestoneStopRecordingModeEnum;
import com.tridium.nmilestone.event.BMilestoneEventCameraExt;
import com.tridium.nmilestone.event.BMilestoneEventRecall;
import com.tridium.nmilestone.messages.MilestoneCameraConnectReq;
import com.tridium.nmilestone.messages.MilestoneCameraConnectRsp;
import com.tridium.nmilestone.messages.MilestoneCameraInitiateRecordingReq;
import com.tridium.nmilestone.messages.MilestoneMoveToPresetReq;
import com.tridium.nmilestone.messages.MilestonePanTiltReq;
import com.tridium.nmilestone.messages.MilestoneStorePresetReq;
import com.tridium.nmilestone.messages.MilestoneVideoStreamReq;
import com.tridium.nmilestone.messages.MilestoneZoomReq;
import com.tridium.nmilestone.util.BMilestoneVideoCameraInfo;
import com.tridium.nmilestone.util.MilestoneHttpUtil;
import com.tridium.nmilestone.util.MilestoneVideoStreamUtil;
import com.tridium.nvideo.camera.BVideoCamera;
import com.tridium.nvideo.camera.BVideoSourcePreferences;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.util.EscUtil;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.baja.ffmpeg.enums.BCodecIdEnum;

public class BMilestoneCamera
extends BVideoCamera
implements BIVideoEventProvider,
BIVideoAlarmRecorder {
    public static final Property videoDeviceId = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneCameraDeviceId(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property ptzSupport = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneVideoCameraInfo(), (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property cameraTcpConfig = BMilestoneCamera.newProperty((int)4, (BValue)new BMilestoneTcpCommConfig(), null);
    public static final Property videoPreferences = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneVideoSourcePreferences(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property milestoneDatabaseId = BMilestoneCamera.newProperty((int)68, (String)"", null);
    public static final Property milestoneGuid = BMilestoneCamera.newProperty((int)68, (String)"", null);
    public static final Property autoSetPtzSupport = BMilestoneCamera.newProperty((int)0, (boolean)false, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property stopRecordingMode = BMilestoneCamera.newProperty((int)0, (BValue)BMilestoneStopRecordingModeEnum.onTimer, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property presetText = BMilestoneCamera.newProperty((int)0, (BValue)BEnumRange.make((String[])new String[]{EscUtil.slot.escape("???")}), null);
    public static final Property highCompressionCodec = BMilestoneCamera.newProperty((int)0, (BValue)BCodecIdEnum.ffmpeg_CODEC_ID_MPEG4, null);
    public static final Property events = BMilestoneCamera.newProperty((int)0, (BValue)new BMilestoneEventCameraExt(), null);
    public static final Property milestonePtzReconnectInterval = BMilestoneCamera.newProperty((int)4, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Property eventRecaller = BMilestoneCamera.newProperty((int)6, (BValue)new BMilestoneEventRecall(), null);
    public static final Action moveToPreset = BMilestoneCamera.newAction((int)4, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    public static final Action storePreset = BMilestoneCamera.newAction((int)4, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    public static final Action forceStartRecording = BMilestoneCamera.newAction((int)4, null);
    public static final Action forceStopRecording = BMilestoneCamera.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$nmilestone$BMilestoneCamera == null ? (class$com$tridium$nmilestone$BMilestoneCamera = BMilestoneCamera.class$("com.tridium.nmilestone.BMilestoneCamera")) : class$com$tridium$nmilestone$BMilestoneCamera));
    protected boolean establishingMilestonePtzConnection;
    protected ConnectionMaintainer connectionMaintainer;
    protected boolean hasPingedAtLeastOnce;
    boolean initialized = false;
    boolean milestonePtzConnectionEstablished;
    protected static int videoRequestId = 1;
    static /* synthetic */ Class class$com$tridium$nmilestone$BMilestoneCamera;

    public BVideoCameraInfo getPtzSupport() {
        return (BVideoCameraInfo)this.get(ptzSupport);
    }

    public void setPtzSupport(BVideoCameraInfo bVideoCameraInfo) {
        this.set(ptzSupport, (BValue)bVideoCameraInfo, null);
    }

    public BMilestoneTcpCommConfig getCameraTcpConfig() {
        return (BMilestoneTcpCommConfig)this.get(cameraTcpConfig);
    }

    public void setCameraTcpConfig(BMilestoneTcpCommConfig bMilestoneTcpCommConfig) {
        this.set(cameraTcpConfig, (BValue)bMilestoneTcpCommConfig, null);
    }

    public BVideoSourcePreferences getVideoPreferences() {
        return (BVideoSourcePreferences)this.get(videoPreferences);
    }

    public void setVideoPreferences(BVideoSourcePreferences bVideoSourcePreferences) {
        this.set(videoPreferences, (BValue)bVideoSourcePreferences, null);
    }

    public String getMilestoneDatabaseId() {
        return this.getString(milestoneDatabaseId);
    }

    public void setMilestoneDatabaseId(String string) {
        this.setString(milestoneDatabaseId, string, null);
    }

    public String getMilestoneGuid() {
        return this.getString(milestoneGuid);
    }

    public void setMilestoneGuid(String string) {
        this.setString(milestoneGuid, string, null);
    }

    public boolean getAutoSetPtzSupport() {
        return this.getBoolean(autoSetPtzSupport);
    }

    public void setAutoSetPtzSupport(boolean bl) {
        this.setBoolean(autoSetPtzSupport, bl, null);
    }

    public BMilestoneStopRecordingModeEnum getStopRecordingMode() {
        return (BMilestoneStopRecordingModeEnum)this.get(stopRecordingMode);
    }

    public void setStopRecordingMode(BMilestoneStopRecordingModeEnum bMilestoneStopRecordingModeEnum) {
        this.set(stopRecordingMode, (BValue)bMilestoneStopRecordingModeEnum, null);
    }

    public BEnumRange getPresetText() {
        return (BEnumRange)this.get(presetText);
    }

    public void setPresetText(BEnumRange bEnumRange) {
        this.set(presetText, (BValue)bEnumRange, null);
    }

    public BCodecIdEnum getHighCompressionCodec() {
        return (BCodecIdEnum)this.get(highCompressionCodec);
    }

    public void setHighCompressionCodec(BCodecIdEnum bCodecIdEnum) {
        this.set(highCompressionCodec, (BValue)bCodecIdEnum, null);
    }

    public BPointDeviceExt getEvents() {
        return (BPointDeviceExt)this.get(events);
    }

    public void setEvents(BPointDeviceExt bPointDeviceExt) {
        this.set(events, (BValue)bPointDeviceExt, null);
    }

    public BRelTime getMilestonePtzReconnectInterval() {
        return (BRelTime)this.get(milestonePtzReconnectInterval);
    }

    public void setMilestonePtzReconnectInterval(BRelTime bRelTime) {
        this.set(milestonePtzReconnectInterval, (BValue)bRelTime, null);
    }

    public BVideoEventRecall getEventRecaller() {
        return (BVideoEventRecall)this.get(eventRecaller);
    }

    public void setEventRecaller(BVideoEventRecall bVideoEventRecall) {
        this.set(eventRecaller, (BValue)bVideoEventRecall, null);
    }

    public void moveToPreset(BValue bValue) {
        this.invoke(moveToPreset, bValue, null);
    }

    public void storePreset(BValue bValue) {
        this.invoke(storePreset, bValue, null);
    }

    public void forceStartRecording() {
        this.invoke(forceStartRecording, null, null);
    }

    public void forceStopRecording() {
        this.invoke(forceStopRecording, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void videoCameraStarted() throws Exception {
        BDeviceNetwork bDeviceNetwork = this.getNetwork();
        String string = (String)bDeviceNetwork.fw(501, (Object)"camera.limit", null, null, null);
        if (string != null) {
            this.configFatal(string);
        }
        this.milestoneCameraStarted();
        super.videoCameraStarted();
    }

    protected void milestoneCameraStarted() {
        try {
            this.tcpCommunicatorStarted();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void doPing() {
        try {
            MilestoneHttpUtil.getCamStatus(this, this.getMilestoneNetwork().hcomm(), this.getMilestoneDvr().httpAddress(), this.getMilestoneDvr().getMilestoneCentralCredentials());
            this.pingOk();
        }
        catch (Exception exception) {
            this.pingFail(exception.getLocalizedMessage());
        }
    }

    public void stopped() throws Exception {
        try {
            super.stopped();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(autoSetPtzSupport)) {
            // empty if block
        }
    }

    public void descendantsStarted() throws Exception {
        String string = this.getMilestoneDatabaseId();
        if (string.length() > 0) {
            this.considerEstablishingMilestoneCameraConnection(string);
        }
    }

    protected void tcpCommunicatorStarted() throws Exception {
        this.connectionMaintainer = new ConnectionMaintainer(this);
        this.connectionMaintainer.start();
    }

    protected void tcpCommunicatorStopped() throws Exception {
        this.connectionMaintainer.stopConnectionMaintainer();
    }

    public void streamToDestination(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        MilestoneVideoStreamReq milestoneVideoStreamReq = new MilestoneVideoStreamReq();
        milestoneVideoStreamReq.setVideoSource((BIVideoSource)this);
        milestoneVideoStreamReq.setVideoDestination(iVideoDestination);
        milestoneVideoStreamReq.setPlaybackParams(bPlaybackParams);
        MilestoneVideoStreamUtil.sendStreamRequest(milestoneVideoStreamReq, this, this.getMilestoneDvr());
        IVideoStream iVideoStream = milestoneVideoStreamReq.makeVideoStream();
        if (iVideoStream != null) {
            iVideoDestination.receiveVideoStream(iVideoStream);
        }
    }

    public void considerEstablishingMilestoneCameraConnection(String string) {
        if (!this.milestonePtzConnectionEstablished && !this.establishingMilestonePtzConnection) {
            this.establishMilestonePtzCameraConnection(string);
        }
    }

    public void establishMilestonePtzCameraConnection(String string) {
        if (!this.isRunning()) {
            return;
        }
        this.establishingMilestonePtzConnection = true;
        try {
            MilestoneCameraConnectReq milestoneCameraConnectReq = this.makeCameraConnectReq(string);
            milestoneCameraConnectReq.setAddress((BAddress)this.getMilestoneDvr().httpAddress());
            MilestoneCameraConnectRsp milestoneCameraConnectRsp = (MilestoneCameraConnectRsp)this.getMilestoneDvr().getTcpIsSession().sendRequest(milestoneCameraConnectReq);
            milestoneCameraConnectRsp.setMilestoneCamera(this);
            milestoneCameraConnectRsp.fromInputStream(milestoneCameraConnectRsp.in);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.getLog().error("Make Camera Connect Req failed.");
        }
    }

    public MilestoneCameraConnectReq makeCameraPtzConnectReq() {
        return this.makeCameraConnectReq(this.getMilestoneDatabaseId());
    }

    public MilestoneCameraConnectReq makeCameraConnectReq(String string) {
        String string2 = this.getMilestoneDvr().getCredentials().getPassword().getString();
        String string3 = this.getMilestoneDvr().getCredentials().getUsername();
        MilestoneCameraConnectReq milestoneCameraConnectReq = new MilestoneCameraConnectReq(string3, string2, string, true, this);
        milestoneCameraConnectReq.setAddress((BAddress)this.getMilestoneDvr().httpAddress());
        return milestoneCameraConnectReq;
    }

    public void setMilestonePtzConnectionEstablished(boolean bl) {
        this.milestonePtzConnectionEstablished = bl;
        this.establishingMilestonePtzConnection = false;
    }

    public boolean getHasPingedAtLeastOnce() {
        return this.hasPingedAtLeastOnce;
    }

    public void pingFail(String string) {
        this.hasPingedAtLeastOnce = true;
        super.pingFail(string);
    }

    public void pingOk() {
        this.hasPingedAtLeastOnce = true;
        this.establishMilestonePtzCameraConnection(this.getMilestoneDatabaseId());
        super.pingOk();
    }

    public BMilestoneDvr getMilestoneDvr() {
        return (BMilestoneDvr)this.getDvr();
    }

    public Action getMoveToPresetAction() {
        return moveToPreset;
    }

    public Action getStorePresetAction() {
        return storePreset;
    }

    public void initPlaybackParams(BPlaybackParams bPlaybackParams, IVideoSession iVideoSession) {
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams bPlaybackParams) {
        if (bPlaybackParams.getCompression() == BVideoCompressionEnum.high && bPlaybackParams.getPlaybackType() == BPlaybackTypeEnum.live && this.getHighCompressionCodec() != BCodecIdEnum.ffmpeg_CODEC_ID_NONE) {
            return new MilestoneFfmpegMpeg4Decoder(this.getHighCompressionCodec());
        }
        return new MilestoneMjpegVideoDecoder();
    }

    public Type getNetworkType() {
        return BMilestoneNetwork.TYPE;
    }

    public void onMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
        if (bVideoPanTiltEnum != BVideoPanTiltEnum.none) {
            try {
                this.getMilestoneDvr().getTcpIsSession().sendMessage(new MilestonePanTiltReq(bVideoPanTiltEnum));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void onZoom(BVideoZoomEnum bVideoZoomEnum) {
        if (bVideoZoomEnum != BVideoZoomEnum.none) {
            try {
                this.getMilestoneDvr().getTcpIsSession().sendMessage(new MilestoneZoomReq(bVideoZoomEnum));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void doMoveToPreset(BValue bValue) {
        try {
            this.getMilestoneDvr().getTcpIsSession().sendMessage(new MilestoneMoveToPresetReq((BDynamicEnum)bValue));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doStorePreset(BValue bValue) {
        try {
            this.getMilestoneDvr().getTcpIsSession().sendMessage(new MilestoneStorePresetReq((BDynamicEnum)bValue));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(moveToPreset) || action.equals(storePreset)) {
            BEnumRange bEnumRange = this.getPresetText();
            int[] nArray = bEnumRange.getOrdinals();
            int n = nArray == null || nArray.length == 0 ? 0 : nArray[0];
            return BDynamicEnum.make((int)n, (BEnumRange)bEnumRange);
        }
        return super.getActionParameterDefault(action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startRecordingAlarm(BAlarmRecord bAlarmRecord) {
        if (bAlarmRecord.getSourceState() == BSourceState.normal) {
            BMilestoneStopRecordingModeEnum bMilestoneStopRecordingModeEnum = this.getStopRecordingMode();
            if (bMilestoneStopRecordingModeEnum == BMilestoneStopRecordingModeEnum.onTimer) return;
            if (bMilestoneStopRecordingModeEnum != BMilestoneStopRecordingModeEnum.onAlarmToNormal) throw new IllegalStateException("Unrecognized BMilestoneStopRecordingModeEnum: " + (Object)((Object)bMilestoneStopRecordingModeEnum));
            this.doForceStopRecording();
            return;
        } else {
            this.doForceStartRecording();
        }
    }

    public void doForceStartRecording() {
        MilestoneCameraInitiateRecordingReq milestoneCameraInitiateRecordingReq = new MilestoneCameraInitiateRecordingReq(this);
        milestoneCameraInitiateRecordingReq.setStartRecording(true);
        try {
            milestoneCameraInitiateRecordingReq.setAddress((BAddress)this.getMilestoneDvr().tcpAddress());
            this.getMilestoneDvr().getTcpCpSession().sendMessage(milestoneCameraInitiateRecordingReq);
        }
        catch (Exception exception) {
            this.getLog().error("Error in Initiate Recording Req");
        }
    }

    public void doForceStopRecording() {
        MilestoneCameraInitiateRecordingReq milestoneCameraInitiateRecordingReq = new MilestoneCameraInitiateRecordingReq(this);
        milestoneCameraInitiateRecordingReq.setStartRecording(false);
        try {
            milestoneCameraInitiateRecordingReq.setAddress((BAddress)this.getMilestoneDvr().tcpAddress());
            this.getMilestoneDvr().getTcpCpSession().sendMessage(milestoneCameraInitiateRecordingReq);
        }
        catch (Exception exception) {
            this.getLog().error("Error in Initiate Recording Req");
        }
    }

    public String getCameraId() {
        return ((BMilestoneCameraDeviceId)this.getVideoDeviceId()).getCameraId();
    }

    public static synchronized int getNextVideoRequestId() {
        return videoRequestId++;
    }

    public BAbsTime getCameraTime() {
        try {
            return BAbsTime.now();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BMilestoneNetwork getMilestoneNetwork() {
        return (BMilestoneNetwork)this.getNetwork();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ConnectionMaintainer
    extends Thread {
        protected boolean running = true;
        BMilestoneCamera camera;

        public ConnectionMaintainer(BMilestoneCamera bMilestoneCamera2) {
            super("MilestoneCommunicator:MaintainConnection");
            this.camera = bMilestoneCamera2;
        }

        public BMilestoneCamera getMilestoneCamera() {
            return this.camera;
        }

        public void start() {
            this.running = true;
            super.start();
        }

        public void stopConnectionMaintainer() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            try {
                while (this.running) {
                    try {
                        this.maintainConnection();
                    }
                    catch (Exception exception) {
                        BMilestoneCamera.this.getLog().error("Error while maintaining camera connection for ptz control", (Throwable)exception);
                    }
                    Thread.sleep(BMilestoneCamera.this.getMilestonePtzReconnectInterval().getMillis());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                BMilestoneCamera.this.getLog().trace("Connection maintainer thread finished.");
            }
        }

        protected void maintainConnection() {
            BMilestoneCamera bMilestoneCamera = this.getMilestoneCamera();
            String string = bMilestoneCamera.getMilestoneDatabaseId();
            if (string.length() == 0) {
                bMilestoneCamera.doPing();
            } else {
                BMilestoneCamera.this.establishMilestonePtzCameraConnection(string);
            }
        }
    }
}

