/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rtsp;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.baja.io.Base64;
import javax.baja.log.Log;
import javax.baja.rtsp.RtpPacket;
import javax.baja.rtsp.RtpStream;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.util.Array;
import javax.baja.util.Queue;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RtspConnection {
    static final int init = 0;
    static final int describe = 1;
    static final int initsetup = 2;
    static final int setup = 3;
    static final int ready = 4;
    static final int play = 5;
    static final int paused = 6;
    static final int WAIT_MEDIA_VIDEO = 0;
    static final int WAIT_VIDEO_TRACKID = 1;
    static final int GOT_VIDEO_TRACKID = 2;
    static int MAX_WAIT_TIME = 5000;
    private static final int MAX_READ_RETRIES = 20;
    private static final int PACKET_DEQUEUE_TIMEOUT = 3000;
    protected Socket controlSocket;
    protected OutputStream controlOut;
    protected InputStream controlInput;
    protected int state;
    protected int CSeq;
    protected int present_session;
    protected String trackid;
    protected int lastError;
    protected String lastCcommand;
    private boolean is_describe;
    private boolean is_setup;
    private boolean is_play;
    private boolean is_pause;
    private boolean is_teardown;
    private boolean is_get_parameter;
    private boolean is_set_parameter;
    private boolean is_announce;
    private boolean is_record;
    private boolean is_redirect;
    protected String hostname;
    protected String username;
    protected String password;
    protected int controlPort;
    protected int dataPort;
    protected String rtspUri;
    public int chunksize;
    protected int timeout;
    String videoParams;
    boolean useBasic;
    String nonce;
    String authorization;
    protected SessionObject session;
    protected UdpDataReader udpReader;
    protected UdpDataReader rtcpReader;
    boolean useTcp;
    protected KeepAliveTask keepAliveTask;
    protected TcpInputStreamReader tcpReader;
    private String keepAliveCommandString;
    boolean useQueue;
    int rtpPacketQueueSize;
    BufferedInputStream buffIn;
    BufferedReader bufferedReader;
    Queue tcpRtpPacketQueue;
    Queue tcpRtspPacketQueue;
    private Object readMonitor;
    private RtspResponsePacket currentRtspResponsePacket;
    DataInputStream din;
    RtpStream pipein;
    Timer keepAliveTimer;
    byte[] tcpRtpPayloadBuffer;
    static /* synthetic */ Class class$java$lang$String;

    public void setAuthorization(String string, String string2) {
        this.username = string;
        this.password = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setupControlSocket() {
        try {
            if (this.hostname == null) throw new Exception("Unknown / Invalid Host");
            if (this.controlSocket == null) {
                this.controlSocket = new Socket(this.bsplit(this.hostname, "/")[0], this.controlPort);
                this.controlSocket.setSoTimeout(100);
            } else {
                this.controlSocket.close();
                this.controlInput = null;
                this.controlOut = null;
                this.controlSocket = new Socket(this.bsplit(this.hostname, "/")[0], this.controlPort);
                this.controlSocket.setSoTimeout(100);
            }
            this.controlOut = this.controlSocket.getOutputStream();
            this.controlInput = this.controlSocket.getInputStream();
            if (this.useTcp) {
                this.buffIn = new BufferedInputStream(this.controlInput);
                this.bufferedReader = new BufferedReader(new InputStreamReader(this.buffIn));
                this.din = new DataInputStream(this.buffIn);
                if (this.tcpReader != null) return;
                this.tcpReader = new TcpInputStreamReader();
                this.tcpReader.start();
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace("***** TCP STREAM READER STARTED *****");
                }
                this.tcpReader.setPriority(10);
                return;
            }
            while (true) {
                if (this.udpReader != null) {
                    return;
                }
                try {
                    this.udpReader = new UdpDataReader("RtspUdpReader", this.dataPort, this.pipein, true);
                    this.udpReader.setPriority(10);
                }
                catch (Exception exception) {
                    if (this.udpReader != null && this.udpReader.isAlive()) {
                        this.udpReader.done = true;
                    }
                    this.udpReader = null;
                    this.dataPort += 2;
                }
            }
        }
        catch (Exception exception) {
            this.getLog().error("Error while setting up control socket", (Throwable)exception);
        }
    }

    protected int getOptions() {
        int n;
        while (true) {
            int n2 = this.sendRtspCommand(this.getOptionsString());
            n = -1;
            if (n2 != 1) break;
            n = this.readOptions();
            if (n >= 0) {
                return n;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return n;
    }

    protected String getOptionsString() {
        if (this.nonce == "") {
            return "OPTIONS " + this.rtspUri + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\n\r\n";
        }
        return "OPTIONS " + this.rtspUri + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAuthorization: " + this.authorization + "\r\n";
    }

    protected int readOptions() {
        String string;
        int n = this.readStatus();
        if (this.useTcp) {
            String[] stringArray = this.currentRtspResponsePacket.body();
            if (n == 200) {
                String string2 = null;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].startsWith("Public:")) {
                        string2 = stringArray[n2];
                        break;
                    }
                    ++n2;
                }
                if (string2 != null) {
                    boolean bl = false;
                    if (string2.indexOf("DESCRIBE") > -1) {
                        bl = true;
                    }
                    this.is_describe = bl;
                    boolean bl2 = false;
                    if (string2.indexOf("GET_PARAMETER") > -1) {
                        bl2 = true;
                    }
                    this.is_get_parameter = bl2;
                    boolean bl3 = false;
                    if (string2.indexOf("ANNOUNCE") > -1) {
                        bl3 = true;
                    }
                    this.is_announce = bl3;
                    boolean bl4 = false;
                    if (string2.indexOf("SETUP") > -1) {
                        bl4 = true;
                    }
                    this.is_setup = bl4;
                    boolean bl5 = false;
                    if (string2.indexOf("PLAY") > -1) {
                        bl5 = true;
                    }
                    this.is_play = bl5;
                    boolean bl6 = false;
                    if (string2.indexOf("PAUSE") > -1) {
                        bl6 = true;
                    }
                    this.is_pause = bl6;
                    boolean bl7 = false;
                    if (string2.indexOf("TEARDOWN") > -1) {
                        bl7 = true;
                    }
                    this.is_teardown = bl7;
                    boolean bl8 = false;
                    if (string2.indexOf("SET_PARAMETER") > -1) {
                        bl8 = true;
                    }
                    this.is_set_parameter = bl8;
                    boolean bl9 = false;
                    if (string2.indexOf("RECORD") > -1) {
                        bl9 = true;
                    }
                    this.is_record = bl9;
                    boolean bl10 = false;
                    if (string2.indexOf("REDIRECT") > -1) {
                        bl10 = true;
                    }
                    this.is_redirect = bl10;
                }
            } else if (n == 401) {
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    stringBuffer.append(stringArray[n3]);
                    ++n3;
                }
                String string3 = this.parseValue(stringBuffer, "realm");
                this.nonce = this.parseValue(stringBuffer, "nonce");
                this.authorization = "";
                try {
                    String string4;
                    this.authorization = string4 = this.getAuthorization(string3, this.nonce, this.rtspUri, this.username, this.password, "OPTIONS");
                    this.useBasic = false;
                    return -1;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return n;
        }
        if (n == 200) {
            String string5;
            while (!(string5 = this.readResponseLine(MAX_WAIT_TIME)).trim().startsWith("CSeq:")) {
            }
            if (Integer.parseInt(this.bsplit(string5, ":")[1].trim()) == this.CSeq) {
                while (!(string5 = this.readResponseLine(MAX_WAIT_TIME).trim()).startsWith("Public:")) {
                }
                String[] stringArray = this.bsplit(this.bsplit(string5, ":")[1], ",");
                int n4 = 0;
                while (n4 < stringArray.length) {
                    if (stringArray[n4].trim().indexOf("DESCRIBE") >= 0) {
                        this.is_describe = true;
                    } else if (stringArray[n4].indexOf("GET_PARAMETER") >= 0) {
                        this.is_get_parameter = true;
                    } else if (stringArray[n4].indexOf("ANNOUNCE") >= 0) {
                        this.is_announce = true;
                    } else if (stringArray[n4].indexOf("SETUP") >= 0) {
                        this.is_setup = true;
                    } else if (stringArray[n4].indexOf("PLAY") >= 0) {
                        this.is_play = true;
                    } else if (stringArray[n4].indexOf("PAUSE") >= 0) {
                        this.is_pause = true;
                    } else if (stringArray[n4].indexOf("TEARDOWN") >= 0) {
                        this.is_teardown = true;
                    } else if (stringArray[n4].indexOf("SET_PARAMETER") >= 0) {
                        this.is_set_parameter = true;
                    } else if (stringArray[n4].indexOf("RECORD") >= 0) {
                        this.is_record = true;
                    } else if (stringArray[n4].indexOf("REDIRECT") >= 0) {
                        this.is_redirect = true;
                    }
                    ++n4;
                }
            }
            while (!this.readResponseLine(MAX_WAIT_TIME).equals("")) {
            }
            return n;
        }
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readResponseLine(MAX_WAIT_TIME)) != "") {
            stringBuffer.append(string);
        }
        if (n == 401) {
            string = this.parseValue(stringBuffer, "realm");
            this.nonce = this.parseValue(stringBuffer, "nonce");
            this.authorization = "";
            try {
                String string6;
                this.authorization = string6 = this.getAuthorization(string, this.nonce, this.rtspUri, this.username, this.password, "OPTIONS");
                n5 = -1;
                this.useBasic = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.lastError = n;
        this.lastCcommand = "OPTIONS";
        return n5;
    }

    protected int getDescribe() {
        int n = 0;
        int n2 = this.sendRtspCommand(this.getDescribeString());
        if (n2 > 0) {
            n = this.readDescribe();
        }
        return n;
    }

    protected String getDescribeString() {
        if (this.useBasic) {
            if (!this.videoParams.equals("")) {
                return "DESCRIBE " + this.rtspUri + '?' + this.videoParams + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAccept: application/sdp\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\n\r\n";
            }
            return "DESCRIBE " + this.rtspUri + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAccept: application/sdp\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\n\r\n";
        }
        return "DESCRIBE " + this.rtspUri + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAccept: application/sdp\r\n\r\n";
    }

    protected int readDescribe() {
        String string;
        int n = this.readStatus();
        if (this.useTcp && n == 200) {
            String[] stringArray = this.currentRtspResponsePacket.body();
            int n2 = stringArray.length - 1;
            while (n2 >= 0) {
                int n3;
                String string2 = stringArray[n2];
                this.session.parseLine(string2.trim());
                if (string2.startsWith("a=control") && (n3 = string2.indexOf("trackID=")) > -1) {
                    this.trackid = string2.substring(n3 + "trackID=".length());
                }
                --n2;
            }
            ++this.CSeq;
            return n;
        }
        if (n == 200) {
            String string3;
            while (!(string3 = this.readResponseLine(MAX_WAIT_TIME)).equals("")) {
            }
            string3 = this.readResponseLine(MAX_WAIT_TIME);
            int n4 = 0;
            while (!string3.equals("")) {
                this.session.parseLine(string3.trim());
                switch (n4) {
                    case 0: {
                        if (!string3.startsWith("m=video")) break;
                        n4 = 1;
                        break;
                    }
                    case 1: {
                        if (string3.startsWith("a=control")) {
                            int n5 = string3.indexOf("trackID=");
                            if (n5 <= 0) break;
                            this.trackid = string3.substring(n5 + 8);
                            n4 = 2;
                            break;
                        }
                        if (!string3.startsWith("m=")) break;
                        n4 = 0;
                        break;
                    }
                }
                string3 = this.readResponseLine(MAX_WAIT_TIME);
            }
            ++this.CSeq;
            return n;
        }
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readResponseLine(MAX_WAIT_TIME)) != "") {
            stringBuffer.append(string);
        }
        if (n == 401) {
            string = this.parseValue(stringBuffer, "realm");
            this.nonce = this.parseValue(stringBuffer, "nonce");
            this.authorization = "";
            try {
                String string4;
                this.authorization = string4 = this.getAuthorization(string, this.nonce, this.rtspUri, this.username, this.password, "OPTIONS");
                n6 = -1;
                this.useBasic = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.lastError = n;
        this.lastCcommand = "OPTIONS";
        return n6;
    }

    protected int getSetup() {
        int n = 0;
        int n2 = this.sendRtspCommand(this.getSetupString(this.videoParams));
        if (n2 > 0) {
            n = this.readSetup();
        }
        if (n != 200 && (n2 = this.sendRtspCommand(this.getSetupString(""))) > 0) {
            n = this.readSetup();
        }
        return n;
    }

    protected String getSetupString(String string) {
        String string2 = "RTP/AVP/UDP;unicast;client_port=" + this.dataPort + '-' + (this.dataPort + 1);
        String string3 = "RTP/AVP/TCP;interleaved=0-1";
        String string4 = this.useTcp ? string3 : string2;
        int n = -1;
        n = this.trackid.indexOf("?");
        if (n != -1 && !string.equals("")) {
            this.trackid = this.trackid.substring(0, n);
        }
        if (this.useBasic) {
            if (!string.equals("")) {
                return "SETUP " + this.rtspUri + "/trackID=" + this.trackid + '?' + string + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nBlocksize: " + this.chunksize + "\r\nTransport: " + string4 + "\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\n\r\n";
            }
            return "SETUP " + this.rtspUri + "/trackID=" + this.trackid + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nBlocksize: " + this.chunksize + "\r\nTransport: " + string4 + "\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\n\r\n";
        }
        if (!string.equals("")) {
            return "SETUP " + this.rtspUri + "/trackID=" + this.trackid + '?' + string + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nBlocksize: " + this.chunksize + "\r\nTransport: " + string4 + "\r\nAuthorization: " + this.authorization + "\r\n\r\n";
        }
        return "SETUP " + this.rtspUri + "/trackID=" + this.trackid + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nBlocksize: " + this.chunksize + "\r\nTransport: " + string4 + "\r\nAuthorization: " + this.authorization + "\r\n\r\n";
    }

    protected int readSetup() {
        String string;
        int n = this.readStatus();
        if (this.useTcp && n == 200) {
            String[] stringArray = this.currentRtspResponsePacket.body();
            int n2 = 0;
            while (n2 < stringArray.length) {
                Object object;
                String string2 = stringArray[n2];
                if (string2.startsWith("Session:")) {
                    object = this.bsplit(string2, ":", 2)[1];
                    object = this.bsplit((String)object, ";", 2)[0].trim();
                    this.session.setSessionId((String)object);
                    this.session.setSessionTimeout(Integer.parseInt(this.bsplit(string2, "timeout=", 2)[1]));
                } else if (string2.startsWith("Transport:")) {
                    object = this.bsplit(string2, ";");
                    int n3 = 0;
                    while (n3 < ((String[])object).length) {
                        if (object[n3].startsWith("ssrc")) {
                            this.session.SSRC = this.bsplit(object[n3], "=")[1];
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++this.CSeq;
            return n;
        }
        if (n == 200) {
            Object object = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit((String)object, ":")[1].trim()) == this.CSeq) {
                Object object2;
                object = this.readResponseLine(MAX_WAIT_TIME);
                if (object.indexOf("Date:") >= 0) {
                    object2 = object;
                }
                while (object != "") {
                    if (object.startsWith("Session")) {
                        object2 = this.bsplit((String)object, ":", 2)[1];
                        object2 = this.bsplit((String)object2, ";", 2)[0].trim();
                        this.session.setSessionId((String)object2);
                        this.session.setSessionTimeout(Integer.parseInt(this.bsplit((String)object, "timeout=", 2)[1]));
                    }
                    if (object.startsWith("Transport")) {
                        object2 = this.bsplit((String)object, ";");
                        int n4 = 0;
                        while (n4 < ((String[])object2).length) {
                            if (object2[n4].startsWith("server_port=")) {
                                String[] stringArray = this.bsplit(this.bsplit(object2[n4], "=")[1], "-");
                                this.session.server_port_rtp = Integer.parseInt(stringArray[0]);
                                this.session.server_port_rtcp = Integer.parseInt(stringArray[1]);
                            }
                            if (object2[n4].startsWith("ssrc")) {
                                this.session.SSRC = this.bsplit(object2[n4], "=")[1];
                            }
                            ++n4;
                        }
                    }
                    object = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return n;
        }
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readResponseLine(MAX_WAIT_TIME)) != "") {
            stringBuffer.append(string);
        }
        if (n == 401) {
            string = this.parseValue(stringBuffer, "realm");
            this.nonce = this.parseValue(stringBuffer, "nonce");
            this.authorization = "";
            try {
                String string3;
                this.authorization = string3 = this.getAuthorization(string, this.nonce, this.rtspUri, this.username, this.password, "OPTIONS");
                n5 = -1;
                this.useBasic = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.lastError = n;
        this.lastCcommand = "SETUP";
        return n5;
    }

    protected int getPlay() {
        int n = 0;
        int n2 = this.sendRtspCommand(this.getPlayString(this.videoParams));
        if (n2 > 0) {
            n = this.readPlay();
        }
        if (n != 200 && (n2 = this.sendRtspCommand(this.getPlayString(""))) > 0) {
            n = this.readPlay();
        }
        return n;
    }

    protected String getPlayString(String string) {
        if (this.useBasic) {
            if (!string.equals("")) {
                return "PLAY " + this.rtspUri + '?' + string + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\n\r\n";
            }
            return "PLAY /" + this.bsplit(this.hostname, "/", 2)[1] + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\n\r\n";
        }
        if (!string.equals("")) {
            return "PLAY " + this.rtspUri + '?' + string + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nRange: npt=0.000-\r\n\r\n";
        }
        return "PLAY " + this.rtspUri + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nRange: npt=0.000-\r\n\r\n";
    }

    protected int readPlay() {
        String string;
        int n = this.readStatus();
        if (this.useTcp && n == 200) {
            ++this.CSeq;
            return n;
        }
        if (n == 200) {
            String string2 = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit(string2, ":")[1].trim()) == this.CSeq) {
                string2 = this.readResponseLine(MAX_WAIT_TIME);
                if (string2.indexOf("Date:") >= 0) {
                    String string3 = string2;
                }
                while (string2 != "") {
                    string2 = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return n;
        }
        while ((string = this.readResponseLine(MAX_WAIT_TIME)) != "") {
        }
        this.lastError = n;
        this.lastCcommand = "PLAY";
        return 0;
    }

    protected int doStop() {
        int n = 0;
        this.getLog().trace("Sending TEARDOWN command...");
        int n2 = this.sendRtspCommand(this.getTearDownString());
        if (n2 > 0) {
            this.getLog().trace("TEARDOWN command sent...");
            int n3 = 200;
            return n3;
        }
        return n;
    }

    protected String getTearDownString() {
        if (this.useBasic) {
            return "TEARDOWN /" + this.bsplit(this.hostname, "/", 2)[1] + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\n\r\n";
        }
        return "TEARDOWN " + this.rtspUri + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\n\r\n";
    }

    protected int readStop() {
        String string;
        int n = this.readStatus();
        if (this.useTcp && n == 200) {
            ++this.CSeq;
            return n;
        }
        if (n == 200) {
            String string2 = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit(string2, ":")[1].trim()) == this.CSeq) {
                string2 = this.readResponseLine(MAX_WAIT_TIME);
                if (string2.indexOf("Date:") >= 0) {
                    String string3 = string2;
                }
                while (string2 != "") {
                    string2 = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return n;
        }
        while ((string = this.readResponseLine(MAX_WAIT_TIME)) != "") {
        }
        this.lastError = n;
        this.lastCcommand = "TEARDOWN";
        return 0;
    }

    protected int doPause() {
        int n = 0;
        int n2 = this.sendRtspCommand(this.getPauseString());
        if (n2 > 0) {
            return this.readPause();
        }
        return n;
    }

    protected String getPauseString() {
        return "PAUSE /" + this.bsplit(this.hostname, "/", 2)[1] + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\n\r\n";
    }

    protected int readPause() {
        String string;
        int n = this.readStatus();
        if (n == 200) {
            String string2 = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit(string2, ":")[1].trim()) == this.CSeq) {
                string2 = this.readResponseLine(MAX_WAIT_TIME);
                if (string2.indexOf("Date:") >= 0) {
                    String string3 = string2;
                }
                while (string2 != "") {
                    string2 = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return n;
        }
        while ((string = this.readResponseLine(MAX_WAIT_TIME)) != "") {
        }
        this.lastError = n;
        this.lastCcommand = "PUASE";
        return 0;
    }

    public int setParameter(String string) {
        int n = 0;
        int n2 = this.sendRtspCommand(this.getSetParameterString(string));
        if (n2 > 0) {
            n = this.readSetParameter();
        }
        return n;
    }

    protected String getSetParameterString(String string) {
        String string2;
        String string3 = "RTP/AVP/UDP;unicast;client_port=" + this.dataPort + '-' + (this.dataPort + 1);
        String string4 = "RTP/AVP/TCP;interleaved=0-1";
        String string5 = string2 = this.useTcp ? string4 : string3;
        if (this.useBasic) {
            return "SET_PARAMETER rtsp://" + this.hostname + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nTransport: " + string2 + "\r\nAuthorization: Basic " + Base64.encode((byte[])(this.username + ':' + this.password).getBytes()) + "\r\nContent-Type: text/parameters\r\nContent-Length:" + string.length() + "\r\n\r\n" + string + "\r\n\r\n";
        }
        return "SET_PARAMETER " + this.rtspUri + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nTransport: " + string2 + "\r\nContent-Type: text/parameters\r\nContent-Length:" + string.length() + "\r\n\r\n" + string + "\r\n\r\n";
    }

    protected int readSetParameter() {
        String string;
        int n = this.readStatus();
        if (n == 200) {
            String string2 = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit(string2, ":")[1].trim()) == this.CSeq) {
                string2 = this.readResponseLine(MAX_WAIT_TIME);
                if (string2.indexOf("Date:") >= 0) {
                    String string3 = string2;
                }
                while (string2 != "") {
                    if (string2.startsWith("Session")) {
                        this.session.setSessionId(this.bsplit(string2, ":", 2)[1]);
                    }
                    string2.startsWith("Transport");
                    string2 = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return n;
        }
        while ((string = this.readResponseLine(MAX_WAIT_TIME)) != "") {
        }
        this.lastError = n;
        this.lastCcommand = "SETUP";
        return 0;
    }

    protected int sendKeepAlive() {
        return this.sendRtspCommand(this.getAliveString());
    }

    protected String getAliveString() {
        if (this.keepAliveCommandString == null) {
            this.keepAliveCommandString = "OPTIONS rtsp://" + this.bsplit(this.hostname, "/")[0] + ':' + this.controlPort + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nSession :" + this.session.sessionId + "\r\n\r\n";
        }
        return this.keepAliveCommandString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connect(String string) throws Exception {
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("Video params = " + string);
        }
        this.setupControlSocket();
        this.videoParams = string;
        int n = this.getOptions();
        if (n != 200) throw new Exception("Unable to get a proper response to OPTIONS");
        this.state = 1;
        if (!this.is_describe) return;
        n = this.getDescribe();
        if (n != 200) throw new Exception("Unable to get a proper response to DESCRIBE");
        this.state = 2;
    }

    public boolean isConnected() {
        return this.state == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void play() throws Exception {
        int n = 0;
        if (!this.isConnected()) return;
        if (!this.is_play) return;
        n = this.getSetup();
        if (n != 200) throw new Exception("Cannot SETUP");
        this.state = 3;
        n = this.getPlay();
        if (n != 200) throw new Exception("Cannot PLAY");
        this.state = 5;
        try {
            if (this.keepAliveTask == null) {
                this.keepAliveTask = new KeepAliveTask();
            }
            if (this.keepAliveTimer == null) {
                this.keepAliveTimer = new Timer();
            }
            long l = this.session.timeout * 500;
            this.keepAliveTimer.scheduleAtFixedRate((TimerTask)this.keepAliveTask, l, l);
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("***** KEEP ALIVE TIMER THREAD STARTED ******");
            }
            if (this.useTcp) return;
            this.udpReader.start();
            if (!this.getLog().isTraceOn()) return;
            this.getLog().trace("***** RTP PACKET READER STARTED ******");
            return;
        }
        catch (Exception exception) {
            this.getLog().error("There was an error starting the data readers", (Throwable)exception);
        }
    }

    public boolean isPlaying() {
        return this.state == 5;
    }

    public void pause() throws Exception {
        if (this.isPlaying() && this.is_pause) {
            int n = this.doPause();
            if (n != 200) {
                throw new Exception("Cannot Pause");
            }
            if (!this.useTcp) {
                this.udpReader.wait();
            }
            this.state = 6;
        }
    }

    public boolean isPaused() {
        return this.state == 6;
    }

    public void stop() throws Exception {
        if ((this.isPlaying() || this.isPaused()) && this.is_teardown) {
            this.state = 0;
            this.doStop();
            if (this.useTcp && this.tcpReader != null) {
                this.tcpReader.done = true;
            } else if (this.udpReader != null) {
                this.udpReader.done = true;
            }
            if (this.controlSocket != null) {
                this.controlSocket.close();
            }
        }
    }

    public void cleanUp() {
        try {
            this.controlSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isStopped() {
        return this.state == 0;
    }

    public InputStream getInputStream() throws IOException {
        if (this.pipein != null) {
            return this.pipein;
        }
        throw new IOException("Null Stream");
    }

    protected int readStatus() {
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("Waiting for RTSP response status code...");
        }
        if (!this.useTcp) {
            String string;
            while ((string = this.readResponseLine(MAX_WAIT_TIME)).indexOf("RTSP/1.0") == -1) {
                if (!this.getLog().isTraceOn()) continue;
                this.getLog().trace("Finished waiting for RTSP response status code...");
            }
            String[] stringArray = TextUtil.split((String)string, (char)' ');
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].indexOf("RTSP/1.0") != -1) {
                    return Integer.parseInt(stringArray[n + 1]);
                }
                ++n;
            }
        } else if (this.currentRtspResponsePacket != null && this.currentRtspResponsePacket.cseq == this.CSeq) {
            return this.currentRtspResponsePacket.status;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readResponseLine(int n) {
        String string = "";
        try {
            this.controlSocket.setSoTimeout(2000);
        }
        catch (Exception exception) {}
        try {
            long l = Clock.ticks() + (long)n;
            while (!this.controlSocket.isClosed()) {
                if (Clock.ticks() > l) {
                    string = " ";
                    break;
                }
                Object object = this.readMonitor;
                synchronized (object) {
                    int n2 = this.controlInput.read();
                    if (n2 == 13) {
                        int n3 = this.controlInput.read();
                        if (n3 == 10) {
                            break;
                        }
                        string = string + (char)n2;
                        string = string + (char)n3;
                    } else {
                        if (n2 == 10) {
                            break;
                        }
                        if (n2 != -1) {
                            string = string + (char)n2;
                            l = Clock.ticks() + (long)n;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {}
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("received = " + string);
        }
        return string.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendRtspCommand(String string) {
        int n = 1;
        try {
            if (this.controlSocket == null) return n;
            if (this.controlSocket.isClosed()) return n;
            this.controlOut.write(string.getBytes());
            this.controlOut.flush();
            if (!this.useTcp) return n;
            if (!this.tcpReader.isAlive()) return n;
            Queue queue = this.tcpRtspPacketQueue;
            synchronized (queue) {
                this.tcpRtspPacketQueue.wait(2000L);
                this.currentRtspResponsePacket = (RtspResponsePacket)this.tcpRtspPacketQueue.dequeue(100);
                return n;
            }
        }
        catch (Exception exception) {
            Log log = this.getLog();
            if (!log.isTraceOn()) return -1;
            log.trace("Exception while sending RTSP command", (Throwable)exception);
            return -1;
        }
    }

    public Log getLog() {
        return Log.getLog((String)("rtsp." + this.bsplit(this.hostname, "/")[0].trim()));
    }

    public String getAuthorization(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        ++this.CSeq;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Digest username=").append("\"").append(string4).append("\"").append(", ");
        stringBuffer.append("realm=").append("\"").append(string).append("\"").append(", ");
        stringBuffer.append("nonce=").append("\"").append(string2).append("\"").append(", ");
        stringBuffer.append("uri=").append("\"").append(string3).append("\"").append(", ");
        stringBuffer.append("response=\"");
        String string7 = string4 + ':' + string + ':' + this.password;
        String string8 = this.hexMD5(string7);
        String string9 = string6 + ':' + string3;
        String string10 = this.hexMD5(string9);
        stringBuffer.append(this.hexMD5(string8 + ':' + string2 + ':' + string10));
        stringBuffer.append("\"\r\n");
        return stringBuffer.toString();
    }

    protected String hexMD5(String string) {
        StringBuffer stringBuffer;
        block3: {
            stringBuffer = new StringBuffer();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = messageDigest.digest(string.getBytes());
                int n = 0;
                while (n < byArray.length) {
                    stringBuffer.append(TextUtil.toLowerCase((String)TextUtil.byteToHexString((int)byArray[n])));
                    ++n;
                }
            }
            catch (Exception exception) {
                if (!this.getLog().isTraceOn()) break block3;
                this.getLog().trace("error creating digest", (Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    public String[] bsplit(String string, String string2) {
        return this.bsplit(string, string2, 0);
    }

    public String[] bsplit(String string, String string2, int n) {
        if (string2 == "" || string2.length() == 0) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            while (n2 < cArray.length) {
                stringBuffer.append(cArray[n2]);
                vector.addElement(stringBuffer.toString());
                stringBuffer.setLength(0);
                ++n2;
            }
            String[] stringArray = new String[vector.size()];
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringArray[n3] = (String)vector.elementAt(n3);
                ++n3;
            }
            return stringArray;
        }
        if (string2 == null) {
            throw new NullPointerException("Delimiter cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("String source cannot be null");
        }
        int n4 = Integer.MAX_VALUE;
        boolean bl = true;
        if (n <= 0) {
            bl = false;
        } else {
            bl = true;
            n4 = n - 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        char[] cArray = string.toCharArray();
        int n5 = 0;
        boolean bl2 = false;
        int n6 = 0;
        while (n6 < cArray.length) {
            String string3;
            if (n6 + string2.length() <= cArray.length && n5 < n4 && (string3 = new String(cArray, n6, string2.length())).equals(string2)) {
                vector.addElement(stringBuffer.toString());
                stringBuffer.setLength(0);
                bl2 = true;
                ++n5;
                n6 = n6 + string2.length() - 1;
            } else {
                stringBuffer.append(cArray[n6]);
                bl2 = false;
            }
            ++n6;
        }
        if (stringBuffer.length() > 0 || bl2 && !bl) {
            vector.addElement(stringBuffer.toString());
        }
        String[] stringArray = new String[vector.size()];
        int n7 = 0;
        while (n7 < stringArray.length) {
            stringArray[n7] = (String)vector.elementAt(n7);
            ++n7;
        }
        return stringArray;
    }

    private final String parseValue(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.indexOf(string);
        if (n < 0) {
            return "";
        }
        int n2 = stringBuffer.indexOf("\"", n);
        int n3 = stringBuffer.indexOf("\"", n2 + 1);
        if (n2 < 0 || n3 < 0) {
            return "";
        }
        return stringBuffer.substring(n2 + 1, n3);
    }

    static /* synthetic */ int access$0() {
        return 20;
    }

    static /* synthetic */ int access$1() {
        return 3000;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.state = 0;
        this.CSeq = 0;
        this.present_session = 0;
        this.trackid = "0";
        this.lastError = 0;
        this.lastCcommand = "";
        this.hostname = "";
        this.username = "";
        this.password = "";
        this.controlPort = 554;
        this.dataPort = 9000;
        this.rtspUri = "";
        this.chunksize = 1500;
        this.timeout = 1000;
        this.videoParams = "";
        this.useBasic = true;
        this.nonce = "";
        this.authorization = "";
        this.useTcp = false;
        this.readMonitor = new Object();
    }

    public RtspConnection(String string, int n, int n2, boolean bl) throws Exception {
        this.this();
        this.hostname = string;
        this.controlPort = n;
        this.dataPort = n2;
        this.state = 0;
        this.rtspUri = "rtsp://" + this.bsplit(this.hostname, "/")[0].trim() + ':' + n + '/' + this.bsplit(this.hostname, "/", 2)[1];
        this.pipein = new RtpStream();
        this.useTcp = bl;
        this.pipein.session = this.session = new SessionObject();
        if (bl && this.tcpRtspPacketQueue == null) {
            this.tcpRtspPacketQueue = new Queue();
        }
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("rtspUri = " + this.rtspUri);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TcpInputStreamReader
    extends Thread {
        private boolean done;
        private int numRetries;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (!this.done && !RtspConnection.this.controlSocket.isClosed()) {
                block26: {
                    try {
                        var1_1 = new byte[8];
                        RtspConnection.this.buffIn.read(var1_1, 0, 2);
                        if (var1_1[0] == 36 && var1_1[1] == 0) {
                            var2_4 = RtspConnection.this.din.readUnsignedShort();
                            if (RtspConnection.this.tcpRtpPayloadBuffer == null || RtspConnection.this.tcpRtpPayloadBuffer.length != var2_4) {
                                RtspConnection.this.tcpRtpPayloadBuffer = new byte[var2_4];
                            }
                            RtspConnection.this.din.readFully(RtspConnection.this.tcpRtpPayloadBuffer);
                            var3_6 = new RtpPacket();
                            var3_6.read(RtspConnection.this.tcpRtpPayloadBuffer, var2_4);
                            RtspConnection.this.pipein.addPacket((RtpPacket)var3_6, true);
                            this.numRetries = 0;
                            var4_7 = RtspConnection.this.pipein;
                            // MONITORENTER : var4_7
                            var6_9 = Clock.ticks();
                            RtspConnection.this.pipein.wait(3000L);
                            var8_12 = Clock.ticks() - var6_9;
                            if (var8_12 >= 3000L) {
                                // MONITOREXIT : var4_7
                                break;
                            }
                            // MONITOREXIT : var4_7
                            continue;
                        }
                        RtspConnection.this.buffIn.read(var1_1, 2, 6);
                        var2_5 = new String(var1_1);
                        if (!var2_5.equals("RTSP/1.0")) continue;
                        var3_6 = new RtspResponsePacket();
                        var4_7 = var2_5 + RtspConnection.this.bufferedReader.readLine();
                        var5_8 = false;
                        var6_10 = 0;
                        while (true) {
                            block27: {
                                if (!var4_7.equals("")) break block27;
                                if (!var5_8) break block26;
                                if (true) ** GOTO lbl69
                            }
                            var3_6.body.add(var4_7);
                            var7_11 = TextUtil.split((String)var4_7, (char)' ');
                            if (var7_11[0].equals("RTSP/1.0")) {
                                var3_6.status = Integer.parseInt(var7_11[1]);
                            } else if (var7_11[0].equals("CSeq:")) {
                                var3_6.cseq = Integer.parseInt(var7_11[1]);
                            } else if (var7_11[0].equals("Content-Length:")) {
                                var6_10 = Integer.parseInt(var7_11[1]);
                            } else if (var4_7.startsWith("Content-Type: application/sdp")) {
                                var5_8 = true;
                            }
                            var4_7 = RtspConnection.this.bufferedReader.readLine();
                        }
                    }
                    catch (Exception var1_2) {
                        if (var1_2 instanceof SocketTimeoutException && this.numRetries++ < 20) continue;
                        if (!RtspConnection.this.getLog().isTraceOn()) break;
                        RtspConnection.this.getLog().trace("TCP Stream Reader read timeout", (Throwable)var1_2);
                    }
                    break;
                    do {
                        var4_7 = RtspConnection.this.bufferedReader.readLine();
                        var3_6.body.add(var4_7);
                        var6_10 -= var4_7.getBytes().length + 2;
lbl69:
                        // 2 sources

                    } while (var6_10 > 0);
                }
                var7_11 = RtspConnection.this.tcpRtspPacketQueue;
                // MONITORENTER : RtspConnection.this.tcpRtspPacketQueue
                RtspConnection.this.tcpRtspPacketQueue.enqueue(var3_6);
                RtspConnection.this.tcpRtspPacketQueue.notifyAll();
                // MONITOREXIT : var7_11
            }
            RtspConnection.this.doStop();
            if (RtspConnection.this.keepAliveTimer != null) {
                RtspConnection.this.keepAliveTimer.cancel();
            }
            try {
                RtspConnection.this.tcpRtspPacketQueue.clear();
                RtspConnection.this.pipein.close();
                RtspConnection.this.controlSocket.close();
                return;
            }
            catch (IOException var1_3) {
                var1_3.printStackTrace();
            }
        }

        static /* synthetic */ boolean access$0(TcpInputStreamReader tcpInputStreamReader) {
            return tcpInputStreamReader.done;
        }

        private final /* synthetic */ void this() {
            this.done = false;
            this.numRetries = 0;
        }

        public TcpInputStreamReader() {
            this.this();
            this.setName("RtspTcpReader");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class UdpDataReader
    extends Thread {
        boolean done;
        int dataport;
        DatagramSocket udpSocket;
        RtpStream rtpStream;
        boolean RTP;
        byte[] buf;
        byte[] rtpData;
        DatagramPacket udpPacket;
        int numRetries;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (!this.done) {
                try {
                    if (this.udpSocket != null && !this.udpSocket.isClosed()) {
                        this.udpSocket.receive(this.udpPacket);
                    }
                    System.arraycopy(this.udpPacket.getData(), 0, this.rtpData, 0, this.udpPacket.getLength());
                    RtpPacket rtpPacket = new RtpPacket();
                    rtpPacket.read(this.rtpData, this.udpPacket.getLength());
                    this.numRetries = 0;
                    this.rtpStream.addPacket(rtpPacket, true);
                    RtpStream rtpStream = this.rtpStream;
                    // MONITORENTER : rtpStream
                    long l = Clock.ticks();
                    this.rtpStream.wait(3000L);
                    long l2 = Clock.ticks() - l;
                    if (l2 >= 3000L) {
                        // MONITOREXIT : rtpStream
                        break;
                    }
                    // MONITOREXIT : rtpStream
                    continue;
                }
                catch (Exception exception) {
                    if (exception instanceof SocketTimeoutException && this.numRetries++ < 20) continue;
                    if (!RtspConnection.this.getLog().isTraceOn()) break;
                    RtspConnection.this.getLog().trace("UDP Reader read timeout", (Throwable)exception);
                }
                break;
            }
            RtspConnection.this.doStop();
            if (RtspConnection.this.keepAliveTimer != null) {
                RtspConnection.this.keepAliveTimer.cancel();
            }
            try {
                this.udpSocket.close();
                this.rtpStream.close();
                RtspConnection.this.controlSocket.close();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private final /* synthetic */ void this() {
            this.done = false;
            this.buf = new byte[1600];
            this.rtpData = new byte[1600];
            this.udpPacket = new DatagramPacket(this.buf, this.buf.length);
            this.numRetries = 0;
        }

        public UdpDataReader(String string, int n, RtpStream rtpStream, boolean bl) throws Exception {
            this.this();
            this.setName(string);
            this.dataport = n;
            this.rtpStream = rtpStream;
            this.RTP = bl;
            this.udpSocket = new DatagramSocket(n);
            this.udpSocket.setReceiveBufferSize(0x7D0000);
            this.udpSocket.setSoTimeout(1000);
            this.rtpStream.setPortandBuffer(n, this.udpSocket.getReceiveBufferSize());
            this.done = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class RtspResponsePacket {
        public int status;
        public int cseq;
        public Array body;

        public String[] body() {
            return (String[])this.body.trim();
        }

        private final /* synthetic */ void this() {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = RtspConnection.class("[Ljava.lang.String;", false);
            }
            this.body = new Array(clazz);
        }

        public RtspResponsePacket() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class SessionObject {
        public long currentTime;
        public long updated;
        public int timeout;
        public int server_port_rtp;
        public int server_port_rtcp;
        public String sdpString;
        public String sessionId;
        public String SSRC;

        public void setSessionId(String string) {
            this.sessionId = string;
        }

        public void setSessionTimeout(int n) {
            this.timeout = n;
            this.updated = BAbsTime.now().getMillis();
        }

        public void parseLine(String string) {
            this.sdpString = this.sdpString + string + '\n';
        }

        public long getCurrentTime() {
            return this.currentTime;
        }

        private final /* synthetic */ void this() {
            this.currentTime = 0L;
            this.updated = 0L;
            this.timeout = 0;
            this.sdpString = "";
            this.sessionId = "";
            this.SSRC = "";
        }

        public SessionObject() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeepAliveTask
    extends TimerTask {
        public void run() {
            RtspConnection.this.sendKeepAlive();
        }
    }
}

