/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonHoneywellXl15c;

import com.tridium.lonHoneywellXl15c.BSbcObject;
import com.tridium.lonHoneywellXl15c.BXl15cLearnJob;
import com.tridium.lonHoneywellXl15c.SbcConstants;
import com.tridium.lonHoneywellXl15c.datatypes.BLinkSource;
import com.tridium.lonHoneywellXl15c.datatypes.BPollRecord;
import com.tridium.lonHoneywellXl15c.enums.BDataTypeEnum;
import com.tridium.lonHoneywellXl15c.enums.BEngUnitsEnum;
import com.tridium.lonHoneywellXl15c.ui.BConfigWidget;
import com.tridium.lonHoneywellXl15c.ui.BPollPntCfgWidget;
import com.tridium.lonworks.xml.XElementQualifier;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XTypeDef;
import com.tridium.lonworks.xml.XUtil;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPollPoint
extends BSbcObject {
    public static final Property selectedElement = BPollPoint.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property pollConfig = BPollPoint.newProperty((int)0, (BValue)new BConfigParameter((BLonData)new BPollRecord(), 286, 15, BModifyFlags.DEFAULT, BLonConfigScope.node, ""), null);
    public static final Property analogLink = BPollPoint.newProperty((int)0, (BValue)new BLinkSource(SbcConstants.ANALOG, SbcConstants.IN_TABLE, SbcConstants.OUTPUT, 27, 1), null);
    public static final Property digitalLink = BPollPoint.newProperty((int)0, (BValue)new BLinkSource(SbcConstants.DIGITAL, SbcConstants.IN_TABLE, SbcConstants.OUTPUT, 29, 1), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$lonHoneywellXl15c$BPollPoint;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonData;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonPrimitive;

    public BOrd getSelectedElement() {
        return (BOrd)this.get(selectedElement);
    }

    public void setSelectedElement(BOrd bOrd) {
        this.set(selectedElement, (BValue)bOrd, null);
    }

    public BConfigParameter getPollConfig() {
        return (BConfigParameter)this.get(pollConfig);
    }

    public void setPollConfig(BConfigParameter bConfigParameter) {
        this.set(pollConfig, (BValue)bConfigParameter, null);
    }

    public BLinkSource getAnalogLink() {
        return (BLinkSource)this.get(analogLink);
    }

    public void setAnalogLink(BLinkSource bLinkSource) {
        this.set(analogLink, (BValue)bLinkSource, null);
    }

    public BLinkSource getDigitalLink() {
        return (BLinkSource)this.get(digitalLink);
    }

    public void setDigitalLink(BLinkSource bLinkSource) {
        this.set(digitalLink, (BValue)bLinkSource, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BConfigWidget getConfigWidget() {
        return new BPollPntCfgWidget(this);
    }

    public int getSbcObjectType() {
        return 8;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == selectedElement && context != BXl15cLearnJob.learning) {
            this.updatePollConfig();
        }
    }

    private final void updatePollConfig() {
        BOrd bOrd = this.getSelectedElement();
        try {
            OrdTarget ordTarget = bOrd.resolve((BObject)this.getLonNetwork());
            BComponent bComponent = ordTarget.getComponent();
            while (!bComponent.getType().is(BLonComponent.TYPE)) {
                bComponent = (BComponent)bComponent.getParent();
            }
            BNetworkVariable bNetworkVariable = (BNetworkVariable)bComponent;
            while (!bComponent.getType().is(BLonDevice.TYPE)) {
                bComponent = (BComponent)bComponent.getParent();
            }
            BLonDevice bLonDevice = (BLonDevice)bComponent;
            BPollRecord bPollRecord = (BPollRecord)this.getPollConfig().copyData();
            bPollRecord.setSubnet(BLonInteger.make((int)bLonDevice.getDeviceData().getSubnetNodeId().getSubnetId()));
            bPollRecord.setDomain(BLonInteger.make((int)bLonDevice.getDeviceData().getWorkingDomain()));
            bPollRecord.setNode(BLonInteger.make((int)bLonDevice.getDeviceData().getSubnetNodeId().getNodeId()));
            bPollRecord.setNvIndex(BLonInteger.make((int)bNetworkVariable.getNvIndex()));
            BLonData bLonData = (BLonData)ordTarget.getComponent();
            int n = bNetworkVariable.getSnvtType();
            if (bLonData.getPrimitives().length <= 1 && n > 0 && n <= 122) {
                bPollRecord.setSnvtType(BLonInteger.make((int)n));
                bPollRecord.setDataType(BLonEnum.make((BEnum)BDataTypeEnum.unconfigured));
                bPollRecord.setByteOffset(BLonInteger.DEFAULT);
                bPollRecord.setBitOffset(BLonInteger.DEFAULT);
                bPollRecord.setLength(BLonInteger.DEFAULT);
                bPollRecord.setScale(BLonInteger.DEFAULT);
                bPollRecord.setEngUnit(BLonEnum.make((BEnum)BEngUnitsEnum.noUnits));
            } else {
                Property property = ordTarget.getPropertyPathInComponent()[0];
                BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers((BFacets)property.getFacets());
                bPollRecord.setByteOffset(BLonInteger.make((int)BPollPoint.getByteOffset(bLonData, property)));
                bPollRecord.setBitOffset(BLonInteger.make((int)bLonElementQualifiers.getBitOffset()));
                n = this.getSnvtType(bLonElementQualifiers.getResolution(), (BUnit)property.getFacets().get("units", (BObject)BUnit.DEFAULT), bLonElementQualifiers.getLength());
                if (n > 0 && n <= 122) {
                    bPollRecord.setSnvtType(BLonInteger.make((int)n));
                    bPollRecord.setDataType(BLonEnum.make((BEnum)BDataTypeEnum.unconfigured));
                    bPollRecord.setLength(BLonInteger.DEFAULT);
                    bPollRecord.setScale(BLonInteger.DEFAULT);
                    bPollRecord.setEngUnit(BLonEnum.make((BEnum)BEngUnitsEnum.noUnits));
                } else {
                    bPollRecord.setSnvtType(BLonInteger.make((int)0));
                    bPollRecord.setDataType(BLonEnum.make((BEnum)this.getDataType(bLonElementQualifiers.getElemtype())));
                    int n2 = bLonElementQualifiers.getDataByteLength();
                    if (n2 == 0) {
                        n2 = bLonElementQualifiers.getLength();
                    }
                    bPollRecord.setLength(BLonInteger.make((int)n2));
                    bPollRecord.setScale(BLonInteger.make((int)this.getScale(bLonElementQualifiers.getResolution())));
                    bPollRecord.setEngUnit(BLonEnum.make((BEnum)BEngUnitsEnum.getEngUnitsEnum((BUnit)property.getFacets().get("units", (BObject)BUnit.DEFAULT))));
                }
            }
            this.getPollConfig().updateData((BLonData)bPollRecord, false);
            this.setStale(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final int getSnvtType(float f, BUnit bUnit, int n) {
        XLonInterfaceFile xLonInterfaceFile = XUtil.getStandard();
        int n2 = xLonInterfaceFile.types.size();
        int n3 = 0;
        while (n3 < n2) {
            XElementQualifier xElementQualifier;
            XTypeDef xTypeDef = (XTypeDef)xLonInterfaceFile.types.get(n3);
            if (xTypeDef.elems.size() == 1 && xTypeDef.getTypeIndex() <= 122 && f == (xElementQualifier = xTypeDef.getElement(0)).getResolution() && bUnit.getUnitName().equals(xElementQualifier.getEngUnit()) && n == xElementQualifier.getLength()) {
                return xTypeDef.getTypeIndex();
            }
            ++n3;
        }
        return 0;
    }

    private final BDataTypeEnum getDataType(BLonElementType bLonElementType) {
        BDataTypeEnum bDataTypeEnum = BDataTypeEnum.other;
        switch (bLonElementType.getOrdinal()) {
            case 1: 
            case 3: 
            case 5: {
                bDataTypeEnum = BDataTypeEnum.signed;
                break;
            }
            case 2: 
            case 4: {
                bDataTypeEnum = BDataTypeEnum.unsigned;
                break;
            }
            case 8: {
                bDataTypeEnum = BDataTypeEnum.float_;
                break;
            }
            case 6: {
                bDataTypeEnum = BDataTypeEnum.unsigned;
                break;
            }
            case 7: {
                bDataTypeEnum = BDataTypeEnum.unsigned;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                bDataTypeEnum = BDataTypeEnum.bit;
                break;
            }
            case 0: 
            case 14: {
                bDataTypeEnum = BDataTypeEnum.ascii;
                break;
            }
            case 15: {
                bDataTypeEnum = BDataTypeEnum.hex;
                break;
            }
        }
        return bDataTypeEnum;
    }

    private final int getScale(float f) {
        double d = Math.log(1.0f / f) / Math.log(2);
        return (int)Math.rint(d);
    }

    public void updateSelect() {
        BPollRecord bPollRecord = (BPollRecord)this.getPollConfig().getData();
        BSubnetNode bSubnetNode = BSubnetNode.make((int)bPollRecord.getSubnet().getInt(), (int)bPollRecord.getNode().getInt());
        BLonDevice bLonDevice = this.getLonNetwork().addressManager().getDeviceByAddress(bSubnetNode);
        if (bLonDevice == null) {
            return;
        }
        int n = bPollRecord.getNvIndex().getInt();
        BNetworkVariable bNetworkVariable = bLonDevice.getNetworkVariable(n);
        if (bNetworkVariable == null) {
            return;
        }
        int n2 = bPollRecord.getByteOffset().getInt();
        BLonData bLonData = bNetworkVariable.getData();
        try {
            EqSearch eqSearch = new EqSearch();
            this.findElement(bLonData, n2, eqSearch);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final void findElement(BLonData bLonData, int n, EqSearch eqSearch) throws LonException {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            if (bObject.getType().is(BLonData.TYPE)) {
                this.findElement((BLonData)bObject, n, eqSearch);
                if (!eqSearch.found) continue;
                return;
            }
            if (!bObject.getType().is(BLonPrimitive.TYPE)) continue;
            Property property = slotCursor.property();
            BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers((BFacets)property.getFacets());
            if (bLonElementQualifiers.hasOffset()) {
                eqSearch.offset = bLonElementQualifiers.getByteOffset();
            }
            if (n == eqSearch.offset) {
                this.setSelectedElement(bLonData, property.getName());
                eqSearch.found = true;
            }
            eqSearch.offset += bLonElementQualifiers.getDataByteLength();
        }
    }

    public void setSelectedElement(BLonData bLonData, String string) {
        String string2 = string.replace('.', '/');
        String string3 = bLonData.getSlotPath() + '/' + string2;
        BOrd bOrd = BOrd.make((String)string3);
        this.set(selectedElement, (BValue)bOrd, BXl15cLearnJob.learning);
    }

    private static final int getByteOffset(BLonData bLonData, Property property) {
        EqSearch eqSearch = new EqSearch();
        eqSearch.sLd = bLonData;
        eqSearch.prop = property;
        BLonData bLonData2 = bLonData;
        while (bLonData2.getParent() instanceof BLonData) {
            bLonData2 = (BLonData)bLonData2.getParent();
        }
        BPollPoint.getByteOffset(eqSearch, bLonData2);
        return eqSearch.offset;
    }

    private static final void getByteOffset(EqSearch eqSearch, BLonData bLonData) {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            Class clazz = class$javax$baja$lonworks$londata$BLonData;
            if (clazz == null) {
                clazz = BPollPoint.class("[Ljavax.baja.lonworks.londata.BLonData;", false);
            }
            if (clazz.isInstance(bObject)) {
                BPollPoint.getByteOffset(eqSearch, (BLonData)bObject);
                if (!eqSearch.found) continue;
                return;
            }
            Class clazz2 = class$javax$baja$lonworks$londata$BLonPrimitive;
            if (clazz2 == null) {
                clazz2 = BPollPoint.class("[Ljavax.baja.lonworks.londata.BLonPrimitive;", false);
            }
            if (!clazz2.isInstance(bObject)) continue;
            Property property = slotCursor.property();
            BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers((BFacets)property.getFacets());
            if (bLonElementQualifiers.hasOffset()) {
                eqSearch.offset = bLonElementQualifiers.getByteOffset();
            }
            if (property == eqSearch.prop && bLonData == eqSearch.sLd) {
                eqSearch.found = true;
                return;
            }
            int n = 1;
            try {
                n = bLonElementQualifiers.getDataByteLength();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            int n2 = eqSearch.offset;
            int n3 = 1;
            if (n != 0) {
                n3 = n;
            }
            eqSearch.offset = n2 + n3;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$lonHoneywellXl15c$BPollPoint;
        if (clazz == null) {
            clazz = class$com$tridium$lonHoneywellXl15c$BPollPoint = BPollPoint.class("[Lcom.tridium.lonHoneywellXl15c.BPollPoint;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class EqSearch {
        BLonData sLd;
        Property prop;
        int offset;
        boolean found;

        private final /* synthetic */ void this() {
            this.offset = 0;
            this.found = false;
        }

        private EqSearch() {
            this.this();
        }
    }
}

