/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.londevices.axwizard.ui.t7350;

import com.honeywell.londevices.axwizard.ui.t7350.BT7350OccEventStates;
import com.honeywell.londevices.axwizard.ui.t7350.BT7350UnoccEventStates;
import com.honeywell.londevices.axwizard.ui.t7350.T7350ByteArray;
import com.honeywell.londevices.axwizard.ui.t7350.T7350Event;
import com.honeywell.londevices.axwizard.ui.t7350.T7350OccEvent;
import com.honeywell.londevices.axwizard.ui.t7350.T7350UnoccEvent;
import javax.baja.gx.BColor;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class T7350Schedule {
    public static final BColor UNCONFIGUREDCOLOR = BColor.gray;
    public static final BColor STANDBYCOLOR = BColor.yellow;
    public static final BColor OCCUPIEDCOLOR = BColor.green;
    public static final BColor UNOCCUPIEDCOLOR = BColor.white;
    public static final T7350Schedule UNCONFIGUREDSCHEDULE = new T7350Schedule();
    public static final int EVENTLENGTH = 2;
    private static final int OCCEVENTMODULO = 2;
    private T7350Event[] event;

    public static BColor getStateColor(int n) {
        switch (n) {
            case 0: {
                return OCCUPIEDCOLOR;
            }
            case 3: {
                return STANDBYCOLOR;
            }
            case 7: {
                return UNCONFIGUREDCOLOR;
            }
            case 1: {
                return UNOCCUPIEDCOLOR;
            }
        }
        return null;
    }

    public void setSchedule(BLonByteArray bLonByteArray) {
        if (bLonByteArray.getBytes().length != 8) {
            throw new IllegalArgumentException("this cannot be a valid T7350 schedule");
        }
        T7350ByteArray t7350ByteArray = new T7350ByteArray(bLonByteArray.getBytes());
        int n = 0;
        int n2 = this.event.length - 1;
        while (n2 >= 0) {
            int n3 = t7350ByteArray.getUnsignedByte(n);
            byte by = (byte)t7350ByteArray.getBits(n + 1, 5, 3);
            int n4 = t7350ByteArray.getBits(n + 1, 0, 5);
            this.setEvent(n2, BTime.make((BRelTime)BRelTime.makeMinutes((int)(by * 256 + n3))), n4);
            n += 2;
            --n2;
        }
    }

    public void setEvent(int n, BTime bTime, int n2) {
        BFrozenEnum bFrozenEnum = null;
        if (n < 0 || n > this.event.length) {
            throw new IllegalArgumentException("a schedule has only four events");
        }
        if (this.isOccEventIndex(n)) {
            if (!BT7350OccEventStates.T7350Occupied.getRange().isOrdinal(n2)) {
                throw new IllegalArgumentException("State not of the respective event");
            }
            bFrozenEnum = BT7350OccEventStates.make(n2);
        } else {
            if (!BT7350UnoccEventStates.T7350Unconfigured.getRange().isOrdinal(n2)) {
                throw new IllegalArgumentException("State not of the respective event");
            }
            bFrozenEnum = BT7350UnoccEventStates.make(n2);
        }
        this.event[n].setStartTime(bTime);
        this.event[n].setState(bFrozenEnum);
    }

    public void setSchedule(T7350Schedule t7350Schedule) {
        int n = 0;
        while (n < this.event.length) {
            BTime bTime = t7350Schedule.getEvent(n).getStartTime();
            if (bTime != null) {
                bTime = BTime.make((int)bTime.getHour(), (int)bTime.getMinute(), (int)bTime.getSecond(), (int)bTime.getMillisecond());
            }
            this.setEvent(n, bTime, t7350Schedule.getEvent(n).getState().getOrdinal());
            ++n;
        }
    }

    public BLonByteArray getSchedule() {
        T7350ByteArray t7350ByteArray = new T7350ByteArray(8);
        int n = 0;
        int n2 = this.event.length - 1;
        while (n2 >= 0) {
            T7350Event t7350Event = this.getEvent(n2);
            BTime bTime = t7350Event.getStartTime();
            int n3 = 0;
            int n4 = 0;
            int n5 = 7;
            if (bTime != null) {
                int n6 = t7350Event.getStartTime().getHour() * 60 + t7350Event.getStartTime().getMinute();
                n3 = n6 / 256;
                n4 = n6 % 256;
                n5 = t7350Event.getState().getOrdinal();
            }
            t7350ByteArray.setByte(n, (byte)n4);
            t7350ByteArray.setBits(n + 1, 5, 3, (byte)n3);
            t7350ByteArray.setBits(n + 1, 0, 5, (byte)n5);
            n += 2;
            --n2;
        }
        return BLonByteArray.make((byte[])t7350ByteArray.getArray());
    }

    public T7350Event getEvent(int n) {
        if (n < 0 || n >= this.event.length) {
            throw new IllegalArgumentException("index should be within 0-3");
        }
        return this.event[n];
    }

    public T7350OccEvent getEvent1() {
        return (T7350OccEvent)this.getEvent(0);
    }

    public void setEvent1(BTime bTime, int n) {
        this.setEvent(0, bTime, n);
    }

    public T7350UnoccEvent getEvent2() {
        return (T7350UnoccEvent)this.getEvent(1);
    }

    public void setEvent2(BTime bTime, int n) {
        this.setEvent(1, bTime, n);
    }

    public T7350OccEvent getEvent3() {
        return (T7350OccEvent)this.getEvent(2);
    }

    public void setEvent3(BTime bTime, int n) {
        this.setEvent(2, bTime, n);
    }

    public T7350UnoccEvent getEvent4() {
        return (T7350UnoccEvent)this.getEvent(3);
    }

    public void setEvent4(BTime bTime, int n) {
        this.setEvent(3, bTime, n);
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < 4) {
            string = string + "Event" + n + ": State-" + this.getEvent(n).getState() + " :Time-" + this.getEvent(n).getStartTime() + '\t';
            ++n;
        }
        return string;
    }

    private final boolean isOccEventIndex(int n) {
        boolean bl = false;
        if (n % 2 == 0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.event = new T7350Event[4];
    }

    public T7350Schedule() {
        this.this();
        int n = 0;
        while (n < 4) {
            this.event[n] = this.isOccEventIndex(n) ? new T7350OccEvent() : new T7350UnoccEvent();
            ++n;
        }
    }
}

