/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.londevices.axwizard.ui.t7350;

import com.honeywell.londevices.axwizard.ui.t7350.BT7350Container;
import com.honeywell.londevices.axwizard.ui.t7350.T7350ByteArray;
import java.util.ArrayList;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class T7350Holiday {
    public static final BEnumRange DAYRANGE = BT7350Container.getEnumRange("u_day_t");
    public static final BEnumRange MONTHRANGE = BT7350Container.getEnumRange("u_month_t");
    public static final byte INVALIDMONTH = 0;
    public static final byte INVALIDDAY = 0;
    public static final byte INVALIDDURATION = 0;
    private static final int HOLIDAYDATALENGTH = 30;
    private static final int DURATIONOFFSET = 0;
    private static final int DAYOFFSET = 1;
    private static final int MONTHOFFSET = 2;
    private static final int ONEHOLIDAYLENGTH = 3;
    private static final int LOWESTDURATION = 1;
    private static final int HIGHESTDURATION = 99;
    private BEnum day;
    private BEnum month;
    private int duration;

    public synchronized void setDay(int n) {
        this.setHoliday(n, this.month.getOrdinal(), this.duration);
    }

    public synchronized void setMonth(int n) {
        this.setHoliday(this.day.getOrdinal(), n, this.duration);
    }

    public synchronized void setDuration(int n) {
        this.setHoliday(this.day.getOrdinal(), this.month.getOrdinal(), n);
    }

    public synchronized void setHoliday(int n, int n2, int n3) {
        if (n == 0 || n2 == 0) {
            this.day = null;
            this.month = null;
            this.duration = 0;
            return;
        }
        if (!DAYRANGE.isOrdinal(n) || !MONTHRANGE.isOrdinal(n2)) {
            throw new IllegalArgumentException("Invalid day and/or month for T7350");
        }
        if (n3 > 99 || n3 < 1) {
            throw new IllegalArgumentException("Duration should be with in range [1, 99]");
        }
        this.day = DAYRANGE.get(n);
        this.month = MONTHRANGE.get(n2);
        this.duration = n3;
    }

    public BEnum getDay() {
        return this.day;
    }

    public BEnum getMonth() {
        return this.month;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isConfigured() {
        return this.day != null && this.month != null;
    }

    public String toString() {
        if (!this.isConfigured()) {
            return "Invalid holiday";
        }
        String string = "";
        string = BT7350Container.getTextFromLexicon(this.month.getDisplayTag(null), "") + ' ' + BT7350Container.getTextFromLexicon(this.day.getDisplayTag(null), "") + " for " + this.duration + " day(s)";
        return string;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (super.equals(object)) {
            return true;
        }
        if (!(object instanceof T7350Holiday)) {
            return false;
        }
        T7350Holiday t7350Holiday = (T7350Holiday)object;
        return this.day.equals((Object)t7350Holiday.getDay()) && this.month.equals((Object)t7350Holiday.getMonth()) && this.duration == t7350Holiday.getDuration();
    }

    public static T7350Holiday[] getHolidays(BLonByteArray bLonByteArray) {
        if (bLonByteArray.getBytes().length != 30) {
            throw new IllegalArgumentException("Holiday data has 30 bytes");
        }
        T7350ByteArray t7350ByteArray = new T7350ByteArray(bLonByteArray.getBytes());
        T7350Holiday[] t7350HolidayArray = new T7350Holiday[10];
        int n = 0;
        int n2 = 0;
        while (n2 < t7350HolidayArray.length) {
            t7350HolidayArray[n2] = new T7350Holiday();
            t7350HolidayArray[n2].setHoliday(t7350ByteArray.getByte(n + 1), t7350ByteArray.getByte(n + 2), t7350ByteArray.getUnsignedByte(n));
            n += 3;
            ++n2;
        }
        return t7350HolidayArray;
    }

    public static T7350Holiday[] getConfiguredHolidays(BLonByteArray bLonByteArray) {
        T7350Holiday[] t7350HolidayArray = T7350Holiday.getHolidays(bLonByteArray);
        ArrayList<T7350Holiday> arrayList = new ArrayList<T7350Holiday>();
        int n = 0;
        while (n < t7350HolidayArray.length) {
            if (t7350HolidayArray[n].isConfigured()) {
                arrayList.add(t7350HolidayArray[n]);
            }
            ++n;
        }
        arrayList.trimToSize();
        if (arrayList.size() == 0) {
            return null;
        }
        T7350Holiday[] t7350HolidayArray2 = new T7350Holiday[arrayList.size()];
        arrayList.toArray(t7350HolidayArray2);
        return t7350HolidayArray2;
    }

    public static BLonByteArray getHolidaySchedule(T7350Holiday[] t7350HolidayArray) {
        T7350ByteArray t7350ByteArray = new T7350ByteArray(30);
        int n = 0;
        while (n < t7350ByteArray.getArray().length) {
            t7350ByteArray.setByte(n + 1, (byte)0);
            t7350ByteArray.setByte(n + 2, (byte)0);
            t7350ByteArray.setByte(n, (byte)0);
            n += 3;
        }
        if (t7350HolidayArray == null) {
            return BLonByteArray.make((byte[])t7350ByteArray.getArray());
        }
        n = 0;
        int n2 = 0;
        while (n < t7350HolidayArray.length) {
            t7350ByteArray.setByte(n2 + 1, (byte)t7350HolidayArray[n].getDay().getOrdinal());
            t7350ByteArray.setByte(n2 + 2, (byte)t7350HolidayArray[n].getMonth().getOrdinal());
            t7350ByteArray.setByte(n2, (byte)t7350HolidayArray[n].getDuration());
            ++n;
            n2 += 3;
        }
        return BLonByteArray.make((byte[])t7350ByteArray.getArray());
    }

    private final /* synthetic */ void this() {
        this.day = null;
        this.month = null;
        this.duration = 0;
    }

    public T7350Holiday() {
        this.this();
    }
}

