/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.londevices.axwizard.ui.t7350;

import javax.baja.util.ByteArrayUtil;

public class T7350ByteArray {
    private byte[] array;

    public synchronized void setArray(byte[] byArray) {
        this.array = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.array, 0, byArray.length);
    }

    public int getBitAsInt(int n, int n2) {
        return this.getBit(n, n2) ? 1 : 0;
    }

    public boolean getBit(int n, int n2) {
        this.isLegalBitOffset(n2);
        boolean bl = false;
        if (this.getBits(n, n2, 1) == 1) {
            bl = true;
        }
        return bl;
    }

    public int getBits(int n, int n2, int n3) {
        this.isLegalBitOffset(n2);
        if (n3 > 8) {
            throw new IllegalArgumentException("length cannot be greater than 8");
        }
        byte by = (byte)((byte)(Math.pow(2, n3) - 1.0) << n2);
        byte by2 = this.andByte(n, by);
        return (byte)(by2 >>> n2 & (int)(Math.pow(2, n3) - 1.0));
    }

    public short getShort(int n) {
        return ByteArrayUtil.readShort((byte[])this.getArray(n, 2), (int)0);
    }

    public int getInt(int n) {
        return ByteArrayUtil.readInt((byte[])this.getArray(n, 4), (int)0);
    }

    public int getUnsignedByte(int n) {
        return this.getByte(n) & 0xFF;
    }

    public int getUnsignedShort(int n) {
        return this.getShort(n) & (char)-1;
    }

    public synchronized byte getByte(int n) {
        return this.array[n];
    }

    public synchronized byte[] getArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.array, n, byArray, 0, n2);
        return byArray;
    }

    public byte[] getArray() {
        return this.getArray(0, this.array.length);
    }

    public void setBit(int n, int n2, boolean bl) {
        byte by = bl ? (byte)1 : 0;
        this.setBits(n, n2, 1, by);
    }

    public void setBit(int n, int n2, byte by) {
        this.setBits(n, n2, 1, by);
    }

    public synchronized void setBits(int n, int n2, int n3, byte by) {
        this.isLegalBitOffset(n2);
        if (n3 > 8 || n2 + n3 > 8) {
            throw new IllegalArgumentException("length should be less than 8");
        }
        if ((double)by > Math.pow(2, n3) - 1.0 || by < 0) {
            throw new IllegalArgumentException("value should satisfy (value > (Math.pow(2,length) - 1))|| (value<0)");
        }
        by = (byte)(by << n2);
        byte by2 = -1;
        by2 = (byte)(by2 << n3 + n2);
        by2 = (byte)(by2 | (byte)((int)Math.pow(2, n2) - 1));
        by2 = this.andByte(n, by2);
        by2 = (byte)(by2 | by);
        this.setByte(n, by2);
    }

    public synchronized void setByte(int n, byte by) {
        this.array[n] = by;
    }

    public void setBytes(int n, byte[] byArray) {
        if (n + byArray.length > this.array.length) {
            throw new IllegalArgumentException("(byteOffset + arr.length) > array.length");
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            this.setByte(n + n2, byArray[n2]);
            ++n2;
        }
    }

    public void setShort(int n, short s) {
        byte[] byArray = new byte[2];
        ByteArrayUtil.writeShort((byte[])byArray, (int)0, (int)s);
        int n2 = 0;
        while (n2 < byArray.length) {
            this.setByte(n + n2, byArray[n2]);
            ++n2;
        }
    }

    public byte andByte(int n, byte by) {
        return (byte)(this.getByte(n) & by);
    }

    public byte orByte(int n, byte by) {
        return (byte)(this.getByte(n) | by);
    }

    public String toString() {
        return ByteArrayUtil.toHexString((byte[])this.array);
    }

    private final void isLegalBitOffset(int n) {
        if (n > 7 || n < 0) {
            throw new IllegalArgumentException("bitoffset cannot be greater than 7or<0");
        }
    }

    public T7350ByteArray() {
        this.array = null;
    }

    public T7350ByteArray(int n) {
        this.setArray(new byte[n]);
    }

    public T7350ByteArray(byte[] byArray) {
        this.setArray(byArray);
    }
}

