/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.londevices.axwizard.ui.t7350;

import com.honeywell.framework.BStep;
import com.honeywell.framework.BStepModifiedEvent;
import com.honeywell.framework.IConfigurationStepContainer;
import com.honeywell.framework.StepContainerException;
import com.honeywell.framework.dragdrop.BBorderPaneEx;
import com.honeywell.framework.dragdrop.BCheckBoxEx;
import com.honeywell.framework.dragdrop.BLabelEx;
import com.honeywell.framework.dragdrop.BPaneBase;
import com.honeywell.londevices.axwizard.ui.t7350.BDefaultEnumDropDown;
import com.honeywell.londevices.axwizard.ui.t7350.BDefaultIntegerField;
import com.honeywell.londevices.axwizard.ui.t7350.BT7350HolidayPage;
import com.honeywell.londevices.axwizard.ui.t7350.BT7350KeyPdDisplayPage;
import com.honeywell.londevices.axwizard.ui.t7350.BT7350SchedulePage;
import com.honeywell.londevices.axwizard.ui.t7350.DisableDeselectCheck;
import com.honeywell.londevices.axwizard.ui.t7350.T7350ByteArray;
import com.honeywell.londevices.utilities.BAXContainer;
import com.honeywell.londevices.utilities.BAXUtil;
import com.honeywell.londevices.utilities.BEnumDropDown;
import com.honeywell.londevices.utilities.BGridPaneEx;
import com.honeywell.londevices.utilities.BNVUtil;
import com.honeywell.londevices.xl10controller.t7350.BT7350;
import com.honeywell.londevices.xl10controller.t7350.BT7350ModelType;
import com.honeywell.londevices.xl10controller.t7350.ext.BAbstractExt;
import com.tridium.sys.Nre;
import java.text.DecimalFormat;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BPane;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BT7350Container
extends BAXContainer {
    public static final Lexicon LEXICON;
    public static final BAXUtil enumUtil;
    public static final int WIDGETHEIGHT = 20;
    private static int iRemoteTempSensor;
    private static int iIntTimeLowLim;
    private static int iDerTimeLowLim;
    private static int iSCALE10;
    public static final String eqpCtrlpge = "T7350EquipControl_Pane";
    public static final String generalPge = "T7350General_Pane";
    public static final String keyPdDisplay = "T7350KeypdDisplay_Pane";
    public static final String stPntPge = "T7350SetPoint_Page";
    public static final String schdPge = "T7350Schedule_Pane";
    public static final String hldPge = "T7350Holidays_Pane";
    public static final String T7350WizardTitle = "T7350WizardTitle";
    public static final String tempMetricUnit = "celsius";
    public static final String tempEngUnit = "fahrenheit";
    public static final String tempMetricDiffUnit = "celsius degrees";
    public static final String tempEngDiffUnit = "fahrenheit degrees";
    public static final String heatRateUnit = "degrees fahrenheit per hour";
    public static final String secUnit = "second";
    public static final String minUnit = "minute";
    public static final String pctUnit = "percent";
    public static final String hourUnit = "hour";
    private static String OATRmpUnit;
    private static String rampRateUnit;
    private static String setPointUnit;
    private static final int leftLabelMargin = 2;
    private static int generalPaneIndex;
    private static int outputPaneIndex;
    private static int inputPaneIndex;
    private static int daylightPaneIndex;
    private static int kpLockoutPaneIndex;
    private static int unitPaneIndex;
    private static int clkDisplayPaneIndex;
    private static int sysSwitchPaneIndex;
    private static int fanSwitchPaneIndex;
    private static int htandcoolPaneIndex;
    private static int rangeStopPaneIndex;
    private static int enrgMgmtPaneIndex;
    private static int dehumidPaneIndex;
    private static int recoveryPaneIndex;
    private static int bypassPaneIndex;
    private static int heatSelectPaneIndex;
    private static int heatOATPaneIndex;
    private static int coolSelectPaneIndex;
    private static int coolOATPaneIndex;
    private static int TuningParameterPaneIndex;
    private static int antAuthPaneIndex;
    private static int borderPaneCount;
    private static int gridPaneCount;
    public static final int leftMarginInsets = 0;
    public static final int topMarginInsets = 5;
    public static final int columnGap = 10;
    public static final int rowGap = 10;
    public static final BHalign HALIGN;
    public static final BHalign labelHALIGN;
    public static final BValign VALIGN;
    public static final BValign labelVALIGN;
    public static final Type TYPE;
    private BT7350 device;
    BGridPaneEx[] gridPanes;
    private BDefaultIntegerField[] textField;
    private BLabel[] labels;
    private BCheckBox[] checkBoxes;
    private BListDropDown[] dropDowns;
    BBorderPaneEx[] borderPane;
    private BBorderPaneEx dehumidification;
    private BBorderPaneEx coolOATPane;
    private BBorderPaneEx heatOATPane;
    private BDefaultIntegerField txfClUnoccStpt;
    private BDefaultIntegerField txfClStdbyStpt;
    private BDefaultIntegerField txfClOccStpt;
    private BDefaultIntegerField txfHtOccStpt;
    private BDefaultIntegerField txfHtStdbyStpt;
    private BDefaultIntegerField txfHtUnoccStpt;
    private BDefaultIntegerField txfHtMinOcc;
    private BDefaultIntegerField txfClMaxOcc;
    private BDefaultIntegerField txfHumHiLimit;
    private BDefaultIntegerField txfHtOATMinRmp;
    private BDefaultIntegerField txfClOATMinRmp;
    private BDefaultIntegerField txfClMinRamp;
    private BDefaultIntegerField txfClMaxRamp;
    private BDefaultIntegerField txfHtMinRamp;
    private BDefaultIntegerField txfHtMaxRamp;
    private BDefaultIntegerField txfHtOATMxRmp;
    private BDefaultIntegerField txfClOATMxRmp;
    private BDefaultIntegerField txfHtOAT;
    private BDefaultIntegerField txfClOAT;
    private BDefaultIntegerField txfHtDATHi;
    private BDefaultIntegerField txfClDATHi;
    private BDefaultIntegerField txfClThrtlRange;
    private BDefaultIntegerField txfHtThrtlRange;
    private BDefaultIntegerField txfClIntegralTime;
    private BDefaultIntegerField txfHtIntegralTime;
    private BDefaultIntegerField txfClDerivTime;
    private BDefaultIntegerField txfHtDerivTime;
    private BDefaultIntegerField txfAntAuth;
    private BLabel lbModel;
    private BLabel lbEquipType;
    private BLabel lbHeatStgs;
    private BLabel lbCoolStgs;
    private BLabel lbAuxDO;
    private BLabel lbHtPmpRevAction;
    private BLabel lbCoolAction;
    private BLabel lbAuxHtStgs;
    private BLabel lbRoomTemp;
    private BLabel lbRoomHumid;
    private BLabel lbDATemp;
    private BLabel lbOATemp;
    private BLabel lbOccSensor;
    private BLabel lbRecLead;
    private BLabel lbHeat;
    private BLabel lbCool;
    private BCheckBox cbDayLghtSave;
    private BCheckBox cbCoolOAT;
    private BCheckBox cbHeatOAT;
    private BCheckBox cbHeatDAT;
    private BCheckBox cbCoolDAT;
    private BCheckBox cbMinOnTime;
    private BCheckBox cbResetHum;
    private BCheckBox cbReheat;
    private BCheckBox cbHtIntegralTime;
    private BCheckBox cbHtDeriveTime;
    private BCheckBox cbClDeriveTime;
    private BCheckBox cbClIntegralTime;
    private BCheckBox cbAntAuth;
    private BButton butConfigID;
    private BListDropDown ddDLCBump;
    private BListDropDown ddPowerFail;
    private BListDropDown ddResetTempStpt;
    private BListDropDown ddMinOnTime;
    private BListDropDown ddBypassTime;
    private BDefaultEnumDropDown ddModel;
    private BDefaultEnumDropDown ddEquipType;
    private BDefaultEnumDropDown ddHtAction;
    private BDefaultEnumDropDown ddCoolAction;
    private BDefaultEnumDropDown ddHtPmpRevValue;
    private BDefaultEnumDropDown ddRoomTemp;
    private BDefaultEnumDropDown ddRoomHumid;
    private BDefaultEnumDropDown ddDATemp;
    private BDefaultEnumDropDown ddOATemp;
    private BDefaultEnumDropDown ddOccSensor;
    private BDefaultEnumDropDown ddHtFanOn;
    private BDefaultEnumDropDown ddHtExtFanOp;
    private BDefaultEnumDropDown ddHtCycRate;
    private BDefaultEnumDropDown ddClExtFanOp;
    private BDefaultEnumDropDown ddClCycRate;
    private BDefaultEnumDropDown dd009StdHtStages;
    private BDefaultEnumDropDown dd009StdCoolStgs;
    private BDefaultEnumDropDown dd009HPAuxHtStgs;
    private BDefaultEnumDropDown dd009HPCompressorStgs;
    private BDefaultEnumDropDown dd017AuxHtStgs;
    private BDefaultEnumDropDown dd017CompressorStgs;
    private BEnumDropDown ddStartDay;
    private BEnumDropDown ddStartMonth;
    private BEnumDropDown ddStopDay;
    private BEnumDropDown ddStopMonth;
    private BEnumDropDown ddAuxDO;
    private DisableDeselectCheck cmdHeatOAT;
    private DisableDeselectCheck cmdCoolOAT;
    private DisableDeselectCheck cmdHeatDAT;
    private DisableDeselectCheck cmdCoolDAT;
    private DisableDeselectCheck cmdDayLtSave;
    private DisableDeselectCheck cmdClIntTime;
    private DisableDeselectCheck cmdClDerTime;
    private DisableDeselectCheck cmdHtIntTime;
    private DisableDeselectCheck cmdHtDerTime;
    private DisableDeselectCheck cmdMinOnTime;
    private DisableDeselectCheck cmdResetTempStpt;
    private BPaneBase equipCtrlPane;
    private BPaneBase generalPane;
    private BPaneBase setPointPane;
    private BT7350KeyPdDisplayPage kpdDisplayPane;
    private BT7350SchedulePage schdPane;
    private BT7350HolidayPage holPane;
    private int equipTxfStart;
    private int equipTxfEnd;
    private int iSetptTxfStop;
    private int iSetptTxfStart;
    private int currentLabel;
    private int currentCheckBox;
    private int currentDropDown;
    private int currentTextField;
    private int iHtLowTemp;
    private int iHtHiTemp;
    private int iClLowTemp;
    private int iClHiTemp;
    private T7350Model selectedModel;
    private T7350Model t7350H0009;
    private T7350Model t7350H0017;
    private T7350ByteArray nciConfig;
    private T7350ByteArray nciConfigPts;
    private T7350ByteArray nciDayLghtSav;
    private int unitConversion;
    private int modelType;
    private int setPointStep;
    private String htStptProp;
    private String clStptProp;
    private boolean bConfigIDGeneration;
    private boolean bResetting;
    static /* synthetic */ Class class$com$honeywell$londevices$axwizard$ui$t7350$BT7350Container;

    private final void resetEquipCtrlPage() {
        this.ddHtExtFanOp.setSelectedOrdinal(this.nciConfig.getBitAsInt(4, 4));
        this.ddHtCycRate.setSelectedOrdinal(this.nciConfig.getBits(6, 2, 2));
        this.txfHtOAT.setValue(this.getDisplayValueRndOff(tempEngUnit, this.nciConfigPts.getByte(21)));
        this.txfHtDATHi.setValue(this.getDisplayValueRndOff(tempEngUnit, this.nciConfigPts.getUnsignedByte(19)));
        this.cmdHeatOAT.setSelected(this.nciConfig.getBit(4, 6));
        this.cmdHeatDAT.setSelected(this.nciConfig.getBit(3, 3));
        this.ddClExtFanOp.setSelectedOrdinal(this.nciConfig.getBitAsInt(4, 5));
        this.ddClCycRate.setSelectedOrdinal(this.nciConfig.getBitAsInt(6, 4));
        this.txfClOAT.setValue(this.getDisplayValueRndOff(tempEngUnit, this.nciConfigPts.getByte(20)));
        this.txfClDATHi.setValue(this.getDisplayValueRndOff(tempEngUnit, this.nciConfigPts.getUnsignedByte(18)));
        this.cmdCoolOAT.setSelected(this.nciConfig.getBit(4, 7));
        this.cmdCoolDAT.setSelected(this.nciConfig.getBit(3, 2));
        this.txfHtThrtlRange.setValue(this.getDisplayValueRndOff(tempEngDiffUnit, this.nciConfigPts.getUnsignedByte(5)));
        this.setIntTime(this.nciConfigPts.getUnsignedShort(8), this.cmdHtIntTime, this.txfHtIntegralTime);
        this.txfHtDerivTime.setValue(this.nciConfigPts.getUnsignedShort(6));
        boolean bl = false;
        if (this.nciConfigPts.getUnsignedShort(6) >= iDerTimeLowLim) {
            bl = true;
        }
        this.cmdHtDerTime.setSelected(bl);
        this.txfClThrtlRange.setValue(this.getDisplayValueRndOff(tempEngDiffUnit, this.nciConfigPts.getUnsignedByte(0)));
        this.setIntTime(this.nciConfigPts.getUnsignedShort(3), this.cmdClIntTime, this.txfClIntegralTime);
        this.txfClDerivTime.setValue(this.nciConfigPts.getUnsignedShort(1));
        boolean bl2 = false;
        if (this.nciConfigPts.getUnsignedShort(1) >= iDerTimeLowLim) {
            bl2 = true;
        }
        this.cmdClDerTime.setSelected(bl2);
        this.txfAntAuth.setValue(this.nciConfig.getBits(2, 0, 4));
        this.cbAntAuth.setSelected(this.nciConfig.getBit(1, 7) ^ true);
    }

    private final void saveEquipCtrlPage() {
        boolean bl = false;
        if (this.ddHtExtFanOp.getSelectedOrdinal() == 1) {
            bl = true;
        }
        this.nciConfig.setBit(4, 4, bl);
        this.nciConfig.setBits(6, 2, 2, (byte)this.ddHtCycRate.getSelectedOrdinal());
        this.nciConfig.setBit(4, 6, this.cmdHeatOAT.isSelected());
        this.nciConfig.setBit(3, 3, this.cmdHeatDAT.isSelected());
        this.nciConfigPts.setByte(21, (byte)this.getNativeValueRndOff(tempEngUnit, this.txfHtOAT.getValue()));
        this.nciConfigPts.setByte(19, (byte)this.getNativeValueRndOff(tempEngUnit, this.txfHtDATHi.getValue()));
        this.nciConfig.setBit(4, 5, (byte)this.ddClExtFanOp.getSelectedOrdinal());
        this.nciConfig.setBit(6, 4, (byte)this.ddClCycRate.getSelectedOrdinal());
        this.nciConfig.setBit(4, 7, this.cmdCoolOAT.isSelected());
        this.nciConfig.setBit(3, 2, this.cmdCoolDAT.isSelected());
        this.nciConfigPts.setByte(20, (byte)this.getNativeValueRndOff(tempEngUnit, this.txfClOAT.getValue()));
        this.nciConfigPts.setByte(18, (byte)this.getNativeValueRndOff(tempEngUnit, this.txfClDATHi.getValue()));
        this.nciConfigPts.setByte(5, (byte)this.getNativeValueRndOff(tempEngDiffUnit, this.txfHtThrtlRange.getValue()));
        this.nciConfigPts.setShort(8, (short)this.txfHtIntegralTime.getValue());
        this.nciConfigPts.setShort(6, (short)this.txfHtDerivTime.getValue());
        this.nciConfigPts.setByte(0, (byte)this.getNativeValueRndOff(tempEngDiffUnit, this.txfClThrtlRange.getValue()));
        this.nciConfigPts.setShort(3, (short)this.txfClIntegralTime.getValue());
        this.nciConfigPts.setShort(1, (short)this.txfClDerivTime.getValue());
        this.nciConfig.setBit(1, 7, this.cbAntAuth.isSelected() ^ true);
        this.nciConfig.setBits(2, 0, 4, (byte)this.txfAntAuth.getValue());
    }

    private final void unloadEquipCtrlPage() throws StepContainerException {
        int n = this.equipTxfStart;
        while (n <= this.equipTxfEnd) {
            try {
                this.textField[n].unload();
            }
            catch (StepContainerException stepContainerException) {}
            ++n;
        }
    }

    private final void saveSetPntPage() {
        BNVUtil bNVUtil = new BNVUtil((BLonComponent)this.device.get("nciSetpoints"), null);
        this.setFloatProperty(bNVUtil, "occupiedCool", this.txfClOccStpt.getValue());
        this.setFloatProperty(bNVUtil, "standbyCool", this.txfClStdbyStpt.getValue());
        this.setFloatProperty(bNVUtil, "unoccupiedCool", this.txfClUnoccStpt.getValue());
        this.setFloatProperty(bNVUtil, "occupiedHeat", this.txfHtOccStpt.getValue());
        this.setFloatProperty(bNVUtil, "standbyHeat", this.txfHtStdbyStpt.getValue());
        this.setFloatProperty(bNVUtil, "unoccupiedHeat", this.txfHtUnoccStpt.getValue());
        this.nciConfigPts.setByte(25, (byte)this.getNativeValueRndOff(tempEngUnit, this.txfClMaxOcc.getValue()));
        this.nciConfigPts.setByte(26, (byte)this.getNativeValueRndOff(tempEngUnit, this.txfHtMinOcc.getValue()));
        this.nciConfig.setBits(1, 0, 4, (byte)this.getNativeValueRndOff(tempEngDiffUnit, Integer.parseInt((String)this.ddDLCBump.getSelectedItem())));
        this.nciConfig.setBits(2, 4, 4, (byte)(Integer.parseInt((String)this.ddPowerFail.getSelectedItem()) / iSCALE10));
        this.nciConfigPts.setByte(22, (byte)this.getNativeValueRndOff(pctUnit, this.txfHumHiLimit.getValue()));
        this.nciConfigPts.setByte(23, (byte)Integer.parseInt((String)this.ddMinOnTime.getSelectedItem()));
        this.nciConfigPts.setByte(24, (byte)this.getNativeValueRndOff(tempEngDiffUnit, Integer.parseInt((String)this.ddResetTempStpt.getSelectedItem())));
        this.nciConfig.setBit(3, 4, this.cmdMinOnTime.isSelected());
        this.nciConfig.setBit(3, 5, this.cmdResetTempStpt.isSelected());
        this.nciConfigPts.setByte(11, (byte)this.getNativeValueRndOff(OATRmpUnit, this.txfClOATMinRmp.getValue()));
        this.nciConfigPts.setByte(15, (byte)this.getNativeValueRndOff(OATRmpUnit, this.txfHtOATMinRmp.getValue()));
        this.nciConfigPts.setByte(13, (byte)this.getNativeValueRndOff(rampRateUnit, this.txfClMinRamp.getValue()));
        this.nciConfigPts.setByte(17, (byte)this.getNativeValueRndOff(rampRateUnit, this.txfHtMinRamp.getValue()));
        this.nciConfigPts.setByte(10, (byte)this.getNativeValueRndOff(OATRmpUnit, this.txfClOATMxRmp.getValue()));
        this.nciConfigPts.setByte(14, (byte)this.getNativeValueRndOff(OATRmpUnit, this.txfHtOATMxRmp.getValue()));
        this.nciConfigPts.setByte(12, (byte)this.getNativeValueRndOff(rampRateUnit, this.txfClMaxRamp.getValue()));
        this.nciConfigPts.setByte(16, (byte)this.getNativeValueRndOff(rampRateUnit, this.txfHtMaxRamp.getValue()));
        int n = Integer.parseInt((String)this.ddBypassTime.getSelectedItem());
        this.nciConfig.setBits(5, 0, 3, (byte)(n - 1));
        BNVUtil bNVUtil2 = new BNVUtil((BLonComponent)this.device.get("nciBypassTime"), null);
        this.setFloatProperty(bNVUtil2, "timeMin", n * 60);
    }

    private final void resetSetPntPage() {
        BNVUtil bNVUtil = new BNVUtil((BLonComponent)this.device.get("nciSetpoints"), null);
        int n = this.getProperty(bNVUtil, "occupiedCool");
        int n2 = this.getProperty(bNVUtil, "standbyCool");
        int n3 = this.getProperty(bNVUtil, "unoccupiedCool");
        int n4 = this.getProperty(bNVUtil, "occupiedHeat");
        int n5 = this.getProperty(bNVUtil, "standbyHeat");
        int n6 = this.getProperty(bNVUtil, "unoccupiedHeat");
        n = this.txfClOccStpt.setValue(n);
        n2 = this.txfClStdbyStpt.setValue(n2);
        n3 = this.txfClUnoccStpt.setValue(n3);
        n4 = this.txfHtOccStpt.setValue(n4);
        n6 = this.txfHtUnoccStpt.setValue(n6);
        n5 = this.txfHtStdbyStpt.setValue(n5);
        int n7 = this.txfHtMinOcc.setValue(this.getDisplayValueRndOff(tempEngUnit, this.nciConfigPts.getUnsignedByte(26)));
        int n8 = this.txfClMaxOcc.setValue(this.getDisplayValueRndOff(tempEngUnit, this.nciConfigPts.getUnsignedByte(25)));
        this.setMinHtOccLmtMsg();
        this.setMaxClOccLmtMsg();
        this.setClOccLmtMsg();
        this.setClStdbyLmtMsg();
        this.setClUnoccLmtMsg();
        this.setHtOccLmtMsg();
        this.setHtStdbyLmtMsg();
        this.setHtUnoccLmtMsg();
        this.ddDLCBump.setSelectedItem((Object)String.valueOf(this.getDisplayValueRndOff(tempEngDiffUnit, this.nciConfig.getBits(1, 0, 4))));
        this.ddPowerFail.setSelectedItem((Object)String.valueOf(this.nciConfig.getBits(2, 4, 4) * iSCALE10));
        this.txfHumHiLimit.setValue(this.getDisplayValueRndOff(pctUnit, this.nciConfigPts.getUnsignedByte(22)));
        this.ddMinOnTime.setSelectedItem((Object)String.valueOf(this.nciConfigPts.getUnsignedByte(23)));
        this.cmdMinOnTime.setSelected(this.nciConfig.getBit(3, 4));
        this.ddResetTempStpt.setSelectedItem((Object)String.valueOf(this.getDisplayValueRndOff(tempEngDiffUnit, this.nciConfigPts.getUnsignedByte(24))));
        this.cmdResetTempStpt.setSelected(this.nciConfig.getBit(3, 5));
        this.txfClOATMinRmp.setValue(this.getDisplayValueRndOff(OATRmpUnit, this.nciConfigPts.getByte(11)));
        this.txfHtOATMinRmp.setValue(this.getDisplayValueRndOff(OATRmpUnit, this.nciConfigPts.getByte(15)));
        this.txfClMinRamp.setValue(this.getDisplayValueRndOff(rampRateUnit, this.nciConfigPts.getUnsignedByte(13)));
        this.txfHtMinRamp.setValue(this.getDisplayValueRndOff(rampRateUnit, this.nciConfigPts.getUnsignedByte(17)));
        this.txfClOATMxRmp.setValue(this.getDisplayValueRndOff(OATRmpUnit, this.nciConfigPts.getByte(10)));
        this.txfHtOATMxRmp.setValue(this.getDisplayValueRndOff(OATRmpUnit, this.nciConfigPts.getByte(14)));
        this.txfClMaxRamp.setValue(this.getDisplayValueRndOff(rampRateUnit, this.nciConfigPts.getUnsignedByte(12)));
        this.txfHtMaxRamp.setValue(this.getDisplayValueRndOff(rampRateUnit, this.nciConfigPts.getUnsignedByte(16)));
        this.updateHeatLeadTimeInfo();
        this.updateCoolLeadTimeInfo();
        this.ddBypassTime.setSelectedItem((Object)String.valueOf(this.nciConfig.getBits(5, 0, 3) + 1));
    }

    private final void unloadSetPntPage() throws StepContainerException {
        this.resetTempSetptModified();
        int n = this.iSetptTxfStart;
        while (n < this.iSetptTxfStop) {
            try {
                this.textField[n].unload();
            }
            catch (StepContainerException stepContainerException) {}
            ++n;
        }
    }

    private final int getRoomTempSelection() {
        int n = this.nciConfig.getBits(0, 0, 2);
        String string = "SpaceSensorSrc";
        if (n == iRemoteTempSensor) {
            if (this.nciConfig.getBit(1, 6)) {
                if (this.nciConfig.getBit(7, 7)) {
                    return BT7350Container.getOrdinal(string, "T7350SpT7771");
                }
                return BT7350Container.getOrdinal(string, "T7350SpT7770BC");
            }
            return BT7350Container.getOrdinal(string, "T7350SpT7770AD");
        }
        return n;
    }

    private final void setRoomTempSelection(int n) {
        String string = "SpaceSensorSrc";
        int n2 = 1;
        int n3 = 6;
        int n4 = 7;
        int n5 = 7;
        int n6 = this.ddRoomTemp.getSelectedOrdinal();
        if (n6 == BT7350Container.getOrdinal(string, "T7350Local") || n6 == BT7350Container.getOrdinal(string, "T7350Network")) {
            this.nciConfig.setBit(n2, n3, false);
            this.nciConfig.setBit(n4, n5, false);
            this.nciConfig.setBits(0, 0, 2, (byte)n6);
            return;
        }
        this.nciConfig.setBits(0, 0, 2, (byte)iRemoteTempSensor);
        if (n6 == BT7350Container.getOrdinal(string, "T7350SpT7770BC")) {
            this.nciConfig.setBit(n2, n3, true);
            this.nciConfig.setBit(n4, n5, false);
            return;
        }
        if (n6 == BT7350Container.getOrdinal(string, "T7350SpT7771")) {
            this.nciConfig.setBit(n2, n3, true);
            this.nciConfig.setBit(n4, n5, true);
            return;
        }
        this.nciConfig.setBit(n2, n3, false);
        this.nciConfig.setBit(n4, n5, false);
    }

    private final void warnForNwSelection() {
        boolean bl = false;
        if (this.bConfigIDGeneration) {
            return;
        }
        String string = "T7350Network";
        if (this.ddRoomTemp.getSelectedOrdinal() == BT7350Container.getOrdinal("SpaceSensorSrc", string) || this.ddRoomHumid.getSelectedOrdinal() == BT7350Container.getOrdinal("HumSensorSrc", string) || this.ddOATemp.getSelectedOrdinal() == BT7350Container.getOrdinal("OdSensorSrc", string) || this.ddOccSensor.getSelectedOrdinal() == BT7350Container.getOrdinal("OccSensorSrc", string)) {
            BDialog.warning(null, (String)LEXICON.get(T7350WizardTitle), (Object)BT7350Container.getTextFromLexicon("warnForNetwork"));
        }
    }

    private final void saveGeneralPage() {
        this.warnForNwSelection();
        this.nciConfig.setBits(6, 0, 2, (byte)this.ddAuxDO.getSelectedOrdinal());
        this.nciConfig.setBit(0, 7, (byte)this.ddHtPmpRevValue.getSelectedOrdinal());
        this.nciConfig.setBit(1, 4, (byte)this.ddHtAction.getSelectedOrdinal());
        this.nciConfig.setBit(1, 5, (byte)this.ddCoolAction.getSelectedOrdinal());
        this.setRoomTempSelection(this.ddRoomTemp.getSelectedOrdinal());
        this.nciConfig.setBits(3, 0, 2, (byte)this.ddRoomHumid.getSelectedOrdinal());
        this.nciConfig.setBit(4, 2, (byte)this.ddDATemp.getSelectedOrdinal());
        this.nciConfig.setBits(4, 0, 2, (byte)this.ddOATemp.getSelectedOrdinal());
        this.nciConfig.setBits(5, 6, 2, (byte)this.ddOccSensor.getSelectedOrdinal());
        if (this.cmdDayLtSave.isSelected()) {
            this.nciDayLghtSav.setByte(0, (byte)this.ddStopDay.getSelectedOrdinal());
            this.nciDayLghtSav.setByte(1, (byte)this.ddStopMonth.getSelectedOrdinal());
            this.nciDayLghtSav.setByte(2, (byte)this.ddStartDay.getSelectedOrdinal());
            this.nciDayLghtSav.setByte(3, (byte)this.ddStartMonth.getSelectedOrdinal());
        } else {
            byte by = 0;
            this.nciDayLghtSav.setByte(0, by);
            this.nciDayLghtSav.setByte(1, by);
            this.nciDayLghtSav.setByte(2, by);
            this.nciDayLghtSav.setByte(3, by);
        }
        this.nciConfig.setBit(0, 6, (byte)this.ddEquipType.getSelectedOrdinal());
    }

    private final void resetGeneralPage() {
        this.ddAuxDO.setSelectedOrdinal(this.nciConfig.getBits(6, 0, 2));
        this.ddRoomTemp.setSelectedOrdinal(this.getRoomTempSelection());
        this.ddRoomHumid.setSelectedOrdinal(this.nciConfig.getBits(3, 0, 2));
        this.ddDATemp.setSelectedOrdinal(this.nciConfig.getBitAsInt(4, 2));
        this.ddOATemp.setSelectedOrdinal(this.nciConfig.getBits(4, 0, 2));
        this.ddOccSensor.setSelectedOrdinal(this.nciConfig.getBits(5, 6, 2));
        BEnumRange bEnumRange = BT7350Container.getEnumRange("u_month_t");
        BEnumRange bEnumRange2 = BT7350Container.getEnumRange("u_day_t");
        byte by = 0;
        byte by2 = 0;
        byte by3 = 255;
        byte by4 = this.nciDayLghtSav.getByte(2);
        byte by5 = this.nciDayLghtSav.getByte(3);
        byte by6 = this.nciDayLghtSav.getByte(0);
        byte by7 = this.nciDayLghtSav.getByte(1);
        if (by6 == by || by6 == by3 || by7 == by2 || by4 == by || by4 == by3 || by5 == by2) {
            this.cmdDayLtSave.setSelected(false);
        } else {
            this.cmdDayLtSave.setSelected(true);
            try {
                this.ddStopDay.setSelectedOrdinal(by6);
                this.ddStopMonth.setSelectedOrdinal(by7);
                this.ddStartDay.setSelectedOrdinal(by4);
                this.ddStartMonth.setSelectedOrdinal(by5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.butConfigID.setText(BT7350Container.getTextFromLexicon("configID"));
        System.out.println("Setting model type as " + this.modelType);
        this.ddModel.setSelectedOrdinal(this.modelType);
    }

    private final void readConfigurations() {
        this.nciConfig = this.readConfigParameter("config0");
        this.nciConfigPts = this.readConfigParameter("config1");
        this.nciDayLghtSav = this.readConfigParameter("config2");
        System.out.println("nciConfig = " + this.nciConfig);
        System.out.println("nciConfigpts = " + this.nciConfigPts);
        System.out.println("nciDayLtSav = " + this.nciDayLghtSav);
        this.modelType = this.device.getModelType().getOrdinal();
    }

    private final void writeConfigurations() {
        this.writeConfigParameter("config0", this.nciConfig);
        this.writeConfigParameter("config1", this.nciConfigPts);
        this.writeConfigParameter("config2", this.nciDayLghtSav);
        this.device.setModelType(BT7350ModelType.make(this.ddModel.getSelectedOrdinal()));
    }

    public void unload(int n) throws StepContainerException {
        super.unload(n);
        if (n != this.getStep(generalPge).getStepId()) {
            if (n == this.getStep(stPntPge).getStepId()) {
                this.unloadSetPntPage();
            } else if (n == this.getStep(eqpCtrlpge).getStepId()) {
                this.unloadEquipCtrlPage();
            }
        }
        this.selectedModel.unload(n);
    }

    public void reset() {
        super.reset();
        this.bResetting = true;
        this.readConfigurations();
        this.resetEquipCtrlPage();
        this.resetSetPntPage();
        this.resetGeneralPage();
        this.selectedModel.reset();
        this.kpdDisplayPane.reset(this.nciConfig, this.device);
        this.schdPane.reset(this.device);
        this.holPane.reset(this.device);
        this.bResetting = false;
    }

    public void save() {
        System.out.println("Save started");
        super.save();
        this.save(false);
        this.writeConfigurations();
        this.schdPane.save(this.device);
        this.holPane.save(this.device);
        System.out.println("Save over");
    }

    private static final String getHexString(byte by) {
        int n = 0xF & by;
        int n2 = (0xF0 & by) >>> 4;
        return Integer.toHexString(n2) + Integer.toHexString(n);
    }

    public void setProperty(BNVUtil bNVUtil, String string, int n) {
        if (this.bConfigIDGeneration) {
            return;
        }
        int n2 = (int)bNVUtil.setInNative(string, n, this.unitConversion);
    }

    public void setFloatProperty(BNVUtil bNVUtil, String string, int n) {
        if (this.bConfigIDGeneration) {
            return;
        }
        bNVUtil.setInNative(string, (float)n, this.unitConversion);
    }

    public int getProperty(BNVUtil bNVUtil, String string) {
        String string2 = bNVUtil.getValue(string, this.unitConversion);
        System.out.println("str property: " + string2);
        float f = Float.parseFloat(string2);
        return Math.round(f);
    }

    static BEnum getEnum(BNVUtil bNVUtil, String string) {
        return bNVUtil.getEnum(string);
    }

    static void setEnum(BNVUtil bNVUtil, String string, int n) {
        bNVUtil.setOrdOfSeletedEnum(string, n);
    }

    public void save(boolean bl) {
        boolean bl2 = this.bConfigIDGeneration;
        this.bConfigIDGeneration = bl;
        this.readConfigurations();
        this.saveSetPntPage();
        this.saveEquipCtrlPage();
        this.saveGeneralPage();
        if (this.bConfigIDGeneration) {
            this.kpdDisplayPane.writeToNciConfig(this.nciConfig);
        } else {
            this.kpdDisplayPane.save(this.nciConfig, this.device, this);
        }
        this.selectedModel.save();
        this.bConfigIDGeneration = bl2;
    }

    private final double getDisplayValue(String string, double d) {
        return BAXUtil.getDisplayValue(string, d, this.unitConversion);
    }

    private final int getDisplayValueRndOff(String string, double d) {
        return (int)Math.round(this.getDisplayValue(string, d));
    }

    private final double getNativeValue(String string, double d) {
        return BAXUtil.getNativeValue(string, d, this.unitConversion);
    }

    private final int getNativeValueRndOff(String string, double d) {
        return (int)Math.round(BAXUtil.getNativeValue(string, d, this.unitConversion));
    }

    private final String getDisplaySymbol(String string) {
        return BAXUtil.getDisplaySymbol(string, this.unitConversion);
    }

    public static int getOrdinal(String string, String string2) {
        return BT7350Container.getEnumRange(string).get(string2).getOrdinal();
    }

    public static BEnumRange getEnumRange(String string) {
        return enumUtil.getEnumRangeFromXml(string);
    }

    public T7350ByteArray readConfigParameter(String string) {
        T7350ByteArray t7350ByteArray = new T7350ByteArray();
        BLonByteArray bLonByteArray = BT7350Container.readConfigParameter(this.device, string);
        t7350ByteArray.setArray(bLonByteArray.getBytes());
        return t7350ByteArray;
    }

    public static BLonByteArray readConfigParameter(BT7350 bT7350, String string) {
        return (BLonByteArray)((BConfigParameter)bT7350.get(string)).get("value");
    }

    public void writeConfigParameter(String string, T7350ByteArray t7350ByteArray) {
        if (this.bConfigIDGeneration) {
            return;
        }
        byte[] byArray = t7350ByteArray.getArray();
        if (byArray == null) {
            throw new NullPointerException("byte array for property " + string + " is null");
        }
        BLonByteArray bLonByteArray = BLonByteArray.make((byte[])byArray);
        BT7350Container.writeConfigParameter(this.device, string, bLonByteArray);
    }

    public static void writeConfigParameter(BT7350 bT7350, String string, BLonByteArray bLonByteArray) {
        BConfigParameter bConfigParameter = (BConfigParameter)bT7350.get(string);
        BConfigParameter bConfigParameter2 = (BConfigParameter)bConfigParameter.copyData();
        bConfigParameter2.set("value", (BValue)bLonByteArray);
        BAbstractExt bAbstractExt = (BAbstractExt)bConfigParameter2.get("ext");
        if (bAbstractExt != null) {
            bAbstractExt.syncFromParent();
        }
        bConfigParameter.updateData((BLonData)bConfigParameter2, false);
    }

    public static String getTextFromLexicon(String string, String string2) {
        return LEXICON.get(string + string2);
    }

    public static String getTextFromLexicon(String string) {
        return BT7350Container.getTextFromLexicon("T7350Container.", string);
    }

    private final void setStepModified(String string, String string2) {
        this.setStepModified(string, new String[]{string2});
    }

    private final void setStepModified(String string, String[] stringArray) {
        if (!this.bResetting) {
            BStep bStep = this.getStep(string);
            if (stringArray == null) {
                bStep.fireStepModified(new BStepModifiedEvent());
                return;
            }
            int[] nArray = new int[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                nArray[n] = this.getStep(stringArray[n]).getStepId();
                ++n;
            }
            bStep.fireStepModified(new BStepModifiedEvent(nArray));
        }
    }

    private final void updateLeadTimeInfo(int n, int n2, int n3, int n4, String string, String string2, BLabel bLabel) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (n == 0 || n2 == 0 || n3 == n4) {
            bLabel.setText(BT7350Container.getTextFromLexicon(string));
            return;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        f2 = this.calculateLeadTime(n, n3, n4);
        if (this.ddOATemp.getSelectedOrdinal() == BT7350Container.getOrdinal("OdSensorSrc", "T7350None") || n == n2) {
            bLabel.setText(string2 + decimalFormat.format(f2) + " hours before OCC");
            return;
        }
        f = this.calculateLeadTime(n2, n3, n4);
        bLabel.setText(string2 + decimalFormat.format(f) + " to " + decimalFormat.format(f2) + " hours before OCC");
    }

    private final float calculateLeadTime(int n, int n2, int n3) {
        if (n == 0) {
            throw new IllegalArgumentException("Ramp should not be zero");
        }
        double d = this.getNativeValue(rampRateUnit, n);
        double d2 = this.getNativeValue(setPointUnit, n2);
        double d3 = this.getNativeValue(setPointUnit, n3);
        String string = "degrees celsius per hour";
        d = BAXUtil.convertTo(BUnit.getUnit((String)rampRateUnit), BUnit.getUnit((String)string), d);
        return (float)((double)(Math.abs((float)(Math.round(d2) - Math.round(d3))) / (float)Math.round(d)) + 0.17);
    }

    private final void updateCoolLeadTimeInfo() {
        int n = this.txfClMinRamp.getValue();
        int n2 = this.txfClMaxRamp.getValue();
        int n3 = this.txfClOccStpt.getValue();
        int n4 = this.txfClUnoccStpt.getValue();
        this.updateLeadTimeInfo(n, n2, n3, n4, "CoolStepChangeRecover", "Cool Ramp starts ", this.lbCool);
    }

    private final void updateHeatLeadTimeInfo() {
        this.updateLeadTimeInfo(this.txfHtMinRamp.getValue(), this.txfHtMaxRamp.getValue(), this.txfHtOccStpt.getValue(), this.txfHtUnoccStpt.getValue(), "HeatStepChangeRecover", "Heat Ramp starts ", this.lbHeat);
    }

    private final void setMaxClOccLmtMsg() {
        this.setLimitAndMessage(this.txfClMaxOcc, this.txfClOccStpt.getValue(), this.iClHiTemp, this.clStptProp, BT7350Container.getTextFromLexicon("ClMaxOccLowWrong"), BT7350Container.getTextFromLexicon("ClMaxStptWrong") + ' ' + String.valueOf(this.iClHiTemp) + ' ' + this.getDisplaySymbol(setPointUnit));
    }

    private final void setClUnoccLmtMsg() {
        this.setLimitAndMessage(this.txfClUnoccStpt, this.txfClOccStpt.getValue(), this.iClHiTemp, this.clStptProp, BT7350Container.getTextFromLexicon("ClUnoccLowWrong"), BT7350Container.getTextFromLexicon("ClMaxStptWrong") + ' ' + String.valueOf(this.iClHiTemp) + ' ' + this.getDisplaySymbol(setPointUnit));
    }

    private final void setClOccLmtMsg() {
        String string;
        int n;
        String string2;
        int n2;
        if (this.txfHtOccStpt.getValue() + this.setPointStep > this.iClLowTemp) {
            n2 = this.txfHtOccStpt.getValue() + this.setPointStep;
            string2 = BT7350Container.getTextFromLexicon("ClOccLowWrong") + " + " + this.setPointStep + ')';
        } else {
            n2 = this.iClLowTemp;
            string2 = BT7350Container.getTextFromLexicon("ClMinStptWrong") + ' ' + this.iClLowTemp + ' ' + this.getDisplaySymbol(setPointUnit);
        }
        if (this.txfClMaxOcc.getValue() >= this.txfClUnoccStpt.getValue()) {
            n = this.txfClUnoccStpt.getValue();
            string = BT7350Container.getTextFromLexicon("ClOccHiClUnoccWrong");
        } else {
            n = this.txfClMaxOcc.getValue();
            string = BT7350Container.getTextFromLexicon("ClOccHiMxClWrong");
        }
        this.setLimitAndMessage(this.txfClOccStpt, n2, n, this.clStptProp, string2, string);
    }

    private final void setClStdbyLmtMsg() {
        String string;
        int n;
        if (this.txfHtStdbyStpt.getValue() + this.setPointStep > this.iClLowTemp) {
            n = this.txfHtStdbyStpt.getValue() + this.setPointStep;
            string = BT7350Container.getTextFromLexicon("ClStdbyLowWrong") + " + " + this.setPointStep;
        } else {
            n = this.iClLowTemp;
            string = BT7350Container.getTextFromLexicon("ClMinStptWrong") + ' ' + this.iClLowTemp + ' ' + this.getDisplaySymbol(setPointUnit);
        }
        this.setLimitAndMessage(this.txfClStdbyStpt, n, this.txfClUnoccStpt.getValue(), this.clStptProp, string, BT7350Container.getTextFromLexicon("ClStdbyHiWrong"));
    }

    private final void setMinHtOccLmtMsg() {
        this.setLimitAndMessage(this.txfHtMinOcc, this.iHtLowTemp, this.txfHtOccStpt.getValue(), this.htStptProp, BT7350Container.getTextFromLexicon("HtMinStptWrong") + ' ' + String.valueOf(this.iHtLowTemp) + ' ' + this.getDisplaySymbol(setPointUnit), BT7350Container.getTextFromLexicon("HtMinOccHiWrong"));
    }

    private final void setHtUnoccLmtMsg() {
        this.setLimitAndMessage(this.txfHtUnoccStpt, this.iHtLowTemp, this.txfHtOccStpt.getValue(), this.htStptProp, BT7350Container.getTextFromLexicon("HtMinStptWrong") + ' ' + String.valueOf(this.iHtLowTemp) + ' ' + this.getDisplaySymbol(setPointUnit), BT7350Container.getTextFromLexicon("HtUnoccHiWrong"));
    }

    private final void setHtOccLmtMsg() {
        String string;
        int n;
        String string2;
        int n2;
        if (this.txfHtMinOcc.getValue() > this.txfHtUnoccStpt.getValue()) {
            n2 = this.txfHtMinOcc.getValue();
            string2 = BT7350Container.getTextFromLexicon("HtOccLowMinHtWrong");
        } else {
            n2 = this.txfHtUnoccStpt.getValue();
            string2 = BT7350Container.getTextFromLexicon("HtOccLowHtUnoccWrong");
        }
        if (this.txfClOccStpt.getValue() - this.setPointStep < this.iHtHiTemp) {
            n = this.txfClOccStpt.getValue() - this.setPointStep;
            string = BT7350Container.getTextFromLexicon("HtOccHiWrong") + " - " + this.setPointStep + ')';
        } else {
            n = this.iHtHiTemp;
            string = BT7350Container.getTextFromLexicon("HtMaxStptWrong") + ' ' + this.iHtHiTemp + ' ' + this.getDisplaySymbol(setPointUnit);
        }
        this.setLimitAndMessage(this.txfHtOccStpt, n2, n, this.htStptProp, string2, string);
    }

    private final void setHtStdbyLmtMsg() {
        String string;
        int n;
        if (this.txfClStdbyStpt.getValue() - this.setPointStep < this.iHtHiTemp) {
            n = this.txfClStdbyStpt.getValue() - this.setPointStep;
            string = BT7350Container.getTextFromLexicon("HtStdByHiWrong") + this.setPointStep;
        } else {
            n = this.iHtHiTemp;
            string = BT7350Container.getTextFromLexicon("HtMaxStptWrong") + ' ' + this.iHtHiTemp + ' ' + this.getDisplaySymbol(setPointUnit);
        }
        this.setLimitAndMessage(this.txfHtStdbyStpt, this.txfHtUnoccStpt.getValue(), n, this.htStptProp, BT7350Container.getTextFromLexicon("HtStdbyLowWrong"), string);
    }

    private final void onFocusLostMaxClOcc() {
        this.setClOccLmtMsg();
    }

    private final void onFocusLostMinHtOcc() {
        this.setHtOccLmtMsg();
    }

    private final void onFocusLostClUnocc() {
        this.setClStdbyLmtMsg();
        this.setClOccLmtMsg();
    }

    private final void onFocusLostClStdby() {
        this.setHtStdbyLmtMsg();
        this.resetTempSetptModified();
    }

    private final void onFocusLostClOcc() {
        this.setMaxClOccLmtMsg();
        this.setClUnoccLmtMsg();
        this.setHtOccLmtMsg();
        this.resetTempSetptModified();
    }

    private final void onFocusLostHtOcc() {
        this.setClOccLmtMsg();
        this.setHtUnoccLmtMsg();
        this.setMinHtOccLmtMsg();
        this.resetTempSetptModified();
    }

    private final void onFocusLostHtStdby() {
        this.setClStdbyLmtMsg();
        this.resetTempSetptModified();
    }

    private final void onFocusLostHtUnocc() {
        this.setHtOccLmtMsg();
        this.setHtStdbyLmtMsg();
    }

    private final void configurationIDClicked() {
        if (this.butConfigID.getText().equals(BT7350Container.getTextFromLexicon("configID"))) {
            this.save(true);
            byte[] byArray = this.nciConfig.getArray();
            String string = BT7350Container.getHexString(byArray[byArray.length - 1]);
            int n = byArray.length - 2;
            while (n > -1) {
                string = string + '.' + BT7350Container.getHexString(byArray[n]);
                --n;
            }
            this.butConfigID.setText(string);
        } else {
            this.butConfigID.setText(BT7350Container.getTextFromLexicon("configID"));
        }
    }

    private final void resetTempSetptModified() {
        if (!this.bResetting) {
            int n;
            int n2;
            float f = (float)this.getNativeValue(setPointUnit, this.txfClOccStpt.getValue());
            float f2 = (float)this.getNativeValue(setPointUnit, this.txfHtOccStpt.getValue());
            float f3 = (float)this.getNativeValue(setPointUnit, this.txfClStdbyStpt.getValue());
            float f4 = (float)this.getNativeValue(setPointUnit, this.txfHtStdbyStpt.getValue());
            int n3 = this.ddResetTempStpt.getSelectedIndex() + 1;
            int n4 = this.getDisplayValueRndOff(tempMetricDiffUnit, f - f2);
            int n5 = n2 = n4 < (n = this.getDisplayValueRndOff(tempMetricDiffUnit, f3 - f4)) ? n4 : n;
            if (n3 >= n2) {
                if (n2 - 1 == 0) {
                    n2 = 2;
                }
                this.ddResetTempStpt.setSelectedItem((Object)String.valueOf(n2 - 1));
            }
        }
    }

    private final void reheatResetClicked() {
        if (this.cbReheat.isSelected() && this.cbResetHum.isSelected()) {
            BDialog.warning(null, (String)LEXICON.get(T7350WizardTitle), (Object)BT7350Container.getTextFromLexicon("reheatResetSelected"));
        }
    }

    private final void changeDATSensor() {
        boolean bl = false;
        if (this.ddDATemp.getSelectedOrdinal() != BT7350Container.getOrdinal("DischSensorSrc", "T7350None")) {
            bl = true;
        }
        boolean bl2 = bl;
        this.cmdCoolDAT.setEnabled(bl2);
        this.cmdHeatDAT.setEnabled(bl2);
        this.setStepModified(generalPge, eqpCtrlpge);
    }

    private final void changeOATSensor() {
        boolean bl = false;
        if (this.ddOATemp.getSelectedOrdinal() != BT7350Container.getOrdinal("OdSensorSrc", "T7350None")) {
            bl = true;
        }
        boolean bl2 = bl;
        this.txfHtOATMinRmp.setEnabled(bl2);
        this.txfClOATMinRmp.setEnabled(bl2);
        this.txfHtOATMxRmp.setEnabled(bl2);
        this.txfClOATMxRmp.setEnabled(bl2);
        this.txfHtMaxRamp.setEnabled(bl2);
        this.txfClMaxRamp.setEnabled(bl2);
        this.cmdHeatOAT.setEnabled(bl2);
        this.cmdCoolOAT.setEnabled(bl2);
        this.setStepModified(generalPge, new String[]{eqpCtrlpge, stPntPge});
        this.updateCoolLeadTimeInfo();
        this.updateHeatLeadTimeInfo();
    }

    private final void changeRoomHumidity() {
        int n = this.ddAuxDO.getSelectedOrdinal();
        if (this.ddRoomHumid.getSelectedOrdinal() == BT7350Container.getOrdinal("HumSensorSrc", "T7350None")) {
            this.ddAuxDO.setEnumRange(BT7350Container.getEnumRange("AuxOpMode"), LEXICON);
            if (n > BT7350Container.getOrdinal("AuxOpModeRmHumid", "T7350EconMinEnable")) {
                this.ddAuxDO.setSelectedOrdinal(BT7350Container.getOrdinal("AuxOpMode", "T7350TodOcc"));
            } else {
                this.ddAuxDO.setSelectedOrdinal(n);
            }
            this.dehumidOptionEnable(false);
            this.ddMinOnTime.setSelectedIndex(0);
            this.ddResetTempStpt.setSelectedIndex(0);
        } else {
            this.ddAuxDO.setEnumRange(BT7350Container.getEnumRange("AuxOpModeRmHumid"), LEXICON);
            this.ddAuxDO.setSelectedOrdinal(n);
            this.dehumidOptionEnable(true);
        }
        this.setStepModified(generalPge, stPntPge);
    }

    private final void dehumidOptionEnable(boolean bl) {
        this.txfHumHiLimit.setEnabled(bl);
        this.cmdMinOnTime.setEnabled(bl);
        if (!bl) {
            this.cbReheat.setSelected(false);
        }
        this.cbReheat.setEnabled(bl);
        this.cmdResetTempStpt.setEnabled(bl);
    }

    private final void setSelectedModel(int n) {
        if (n == BT7350Container.getOrdinal("modeltype", "T7350H0009")) {
            System.out.println("setselectedModel");
            this.t7350H0017.removeAsCurrentModel();
            this.t7350H0009.setAsCurrentModel();
        } else {
            this.t7350H0009.removeAsCurrentModel();
            this.t7350H0017.setAsCurrentModel();
        }
    }

    private final void createGeneralPage() {
        this.currentLabel = 0;
        int n = 0;
        this.lbModel = this.labels[this.currentLabel];
        this.setCurrentLabel("model");
        this.lbEquipType = this.labels[this.currentLabel];
        this.setCurrentLabel("EquipType");
        this.currentDropDown = 0;
        int n2 = 0;
        this.ddModel = new BDefaultEnumDropDown(BT7350Container.getEnumRange("modeltype"), LEXICON, BT7350Container.getOrdinal("modeltype", "T7350H0009"));
        this.dropDowns[this.currentDropDown++] = this.ddModel;
        this.ddEquipType = new BDefaultEnumDropDown(BT7350Container.getEnumRange("equipType"), LEXICON, BT7350Container.getOrdinal("equipType", "T7350Standard"));
        this.dropDowns[this.currentDropDown++] = this.ddEquipType;
        this.gridPanes[BT7350Container.generalPaneIndex] = new BGridPaneEx(2, 2, 150, 20);
        this.gridPanes[generalPaneIndex].setColumnWidth(0, 100);
        BT7350Container.addToGrid(2, 0, this.gridPanes[generalPaneIndex], (BWidget[])this.labels, n);
        BT7350Container.addToGrid(2, 1, this.gridPanes[generalPaneIndex], (BWidget[])this.dropDowns, n2);
        int n3 = this.currentLabel;
        this.lbHeatStgs = this.setCurrentLabel("HeatStgs");
        int n4 = this.currentDropDown;
        this.dd009StdHtStages = new BDefaultEnumDropDown(BT7350Container.getEnumRange("Std009ThreeStages"), LEXICON, BT7350Container.getOrdinal("Std009ThreeStages", "T7350ThreeStage"));
        this.dropDowns[this.currentDropDown++] = this.dd009StdHtStages;
        this.dd009HPAuxHtStgs = new BDefaultEnumDropDown(BT7350Container.getEnumRange("HP009Stages"), LEXICON, BT7350Container.getOrdinal("HP009Stages", "T7350OneStage"));
        this.dropDowns[this.currentDropDown++] = this.dd009HPAuxHtStgs;
        this.dd017AuxHtStgs = new BDefaultEnumDropDown(BT7350Container.getEnumRange("Aux017HtStages"), LEXICON, BT7350Container.getOrdinal("Aux017HtStages", "T7350HtEnable"));
        this.dropDowns[this.currentDropDown++] = this.dd017AuxHtStgs;
        this.lbCoolStgs = this.setCurrentLabel("CoolStgs");
        this.dd009StdCoolStgs = new BDefaultEnumDropDown(BT7350Container.getEnumRange("Std009FourStages"), LEXICON, 3);
        this.dropDowns[this.currentDropDown++] = this.dd009StdCoolStgs;
        this.dd009HPCompressorStgs = new BDefaultEnumDropDown(BT7350Container.getEnumRange("HP009Stages"), LEXICON, 2);
        this.dropDowns[this.currentDropDown++] = this.dd009HPCompressorStgs;
        this.dd017CompressorStgs = new BDefaultEnumDropDown(BT7350Container.getEnumRange("Aux017ClStages"), LEXICON, 0);
        this.dropDowns[this.currentDropDown++] = this.dd017CompressorStgs;
        this.lbAuxDO = this.setCurrentLabel("AuxDO");
        this.ddAuxDO = new BEnumDropDown(BT7350Container.getEnumRange("AuxOpModeRmHumid"), LEXICON);
        this.dropDowns[this.currentDropDown++] = this.ddAuxDO;
        this.ddAuxDO.setSelectedOrdinal(BT7350Container.getOrdinal("AuxOpModeRmHumid", "T7350TodOcc"));
        this.lbHtPmpRevAction = this.setCurrentLabel("HtPmpRevVal");
        this.ddHtPmpRevValue = new BDefaultEnumDropDown(BT7350Container.getEnumRange("HtPmpRevVal"), LEXICON, BT7350Container.getOrdinal("HtPmpRevVal", "T7350ActCool"));
        this.dropDowns[this.currentDropDown++] = this.ddHtPmpRevValue;
        this.ddHtPmpRevValue.setSelectedOrdinal(BT7350Container.getOrdinal("HtPmpRevVal", "T7350ActCool"));
        this.ddHtAction = new BDefaultEnumDropDown(BT7350Container.getEnumRange("Action"), LEXICON, BT7350Container.getOrdinal("Action", "T7350DirectAct"));
        this.dropDowns[this.currentDropDown++] = this.ddHtAction;
        this.lbCoolAction = this.setCurrentLabel("CoolAction");
        this.ddCoolAction = new BDefaultEnumDropDown(BT7350Container.getEnumRange("Action"), LEXICON, BT7350Container.getOrdinal("Action", "T7350DirectAct"));
        this.dropDowns[this.currentDropDown++] = this.ddCoolAction;
        this.ddHtAction.setSelectedOrdinal(BT7350Container.getOrdinal("Action", "T7350DirectAct"));
        this.ddCoolAction.setSelectedOrdinal(BT7350Container.getOrdinal("Action", "T7350DirectAct"));
        this.gridPanes[BT7350Container.outputPaneIndex] = new BGridPaneEx(5, 2);
        BT7350Container.addToGrid(this.gridPanes[outputPaneIndex].getRowCount(), 0, this.gridPanes[outputPaneIndex], (BWidget[])this.labels, n3);
        this.gridPanes[outputPaneIndex].setWidget((BWidget)this.ddAuxDO, 2, 1);
        int n5 = this.currentLabel;
        int n6 = this.currentDropDown;
        this.setCurrentLabel("RoomTemp");
        this.setCurrentLabel("RoomHumidity");
        this.setCurrentLabel("DATemp");
        this.setCurrentLabel("OATemp");
        this.setCurrentLabel("OccSensor");
        this.ddRoomTemp = new BDefaultEnumDropDown(BT7350Container.getEnumRange("SpaceSensorSrc"), LEXICON, 0);
        this.dropDowns[this.currentDropDown++] = this.ddRoomTemp;
        this.ddRoomHumid = new BDefaultEnumDropDown(BT7350Container.getEnumRange("HumSensorSrc"), LEXICON, 0);
        this.dropDowns[this.currentDropDown++] = this.ddRoomHumid;
        this.ddDATemp = new BDefaultEnumDropDown(BT7350Container.getEnumRange("DischSensorSrc"), LEXICON, 0);
        this.dropDowns[this.currentDropDown++] = this.ddDATemp;
        this.ddOATemp = new BDefaultEnumDropDown(BT7350Container.getEnumRange("OdSensorSrc"), LEXICON, 0);
        this.dropDowns[this.currentDropDown++] = this.ddOATemp;
        this.ddOccSensor = new BDefaultEnumDropDown(BT7350Container.getEnumRange("OccSensorSrc"), LEXICON, 0);
        this.dropDowns[this.currentDropDown++] = this.ddOccSensor;
        this.gridPanes[BT7350Container.inputPaneIndex] = new BGridPaneEx(5, 2);
        this.gridPanes[inputPaneIndex].setColumnWidth(0, 100);
        BT7350Container.addToGrid(this.gridPanes[inputPaneIndex].getRowCount(), 0, this.gridPanes[inputPaneIndex], (BWidget[])this.labels, n5);
        BT7350Container.addToGrid(this.gridPanes[inputPaneIndex].getRowCount(), 1, this.gridPanes[inputPaneIndex], (BWidget[])this.dropDowns, n6);
        this.borderPane[daylightPaneIndex].setBorder(BBorder.none);
        int n7 = this.currentLabel;
        this.setCurrentLabel("StartMonth");
        this.setCurrentLabel("EndMonth");
        this.setCurrentLabel("StartDay");
        this.setCurrentLabel("EndDay");
        int n8 = this.currentDropDown;
        this.ddStartMonth = new BDefaultEnumDropDown(BT7350Container.getEnumRange("u_month_t"), LEXICON, 4);
        this.dropDowns[this.currentDropDown++] = this.ddStartMonth;
        this.ddStopMonth = new BDefaultEnumDropDown(BT7350Container.getEnumRange("u_month_t"), LEXICON, 10);
        this.dropDowns[this.currentDropDown++] = this.ddStopMonth;
        this.ddStartDay = new BDefaultEnumDropDown(BT7350Container.getEnumRange("u_day_t"), LEXICON, 33);
        this.dropDowns[this.currentDropDown++] = this.ddStartDay;
        this.ddStopDay = new BDefaultEnumDropDown(BT7350Container.getEnumRange("u_day_t"), LEXICON, 68);
        this.dropDowns[this.currentDropDown++] = this.ddStopDay;
        this.cmdDayLtSave = BT7350Container.setDeselectCmdCheck(this.cbDayLghtSave, BT7350Container.getTextFromLexicon("dayLtSave"), new BWidget[]{this.ddStartMonth, this.ddStartDay, this.ddStopMonth, this.ddStopDay});
        this.gridPanes[BT7350Container.daylightPaneIndex] = new BGridPaneEx(2, 4);
        this.gridPanes[daylightPaneIndex].setColumnWidth(0, 70);
        this.gridPanes[daylightPaneIndex].setColumnWidth(2, 70);
        boolean bl = false;
        int n9 = 0;
        while (n9 < 4) {
            BT7350Container.addToGrid(this.gridPanes[daylightPaneIndex].getRowCount(), n9, this.gridPanes[daylightPaneIndex], (BWidget[])this.labels, n7 + n9);
            BT7350Container.addToGrid(this.gridPanes[daylightPaneIndex].getRowCount(), n9 + 1, this.gridPanes[daylightPaneIndex], (BWidget[])this.dropDowns, n8 + n9);
            n9 += 2;
        }
        this.butConfigID = new BButton(BT7350Container.getTextFromLexicon("configID"));
        this.butConfigID.setBounds(10.0, 460.0, 150.0, 25.0);
        this.generalPane.add("ConfigurationID", (BValue)this.butConfigID);
    }

    private final void createKeypdDisplay() {
    }

    private final void createSetpointsPage() {
        this.currentTextField = 0;
        int n = 0;
        this.iSetptTxfStart = 0;
        int n2 = 2;
        int n3 = 40;
        int n4 = 45;
        this.textField[this.currentTextField++] = this.txfClUnoccStpt = new BDefaultIntegerField(n4, n2, true);
        this.textField[this.currentTextField++] = this.txfClStdbyStpt = new BDefaultIntegerField(n4, n2, true);
        this.textField[this.currentTextField++] = this.txfClOccStpt = new BDefaultIntegerField(n4, n2, true);
        this.textField[this.currentTextField++] = this.txfHtOccStpt = new BDefaultIntegerField(n3, n2, true);
        this.textField[this.currentTextField++] = this.txfHtStdbyStpt = new BDefaultIntegerField(n3, n2, true);
        this.textField[this.currentTextField++] = this.txfHtUnoccStpt = new BDefaultIntegerField(n3, n2, true);
        int n5 = this.currentLabel;
        this.setCurrentLabel("CoolUnoccStpt");
        this.setCurrentLabel("CoolStdbyStpt");
        this.setCurrentLabel("CoolOccStpt");
        this.setCurrentLabel("HeatOccStpt");
        this.setCurrentLabel("HeatStdbyStpt");
        this.setCurrentLabel("HeatUnoccStpt");
        this.gridPanes[BT7350Container.htandcoolPaneIndex] = new BGridPaneEx(6, 3);
        this.createSetPoint(htandcoolPaneIndex, this.gridPanes[htandcoolPaneIndex].getRowCount(), n5, n, setPointUnit);
        int n6 = this.currentLabel;
        this.setCurrentLabel("MinHtOcc");
        this.setCurrentLabel("MaxCoolOcc");
        int n7 = this.currentTextField;
        this.textField[this.currentTextField++] = this.txfHtMinOcc = new BDefaultIntegerField(n3, n2, true);
        this.textField[this.currentTextField++] = this.txfClMaxOcc = new BDefaultIntegerField(n4, n2, true);
        this.gridPanes[BT7350Container.rangeStopPaneIndex] = new BGridPaneEx(2, 3);
        this.createSetPoint(rangeStopPaneIndex, this.gridPanes[rangeStopPaneIndex].getRowCount(), n6, n7, tempEngUnit);
        int n8 = this.currentDropDown;
        int n9 = this.currentLabel;
        this.setCurrentLabel("DLCBump");
        this.setCurrentLabel("PowFailSeqStart");
        this.dropDowns[this.currentDropDown++] = this.ddDLCBump = new BListDropDown();
        int n10 = this.getDisplayValueRndOff(tempEngDiffUnit, 10.0);
        BList bList = this.ddDLCBump.getList();
        int n11 = this.getDisplayValueRndOff(tempEngDiffUnit, 0.0);
        while (n11 <= n10) {
            bList.addItem((Object)String.valueOf(n11));
            ++n11;
        }
        this.dropDowns[this.currentDropDown++] = this.ddPowerFail = new BListDropDown();
        bList = this.ddPowerFail.getList();
        n11 = 0;
        while (n11 <= 150) {
            bList.addItem((Object)String.valueOf(n11));
            n11 += 10;
        }
        this.gridPanes[BT7350Container.enrgMgmtPaneIndex] = new BGridPaneEx(2, 3);
        this.gridPanes[enrgMgmtPaneIndex].setColumnWidth(0, 135);
        this.gridPanes[enrgMgmtPaneIndex].setColumnWidth(1, 45);
        this.gridPanes[enrgMgmtPaneIndex].setColumnWidth(2, 25);
        BT7350Container.addToGrid(this.gridPanes[enrgMgmtPaneIndex].getRowCount(), 0, this.gridPanes[enrgMgmtPaneIndex], (BWidget[])this.labels, n9);
        BT7350Container.addToGrid(this.gridPanes[enrgMgmtPaneIndex].getRowCount(), 1, this.gridPanes[enrgMgmtPaneIndex], (BWidget[])this.dropDowns, n8);
        this.gridPanes[enrgMgmtPaneIndex].setWidget((BWidget)this.createEnggUnitPane(tempEngDiffUnit), 0, 2);
        this.gridPanes[enrgMgmtPaneIndex].setWidget((BWidget)this.createNativeEnggUnitPane(secUnit), 1, 2);
        n11 = 0;
        this.textField[this.currentTextField++] = this.txfHumHiLimit = this.createRecoveryField(10, 90, 65, pctUnit, "humhilmt");
        this.dehumidification.add("textHilimit", (BValue)this.txfHumHiLimit);
        this.txfHumHiLimit.setBounds(80.0, 25.0, 50.0, 20.0);
        this.currentCheckBox = 0;
        int n12 = 0;
        this.borderPane[dehumidPaneIndex].setBorder(BBorder.NULL);
        this.checkBoxes[this.currentCheckBox++] = this.cbMinOnTime = new BCheckBox(BT7350Container.getTextFromLexicon("MinOnTime"));
        this.checkBoxes[this.currentCheckBox++] = this.cbReheat = new BCheckBox(BT7350Container.getTextFromLexicon("Reheat"));
        this.checkBoxes[this.currentCheckBox++] = this.cbResetHum = new BCheckBox(BT7350Container.getTextFromLexicon("ResetTempSetPt"));
        int n13 = this.currentDropDown;
        this.dropDowns[this.currentDropDown++] = this.ddMinOnTime = new BListDropDown();
        this.dropDowns[this.currentDropDown++] = this.ddResetTempStpt = new BListDropDown();
        bList = this.ddMinOnTime.getList();
        n11 = 5;
        n10 = 15;
        int n14 = n11;
        while (n14 <= n10) {
            bList.addItem((Object)String.valueOf(n14));
            ++n14;
        }
        bList = this.ddResetTempStpt.getList();
        String string = tempEngDiffUnit;
        n10 = this.getDisplayValueRndOff(string, 5);
        int n15 = n11 = this.getDisplayValueRndOff(string, 1.0);
        while (n15 <= n10) {
            bList.addItem((Object)String.valueOf(n15));
            ++n15;
        }
        this.cmdMinOnTime = BT7350Container.setDeselectCmdCheck(this.cbMinOnTime, BT7350Container.getTextFromLexicon("MinOnTime"), (BWidget)this.ddMinOnTime);
        this.cmdResetTempStpt = BT7350Container.setDeselectCmdCheck(this.cbResetHum, BT7350Container.getTextFromLexicon("ResetTempSetPt"), (BWidget)this.ddResetTempStpt);
        this.gridPanes[BT7350Container.dehumidPaneIndex] = new BGridPaneEx(3, 3);
        this.gridPanes[dehumidPaneIndex].setColumnWidth(1, 50);
        this.gridPanes[dehumidPaneIndex].setColumnWidth(2, 30);
        BT7350Container.addToGrid(this.gridPanes[dehumidPaneIndex].getRowCount(), 0, this.gridPanes[dehumidPaneIndex], (BWidget[])this.checkBoxes, n12);
        this.gridPanes[dehumidPaneIndex].setWidget((BWidget)this.ddMinOnTime, 0, 1);
        this.gridPanes[dehumidPaneIndex].setWidget((BWidget)this.createNativeEnggUnitPane(minUnit), 0, 2);
        this.gridPanes[dehumidPaneIndex].setWidget((BWidget)this.ddResetTempStpt, 2, 1);
        this.gridPanes[dehumidPaneIndex].setWidget((BWidget)this.createEnggUnitPane(string), 2, 2);
        this.borderPane[recoveryPaneIndex].setBorder(BBorder.none);
        int n16 = this.currentLabel;
        this.setCurrentLabel("OATMinRamp");
        this.setCurrentLabel("MinRampRate");
        this.setCurrentLabel("OATMaxRamp");
        this.setCurrentLabel("MaxRampRate");
        int n17 = this.currentTextField;
        n11 = -20;
        n10 = 100;
        n15 = 0;
        int n18 = 20;
        this.textField[this.currentTextField++] = this.txfClOATMinRmp = this.createRecoveryField(n11, n10, 90, OATRmpUnit, "OATMinRamp");
        this.textField[this.currentTextField++] = this.txfClMinRamp = this.createRecoveryField(n15, n18, 3, rampRateUnit, "MinRampRate");
        this.textField[this.currentTextField++] = this.txfClOATMxRmp = this.createRecoveryField(n11, n10, 70, OATRmpUnit, "OATMaxRamp");
        this.textField[this.currentTextField++] = this.txfClMaxRamp = this.createRecoveryField(n15, n18, 6, rampRateUnit, "MaxRampRate");
        int n19 = this.currentTextField;
        this.textField[this.currentTextField++] = this.txfHtOATMinRmp = this.createRecoveryField(n11, n10, 0, OATRmpUnit, "OATMinRamp");
        this.textField[this.currentTextField++] = this.txfHtMinRamp = this.createRecoveryField(n15, n18, 5, rampRateUnit, "MinRampRate");
        this.textField[this.currentTextField++] = this.txfHtOATMxRmp = this.createRecoveryField(n11, n10, 40, OATRmpUnit, "OATMaxRamp");
        this.textField[this.currentTextField++] = this.txfHtMaxRamp = this.createRecoveryField(n15, n18, 8, rampRateUnit, "MaxRampRate");
        this.gridPanes[BT7350Container.recoveryPaneIndex] = new BGridPaneEx(4, 4);
        this.gridPanes[recoveryPaneIndex].setColumnWidth(3, 30);
        this.gridPanes[recoveryPaneIndex].setColumnWidth(2, 50);
        this.gridPanes[recoveryPaneIndex].setColumnWidth(1, 50);
        this.gridPanes[recoveryPaneIndex].setColumnWidth(0, 90);
        BT7350Container.addToGrid(this.gridPanes[recoveryPaneIndex].getRowCount(), 0, this.gridPanes[recoveryPaneIndex], (BWidget[])this.labels, n16);
        BT7350Container.addToGrid(this.gridPanes[recoveryPaneIndex].getRowCount(), 1, this.gridPanes[recoveryPaneIndex], (BWidget[])this.textField, n17);
        BT7350Container.addToGrid(this.gridPanes[recoveryPaneIndex].getRowCount(), 2, this.gridPanes[recoveryPaneIndex], (BWidget[])this.textField, n19);
        int n20 = 0;
        while (n20 < 4) {
            BPane bPane = null;
            bPane = n20 % 2 != 1 ? this.createEnggUnitPane(OATRmpUnit) : this.createEnggUnitPane(rampRateUnit);
            this.gridPanes[recoveryPaneIndex].setWidget((BWidget)bPane, n20, 3);
            ++n20;
        }
        int n21 = this.currentLabel;
        this.labels[this.currentLabel++].setText(BT7350Container.getTextFromLexicon("BypassTime"));
        int n22 = this.currentDropDown;
        this.dropDowns[this.currentDropDown++] = this.ddBypassTime = new BListDropDown();
        bList = this.ddBypassTime.getList();
        n11 = 1;
        n10 = 9;
        n20 = n11;
        while (n20 < n10) {
            bList.addItem((Object)String.valueOf(n20));
            ++n20;
        }
        this.gridPanes[BT7350Container.bypassPaneIndex] = new BGridPaneEx(1, 3);
        this.gridPanes[bypassPaneIndex].setColumnWidth(1, 50);
        this.gridPanes[bypassPaneIndex].setColumnWidth(2, 30);
        this.gridPanes[bypassPaneIndex].setWidget((BWidget)this.labels[n21], 0, 0);
        this.gridPanes[bypassPaneIndex].setWidget((BWidget)this.dropDowns[n22], 0, 1);
        this.gridPanes[bypassPaneIndex].setWidget((BWidget)this.createNativeEnggUnitPane(hourUnit), 0, 2);
        this.iSetptTxfStop = this.currentTextField;
    }

    private final void createEquipControlPage() {
        int n;
        this.borderPane[heatSelectPaneIndex].setBorder(BBorder.none);
        this.heatOATPane.setBorder(BBorder.none);
        this.equipTxfStart = n = this.currentTextField;
        this.textField[this.currentTextField++] = this.txfHtOAT = this.createRecoveryField(-40, 120, 70, tempEngUnit, "HtOATLock");
        this.textField[this.currentTextField++] = this.txfHtDATHi = this.createRecoveryField(65, 140, 110, tempEngUnit, "HtDATHi");
        BFlowPane bFlowPane = this.createEquipField(this.txfHtOAT, tempEngUnit);
        bFlowPane.setBounds(130.0, 30.0, 80.0, 25.0);
        this.heatOATPane.add("txfHeatOAT", (BValue)bFlowPane);
        bFlowPane = this.createEquipField(this.txfHtDATHi, tempEngUnit);
        this.heatOATPane.add("txfHeatDAT", (BValue)bFlowPane);
        bFlowPane.setBounds(130.0, 80.0, 80.0, 25.0);
        this.cmdHeatOAT = BT7350Container.setDeselectCmdCheck(this.cbHeatOAT, BT7350Container.getTextFromLexicon("cbHeatOAT"), (BWidget)this.txfHtOAT);
        this.cmdHeatDAT = BT7350Container.setDeselectCmdCheck(this.cbHeatDAT, BT7350Container.getTextFromLexicon("cbHeatDAT"), (BWidget)this.txfHtDATHi);
        int n2 = this.currentLabel;
        this.setCurrentLabel("FanOnHt");
        this.setCurrentLabel("ExtFanOp");
        this.setCurrentLabel("HtCycleRate");
        int n3 = this.currentDropDown;
        this.ddHtFanOn = new BDefaultEnumDropDown(BT7350Container.getEnumRange("FanOnHeat"), LEXICON, 0);
        this.dropDowns[this.currentDropDown++] = this.ddHtFanOn;
        this.ddHtExtFanOp = new BDefaultEnumDropDown(BT7350Container.getEnumRange("HtExtFanOp"), LEXICON, 1);
        this.dropDowns[this.currentDropDown++] = this.ddHtExtFanOp;
        this.ddHtCycRate = new BDefaultEnumDropDown(BT7350Container.getEnumRange("HeatCPH"), LEXICON, 1);
        this.dropDowns[this.currentDropDown++] = this.ddHtCycRate;
        this.gridPanes[BT7350Container.heatSelectPaneIndex] = new BGridPaneEx(3, 2);
        BT7350Container.addToGrid(this.gridPanes[heatSelectPaneIndex].getRowCount(), 0, this.gridPanes[heatSelectPaneIndex], (BWidget[])this.labels, n2);
        BT7350Container.addToGrid(this.gridPanes[heatSelectPaneIndex].getRowCount(), 1, this.gridPanes[heatSelectPaneIndex], (BWidget[])this.dropDowns, n3);
        this.borderPane[coolSelectPaneIndex].setBorder(BBorder.none);
        this.coolOATPane.setBorder(BBorder.none);
        int n4 = this.currentTextField;
        this.textField[this.currentTextField++] = this.txfClOAT = this.createRecoveryField(-40, 120, 35, tempEngUnit, "ClOATLock");
        this.textField[this.currentTextField++] = this.txfClDATHi = this.createRecoveryField(35, 60, 45, tempEngUnit, "ClDATHi");
        bFlowPane = this.createEquipField(this.txfClOAT, tempEngUnit);
        bFlowPane.setBounds(130.0, 30.0, 80.0, 25.0);
        this.coolOATPane.add("txfclOAT", (BValue)bFlowPane);
        bFlowPane = this.createEquipField(this.txfClDATHi, tempEngUnit);
        this.coolOATPane.add("txfClDAT", (BValue)bFlowPane);
        bFlowPane.setBounds(130.0, 80.0, 80.0, 25.0);
        this.cmdCoolDAT = BT7350Container.setDeselectCmdCheck(this.cbCoolDAT, BT7350Container.getTextFromLexicon("cbCoolDAT"), (BWidget)this.txfClDATHi);
        this.cmdCoolOAT = BT7350Container.setDeselectCmdCheck(this.cbCoolOAT, BT7350Container.getTextFromLexicon("cbCoolOAT"), (BWidget)this.txfClOAT);
        int n5 = this.currentLabel;
        this.setCurrentLabel("ExtFanOp");
        this.setCurrentLabel("ClCycleRate");
        int n6 = this.currentDropDown;
        this.ddClExtFanOp = new BDefaultEnumDropDown(BT7350Container.getEnumRange("ClExtFanOp"), LEXICON, 0);
        this.dropDowns[this.currentDropDown++] = this.ddClExtFanOp;
        this.ddClCycRate = new BDefaultEnumDropDown(BT7350Container.getEnumRange("CoolCPH"), LEXICON, 0);
        this.dropDowns[this.currentDropDown++] = this.ddClCycRate;
        this.gridPanes[BT7350Container.coolSelectPaneIndex] = new BGridPaneEx(2, 2);
        BT7350Container.addToGrid(this.gridPanes[coolSelectPaneIndex].getRowCount(), 0, this.gridPanes[coolSelectPaneIndex], (BWidget[])this.labels, n5);
        BT7350Container.addToGrid(this.gridPanes[coolSelectPaneIndex].getRowCount(), 1, this.gridPanes[coolSelectPaneIndex], (BWidget[])this.dropDowns, n6);
        this.borderPane[TuningParameterPaneIndex].setBorder(BBorder.none);
        int n7 = this.currentLabel;
        this.setCurrentLabel("ThrottleRange");
        this.setCurrentLabel("IntegralTime");
        this.setCurrentLabel("DerivativeTime");
        int n8 = this.currentCheckBox;
        this.checkBoxes[this.currentCheckBox++] = this.cbHtIntegralTime = new BCheckBox();
        this.checkBoxes[this.currentCheckBox++] = this.cbHtDeriveTime = new BCheckBox();
        this.checkBoxes[this.currentCheckBox++] = this.cbClIntegralTime = new BCheckBox();
        this.checkBoxes[this.currentCheckBox++] = this.cbClDeriveTime = new BCheckBox();
        int n9 = this.currentTextField;
        this.textField[this.currentTextField++] = this.txfHtThrtlRange = this.createRecoveryField(1, 30, 3, tempEngDiffUnit, "ThrottleRange");
        this.textField[this.currentTextField++] = this.txfHtIntegralTime = this.createRecoveryField(iIntTimeLowLim, 5000, 0, null, "IntegralTime");
        this.textField[this.currentTextField++] = this.txfHtDerivTime = this.createRecoveryField(iDerTimeLowLim, 3000, 0, null, "DerivativeTime");
        int n10 = this.currentTextField;
        this.textField[this.currentTextField++] = this.txfClThrtlRange = this.createRecoveryField(1, 30, 3, tempEngDiffUnit, "ThrottleRange");
        this.textField[this.currentTextField++] = this.txfClIntegralTime = this.createRecoveryField(iIntTimeLowLim, 5000, 0, null, "IntegralTime");
        this.textField[this.currentTextField++] = this.txfClDerivTime = this.createRecoveryField(iDerTimeLowLim, 3000, 0, null, "DerivativeTime");
        this.cmdHtDerTime = BT7350Container.setDeselectCmdCheck(this.cbHtDeriveTime, BT7350Container.getTextFromLexicon("DerivativeTime"), (BWidget)this.txfHtDerivTime);
        this.cmdHtIntTime = BT7350Container.setDeselectCmdCheck(this.cbHtIntegralTime, BT7350Container.getTextFromLexicon("IntegralTime"), (BWidget)this.txfHtIntegralTime);
        this.cmdClDerTime = BT7350Container.setDeselectCmdCheck(this.cbClDeriveTime, "", (BWidget)this.txfClDerivTime);
        this.cmdClIntTime = BT7350Container.setDeselectCmdCheck(this.cbClIntegralTime, "", (BWidget)this.txfClIntegralTime);
        BFlowPane[] bFlowPaneArray = new BFlowPane[this.currentCheckBox - n8];
        int n11 = 0;
        while (n11 < bFlowPaneArray.length) {
            bFlowPaneArray[n11] = new BFlowPane();
            ++n11;
        }
        n11 = 0;
        while (n11 < 2) {
            bFlowPaneArray[n11].add("checkbox", (BValue)this.checkBoxes[n8 + n11]);
            BCanvasPane bCanvasPane = new BCanvasPane();
            bCanvasPane.add("pane", (BValue)this.textField[n9 + n11 + 1]);
            bCanvasPane.setViewSize(BSize.make((double)48.0, (double)20.0));
            bFlowPaneArray[n11].add("textField", (BValue)bCanvasPane);
            ++n11;
        }
        n11 = 2;
        int n12 = 0;
        while (n11 < 4) {
            bFlowPaneArray[n11].add("checkbox", (BValue)this.checkBoxes[n8 + n11]);
            BCanvasPane bCanvasPane = new BCanvasPane();
            bCanvasPane.add("pane", (BValue)this.textField[n10 + n12 + 1]);
            bCanvasPane.setViewSize(BSize.make((double)48.0, (double)20.0));
            bFlowPaneArray[n11].add("textField", (BValue)bCanvasPane);
            ++n11;
            ++n12;
        }
        this.gridPanes[BT7350Container.TuningParameterPaneIndex] = new BGridPaneEx(3, 4);
        this.gridPanes[TuningParameterPaneIndex].setColumnWidth(0, 115);
        this.gridPanes[TuningParameterPaneIndex].setColumnWidth(1, 75);
        this.gridPanes[TuningParameterPaneIndex].setColumnWidth(2, 75);
        this.gridPanes[TuningParameterPaneIndex].setColumnWidth(3, 30);
        this.gridPanes[TuningParameterPaneIndex].setWidget((BWidget)this.createEnggUnitPane(tempEngDiffUnit), 0, 3);
        n11 = 0;
        while (n11 < 2) {
            this.checkBoxes[n8 + n11].setHalign(BHalign.left);
            this.gridPanes[TuningParameterPaneIndex].setWidget((BWidget)this.createNativeEnggUnitPane(secUnit), n11 + 1, 3);
            ++n11;
        }
        BT7350Container.addToGrid(this.gridPanes[TuningParameterPaneIndex].getRowCount(), 0, this.gridPanes[TuningParameterPaneIndex], (BWidget[])this.labels, n7);
        BT7350Container.addToGrid(3, 1, this.gridPanes[TuningParameterPaneIndex], new BWidget[]{this.txfHtThrtlRange, bFlowPaneArray[0], bFlowPaneArray[1]}, 0);
        BT7350Container.addToGrid(3, 2, this.gridPanes[TuningParameterPaneIndex], new BWidget[]{this.txfClThrtlRange, bFlowPaneArray[2], bFlowPaneArray[3]}, 0);
        this.borderPane[antAuthPaneIndex].setBorder(BBorder.none);
        int n13 = this.currentTextField;
        this.textField[this.currentTextField++] = this.txfAntAuth = this.createRecoveryField(2, 15, 4, null, "AntAuth");
        this.txfAntAuth.setBounds(10.0, 40.0, 60.0, 25.0);
        this.borderPane[antAuthPaneIndex].add("txfAntAuth", (BValue)this.txfAntAuth);
        this.equipTxfEnd = this.currentTextField - 1;
    }

    private final void setLimitAndMessage(BDefaultIntegerField bDefaultIntegerField, int n, int n2, String string, String string2, String string3) {
        bDefaultIntegerField.setLimitCheck(n, n2, string);
        bDefaultIntegerField.setLimitWrongMessage(string2, string3);
    }

    private final void setIntTime(int n, DisableDeselectCheck disableDeselectCheck, BDefaultIntegerField bDefaultIntegerField) {
        bDefaultIntegerField.setValue(n);
        boolean bl = false;
        if (n >= iIntTimeLowLim) {
            bl = true;
        }
        disableDeselectCheck.setSelected(bl);
    }

    private final BDefaultIntegerField createRecoveryField(int n, int n2, int n3, String string, String string2) {
        if (string != null) {
            n3 = this.getDisplayValueRndOff(string, n3);
            n2 = this.getDisplayValueRndOff(string, n2);
            n = this.getDisplayValueRndOff(string, n);
        }
        BDefaultIntegerField bDefaultIntegerField = new BDefaultIntegerField(n3, 2, true);
        bDefaultIntegerField.setLimitCheck(n, n2, BT7350Container.getTextFromLexicon(string2));
        bDefaultIntegerField.setDefaultValue(n3);
        bDefaultIntegerField.setShowDialog(false);
        return bDefaultIntegerField;
    }

    private final BPane createNativeEnggUnitPane(String string) {
        return new BBorderPane((BWidget)new BLabel(BAXUtil.getDisplaySymbol(string, 0), BHalign.left), BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)2));
    }

    private final BPane createEnggUnitPane(String string) {
        return new BBorderPane((BWidget)new BLabel(this.getDisplaySymbol(string), BHalign.left), BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)2));
    }

    private final void createSetPoint(int n, int n2, int n3, int n4, String string) {
        this.gridPanes[n].setColumnWidth(1, 60);
        this.gridPanes[n].setColumnWidth(2, 30);
        BT7350Container.addToGrid(n2, 0, this.gridPanes[n], (BWidget[])this.labels, n3);
        BT7350Container.addToGrid(n2, 1, this.gridPanes[n], (BWidget[])this.textField, n4);
        int n5 = 0;
        while (n5 < n2) {
            this.gridPanes[n].setWidget((BWidget)this.createEnggUnitPane(string), n5, 2);
            ++n5;
        }
    }

    private final BLabel setCurrentLabel(String string) {
        this.labels[this.currentLabel].setText(BT7350Container.getTextFromLexicon(string));
        return this.labels[this.currentLabel++];
    }

    private final BFlowPane createEquipField(BDefaultIntegerField bDefaultIntegerField, String string) {
        BFlowPane bFlowPane = new BFlowPane();
        BCanvasPane bCanvasPane = new BCanvasPane();
        bCanvasPane.add("text", (BValue)bDefaultIntegerField);
        bCanvasPane.setViewSize(BSize.make((double)50.0, (double)20.0));
        bFlowPane.add("textOAT", (BValue)bCanvasPane);
        bFlowPane.add("unit", (BValue)this.createEnggUnitPane(string));
        return bFlowPane;
    }

    public static DisableDeselectCheck setDeselectCmdCheck(BCheckBox bCheckBox, String string, BWidget bWidget) {
        return BT7350Container.setDeselectCmdCheck(bCheckBox, string, new BWidget[]{bWidget});
    }

    public static DisableDeselectCheck setDeselectCmdCheck(BCheckBox bCheckBox, String string, BWidget[] bWidgetArray) {
        DisableDeselectCheck disableDeselectCheck = new DisableDeselectCheck((BWidget)bCheckBox, string, bWidgetArray);
        bCheckBox.setCommand((Command)disableDeselectCheck, false, false);
        return disableDeselectCheck;
    }

    public static void addToGrid(int n, int n2, int n3, BGridPaneEx bGridPaneEx, BWidget[] bWidgetArray, int n4) {
        int n5 = n2;
        int n6 = 0;
        while (n5 < n2 + n) {
            bGridPaneEx.setWidget((BWidget)new BBorderPane(bWidgetArray[n6 + n4], BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)2)), n5, n3);
            ++n5;
            ++n6;
        }
    }

    public static void addToGrid(int n, int n2, BGridPaneEx bGridPaneEx, BWidget[] bWidgetArray, int n3) {
        BT7350Container.addToGrid(n, 0, n2, bGridPaneEx, bWidgetArray, n3);
    }

    public static void addToGridHorizontal(BGridPaneEx bGridPaneEx, int n, int n2, BWidget[] bWidgetArray) {
        int n3 = 0;
        while (n3 < bGridPaneEx.getColumnCount()) {
            bGridPaneEx.setWidget(bWidgetArray[n2 + n3], n, n3);
            ++n3;
        }
    }

    private final BCheckBox getCheckBox(BWidget bWidget, String string) {
        return (BCheckBox)((BCheckBoxEx)bWidget.get((String)string)).ctrl;
    }

    public void makeStaticReferences(BWidget bWidget) {
        int n;
        super.makeStaticReferences(bWidget);
        this.borderPane = new BBorderPaneEx[borderPaneCount];
        generalPaneIndex = n = 0;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("GeneralBorder");
        outputPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("OutputBorderPane");
        inputPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("InputBorderPane");
        daylightPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("DayLtBorderPane");
        htandcoolPaneIndex = n;
        System.out.println(htandcoolPaneIndex);
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("HeatCoolBorderPane");
        rangeStopPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("RangeStopBorderPane");
        enrgMgmtPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("EnergyMmtBorderPane");
        dehumidPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("DehumdOption");
        recoveryPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("CoolHeatRecovery");
        bypassPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("BypassBorderPane");
        heatSelectPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("HeatSelect");
        coolSelectPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("CoolSelect");
        TuningParameterPaneIndex = n;
        this.borderPane[n++] = (BBorderPaneEx)bWidget.get("TuningParameter");
        antAuthPaneIndex = n;
        this.borderPane[n] = (BBorderPaneEx)bWidget.get("AnticipatorAuthPane");
        this.dehumidification = (BBorderPaneEx)bWidget.get("DehumidBorderPane");
        this.heatOATPane = (BBorderPaneEx)bWidget.get("HeatOAT");
        this.cbHeatOAT = this.getCheckBox(bWidget, "cbHeatOAT");
        this.cbHeatDAT = this.getCheckBox(bWidget, "cbHeatDAT");
        this.coolOATPane = (BBorderPaneEx)bWidget.get("CoolOAT");
        this.cbCoolOAT = this.getCheckBox(bWidget, "cbCoolOAT");
        this.cbCoolDAT = this.getCheckBox(bWidget, "cbCoolDAT");
        this.cbDayLghtSave = this.getCheckBox(bWidget, "DayLightSaveEnable");
        this.cbAntAuth = this.getCheckBox(bWidget, "cbAntAuth");
        this.lbRecLead = (BLabel)((BLabelEx)bWidget.get((String)"LabelRecoveyTime")).ctrl;
        this.lbRecLead.setHalign(BHalign.left);
        this.lbHeat = (BLabel)((BLabelEx)bWidget.get((String)"HeatRecInfo")).ctrl;
        this.lbHeat.setHalign(BHalign.left);
        this.lbCool = (BLabel)((BLabelEx)bWidget.get((String)"CoolRecInfo")).ctrl;
        this.lbCool.setHalign(BHalign.left);
        this.generalPane = (BPaneBase)bWidget.get(generalPge);
        this.setPointPane = (BPaneBase)bWidget.get(stPntPge);
        this.equipCtrlPane = (BPaneBase)bWidget.get(eqpCtrlpge);
        this.kpdDisplayPane = (BT7350KeyPdDisplayPage)((BPaneBase)bWidget.get(keyPdDisplay));
        this.schdPane = (BT7350SchedulePage)bWidget.get(schdPge);
        this.holPane = (BT7350HolidayPage)bWidget.get(hldPge);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ T7350Model access$36(BT7350Container bT7350Container) {
        return bT7350Container.selectedModel;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.textField = new BDefaultIntegerField[28];
        this.labels = new BLabel[39];
        this.checkBoxes = new BCheckBox[7];
        this.dropDowns = new BListDropDown[31];
        this.unitConversion = 0;
        this.modelType = 3;
        this.setPointStep = 1;
        this.bConfigIDGeneration = false;
        this.bResetting = false;
    }

    public BT7350Container(boolean bl, String string, BT7350 bT7350) {
        super(bl, string, LEXICON);
        this.this();
        this.device = bT7350;
        this.unitConversion = Nre.unitConversion;
        if (this.unitConversion == 0) {
            this.unitConversion = 2;
        }
        this.setPointStep = (int)Math.round(this.getDisplayValue(setPointUnit, 21.0) - this.getDisplayValue(setPointUnit, 20.0));
        this.htStptProp = BT7350Container.getTextFromLexicon("HeatSetpnt");
        this.clStptProp = BT7350Container.getTextFromLexicon("CoolSetpnt");
        this.gridPanes = new BGridPaneEx[gridPaneCount];
        int n = 0;
        while (n < this.labels.length) {
            this.labels[n] = new BLabel();
            this.labels[n].setHalign(labelHALIGN);
            this.labels[n].setValign(labelVALIGN);
            ++n;
        }
        this.iHtLowTemp = this.getDisplayValueRndOff(tempEngUnit, 40.0);
        this.iHtHiTemp = this.getDisplayValueRndOff(tempEngUnit, 90.0);
        this.iClLowTemp = this.getDisplayValueRndOff(tempEngUnit, 45.0);
        this.iClHiTemp = this.getDisplayValueRndOff(tempEngUnit, 99.0);
        this.createGeneralPage();
        this.createSetpointsPage();
        this.createKeypdDisplay();
        this.createEquipControlPage();
        System.out.println("TextFields:" + this.currentTextField + " Labels:" + this.currentLabel + " Checkboxes:" + this.currentCheckBox + " dropDowns:" + this.currentDropDown + " noofPanes" + antAuthPaneIndex);
        n = 0;
        while (n < gridPaneCount) {
            this.borderPane[n].setContent((BWidget)this.gridPanes[n]);
            this.gridPanes[n].setBounds(0.0, 5, this.borderPane[n].getWidth(), this.borderPane[n].getHeight());
            this.gridPanes[n].setColumnAlign(labelHALIGN);
            this.gridPanes[n].setRowAlign(labelVALIGN);
            this.gridPanes[n].setHalign(HALIGN);
            this.gridPanes[n].setValign(VALIGN);
            this.gridPanes[n].setColumnGap(10.0);
            this.gridPanes[n].setRowGap(10.0);
            ++n;
        }
        n = daylightPaneIndex;
        this.selectedModel = this.t7350H0009 = new T7350H0009();
        this.t7350H0017 = new T7350H0017();
        new WidgetSubscriber(){

            public final void modified(BWidgetEvent bWidgetEvent) {
                BT7350Container.this.changeDATSensor();
            }
        }.subscribe((BComponent)this.ddDATemp);
        new WidgetSubscriber(){

            public final void modified(BWidgetEvent bWidgetEvent) {
                BT7350Container.this.changeOATSensor();
            }
        }.subscribe((BComponent)this.ddOATemp);
        new WidgetSubscriber(){

            public final void modified(BWidgetEvent bWidgetEvent) {
                BT7350Container.this.changeRoomHumidity();
            }
        }.subscribe((BComponent)this.ddRoomHumid);
        new WidgetSubscriber(){

            public final void modified(BWidgetEvent bWidgetEvent) {
                BT7350Container.this.setSelectedModel(BT7350Container.this.ddModel.getSelectedOrdinal());
            }
        }.subscribe((BComponent)this.ddModel);
        WidgetSubscriber widgetSubscriber = new WidgetSubscriber(){

            public final void actionPerformed(BWidgetEvent bWidgetEvent) {
                BT7350Container.this.reheatResetClicked();
            }
        };
        widgetSubscriber.subscribe((BComponent)this.cbReheat);
        widgetSubscriber.subscribe((BComponent)this.cbResetHum);
        new WidgetSubscriber(){

            public final void actionPerformed(BWidgetEvent bWidgetEvent) {
                BT7350Container.this.resetTempSetptModified();
            }
        }.subscribe((BComponent)this.ddResetTempStpt.getList());
        new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.onFocusLostMinHtOcc();
            }
        }.subscribe((BComponent)this.txfHtMinOcc);
        new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.onFocusLostHtOcc();
            }
        }.subscribe((BComponent)this.txfHtOccStpt);
        new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.onFocusLostHtStdby();
            }
        }.subscribe((BComponent)this.txfHtStdbyStpt);
        new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.onFocusLostHtUnocc();
            }
        }.subscribe((BComponent)this.txfHtUnoccStpt);
        new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.onFocusLostMaxClOcc();
            }
        }.subscribe((BComponent)this.txfClMaxOcc);
        new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.onFocusLostClOcc();
            }
        }.subscribe((BComponent)this.txfClOccStpt);
        new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.onFocusLostClStdby();
            }
        }.subscribe((BComponent)this.txfClStdbyStpt);
        new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.onFocusLostClUnocc();
            }
        }.subscribe((BComponent)this.txfClUnoccStpt);
        WidgetSubscriber widgetSubscriber2 = new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.updateHeatLeadTimeInfo();
            }
        };
        WidgetSubscriber widgetSubscriber3 = new WidgetSubscriber(){

            public final void focusLost(BFocusEvent bFocusEvent) {
                BT7350Container.this.updateCoolLeadTimeInfo();
            }
        };
        widgetSubscriber2.subscribe((BComponent)this.txfHtOccStpt);
        widgetSubscriber2.subscribe((BComponent)this.txfHtUnoccStpt);
        widgetSubscriber2.subscribe((BComponent)this.txfHtMinRamp);
        widgetSubscriber2.subscribe((BComponent)this.txfHtMaxRamp);
        widgetSubscriber3.subscribe((BComponent)this.txfClOccStpt);
        widgetSubscriber3.subscribe((BComponent)this.txfClUnoccStpt);
        widgetSubscriber3.subscribe((BComponent)this.txfClMinRamp);
        widgetSubscriber3.subscribe((BComponent)this.txfClMaxRamp);
        new WidgetSubscriber(){

            public final void actionPerformed(BWidgetEvent bWidgetEvent) {
                BT7350Container.this.configurationIDClicked();
            }
        }.subscribe((BComponent)this.butConfigID);
    }

    static {
        Class clazz = class$com$honeywell$londevices$axwizard$ui$t7350$BT7350Container;
        if (clazz == null) {
            clazz = class$com$honeywell$londevices$axwizard$ui$t7350$BT7350Container = BT7350Container.class("[Lcom.honeywell.londevices.axwizard.ui.t7350.BT7350Container;", false);
        }
        LEXICON = Lexicon.make((Class)clazz);
        enumUtil = new BAXUtil("local:|module://lonhoneywellAXWizards/com/honeywell/londevices/axwizard/ui/t7350/T7350Enumdefs.xml");
        iRemoteTempSensor = 1;
        iIntTimeLowLim = 100;
        iDerTimeLowLim = 10;
        iSCALE10 = 10;
        OATRmpUnit = tempEngUnit;
        rampRateUnit = heatRateUnit;
        setPointUnit = tempMetricUnit;
        enrgMgmtPaneIndex = 11;
        dehumidPaneIndex = 12;
        recoveryPaneIndex = 13;
        bypassPaneIndex = 14;
        borderPaneCount = 14;
        gridPaneCount = 13;
        HALIGN = BHalign.center;
        labelHALIGN = BHalign.left;
        VALIGN = BValign.center;
        labelVALIGN = BValign.center;
        Class clazz2 = class$com$honeywell$londevices$axwizard$ui$t7350$BT7350Container;
        if (clazz2 == null) {
            clazz2 = class$com$honeywell$londevices$axwizard$ui$t7350$BT7350Container = BT7350Container.class("[Lcom.honeywell.londevices.axwizard.ui.t7350.BT7350Container;", false);
        }
        TYPE = Sys.loadType((Class)clazz2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private abstract class T7350Model
    implements IConfigurationStepContainer {
        public abstract void setAsCurrentModel();

        public abstract void removeAsCurrentModel();

        public void reset() {
            BT7350Container.this.ddHtFanOn.setSelectedOrdinal(BT7350Container.this.nciConfig.getBitAsInt(4, 3));
        }

        public void save() {
            T7350ByteArray t7350ByteArray = BT7350Container.this.nciConfig;
            boolean bl = false;
            if (BT7350Container.this.ddHtFanOn.getSelectedOrdinal() == 1) {
                bl = true;
            }
            t7350ByteArray.setBit(4, 3, bl);
        }

        private T7350Model() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class T7350H0009
    extends T7350Model {
        boolean bCurrent;
        int iStdEquip;
        int iHtPump;
        boolean bSettingEquipType;

        private final void setClDefThrtlRngIntTime() {
            int n = 0;
            int n2 = 0;
            n = this.calculateDefClThrtl();
            n2 = this.calculateDefClIntTime();
            if (this.calculateClStages() > 0 && !BT7350Container.this.bResetting) {
                String string = BT7350Container.getTextFromLexicon("setDefaultClThrtInt");
                string = string + ' ' + n + " & " + n2;
                if (BDialog.confirm(null, (Object)(string = string + ' ' + BT7350Container.getTextFromLexicon("setDefaultConfirmMsg"))) == 4) {
                    BT7350Container.this.txfClThrtlRange.setValue(n);
                    BT7350Container.this.setIntTime(n2, BT7350Container.this.cmdClIntTime, BT7350Container.this.txfClIntegralTime);
                    BT7350Container.this.setStepModified(BT7350Container.generalPge, BT7350Container.eqpCtrlpge);
                }
            }
        }

        private final void setHtDefThrtlRngIntTime() {
            int n = 0;
            int n2 = 0;
            int n3 = BT7350Container.this.ddEquipType.getSelectedOrdinal();
            n = this.calculateDefHtThrtl();
            n2 = this.calculateDefHtIntTime();
            if (this.calculateHtStages() > 0 && !BT7350Container.this.bResetting) {
                String string = BT7350Container.getTextFromLexicon("setDefaultHtThrtInt");
                string = string + ' ' + n + " & " + n2;
                if (BDialog.confirm(null, (Object)(string = string + ' ' + BT7350Container.getTextFromLexicon("setDefaultConfirmMsg"))) == 4) {
                    BT7350Container.this.txfHtThrtlRange.setValue(n);
                    BT7350Container.this.setIntTime(n2, BT7350Container.this.cmdHtIntTime, BT7350Container.this.txfHtIntegralTime);
                    BT7350Container.this.setStepModified(BT7350Container.generalPge, BT7350Container.eqpCtrlpge);
                }
            }
        }

        private final void enableHtCycRate(int n) {
            boolean bl = BT7350Container.this.ddHtCycRate.isEnabled();
            BDefaultEnumDropDown bDefaultEnumDropDown = BT7350Container.this.ddHtCycRate;
            int n2 = 0;
            if (n == 0) {
                n2 = 1;
            }
            bDefaultEnumDropDown.setEnabled(1 - n2);
            if (bl != BT7350Container.this.ddHtCycRate.isEnabled()) {
                BT7350Container.this.setStepModified(BT7350Container.generalPge, BT7350Container.eqpCtrlpge);
            }
        }

        private final void enableClCycRate(int n) {
            boolean bl = BT7350Container.this.ddClCycRate.isEnabled();
            BDefaultEnumDropDown bDefaultEnumDropDown = BT7350Container.this.ddClCycRate;
            int n2 = 0;
            if (n == 0) {
                n2 = 1;
            }
            bDefaultEnumDropDown.setEnabled(1 - n2);
            if (bl != BT7350Container.this.ddClCycRate.isEnabled()) {
                BT7350Container.this.setStepModified(BT7350Container.generalPge, BT7350Container.eqpCtrlpge);
            }
        }

        public void setAsCurrentModel() {
            this.bCurrent = true;
            BT7350Container.this.selectedModel = this;
            BT7350Container.this.ddEquipType.setEnabled(true);
            this.setEquipType(this.iStdEquip);
            BT7350Container.this.gridPanes[outputPaneIndex].setWidget((BWidget)BT7350Container.this.ddHtPmpRevValue, 3, 1);
            BT7350Container.this.cbReheat.setVisible(true);
            BT7350Container.this.ddHtFanOn.setSelectedOrdinal(BT7350Container.getEnumRange("FanOnHeat").get("T7350OFF").getOrdinal());
            BT7350Container.this.setStepModified(BT7350Container.generalPge, new String[]{BT7350Container.stPntPge, BT7350Container.eqpCtrlpge});
            BT7350Container.this.lbHtPmpRevAction.setText(BT7350Container.getTextFromLexicon("HtPmpRevVal"));
        }

        public void setEquipType(int n) {
            System.out.println("setign equip type:" + n);
            this.bSettingEquipType = true;
            BT7350Container.this.kpdDisplayPane.setEquipType(n);
            BT7350Container.this.setStepModified(BT7350Container.generalPge, BT7350Container.keyPdDisplay);
            if (this.bCurrent) {
                if (n == this.iStdEquip) {
                    BT7350Container.this.ddHtPmpRevValue.setEnabled(false);
                    BT7350Container.this.lbHeatStgs.setText(BT7350Container.getTextFromLexicon("HeatStgs"));
                    BT7350Container.this.lbCoolStgs.setText(BT7350Container.getTextFromLexicon("CoolStgs"));
                    BT7350Container.this.dd009StdCoolStgs.getList().getSelection().deselectAll();
                    BT7350Container.this.dd009StdCoolStgs.setEnumRange(BT7350Container.getEnumRange("Std009FourStages"), LEXICON, 3);
                    BT7350Container.this.dd009StdHtStages.getList().getSelection().deselectAll();
                    BT7350Container.this.dd009StdHtStages.setEnumRange(BT7350Container.getEnumRange("Std009ThreeStages"), LEXICON, 3);
                    BT7350Container.this.gridPanes[outputPaneIndex].setWidget((BWidget)BT7350Container.this.dd009StdHtStages, 0, 1);
                    BT7350Container.this.gridPanes[outputPaneIndex].setWidget((BWidget)BT7350Container.this.dd009StdCoolStgs, 1, 1);
                } else if (n == this.iHtPump) {
                    BT7350Container.this.ddHtPmpRevValue.setEnabled(true);
                    BT7350Container.this.lbHeatStgs.setText(BT7350Container.getTextFromLexicon("AuxHtStages"));
                    BT7350Container.this.lbCoolStgs.setText(BT7350Container.getTextFromLexicon("CompressorStgs"));
                    BT7350Container.this.dd009HPCompressorStgs.setEnumRange(BT7350Container.getEnumRange("HP009Stages"), LEXICON, 2);
                    BT7350Container.this.dd009HPAuxHtStgs.setEnumRange(BT7350Container.getEnumRange("HP009Stages"), LEXICON, 1);
                    BT7350Container.this.gridPanes[outputPaneIndex].setWidget((BWidget)BT7350Container.this.dd009HPAuxHtStgs, 0, 1);
                    BT7350Container.this.gridPanes[outputPaneIndex].setWidget((BWidget)BT7350Container.this.dd009HPCompressorStgs, 1, 1);
                }
            }
            this.bSettingEquipType = false;
        }

        public BStep[] getSteps() {
            return null;
        }

        public void load(int n) throws StepContainerException {
        }

        public void save() {
            if (!this.bCurrent) {
                return;
            }
            BT7350Container.this.nciConfig.setBit(0, 6, (byte)BT7350Container.this.ddEquipType.getSelectedOrdinal());
            if (BT7350Container.this.ddEquipType.getSelectedOrdinal() == this.iStdEquip) {
                this.saveStandard();
            } else {
                this.saveHtPmp();
            }
            BT7350Container.this.nciConfig.setBit(3, 6, BT7350Container.this.cbReheat.isSelected());
            super.save();
        }

        public void unload(int n) throws StepContainerException {
        }

        public void reset() {
            BT7350Container.this.ddEquipType.setSelectedOrdinal(BT7350Container.this.nciConfig.getBitAsInt(0, 6));
            System.out.println("nciConfig7byte" + BT7350Container.this.nciConfig.getByte(7) + "nciConfig:" + BT7350Container.this.nciConfig);
            int n = BT7350Container.this.nciConfig.getBits(7, 0, 3);
            if (BT7350Container.this.ddEquipType.getSelectedOrdinal() == this.iHtPump) {
                BT7350Container.this.dd009HPCompressorStgs.setSelectedOrdinal(n);
                BT7350Container.this.dd009HPAuxHtStgs.setSelectedOrdinal(BT7350Container.this.nciConfig.getBits(7, 5, 2));
            } else {
                BT7350Container.this.dd009StdCoolStgs.setSelectedOrdinal(n);
                BT7350Container.this.dd009StdHtStages.setSelectedOrdinal(BT7350Container.this.nciConfig.getBits(7, 3, 2));
            }
            BT7350Container.this.ddHtPmpRevValue.setSelectedOrdinal(BT7350Container.this.nciConfig.getBitAsInt(0, 7));
            BT7350Container.this.cbReheat.setSelected(BT7350Container.this.nciConfig.getBit(3, 6));
            super.reset();
        }

        public void saveStandard() {
            BT7350Container.this.nciConfig.setBits(7, 3, 2, (byte)BT7350Container.this.dd009StdHtStages.getSelectedOrdinal());
            BT7350Container.this.nciConfig.setBits(7, 0, 3, (byte)BT7350Container.this.dd009StdCoolStgs.getSelectedOrdinal());
        }

        public void saveHtPmp() {
            BT7350Container.this.nciConfig.setBits(7, 3, 2, (byte)0);
            BT7350Container.this.nciConfig.setBits(7, 5, 2, (byte)BT7350Container.this.dd009HPAuxHtStgs.getSelectedOrdinal());
            BT7350Container.this.nciConfig.setBits(7, 0, 3, (byte)BT7350Container.this.dd009HPCompressorStgs.getSelectedOrdinal());
        }

        public void removeAsCurrentModel() {
            BT7350Container.this.cbReheat.setSelected(false);
            BT7350Container.this.cbReheat.setVisible(false);
            this.bCurrent = false;
        }

        private final int calculateHtStages() {
            int n = BT7350Container.this.ddEquipType.getSelectedOrdinal();
            if (n == this.iStdEquip) {
                return BT7350Container.this.dd009StdHtStages.getSelectedOrdinal();
            }
            if (n == this.iHtPump) {
                return BT7350Container.this.dd009HPAuxHtStgs.getSelectedOrdinal() + BT7350Container.this.dd009HPCompressorStgs.getSelectedOrdinal();
            }
            return 0;
        }

        private final int calculateClStages() {
            int n = BT7350Container.this.ddEquipType.getSelectedOrdinal();
            if (n == this.iStdEquip) {
                return BT7350Container.this.dd009StdCoolStgs.getSelectedOrdinal();
            }
            if (n == this.iHtPump) {
                return BT7350Container.this.dd009HPCompressorStgs.getSelectedOrdinal();
            }
            return 0;
        }

        private final int calculateDefHtThrtl() {
            int n = BT7350Container.this.getNativeValueRndOff(BT7350Container.tempEngDiffUnit, BT7350Container.this.txfHtThrtlRange.getValue());
            switch (this.calculateHtStages()) {
                case 1: {
                    n = 3;
                    break;
                }
                case 2: {
                    n = 4;
                    break;
                }
                case 3: {
                    n = 7;
                    break;
                }
                case 4: {
                    n = 8;
                    break;
                }
            }
            return BT7350Container.this.getDisplayValueRndOff(BT7350Container.tempEngDiffUnit, n);
        }

        private final int calculateDefHtIntTime() {
            int n = BT7350Container.this.txfHtIntegralTime.getValue();
            switch (this.calculateHtStages()) {
                case 1: {
                    n = 3100;
                    break;
                }
                case 2: {
                    n = 2500;
                    break;
                }
                case 3: {
                    n = 1650;
                    break;
                }
                case 4: {
                    n = 1250;
                    break;
                }
            }
            return n;
        }

        private final int calculateDefClThrtl() {
            int n = BT7350Container.this.getNativeValueRndOff(BT7350Container.tempEngDiffUnit, BT7350Container.this.txfClThrtlRange.getValue());
            switch (this.calculateClStages()) {
                case 1: {
                    n = 3;
                    break;
                }
                case 2: {
                    n = 4;
                    break;
                }
                case 3: {
                    n = 7;
                    break;
                }
                case 4: {
                    n = 8;
                    break;
                }
            }
            return BT7350Container.this.getDisplayValueRndOff(BT7350Container.tempEngDiffUnit, n);
        }

        private final int calculateDefClIntTime() {
            int n = BT7350Container.this.txfClIntegralTime.getValue();
            switch (this.calculateClStages()) {
                case 1: {
                    n = 3100;
                    break;
                }
                case 2: {
                    n = 2500;
                    break;
                }
                case 3: {
                    n = 1650;
                    break;
                }
                case 4: {
                    n = 1250;
                    break;
                }
            }
            return n;
        }

        private final /* synthetic */ void this() {
            this.bCurrent = false;
            this.iStdEquip = BT7350Container.getEnumRange("equipType").get("T7350Standard").getOrdinal();
            this.iHtPump = BT7350Container.getEnumRange("equipType").get("T7350HeatPump").getOrdinal();
            this.bSettingEquipType = false;
        }

        public T7350H0009() {
            this.this();
            HtClStageHandler htClStageHandler = new HtClStageHandler(true);
            HtClStageHandler htClStageHandler2 = new HtClStageHandler(false);
            htClStageHandler.subscribe((BComponent)BT7350Container.this.dd009HPAuxHtStgs);
            htClStageHandler.subscribe((BComponent)BT7350Container.this.dd009StdHtStages);
            htClStageHandler2.subscribe((BComponent)BT7350Container.this.dd009HPCompressorStgs);
            htClStageHandler2.subscribe((BComponent)BT7350Container.this.dd009StdCoolStgs);
            new WidgetSubscriber(){

                public final void modified(BWidgetEvent bWidgetEvent) {
                    int n = BT7350Container.this.dd009StdHtStages.getSelectedOrdinal();
                    boolean bl = false;
                    BEnumRange bEnumRange = null;
                    if (BT7350Container.this.dd009StdCoolStgs.getSelectedOrdinal() > 3) {
                        bEnumRange = BT7350Container.getEnumRange("Std009TwoStages");
                        int n2 = bEnumRange.get("T7350TwoStage").getOrdinal();
                        if (n > n2) {
                            n = n2;
                            bl = true;
                        }
                    } else {
                        bEnumRange = BT7350Container.getEnumRange("Std009ThreeStages");
                        if (BT7350Container.this.bResetting) {
                            n = 3;
                        }
                    }
                    BT7350Container.this.dd009StdHtStages.setEnumRange(bEnumRange, LEXICON);
                    if (bl) {
                        BT7350Container.this.dd009StdHtStages.setSelectedOrdinal(n);
                    }
                }
            }.subscribe((BComponent)BT7350Container.this.dd009StdCoolStgs);
            new WidgetSubscriber(){

                public final void modified(BWidgetEvent bWidgetEvent) {
                    T7350H0009.this.setEquipType(BT7350Container.this.ddEquipType.getSelectedOrdinal());
                }
            }.subscribe((BComponent)BT7350Container.this.ddEquipType);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        private class HtClStageHandler
        extends WidgetSubscriber {
            boolean bForHeat;

            public void modified(BWidgetEvent bWidgetEvent) {
                if (!(bWidgetEvent.getWidget() instanceof BDefaultEnumDropDown)) {
                    return;
                }
                BDefaultEnumDropDown bDefaultEnumDropDown = (BDefaultEnumDropDown)bWidgetEvent.getWidget();
                if (this.bForHeat) {
                    T7350H0009.this.enableHtCycRate(bDefaultEnumDropDown.getSelectedOrdinal());
                    T7350H0009.this.setHtDefThrtlRngIntTime();
                } else {
                    T7350H0009.this.enableClCycRate(bDefaultEnumDropDown.getSelectedOrdinal());
                    T7350H0009.this.setClDefThrtlRngIntTime();
                    if (BT7350Container.this.ddEquipType.getSelectedOrdinal() == T7350H0009.this.iHtPump && !T7350H0009.this.bSettingEquipType) {
                        T7350H0009.this.setHtDefThrtlRngIntTime();
                    }
                }
            }

            public HtClStageHandler(boolean bl) {
                this.bForHeat = bl;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class T7350H0017
    extends T7350Model {
        boolean bCurrent;

        private final void setHtDefaultThrtlIntTime() {
            if (!BT7350Container.this.bResetting) {
                int n = BT7350Container.this.getDisplayValueRndOff(BT7350Container.tempEngDiffUnit, 5);
                int n2 = 1250;
                String string = BT7350Container.getTextFromLexicon("setDefaultHtThrtInt");
                string = string + ' ' + n + " & " + n2;
                if (BDialog.confirm(null, (Object)(string = string + ' ' + BT7350Container.getTextFromLexicon("setDefaultConfirmMsg"))) == 4) {
                    BT7350Container.this.txfHtThrtlRange.setValue(n);
                    BT7350Container.this.setIntTime(n2, BT7350Container.this.cmdHtIntTime, BT7350Container.this.txfHtIntegralTime);
                }
            }
        }

        private final void setClDefaultThrtlIntTime() {
            if (!BT7350Container.this.bResetting) {
                int n = BT7350Container.this.getDisplayValueRndOff(BT7350Container.tempEngDiffUnit, 5);
                int n2 = 1250;
                String string = BT7350Container.getTextFromLexicon("setDefaultClThrtInt") + ' ' + n + " & " + n2;
                if (BDialog.confirm(null, (Object)(string = string + ' ' + BT7350Container.getTextFromLexicon("setDefaultConfirmMsg"))) == 4) {
                    BT7350Container.this.txfClThrtlRange.setValue(n);
                    BT7350Container.this.setIntTime(n2, BT7350Container.this.cmdClIntTime, BT7350Container.this.txfClIntegralTime);
                }
            }
        }

        public void setAsCurrentModel() {
            this.bCurrent = true;
            BT7350Container.this.selectedModel = this;
            BT7350Container.this.ddEquipType.setEnabled(false);
            BT7350Container.this.lbHeatStgs.setText(BT7350Container.getTextFromLexicon("AuxHtStages"));
            BT7350Container.this.lbCoolStgs.setText(BT7350Container.getTextFromLexicon("CompressorStgs"));
            BT7350Container.this.lbHtPmpRevAction.setText(BT7350Container.getTextFromLexicon("HtAction"));
            BT7350Container.this.lbCoolAction.setVisible(true);
            BT7350Container.this.dd017AuxHtStgs.setEnumRange(BT7350Container.getEnumRange("Aux017HtStages"), LEXICON, 0);
            BT7350Container.this.dd017CompressorStgs.setEnumRange(BT7350Container.getEnumRange("Aux017ClStages"), LEXICON, 0);
            BT7350Container.this.ddHtAction.setVisible(true);
            BT7350Container.this.ddCoolAction.setVisible(true);
            BGridPaneEx bGridPaneEx = BT7350Container.this.gridPanes[outputPaneIndex];
            int n = 1;
            bGridPaneEx.setWidget((BWidget)BT7350Container.this.dd017AuxHtStgs, 0, n);
            bGridPaneEx.setWidget((BWidget)BT7350Container.this.dd017CompressorStgs, 1, n);
            bGridPaneEx.setWidget((BWidget)BT7350Container.this.ddHtAction, 3, n);
            bGridPaneEx.setWidget((BWidget)BT7350Container.this.ddCoolAction, 4, n);
            BT7350Container.this.ddHtFanOn.setSelectedOrdinal(BT7350Container.getEnumRange("FanOnHeat").get("T7350ON").getOrdinal());
            BT7350Container.this.setStepModified(BT7350Container.generalPge, new String[]{BT7350Container.stPntPge, BT7350Container.eqpCtrlpge});
        }

        public BStep[] getSteps() {
            return null;
        }

        public void load(int n) throws StepContainerException {
        }

        public void save() {
            BT7350Container.this.nciConfig.setBits(7, 0, 3, (byte)BT7350Container.this.dd017CompressorStgs.getSelectedOrdinal());
            BT7350Container.this.nciConfig.setBits(7, 3, 2, (byte)BT7350Container.this.dd017AuxHtStgs.getSelectedOrdinal());
            BT7350Container.this.nciConfig.setBit(3, 6, false);
            super.save();
        }

        public void unload(int n) throws StepContainerException {
        }

        public void reset() {
            BT7350Container.this.dd017AuxHtStgs.setSelectedOrdinal(BT7350Container.this.nciConfig.getBits(7, 3, 2));
            BT7350Container.this.dd017CompressorStgs.setSelectedOrdinal(BT7350Container.this.nciConfig.getBits(7, 0, 3));
            BT7350Container.this.ddHtAction.setSelectedOrdinal(BT7350Container.this.nciConfig.getBitAsInt(1, 4));
            BT7350Container.this.ddCoolAction.setSelectedOrdinal(BT7350Container.this.nciConfig.getBitAsInt(1, 5));
            super.reset();
        }

        public void removeAsCurrentModel() {
            this.bCurrent = false;
            BT7350Container.this.lbCoolAction.setVisible(false);
            BT7350Container.this.ddHtAction.setVisible(false);
            BT7350Container.this.ddCoolAction.setVisible(false);
            BT7350Container.this.ddAuxDO.setEnabled(true);
        }

        private final /* synthetic */ void this() {
            this.bCurrent = false;
        }

        public T7350H0017() {
            this.this();
            new WidgetSubscriber(){

                public final void modified(BWidgetEvent bWidgetEvent) {
                    int n = BT7350Container.this.dd017CompressorStgs.getSelectedOrdinal();
                    if (BT7350Container.this.dd017AuxHtStgs.getSelectedOrdinal() > 1) {
                        BT7350Container.this.dd017CompressorStgs.setEnumRange(BT7350Container.getEnumRange("Aux017OneClStage"), LEXICON);
                        BT7350Container.this.ddAuxDO.setEnabled(false);
                    } else {
                        BT7350Container.this.dd017CompressorStgs.setEnumRange(BT7350Container.getEnumRange("Aux017ClStages"), LEXICON);
                        if (BT7350Container.this.dd017CompressorStgs.getSelectedOrdinal() < 2) {
                            BT7350Container.this.ddAuxDO.setEnabled(true);
                        }
                    }
                    T7350H0017.this.setHtDefaultThrtlIntTime();
                    BT7350Container.this.setStepModified(BT7350Container.generalPge, BT7350Container.eqpCtrlpge);
                }
            }.subscribe((BComponent)BT7350Container.this.dd017AuxHtStgs);
            new WidgetSubscriber(){

                public final void modified(BWidgetEvent bWidgetEvent) {
                    int n = BT7350Container.this.dd017AuxHtStgs.getSelectedOrdinal();
                    if (BT7350Container.this.dd017CompressorStgs.getSelectedOrdinal() > 1) {
                        BT7350Container.this.dd017AuxHtStgs.setEnumRange(BT7350Container.getEnumRange("Aux017OneHtStage"), LEXICON);
                        BT7350Container.this.ddAuxDO.setEnabled(false);
                    } else {
                        BT7350Container.this.dd017AuxHtStgs.setEnumRange(BT7350Container.getEnumRange("Aux017HtStages"), LEXICON);
                        if (BT7350Container.this.dd017AuxHtStgs.getSelectedOrdinal() < 2) {
                            BT7350Container.this.ddAuxDO.setEnabled(true);
                        }
                    }
                    T7350H0017.this.setClDefaultThrtlIntTime();
                    BT7350Container.this.setStepModified(BT7350Container.generalPge, BT7350Container.eqpCtrlpge);
                }
            }.subscribe((BComponent)BT7350Container.this.dd017CompressorStgs);
        }
    }
}

