/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.londevices.axwizard.ui.VAV;

import com.honeywell.framework.StepContainerException;
import com.honeywell.framework.dragdrop.BBorderPaneEx;
import com.honeywell.framework.dragdrop.BITextFieldEx;
import com.honeywell.framework.dragdrop.BLabelEx;
import com.honeywell.framework.dragdrop.BPaneBase;
import com.honeywell.londevices.axwizard.ui.VAV.BVavConfig;
import com.honeywell.londevices.axwizard.ui.VAV.BVavContainer;
import com.honeywell.londevices.utilities.BIntegerTextField;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BLonComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVavPID
extends BPaneBase {
    public static final Type TYPE;
    private static Lexicon lex;
    BLabelEx lblCoolThrottleRange;
    BLabelEx lblCoolIntegral;
    BLabelEx lblCoolDerivative;
    BLabelEx lblHeatThrottleRange;
    BLabelEx lblHeatIntegral;
    BLabelEx lblHeatDerivative;
    BLabelEx lblCoolThrottleRangeUnit;
    BLabelEx lblCoolIntegralUnit;
    BLabelEx lblCoolDerivativeUnit;
    BLabelEx lblHeatThrottleRangeUnit;
    BLabelEx lblHeatIntegralUnit;
    BLabelEx lblHeatDerivativeUnit;
    BITextFieldEx tfIxCoolThrottleRange;
    BITextFieldEx tfIxCoolIntegral;
    BITextFieldEx tfIxCoolDerivative;
    BITextFieldEx tfIxHeatThrottleRange;
    BITextFieldEx tfIxHeatIntegral;
    BITextFieldEx tfIxHeatDerivative;
    BIntegerTextField tfICoolThrottleRange;
    BIntegerTextField tfICoolIntegral;
    BIntegerTextField tfICoolDerivative;
    BIntegerTextField tfIHeatThrottleRange;
    BIntegerTextField tfIHeatIntegral;
    BIntegerTextField tfIHeatDerivative;
    float nCoolHeatKpMin;
    float nCoolHeatKpMax;
    float nCoolDefaultKp;
    float nHeatDefaultKp;
    BBorderPaneEx bBCooling;
    BBorderPaneEx bBHeating;
    int nTrCoolGain;
    int nIntCoolGain;
    int nDerCoolGain;
    int nTrHeatGain;
    int nIntHeatGain;
    int nDerHeatGain;
    BConfigParameter bCPnciAux2Setpt;
    BVavConfig objVavConfig;
    static /* synthetic */ Class class$com$honeywell$londevices$axwizard$ui$VAV$BVavPID;

    public Type getType() {
        return TYPE;
    }

    public void makeStaticReferences(BWidget bWidget) {
        super.makeStaticReferences(bWidget);
        System.out.println("makeStaticReferences ");
        this.objVavConfig = (BVavConfig)bWidget.get("vav_config");
        this.getGroupReferences(bWidget);
        this.getTextFieldReferences(bWidget);
        this.getUnitLabelReferences(bWidget);
        this.getLabelReferences(bWidget);
    }

    private final void getGroupReferences(BWidget bWidget) {
        this.bBCooling = (BBorderPaneEx)bWidget.get("grp_lbl_pid_cooling");
        this.bBHeating = (BBorderPaneEx)bWidget.get("grp_lbl_pid_heating");
    }

    private final void getLabelReferences(BWidget bWidget) {
        this.lblCoolThrottleRange = (BLabelEx)bWidget.get("lbl_pid_cool_throttle");
        this.lblCoolIntegral = (BLabelEx)bWidget.get("lbl_pid_cool_integral");
        this.lblCoolDerivative = (BLabelEx)bWidget.get("lbl_pid_cool_derivative");
        this.lblHeatThrottleRange = (BLabelEx)bWidget.get("lbl_pid_heat_throttle");
        this.lblHeatIntegral = (BLabelEx)bWidget.get("lbl_pid_heat_integral");
        this.lblHeatDerivative = (BLabelEx)bWidget.get("lbl_pid_heat_derivative");
    }

    private final void getUnitLabelReferences(BWidget bWidget) {
        this.lblCoolThrottleRangeUnit = (BLabelEx)bWidget.get("lbl_pid_cool_throttle_unit");
        this.lblCoolIntegralUnit = (BLabelEx)bWidget.get("lbl_pid_cool_integral_unit");
        this.lblCoolDerivativeUnit = (BLabelEx)bWidget.get("lbl_pid_cool_derivative_unit");
        this.lblHeatThrottleRangeUnit = (BLabelEx)bWidget.get("lbl_pid_heat_throttle_unit");
        this.lblHeatIntegralUnit = (BLabelEx)bWidget.get("lbl_pid_heat_integral_unit");
        this.lblHeatDerivativeUnit = (BLabelEx)bWidget.get("lbl_pid_heat_derivative_unit");
    }

    private final void getTextFieldReferences(BWidget bWidget) {
        this.tfIxCoolThrottleRange = (BITextFieldEx)bWidget.get("tf_pid_cool_throttle");
        this.tfICoolThrottleRange = (BIntegerTextField)this.tfIxCoolThrottleRange.ctrl;
        this.tfIxCoolIntegral = (BITextFieldEx)bWidget.get("tf_pid_cool_integral");
        this.tfICoolIntegral = (BIntegerTextField)this.tfIxCoolIntegral.ctrl;
        this.tfIxCoolDerivative = (BITextFieldEx)bWidget.get("tf_pid_cool_derivative");
        this.tfICoolDerivative = (BIntegerTextField)this.tfIxCoolDerivative.ctrl;
        this.tfIxHeatThrottleRange = (BITextFieldEx)bWidget.get("tf_pid_heat_throttle");
        this.tfIHeatThrottleRange = (BIntegerTextField)this.tfIxHeatThrottleRange.ctrl;
        this.tfIxHeatIntegral = (BITextFieldEx)bWidget.get("tf_pid_heat_integral");
        this.tfIHeatIntegral = (BIntegerTextField)this.tfIxHeatIntegral.ctrl;
        this.tfIxHeatDerivative = (BITextFieldEx)bWidget.get("tf_pid_heat_derivative");
        this.tfIHeatDerivative = (BIntegerTextField)this.tfIxHeatDerivative.ctrl;
    }

    public void reset() throws Exception {
        String string;
        this.ReadDataFromDatabase();
        if (BVavContainer.nUnitConversion == 1) {
            this.nCoolHeatKpMin = 0.5f;
            this.nCoolHeatKpMax = 11.1f;
            this.nCoolDefaultKp = 1.6f;
            this.nHeatDefaultKp = 2.7f;
            string = BUnit.getUnit((String)"celsius degrees").toString();
        } else {
            this.nCoolHeatKpMin = 1.0f;
            this.nCoolHeatKpMax = 20.0f;
            this.nCoolDefaultKp = 3;
            this.nHeatDefaultKp = 5;
            string = BUnit.getUnit((String)"fahrenheit degrees").toString();
        }
        this.tfICoolThrottleRange.setText(String.valueOf(this.nTrCoolGain));
        this.tfICoolThrottleRange.setLimitCheck((int)this.nCoolHeatKpMin, (int)this.nCoolHeatKpMax, "Cool Throttling Range");
        this.tfICoolIntegral.setText(String.valueOf(this.nIntCoolGain));
        this.tfICoolIntegral.setLimitCheck(0, 5000, "Cool Integral Action");
        this.tfICoolDerivative.setText(String.valueOf(this.nDerCoolGain));
        this.tfICoolDerivative.setLimitCheck(0, 255, "Cool Derivative Action");
        this.lblCoolThrottleRangeUnit.setText(string);
        this.tfIHeatThrottleRange.setText(String.valueOf(this.nTrHeatGain));
        this.tfIHeatThrottleRange.setLimitCheck((int)this.nCoolHeatKpMin, (int)this.nCoolHeatKpMax, "Heat Throttling Range");
        this.tfIHeatIntegral.setText(String.valueOf(this.nIntHeatGain));
        this.tfIHeatIntegral.setLimitCheck(0, 5000, "Heat Integral Action");
        this.tfIHeatDerivative.setText(String.valueOf(this.nDerHeatGain));
        this.tfIHeatDerivative.setLimitCheck(0, 255, "Heat Derivative Action");
        this.lblHeatThrottleRangeUnit.setText(string);
        super.reset();
    }

    public void load() throws StepContainerException {
        super.load();
        this.ValidateSetPts();
        boolean bl = false;
        boolean bl2 = false;
        switch (this.objVavConfig.g_nFlowControlType) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                bl = true;
                break;
            }
        }
        if (this.objVavConfig.g_nReheatType == 0 && this.objVavConfig.g_nFanType == 0 || this.objVavConfig.g_nReheatType == 0 && bl) {
            bl2 = true;
        }
        this.tfIxCoolThrottleRange.setEnabled(bl ^ true);
        this.tfIxCoolIntegral.setEnabled(bl ^ true);
        this.tfIxCoolDerivative.setEnabled(bl ^ true);
        this.tfIxHeatThrottleRange.setEnabled(bl2 ^ true);
        this.tfIxHeatIntegral.setEnabled(bl2 ^ true);
        this.tfIxHeatDerivative.setEnabled(bl2 ^ true);
    }

    private final void ValidateSetPts() {
        if ((float)this.nTrCoolGain < this.nCoolHeatKpMin || (float)this.nTrCoolGain > this.nCoolHeatKpMax) {
            this.nTrCoolGain = (int)this.nCoolDefaultKp;
        }
        if ((float)this.nTrHeatGain < this.nCoolHeatKpMin || (float)this.nTrHeatGain > this.nCoolHeatKpMax) {
            this.nTrHeatGain = (int)this.nHeatDefaultKp;
        }
        if (this.nIntCoolGain < 0 || this.nIntCoolGain > 5000) {
            this.nIntCoolGain = 4000;
        }
        if (this.nIntHeatGain < 0 || this.nIntHeatGain > 5000) {
            this.nIntHeatGain = 4000;
        }
        if (this.nDerCoolGain < 0 || this.nDerCoolGain > 255) {
            this.nDerCoolGain = 0;
        }
        if (this.nDerHeatGain < 0 || this.nDerHeatGain > 255) {
            this.nDerHeatGain = 0;
        }
    }

    public void unload() throws StepContainerException {
        super.unload();
        System.out.println("In the unload of the step");
        if (this.tfICoolThrottleRange.isEnabled()) {
            this.tfICoolThrottleRange.validateRange();
        }
        if (this.tfICoolIntegral.isEnabled()) {
            this.tfICoolIntegral.validateRange();
        }
        if (this.tfICoolDerivative.isEnabled()) {
            this.tfICoolDerivative.validateRange();
        }
        if (this.tfIHeatThrottleRange.isEnabled()) {
            this.tfIHeatThrottleRange.validateRange();
        }
        if (this.tfIHeatIntegral.isEnabled()) {
            this.tfIHeatIntegral.validateRange();
        }
        if (this.tfIHeatDerivative.isEnabled()) {
            this.tfIHeatDerivative.validateRange();
        }
    }

    public void save() throws Exception {
        super.save();
        this.WriteDataToDatabase();
    }

    private final void WriteDataToDatabase() {
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bCPnciAux2Setpt);
        BVavContainer.g_NVUtil.setInNative("ubTrCoolS2", Integer.parseInt(this.tfICoolThrottleRange.getText()), BVavContainer.nUnitConversion);
        BVavContainer.g_NVUtil.setInNative("siItCoolS0", Integer.parseInt(this.tfICoolIntegral.getText()), 0);
        BVavContainer.g_NVUtil.setInNative("ubDtCoolS0", Integer.parseInt(this.tfICoolDerivative.getText()), 0);
        BVavContainer.g_NVUtil.setInNative("ubTrHeatS2", Integer.parseInt(this.tfIHeatThrottleRange.getText()), BVavContainer.nUnitConversion);
        BVavContainer.g_NVUtil.setInNative("siItHeatS0", Integer.parseInt(this.tfIHeatIntegral.getText()), 0);
        BVavContainer.g_NVUtil.setInNative("ubDtHeatS0", Integer.parseInt(this.tfIHeatDerivative.getText()), 0);
    }

    private final void ReadDataFromDatabase() {
        this.bCPnciAux2Setpt = (BConfigParameter)this.device.get("Aux2SetPt");
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bCPnciAux2Setpt);
        this.nTrCoolGain = Math.round(Float.parseFloat(BVavContainer.g_NVUtil.getValue("ubTrCoolS2", BVavContainer.nUnitConversion)));
        this.nIntCoolGain = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("siItCoolS0", BVavContainer.nUnitConversion));
        this.nDerCoolGain = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("ubDtCoolS0", BVavContainer.nUnitConversion));
        this.nTrHeatGain = Math.round(Float.parseFloat(BVavContainer.g_NVUtil.getValue("ubTrHeatS2", BVavContainer.nUnitConversion)));
        this.nIntHeatGain = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("siItHeatS0", BVavContainer.nUnitConversion));
        System.out.println("Heat Integral" + this.nIntHeatGain);
        this.nDerHeatGain = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("ubDtHeatS0", BVavContainer.nUnitConversion));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BVavPID() {
        System.out.println("BVavPID constructor");
        lex = this.getLexicon();
    }

    static {
        Class clazz = class$com$honeywell$londevices$axwizard$ui$VAV$BVavPID;
        if (clazz == null) {
            clazz = class$com$honeywell$londevices$axwizard$ui$VAV$BVavPID = BVavPID.class("[Lcom.honeywell.londevices.axwizard.ui.VAV.BVavPID;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

