/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.londevices.axwizard.ui.VAV;

import com.honeywell.framework.dragdrop.BAXSubscriber;
import com.honeywell.londevices.axwizard.ui.VAV.BVavContainer;
import com.honeywell.londevices.utilities.BAXUtil;
import com.honeywell.londevices.utilities.BGridPaneEx;
import com.honeywell.londevices.utilities.BIntegerTextField;
import com.honeywell.londevices.xl10controller.VAV.BExcel10VAV;
import com.tridium.sys.Nre;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.WbMain;
import java.util.Timer;
import java.util.TimerTask;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.workbench.BWbShell;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVavAirBalanceDlg
extends BDialog {
    public static final Type TYPE;
    public static final int NO_CALIBRATE = 0;
    public static final int CALIBRATE = 1;
    public static final int FLOATINGOUTOFSYNCH = 14;
    public static final int STARTUPWAIT = 0;
    public static final int MODE_HEAT = 1;
    public static final int MODE_COOL = 2;
    public static final int REHEAT = 3;
    public static final int MORNWARM = 4;
    public static final int NIGHTPURGE = 5;
    public static final int PRESSURIZE = 6;
    public static final int DEPRESSURIZE = 7;
    public static final int TRACKFLOW = 8;
    public static final int MANUALPOS = 9;
    public static final int MANUALFLOW = 10;
    public static final int FREEZEPROTECT = 11;
    public static final int FACTORYTEST = 12;
    public static final int IOTEST = 13;
    public static final int FLOATINGOUTSYNC = 14;
    public static final int DISABLED = 15;
    public static final int MANUAL = 16;
    public static final int ALL_DISABLE = 5;
    public static final int MAX_MIN_DISABLE = 0;
    public static final int MIN_DISABLE = 3;
    public static final int NO_DISABLE = 4;
    public static final int NO_CALIB_DONE = 0;
    public static final int ZERO_CALIB_DONE = 1;
    public static final int MAX_CALIB_DONE = 2;
    public static final int MAX_SELECTED = 0;
    public static final int MIN_SELECTED = 1;
    public static final int ZERO_SELECTED = 2;
    public static final int SETPT_SELECTED = 3;
    public static final int RESET_SELECTED = 4;
    public static final int CLOSE_MODE = 5;
    public static final int OFF_MODE = 0;
    public static final int FLOW_VALUE_MODE = 2;
    public static final int SET_MODE_ONLY_ACTION = 0;
    public static final int SET_MODE_AND_FLOW_ACTION = 1;
    public static final int MINIMUM_CAL_TIME = 25;
    public static float FACT_F2_M2;
    public static float FACT_FPM_MPS;
    public static float FACT_LPS_FT3PM;
    public static BAXUtil bAXUtil;
    BEdgePane content;
    BRadioButton bRadioMax;
    BRadioButton bRadioMin;
    BRadioButton bRadioZero;
    BRadioButton bRadioSetpt;
    BRadioButton bRadioReset;
    boolean bIdleTimerTaskOn;
    boolean bRebootTimerTaskOn;
    boolean bActionBasedTimerTaskOn;
    Timer objCommonTimer;
    int nFlowCalType;
    BIdleTimerTask bIdleTimerTask;
    BRebootTimerTask bRebootTimerTask;
    BActionBasedTimerTask bActionBasedTimerTask;
    BMaxTypeCommand bMax;
    BMinTypeCommand bMin;
    BZeroTypeCommand bZero;
    BSetptTypeCommand bSetpoint;
    BResetTypeCommand bReset;
    BNetworkVariable nvoData;
    BNetworkVariable nviManOverride;
    BNetworkVariable nvoIO;
    BNetworkVariable nviManualMode;
    BConfigParameter nciFld3PtCal;
    BConfigParameter nciMaxFlow;
    BConfigParameter nciMinFlow;
    BConfigParameter nciConfig;
    BConfigParameter nciFlowVoltOffset;
    BExcel10VAV bObjVav;
    BIntegerTextField bIEdit1;
    BIntegerTextField bIEdit2;
    BIntegerTextField bIEdit3;
    BIntegerTextField bIEdit4;
    BIntegerTextField bIEdit5;
    BIntegerTextField[] bITmpEdit;
    BLabel[] bITmpStatic;
    BLabel[] bITmpUnit;
    BLabel bLUnit1;
    BLabel bLStatic1;
    BLabel bLUnit2;
    BLabel bLStatic2;
    BLabel bLUnit3;
    BLabel bLStatic3;
    BLabel bLUnit4;
    BLabel bLStatic4;
    BLabel bLUnit5;
    BLabel bLStatic5;
    BButton bBCalibrateStatusBtn;
    BButton bBStartStopBtn;
    BButton bBHelpBtn;
    BButton butClose;
    BTextEditorPane bStatusText;
    BVavContainer bVavContainer;
    long pFlowOffsetVal1;
    long pFlowOffsetVal2;
    boolean bCalComplete;
    float fCorrFlowAverageTemp;
    float fUnCorrFlowAverageTemp;
    float fCorrFlowAverage;
    float fUnCorrFlowAverage;
    float fDuctArea;
    float fStableFlow;
    float fHysFlow;
    int nStableCount;
    int nCounter;
    int nMinOrMaxFlow;
    int nDamperSpeed;
    int nButtonState;
    int nMaxFlow;
    int nMinFlow;
    int[] nDamperDrive;
    int nMaxAct;
    int nMaxAppr;
    int nMinAct;
    int nMinAppr;
    int nZeroAct;
    int nZeroAppr;
    int nDamperPos;
    int nNvoDataMode;
    int nNvoDataMode1;
    int nManOverrideState;
    int nValue1;
    int nValue2;
    int nValue3;
    int nValue4;
    int nElapsedTime;
    int nZeroCalibFlag;
    int nUnitConversion;
    int nFldPtCal1;
    int nFldPtCal2;
    BLonComponent[] compArray;
    String[] compNameArray;
    String strPrev;
    static /* synthetic */ Class class$com$honeywell$londevices$axwizard$ui$VAV$BVavAirBalanceDlg;

    public Type getType() {
        return TYPE;
    }

    public void doInitialSetup() {
        this.objCommonTimer = new Timer();
        this.bIdleTimerTask = new BIdleTimerTask();
        if (this.readNvoDataMode()) {
            if (this.nNvoDataMode == 14) {
                System.out.println("Controller is in floatingoutofsynch mode ");
                this.enableDisableOptions(false);
                this.enableDisableControls(5);
                this.bRebootTimerTaskOn = true;
                this.bRebootTimerTaskOn = true;
                this.bRebootTimerTask = new BRebootTimerTask();
                this.objCommonTimer.scheduleAtFixedRate((TimerTask)this.bRebootTimerTask, 0L, 1500L);
            } else {
                System.out.println("InitialSetup - mode is not floatingoutofsynch");
                this.bSetpoint.setSelected(true);
                System.out.println("After selecting setpt");
                this.nZeroCalibFlag = this.readVavMiscZeroCalibFlag();
                System.out.println("VavMiscZeroCalibFlag = " + this.nZeroCalibFlag);
                switch (this.nZeroCalibFlag) {
                    case 0: {
                        this.enableDisableControls(0);
                        break;
                    }
                    case 1: {
                        this.enableDisableControls(3);
                        break;
                    }
                    case 2: {
                        this.enableDisableControls(4);
                        break;
                    }
                }
            }
        } else {
            this.updateTheStatusWindow("Communication error: Controller is not responding.");
            return;
        }
    }

    private final boolean readNvoDataMode() {
        ((BLonComponent)this.bObjVav.get("nvoData")).lease();
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("nvoData"));
        this.nNvoDataMode = BVavContainer.g_NVUtil.getEnum("Mode").getOrdinal();
        return true;
    }

    private final boolean readNvoCtlDataG() {
        ((BLonComponent)this.bObjVav.get("nvoData")).lease();
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("nvoData"));
        this.nValue1 = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("uiBoxFlowControlPtS0", this.nUnitConversion));
        this.nValue2 = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("uiBoxFlowS0", this.nUnitConversion));
        this.nDamperPos = this.nValue4 = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("ubDamperPosS1", this.nUnitConversion));
        return true;
    }

    private final boolean updateValuesToControls() {
        this.bIEdit1.setText(String.valueOf(this.nValue1));
        this.bIEdit2.setText(String.valueOf(this.nValue2));
        this.bIEdit3.setText(String.valueOf(this.nValue3));
        this.bIEdit4.setText(String.valueOf(this.nDamperPos));
        this.bIEdit5.setText(String.valueOf(this.nElapsedTime));
        return true;
    }

    private final void enableDisableOptions(boolean bl) {
        this.bRadioMax.setEnabled(bl);
        this.bRadioMin.setEnabled(bl);
        this.bRadioZero.setEnabled(bl);
        this.bRadioSetpt.setEnabled(bl);
        this.bRadioReset.setEnabled(bl);
    }

    private final void enableDisableControls(int n) {
        switch (n) {
            case 0: {
                this.bRadioMax.setEnabled(false);
                this.bRadioMin.setEnabled(false);
                break;
            }
            case 3: {
                this.bRadioMax.setEnabled(true);
                this.bRadioMin.setEnabled(false);
                this.bRadioZero.setEnabled(true);
                this.bRadioSetpt.setEnabled(true);
                this.bRadioReset.setEnabled(true);
                break;
            }
            case 4: {
                this.bRadioMax.setEnabled(true);
                this.bRadioMin.setEnabled(true);
                this.bRadioZero.setEnabled(true);
                this.bRadioSetpt.setEnabled(true);
                this.bRadioReset.setEnabled(true);
                break;
            }
            case 5: {
                this.bRadioMax.setEnabled(false);
                this.bRadioMin.setEnabled(false);
                this.bRadioZero.setEnabled(false);
                this.bRadioSetpt.setEnabled(false);
                this.bRadioReset.setEnabled(false);
                break;
            }
        }
    }

    private final void updateTheStatusWindow(String string) {
        if (this.strPrev == string) {
            return;
        }
        this.strPrev = string;
        String string2 = this.bStatusText.getText();
        string = string + '\n';
        string = string + string2;
        this.bStatusText.setText(string);
    }

    private final BEdgePane buildDialog() {
        this.content = new BEdgePane(null, null, null, null, (BWidget)new BBorderPane((BWidget)this.createMiddlePane(), BBorder.solid));
        return this.content;
    }

    public void close() {
        if (this.bActionBasedTimerTaskOn) {
            BDialog.message(null, (Object)"Calibration in progress.Stop calibration and close the window.");
            return;
        }
        this.cancelTimerTask(this.bIdleTimerTask);
        this.cancelTimerTask(this.bRebootTimerTask);
        super.close();
    }

    private final BActionBasedTimerTask startTimerTask(int n) {
        BActionBasedTimerTask bActionBasedTimerTask = new BActionBasedTimerTask();
        this.objCommonTimer.scheduleAtFixedRate((TimerTask)bActionBasedTimerTask, 0L, (long)n);
        return bActionBasedTimerTask;
    }

    private final BIdleTimerTask startIdleTimerTask(int n) {
        BIdleTimerTask bIdleTimerTask = new BIdleTimerTask();
        return bIdleTimerTask;
    }

    private final BRebootTimerTask startRebootTimerTask(int n) {
        BRebootTimerTask bRebootTimerTask = new BRebootTimerTask();
        this.objCommonTimer.scheduleAtFixedRate((TimerTask)bRebootTimerTask, 0L, (long)n);
        return bRebootTimerTask;
    }

    public void cancelTimerTask(TimerTask timerTask) {
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        if (this.bActionBasedTimerTaskOn) {
            BDialog.message(null, (Object)"Calibration in progress.Stop calibration and close the window.");
            return;
        }
        this.cancelTimerTask(this.bIdleTimerTask);
        this.cancelTimerTask(this.bRebootTimerTask);
        super.windowClosing(bWindowEvent);
        this.close();
    }

    private final int readVavMiscZeroCalibFlag() {
        this.nZeroCalibFlag = ((BInteger)this.bObjVav.get("nZeroCalibFlag")).getInt();
        return this.nZeroCalibFlag;
    }

    private final void writeVavMiscZeroCalibFlag(int n) {
        this.bObjVav.set("nZeroCalibFlag", (BValue)BInteger.make((int)n));
    }

    private final void abortZeroCalibration() {
        this.cancelTimerTask(this.bActionBasedTimerTask);
        this.updateTheStatusWindow("Zero Calibration Aborted");
        this.bActionBasedTimerTaskOn = false;
        this.enableDisableOptions(true);
        this.changeBtnText(this.bBStartStopBtn, "Start");
        this.enableDisableControls(0);
    }

    private final void readNciFldPtCal(int n) {
        String string = "";
        String string2 = "";
        switch (n) {
            case 0: {
                string = "siCalActualLoS3";
                string2 = "siCalApparentLoS3";
                break;
            }
            case 1: {
                string = "siCalActualMidS3";
                string2 = "siCalApparentMidS3";
                break;
            }
            case 2: {
                string = "siCalActualHiS3";
                string2 = "siCalApparentHiS3";
                break;
            }
        }
        this.bObjVav.invoke(BExcel10VAV.readCPFromDeviceAndUpdateDB, (BValue)BString.make((String)"Fld3PtCal"), null);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("Fld3PtCal"));
        BVavContainer.g_NVUtil.networkConfig.lease(1);
        this.nFldPtCal1 = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue(string, 0));
        this.nFldPtCal2 = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue(string2, 0));
        if (this.nUnitConversion == 1) {
            this.nFldPtCal1 = (int)((float)this.nFldPtCal1 * FACT_FPM_MPS);
            this.nFldPtCal2 = (int)((float)this.nFldPtCal2 * FACT_FPM_MPS);
        }
    }

    private final void writeNciFldPtCal(int n, int n2, int n3) {
        String string = "";
        String string2 = "";
        switch (n) {
            case 0: {
                string = "siCalActualLoS3";
                string2 = "siCalApparentLoS3";
                break;
            }
            case 1: {
                string = "siCalActualMidS3";
                string2 = "siCalApparentMidS3";
                break;
            }
            case 2: {
                string = "siCalActualHiS3";
                string2 = "siCalApparentHiS3";
                break;
            }
        }
        this.bObjVav.invoke(BExcel10VAV.readCPFromDeviceAndUpdateDB, (BValue)BString.make((String)"Fld3PtCal"), null);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("Fld3PtCal"));
        BVavContainer.g_NVUtil.networkConfig.lease(1);
        if (this.nUnitConversion == 1) {
            n2 = (int)((float)n2 / FACT_FPM_MPS);
            n3 = (int)((float)n3 / FACT_FPM_MPS);
        }
        BVavContainer.g_NVUtil.setInNative(string, (float)n2, 0, true);
        BVavContainer.g_NVUtil.setInNative(string2, (float)n3, 0, true);
        System.out.println("WriteNciFld3PtCal - nActual = " + n2 + "nApparent = " + n3);
    }

    private final void updateNciFldPtCalAndValidate() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        this.readNvoCtlDataG();
        this.nValue2 = 0;
        this.updateValuesToControls();
        this.cancelTimerTask(this.bActionBasedTimerTask);
        this.bActionBasedTimerTaskOn = false;
        this.readNciFldPtCal(1);
        this.nMinAct = this.nFldPtCal1;
        this.nMinAppr = this.nFldPtCal2;
        this.writeNciFldPtCal(1, this.nMinAct + 1, this.nMinAppr);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
        this.pFlowOffsetVal1 = this.readNciFlowVoltOffset();
        this.writeNciFldPtCal(1, this.nMinAct, this.nMinAppr);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
        this.pFlowOffsetVal2 = this.readNciFlowVoltOffset();
        this.enableDisableOptions(true);
        if ((double)Math.abs(this.pFlowOffsetVal2 - this.pFlowOffsetVal1) <= 0.003) {
            this.updateTheStatusWindow("Zero Calibration Complete.");
            this.writeVavMiscZeroCalibFlag(1);
            this.enableDisableControls(3);
            this.terminateCalibration();
        } else {
            this.updateTheStatusWindow("Unstable air flow.Please verify proper mechanical installation of VAV box and recalibrate.");
            this.changeManualOverride(0, 0, -1);
            this.enableDisableControls(0);
            this.terminateCalibration();
        }
        this.changeBtnText(this.bBStartStopBtn, "Start");
    }

    private final void HandleZeroFlowSelection() {
        this.readNvoCtlDataG();
        this.nValue3 = this.nValue2;
        this.updateValuesToControls();
        if (!this.readNvoDataMode()) {
            this.abortZeroCalibration();
        } else if (this.nNvoDataMode != 9) {
            this.abortZeroCalibration();
            this.terminateCalibration();
        } else {
            this.readNvoCtlDataG();
            if (this.nDamperPos != 0) {
                if (this.nElapsedTime <= 0) {
                    this.abortZeroCalibration();
                    this.terminateCalibration();
                } else {
                    --this.nElapsedTime;
                    this.bIEdit5.setText(String.valueOf(this.nElapsedTime));
                    this.updateValuesToControls();
                    this.updateTheStatusWindow("Zeroing controller.Please wait...");
                }
            } else if (this.nElapsedTime <= 0) {
                this.updateNciFldPtCalAndValidate();
            } else {
                --this.nElapsedTime;
                this.bIEdit5.setText(String.valueOf(this.nElapsedTime));
                this.updateTheStatusWindow("Zeroing controller.Please wait...");
            }
        }
    }

    private final float getDuctArea() {
        this.bObjVav.invoke(BExcel10VAV.readCPFromDeviceAndUpdateDB, (BValue)BString.make((String)"DuctArea"), null);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("DuctArea"));
        BVavContainer.g_NVUtil.networkConfig.lease(1);
        this.fDuctArea = Float.parseFloat(BVavContainer.g_NVUtil.getValue("ductArea", 0));
        if (this.nUnitConversion == 2) {
            this.fDuctArea /= FACT_F2_M2;
        }
        return this.fDuctArea;
    }

    private final void HandleTimer(int n) {
        float f = 0.0f;
        int n2 = 10;
        if (this.nUnitConversion == 2) {
            n2 = (int)((float)n2 * 2.1186f);
        }
        if (this.nButtonState == 1) {
            this.readNvoCtlDataG();
            --this.nElapsedTime;
            this.bIEdit1.setText(String.valueOf(this.nValue1));
            this.bIEdit2.setText(String.valueOf(this.nValue2));
            this.bIEdit4.setText(String.valueOf(this.nDamperPos));
            this.bIEdit5.setText(String.valueOf(this.nElapsedTime));
            return;
        }
        this.readNvoCtlDataG();
        this.nValue3 = this.nValue2;
        this.updateValuesToControls();
        float f2 = (float)this.nValue2 / this.fDuctArea;
        if (this.nUnitConversion == 1) {
            f2 = (float)((double)f2 * 0.001);
        }
        f = f2 < this.fHysFlow ? this.fHysFlow : f2;
        this.getAverageFlowFromNvoIo();
        this.fCorrFlowAverageTemp = this.fCorrFlowAverageTemp * 0.8f + this.fCorrFlowAverage * 0.2f;
        this.fUnCorrFlowAverageTemp = this.fUnCorrFlowAverageTemp * 0.8f + this.fUnCorrFlowAverage * 0.2f;
        if (this.nStableCount > 10 && this.nCounter > 10 || this.bCalComplete) {
            this.updateTheStatusWindow("Stable flow reached. Enter value for calibration.");
            this.bIEdit3.setEnabled(true);
            this.changeBtnText(this.bBStartStopBtn, "Stop");
            this.enableButton(this.bBCalibrateStatusBtn, true);
            this.nButtonState = 1;
            this.enableDisableOptions(false);
        } else if (Math.abs(this.nValue2 - this.nMinOrMaxFlow) < n2) {
            ++this.nCounter;
        }
        this.nStableCount = Math.abs(f2 - this.fCorrFlowAverage) <= f ? ++this.nStableCount : 0;
        if ((double)(this.nDamperSpeed - this.nElapsedTime) > 1.5 * (double)this.nDamperSpeed) {
            this.cancelTimerTask(this.bActionBasedTimerTask);
            this.cancelTimerTask(this.bIdleTimerTask);
            this.bActionBasedTimerTaskOn = false;
            this.bIdleTimerTaskOn = false;
            if (BDialog.confirm(null, (Object)"Stable air flow or flow setpoint cannot be obtained! Continue calibration?") == 4) {
                this.updateTheStatusWindow("Stable flow not reached. Enter value for calibration.");
                this.bIEdit3.setEnabled(true);
                this.changeBtnText(this.bBStartStopBtn, "Stop");
                this.enableButton(this.bBCalibrateStatusBtn, true);
                this.nButtonState = 1;
                this.enableDisableOptions(false);
                this.bCalComplete = true;
                this.bActionBasedTimerTask = this.startTimerTask(1000);
                this.bIdleTimerTask = this.startIdleTimerTask(1500);
                this.bActionBasedTimerTaskOn = true;
                this.bIdleTimerTaskOn = true;
            } else {
                this.updateTheStatusWindow("Calibration Complete, Values unchanged.");
                this.changeManualOverride(0, 0, -1);
                this.bIEdit3.setEnabled(false);
                this.changeBtnText(this.bBStartStopBtn, "Start");
                this.enableDisableOptions(true);
                if (n == 0) {
                    this.enableDisableControls(3);
                } else if (n == 1) {
                    this.enableDisableControls(4);
                }
                this.nButtonState = 0;
            }
        }
        --this.nElapsedTime;
        this.bIEdit5.setText(String.valueOf(this.nElapsedTime));
    }

    private final void changeBtnText(BButton bButton, String string) {
        bButton.setText(string);
    }

    private final void enableButton(BButton bButton, boolean bl) {
        bButton.setEnabled(bl);
    }

    private final void stopCalibrationAndUpdateBtnStatus() {
        System.out.println("In stopCalibrationAndUpdateBtnStatus");
        this.changeBtnText(this.bBStartStopBtn, "Start");
        this.enableButton(this.bBCalibrateStatusBtn, false);
        switch (this.nFlowCalType) {
            case 0: {
                this.updateTheStatusWindow("Maximum calibration terminated, values unchanged.");
                this.enableDisableOptions(true);
                this.bIEdit3.setEnabled(false);
                this.enableDisableControls(3);
                break;
            }
            case 1: {
                this.updateTheStatusWindow("Minimum calibration terminated, values unchanged.");
                this.bIEdit3.setEnabled(false);
                this.enableDisableControls(4);
                break;
            }
        }
        if (this.bActionBasedTimerTaskOn) {
            this.cancelTimerTask(this.bActionBasedTimerTask);
            this.bActionBasedTimerTaskOn = false;
        }
        this.nButtonState = 0;
        this.terminateCalibration();
    }

    private final void doZeroCalibration() {
        System.out.println("In doZeroCalibration");
        if (this.bActionBasedTimerTaskOn) {
            System.out.println("Calibration is on and the user pressed Stop");
            this.cancelTimerTask(this.bActionBasedTimerTask);
            this.bActionBasedTimerTaskOn = false;
            this.changeBtnText(this.bBStartStopBtn, "Start");
            this.updateTheStatusWindow("Zero Calibration Aborted.");
            this.writeVavMiscZeroCalibFlag(0);
            this.enableDisableOptions(true);
            this.enableDisableControls(0);
            this.terminateCalibration();
        } else {
            System.out.println("No action based timer is on now");
            this.changeBtnText(this.bBStartStopBtn, "Stop");
            this.enableDisableOptions(false);
            if (!this.NvoDataModeCheck()) {
                this.updateTheStatusWindow("Invalid Mode.Aborting zero calibration.");
                this.changeBtnText(this.bBStartStopBtn, "Start");
                this.enableDisableOptions(true);
                this.enableDisableControls(0);
            } else {
                System.out.println("In doZeroCalibration trying to change the manual override");
                this.changeManualOverride(0, 5, -1);
                try {
                    System.out.println("In doZeroCalibration sleep for 2 secs");
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                if (this.readNvoDataMode()) {
                    System.out.println("In doZeroCalibration successfully read nvoData and the mode is " + this.getModeString());
                    if (this.nNvoDataMode != 9) {
                        String string = "Controller is " + this.getModeString() + "mode.Unable to put the controller in Manual position mode.Calibration terminated";
                        this.updateTheStatusWindow(string);
                        this.changeBtnText(this.bBStartStopBtn, "Start");
                        this.enableButton(this.bBStartStopBtn, true);
                        this.enableDisableOptions(true);
                        this.enableDisableControls(0);
                        this.terminateCalibration();
                    } else {
                        this.nDamperSpeed = this.getDamperSpeed();
                        this.nDamperSpeed = (int)((double)(this.nDamperSpeed * this.nDamperPos) * 1.25) / 100;
                        System.out.println("In doZeroCalibration - DamperSpeed is " + this.nDamperSpeed + " Damper Pos is " + this.nDamperPos);
                        this.bActionBasedTimerTask = this.startTimerTask(1000);
                        this.nElapsedTime = this.nDamperSpeed + 8;
                        this.bIEdit5.setText(String.valueOf(this.nElapsedTime));
                        this.nCounter = 0;
                        this.bActionBasedTimerTaskOn = true;
                    }
                }
            }
        }
    }

    private final void handleSetptSelection() {
        this.nValue1 = Integer.parseInt(this.bIEdit1.getText());
        this.nValue2 = Integer.parseInt(this.bIEdit2.getText());
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("MaxFlow"));
        BVavContainer.g_NVUtil.networkConfig.lease(1, 1000L);
        BVavContainer.g_NVUtil.setInNative("maxFlow", (float)this.nValue1, this.nUnitConversion, true);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("MinFlow"));
        BVavContainer.g_NVUtil.networkConfig.lease(1, 1000L);
        BVavContainer.g_NVUtil.setInNative("minFlow", (float)this.nValue2, this.nUnitConversion, true);
        System.out.println("nValue1 = " + this.nValue1 + "nValue2 = " + this.nValue2);
        this.updateTheStatusWindow("Setpoint configured successfully");
    }

    private final void initiateCalibration(int n) {
        int n2 = 3500;
        int n3 = 1000;
        if (this.nUnitConversion == 1) {
            n2 = (int)((float)n2 * FACT_FPM_MPS);
            n3 = (int)((float)n3 * FACT_FPM_MPS);
        }
        if (this.bActionBasedTimerTaskOn) {
            if (this.nButtonState == 1) {
                this.calibrateForFlowType(n);
            } else {
                if (n == 0) {
                    System.out.println("In initiateCalibration - Max Flow Type");
                    this.updateTheStatusWindow("Maximum calibration terminated, values unchanged.");
                    this.bIEdit3.setEnabled(false);
                    this.enableDisableControls(3);
                } else if (n == 1) {
                    this.updateTheStatusWindow("Minimum calibration terminated, values unchanged.");
                    this.bIEdit3.setEnabled(false);
                    this.enableDisableControls(4);
                }
                this.terminateCalibration();
            }
            this.cancelTimerTask(this.bActionBasedTimerTask);
            this.changeBtnText(this.bBStartStopBtn, "Start");
            this.enableButton(this.bBCalibrateStatusBtn, false);
            this.bActionBasedTimerTaskOn = false;
        } else {
            this.startTimerToSeekStableFlow(n);
        }
    }

    private final void calibrateForMaxFlowType() {
        int n = 3500;
        int n2 = 1000;
        if (this.nUnitConversion == 1) {
            n = (int)((float)n * FACT_FPM_MPS);
            n2 = (int)((float)n2 * FACT_FPM_MPS);
        }
        this.nValue3 = Integer.parseInt(this.bIEdit3.getText());
        float f = (float)this.nValue3 / this.fDuctArea;
        System.out.println("In CalibrateForMaxFlowType - nMax_Flow = " + n + " nActAppDef = " + n2 + " nValue3 = " + this.nValue3);
        System.out.println("In CalibrateForMaxFlowType = Duct Area = " + this.fDuctArea + "fCurrentFlow = " + f);
        if (this.nUnitConversion == 1) {
            f = (float)((double)f * 0.001);
        }
        System.out.println("calibrateForMaxFlowType - FCurrentFlow = " + f);
        if (f > (float)n || this.fUnCorrFlowAverage > (float)n) {
            if (BDialog.confirm(null, (Object)"Maximum Calibration has failed, Calibration velocities exceed high limits. Try Again? See status window for details") == 4) {
                if (f > (float)n) {
                    this.updateTheStatusWindow("Entered flow is exceeding Maximum flow. Please enter low value for Flow.");
                }
                if (this.fUnCorrFlowAverage > (float)n) {
                    this.updateTheStatusWindow("Uncorrected Flow Average in the Controller is more than the maximum flow. Please try calibration after sometime.");
                }
                return;
            }
            System.out.println("In calibrateForMaxFlowType, Maximum calibration terminated, values unchanged");
            this.updateTheStatusWindow("Maximum calibration terminated, values unchanged.");
            this.bIEdit3.setEnabled(false);
            this.enableDisableControls(3);
        } else {
            this.nMaxAct = (int)f;
            this.nMaxAppr = (int)this.fUnCorrFlowAverage;
            if (this.nMaxAct <= this.nMinAct || this.nMaxAppr <= this.nMinAppr) {
                this.nMinAct = (int)f / 2;
                this.nMinAppr = (int)this.fUnCorrFlowAverage / 2;
                BDialog.message(null, (Object)"Minimum air flow calibration was adjusted in reponse to Maximum Air Flow calibration now.");
            }
            System.out.println("In calibrateForMaxFlowType - nMaxAct =" + this.nMaxAct + " nMaxAppr = " + this.nMaxAppr + " nMinAct = " + this.nMinAct + " nMinAppr = " + this.nMinAppr);
            if (!this.Check3PointCalibrationValues(this.nMaxAct, this.nMaxAppr, this.nMinAct, this.nMinAppr)) {
                BDialog.message(null, (Object)"Unable to update the actual and apparent flow values into EEPROM.");
                this.updateTheStatusWindow("Unable to perform the field correction. Please check the measured flow. Calibration terminated.");
                System.out.println("In calibrateForMaxFlowType - Maximum calibration terminated, values unchanged");
                this.updateTheStatusWindow("Maximum calibration terminated, values unchanged.");
                this.bIEdit3.setEnabled(false);
                this.enableDisableControls(3);
            } else {
                this.writeNciFldPtCal(2, this.nMaxAct, this.nMaxAppr);
                this.writeNciFldPtCal(1, this.nMinAct, this.nMinAppr);
                this.terminateCalibration();
                this.updateTheStatusWindow("Maximum calibration completed.");
                this.writeVavMiscZeroCalibFlag(2);
                this.enableDisableControls(4);
            }
        }
    }

    private final void calibrateForMinFlowType() {
        int n = 3500;
        int n2 = 1000;
        if (this.nUnitConversion == 1) {
            n = (int)((float)n * FACT_FPM_MPS);
            n2 = (int)((float)n2 * FACT_FPM_MPS);
        }
        this.nValue3 = Integer.parseInt(this.bIEdit3.getText());
        float f = (float)this.nValue3 / this.fDuctArea;
        if (this.nUnitConversion == 1) {
            f = (float)((double)f * 0.001);
        }
        this.nMinAct = (int)f;
        this.nMinAppr = (int)this.fUnCorrFlowAverage;
        if (this.nMinAct <= this.nZeroAct || this.nMinAppr <= this.nZeroAppr || this.nMinAct >= this.nMaxAct || this.nMinAppr >= this.nMaxAppr) {
            if (BDialog.confirm(null, (Object)"Minimum Calibration has failed, balance values exceed limits. Try Again? See status window for details") == 4) {
                if (f >= (float)this.nMaxAct) {
                    this.updateTheStatusWindow("Entered flow is exceeding Maximum flow. Please enter low value for Flow.");
                }
                if (this.fUnCorrFlowAverage >= (float)this.nMaxAppr) {
                    this.updateTheStatusWindow("Uncorrected Flow Average in the Controller is more than the maximum flow. Please try calibration after sometime.");
                }
                if (f <= (float)this.nZeroAct) {
                    this.updateTheStatusWindow("Entered flow is less than minimum flow. Please enter a higher value for Flow.");
                }
                if (this.fUnCorrFlowAverage >= (float)n) {
                    this.updateTheStatusWindow("Uncorrected Flow Average in the Controller is more than the maximum flow. Please try calibration after sometime.");
                }
                if (this.fUnCorrFlowAverage <= (float)this.nZeroAppr) {
                    this.updateTheStatusWindow("Uncorrected Flow Average in the Controller is less than the minimum flow. Please try calibration after sometime.");
                }
                return;
            }
            this.updateTheStatusWindow("Minimum calibration terminated, values unchanged.");
            this.bIEdit3.setEnabled(false);
            this.enableDisableControls(4);
        } else {
            if (this.fUnCorrFlowAverage > (float)n2 || f > (float)n2) {
                if (this.fUnCorrFlowAverage > f) {
                    this.nMinAct = (int)((float)n2 - this.fUnCorrFlowAverage + f);
                    this.nMinAppr = n2;
                } else {
                    this.nMinAct = n2;
                    this.nMinAppr = (int)((float)n2 - f + this.fUnCorrFlowAverage);
                }
            } else {
                this.nMinAct = (int)f;
                this.nMinAppr = (int)this.fUnCorrFlowAverage;
            }
            if (!this.Check3PointCalibrationValues(this.nMaxAct, this.nMaxAppr, this.nMinAct, this.nMinAppr)) {
                BDialog.message(null, (String)"Unable to update the actual and apparent flow values into EEPROM.", (Object)BDialog.ERROR_ICON);
                this.updateTheStatusWindow("Unable to perform the field correction. Please check the measured flow. Calibration terminated.");
                this.updateTheStatusWindow("Minimum calibration terminated, values unchanged.");
                this.bIEdit3.setEnabled(false);
                this.enableDisableControls(4);
            } else {
                this.writeNciFldPtCal(1, this.nMinAct, this.nMinAppr);
                this.terminateCalibration();
                this.updateTheStatusWindow("Minimum calibration completed.");
                this.enableDisableControls(4);
            }
        }
    }

    private final void calibrateForFlowType(int n) {
        if (n == 0) {
            this.readNciFldPtCal(1);
            this.nMinAct = this.nFldPtCal1;
            this.nMinAppr = this.nFldPtCal2;
            this.readNciFldPtCal(2);
            this.nMaxAct = this.nFldPtCal1;
            this.nMaxAppr = this.nFldPtCal2;
        }
        if (1 == n) {
            this.readNciFldPtCal(0);
            this.nZeroAct = this.nFldPtCal1;
            this.nZeroAppr = this.nFldPtCal2;
            this.readNciFldPtCal(2);
            this.nMaxAct = this.nFldPtCal1;
            this.nMaxAppr = this.nFldPtCal2;
        }
        this.getAverageFlowFromNvoIo();
        switch (this.nFlowCalType) {
            case 0: {
                this.calibrateForMaxFlowType();
                break;
            }
            case 1: {
                this.calibrateForMinFlowType();
                break;
            }
        }
        this.nButtonState = 0;
        this.bIEdit3.setEnabled(false);
    }

    private final boolean getAverageFlowFromNvoIo() {
        ((BLonComponent)this.bObjVav.get("nvoIO")).lease(1);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("nvoIO"));
        this.fCorrFlowAverage = Float.parseFloat(BVavContainer.g_NVUtil.getValue("siFlowSensorS3", 0));
        this.fUnCorrFlowAverage = Float.parseFloat(BVavContainer.g_NVUtil.getValue("siFlowUncorrectedS3", 0));
        if (this.nUnitConversion == 1) {
            this.fCorrFlowAverage *= FACT_FPM_MPS;
            this.fUnCorrFlowAverage *= FACT_FPM_MPS;
        }
        return true;
    }

    private final int getDamperSpeed() {
        this.bObjVav.invoke(BExcel10VAV.readCPFromDeviceAndUpdateDB, (BValue)BString.make((String)"Config"), null);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("Config"));
        BVavContainer.g_NVUtil.networkConfig.lease(1);
        this.nDamperSpeed = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("uiDamperMtrTimeS0", 0));
        System.out.println("In getDamperSpeed - " + this.nDamperSpeed);
        return this.nDamperSpeed;
    }

    private final void startTimerToSeekStableFlow(int n) {
        if (!this.NvoDataModeCheck()) {
            if (n == 0) {
                this.updateTheStatusWindow("Maximum calibration terminated, values unchanged.");
                this.bIEdit3.setEnabled(false);
                this.enableDisableControls(3);
            } else if (n == 1) {
                this.updateTheStatusWindow("Minimum calibration terminated, values unchanged.");
                this.bIEdit3.setEnabled(false);
                this.enableDisableControls(4);
            }
        } else {
            int n2;
            this.enableDisableOptions(false);
            this.changeBtnText(this.bBStartStopBtn, "Stop");
            this.updateTheStatusWindow("Seeking stable flow, please wait.");
            this.readNvoCtlDataG();
            this.nValue3 = this.nValue2;
            this.updateValuesToControls();
            if (n == 0) {
                this.readMaxAndMinFlowFromCtrl();
                this.nMinOrMaxFlow = this.nMaxFlow;
                n2 = this.nMinFlow;
            }
            if (n == 1) {
                this.readMaxAndMinFlowFromCtrl();
                n2 = this.nMaxFlow;
                this.nMinOrMaxFlow = this.nMinFlow;
            }
            this.changeManualOverride(1, 2, this.nMinOrMaxFlow);
            this.nDamperSpeed = this.getDamperSpeed();
            System.out.println("nValue2, nDamperSpeed" + this.nValue2 + this.nDamperSpeed);
            this.nDamperSpeed = this.nValue2 > this.nMinOrMaxFlow ? (int)((double)(this.nDamperSpeed * this.nDamperPos) * 1.25) / 100 : (int)((double)(this.nDamperSpeed * (100 - this.nDamperPos)) * 1.25) / 100;
            if (this.nDamperSpeed < 25) {
                this.nDamperSpeed = 25;
            }
            this.getAverageFlowFromNvoIo();
            this.fCorrFlowAverageTemp = this.fCorrFlowAverage;
            this.fUnCorrFlowAverageTemp = this.fUnCorrFlowAverage;
            this.fHysFlow = this.CalcStableFlowfromDamper();
            System.out.println("In   startTimerToSeekStableFlow CalcStableFlowFromDamper returned HysFlow" + this.fHysFlow);
            this.bActionBasedTimerTask = this.startTimerTask(1000);
            this.nElapsedTime = this.nDamperSpeed;
            this.nCounter = 0;
            this.bActionBasedTimerTaskOn = true;
            this.bCalComplete = false;
            this.nStableCount = 0;
            this.bIEdit5.setText(String.valueOf(this.nElapsedTime));
        }
    }

    private final void readMaxAndMinFlowFromCtrl() {
        if (this.bObjVav == null) {
            System.out.println("Device is null in ReadMinAndMaxFlow");
        }
        System.out.println(this.bObjVav.toString());
        this.bObjVav.invoke(BExcel10VAV.readCPFromDeviceAndUpdateDB, (BValue)BString.make((String)"MaxFlow"), null);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("MaxFlow"));
        BVavContainer.g_NVUtil.networkConfig.lease(1);
        this.nMaxFlow = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("maxFlow", this.nUnitConversion));
        System.out.println("in readMaxAndMinFlowFromCtrl maxFlow is " + this.nMaxFlow);
        this.bObjVav.invoke(BExcel10VAV.readCPFromDeviceAndUpdateDB, (BValue)BString.make((String)"MinFlow"), null);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("MinFlow"));
        BVavContainer.g_NVUtil.networkConfig.lease(1);
        this.nMinFlow = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("minFlow", this.nUnitConversion));
    }

    private final float CalcStableFlowfromDamper() {
        this.bObjVav.invoke(BExcel10VAV.readCPFromDeviceAndUpdateDB, (BValue)BString.make((String)"Aux2SetPt"), null);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("Aux2SetPt"));
        BVavContainer.g_NVUtil.networkConfig.lease(1);
        int n = 0;
        while (n < 10) {
            this.nDamperDrive[n] = (int)Float.parseFloat(BVavContainer.g_NVUtil.getValue("ubDamperDriveS" + n, 0));
            ++n;
        }
        float f = 0.0f;
        int n2 = 0;
        while (n2 < 10) {
            if (this.nDamperDrive[n2] >= 1) break;
            f += 10.0f;
            ++n2;
        }
        if (this.nUnitConversion == 2) {
            f /= FACT_FPM_MPS;
        }
        return f;
    }

    private final boolean Check3PointCalibrationValues(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        return n6 < n3 && n3 < n && n5 < n4 && n4 < n2;
    }

    private final long readNciFlowVoltOffset() {
        this.bObjVav.invoke(BExcel10VAV.readCPFromDeviceAndUpdateDB, (BValue)BString.make((String)"FlowVoltOffsetS12"), null);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("FlowVoltOffsetS12"));
        BVavContainer.g_NVUtil.networkConfig.lease(1);
        long l = (long)Float.parseFloat(BVavContainer.g_NVUtil.getValue("offsetVolts", 0));
        return l;
    }

    private final void terminateCalibration() {
        this.writeNviManOverride();
    }

    private final boolean ReadNviManOverride() {
        ((BLonComponent)this.bObjVav.get("nviManOverride")).lease();
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("nviManOverride"));
        this.nManOverrideState = BVavContainer.g_NVUtil.getEnum("state").getOrdinal();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void writeNviManOverride() {
        ((BLonComponent)this.bObjVav.get("nviManOverride")).lease();
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("nviManOverride"));
        this.nManOverrideState = BVavContainer.g_NVUtil.getEnum("state").getOrdinal();
        if (this.nNvoDataMode1 == 9) {
            if (BDialog.confirm(null, (Object)"Controller was  in manual position mode.Do you want to put it in Auto mode?") == 4) {
                this.changeManualOverride(0, 0, -1);
                return;
            }
            BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("nviManOverride"));
            BEnum bEnum = null;
            BEnumRange bEnumRange = null;
            bEnum = BVavContainer.g_NVUtil.networkConfig.getLonEnum("state", null);
            bEnumRange = bEnum.getRange();
            bEnum = bEnumRange.get(this.nManOverrideState);
            ((BLonComponent)this.bObjVav.get("nviManOverride")).set("state", (BValue)BLonEnum.make((BEnum)bEnum));
            try {
                Thread.sleep(4000L);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.changeManualOverride(0, 0, -1);
    }

    private final void changeManualOverride(int n, int n2, int n3) {
        ((BLonComponent)this.bObjVav.get("nviManOverride")).lease(1);
        BVavContainer.g_NVUtil.setNV((BLonComponent)this.bObjVav.get("nviManOverride"));
        System.out.println("In changeManualOverride - nMode is " + n2 + ' ' + n);
        if (n == 0 || n == 1) {
            BEnum bEnum = null;
            BEnumRange bEnumRange = null;
            bEnum = BVavContainer.g_NVUtil.networkConfig.getLonEnum("state", null);
            bEnumRange = bEnum.getRange();
            bEnum = bEnumRange.get(n2);
            ((BLonComponent)this.bObjVav.get("nviManOverride")).set("state", (BValue)BLonEnum.make((BEnum)bEnum));
        }
        if (n == 1 || n == 2) {
            if (this.nUnitConversion == 2) {
                n3 = (int)((float)n3 / FACT_LPS_FT3PM);
            }
            BVavContainer.g_NVUtil.setInNative("flow", (float)n3, 0, true);
        }
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private final boolean NvoDataModeCheck() {
        if (this.readNvoDataMode()) {
            this.nNvoDataMode1 = this.nNvoDataMode;
            if (this.nNvoDataMode == 14) {
                this.bRebootTimerTask = this.startRebootTimerTask(15000);
                this.bRebootTimerTaskOn = true;
                this.enableDisableOptions(false);
                this.enableDisableControls(5);
            }
            if (6 == this.nNvoDataMode || 7 == this.nNvoDataMode || 12 == this.nNvoDataMode || 13 == this.nNvoDataMode || 15 == this.nNvoDataMode || 16 == this.nNvoDataMode || this.nNvoDataMode == 0) {
                String string = this.getModeString();
                String string2 = "Controller is " + string + "mode.Calibration terminated.";
                this.updateTheStatusWindow(string2);
                this.changeBtnText(this.bBStartStopBtn, "Start");
                this.enableDisableOptions(true);
                this.enableDisableControls(0);
                return false;
            }
            if (10 == this.nNvoDataMode || 9 == this.nNvoDataMode) {
                String string = this.getModeString();
                String string3 = "Controller is " + string + "mode.Do you want to override?";
                if (BDialog.confirm(null, (Object)string3) == 4) {
                    this.nNvoDataMode1 = this.nNvoDataMode;
                    return this.ReadNviManOverride();
                }
                this.updateTheStatusWindow("Zero calibration terminated");
                this.writeVavMiscZeroCalibFlag(0);
                return false;
            }
            return true;
        }
        return false;
    }

    String getModeString() {
        String string;
        switch (this.nNvoDataMode) {
            case 2: {
                string = "in Cool";
                break;
            }
            case 1: {
                string = "in Heat";
                break;
            }
            case 9: {
                string = "in ManualPos";
                break;
            }
            case 10: {
                string = "in ManualFlow";
                break;
            }
            case 16: {
                string = "in Manual";
                break;
            }
            case 3: {
                string = "in Reheat";
                break;
            }
            case 4: {
                string = "in MornWarm";
                break;
            }
            case 5: {
                string = "in NightPurge";
                break;
            }
            case 8: {
                string = "in TrackFlow";
                break;
            }
            case 11: {
                string = "in FreezeProtect";
                break;
            }
            default: {
                string = "not in Manual_Pos";
            }
        }
        return string;
    }

    private final void addToCommandGroup() {
        ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
        toggleCommandGroup.add((ToggleCommand)this.bSetpoint);
        toggleCommandGroup.add((ToggleCommand)this.bMax);
        toggleCommandGroup.add((ToggleCommand)this.bMin);
        toggleCommandGroup.add((ToggleCommand)this.bZero);
        toggleCommandGroup.add((ToggleCommand)this.bReset);
        this.bRadioSetpt.requestFocus();
    }

    private final BPane createMiddlePane() {
        this.bRadioMax = new BRadioButton("Maximum");
        this.bRadioMin = new BRadioButton("Minimum");
        this.bRadioZero = new BRadioButton("Zero");
        this.bRadioSetpt = new BRadioButton("Setpoint");
        this.bRadioReset = new BRadioButton("Reset");
        this.bMax = new BMaxTypeCommand((BWidget)this, "Maximum");
        this.bMin = new BMinTypeCommand((BWidget)this, "Minimum");
        this.bZero = new BZeroTypeCommand((BWidget)this, "Zero");
        this.bSetpoint = new BSetptTypeCommand((BWidget)this, "Setpoint");
        this.bReset = new BResetTypeCommand((BWidget)this, "Reset");
        this.bRadioMax.setCommand((Command)this.bMax, false, false);
        this.bRadioMin.setCommand((Command)this.bMin, false, false);
        this.bRadioZero.setCommand((Command)this.bZero, false, false);
        this.bRadioSetpt.setCommand((Command)this.bSetpoint, false, false);
        this.bRadioReset.setCommand((Command)this.bReset, false, false);
        BGridPaneEx bGridPaneEx = new BGridPaneEx(5, 1, 120, 20);
        bGridPaneEx.setRowGap(10.0);
        bGridPaneEx.setColumnAlign(BHalign.left);
        bGridPaneEx.setRowAlign(BValign.top);
        bGridPaneEx.setHalign(BHalign.left);
        bGridPaneEx.setValign(BValign.top);
        bGridPaneEx.setColumnGap(10.0);
        bGridPaneEx.setWidget((BWidget)this.bRadioMax, 0, 0);
        bGridPaneEx.setWidget((BWidget)this.bRadioMin, 1, 0);
        bGridPaneEx.setWidget((BWidget)this.bRadioZero, 2, 0);
        bGridPaneEx.setWidget((BWidget)this.bRadioSetpt, 3, 0);
        bGridPaneEx.setWidget((BWidget)this.bRadioReset, 4, 0);
        this.bITmpStatic[0] = this.bLStatic1 = new BLabel("Flow setpoint");
        this.bITmpStatic[1] = this.bLStatic2 = new BLabel("Displayed Flow");
        this.bITmpStatic[2] = this.bLStatic3 = new BLabel("Measured Flow");
        this.bITmpStatic[3] = this.bLStatic4 = new BLabel("Damper Position");
        this.bITmpStatic[4] = this.bLStatic5 = new BLabel("Time Remaining");
        this.bITmpEdit[0] = this.bIEdit1 = new BIntegerTextField();
        this.bITmpEdit[1] = this.bIEdit2 = new BIntegerTextField();
        this.bITmpEdit[2] = this.bIEdit3 = new BIntegerTextField();
        this.bITmpEdit[3] = this.bIEdit4 = new BIntegerTextField();
        this.bITmpEdit[4] = this.bIEdit5 = new BIntegerTextField();
        this.bITmpUnit[0] = this.bLUnit1 = new BLabel("l/s", BHalign.left);
        this.bITmpUnit[1] = this.bLUnit2 = new BLabel("l/s", BHalign.left);
        this.bITmpUnit[2] = this.bLUnit3 = new BLabel("l/s", BHalign.left);
        this.bITmpUnit[3] = this.bLUnit4 = new BLabel("%", BHalign.left);
        this.bITmpUnit[4] = this.bLUnit5 = new BLabel("s", BHalign.left);
        BGridPaneEx bGridPaneEx2 = new BGridPaneEx(5, 3);
        bGridPaneEx2.setColumnAlign(BHalign.left);
        bGridPaneEx2.setRowAlign(BValign.top);
        bGridPaneEx2.setHalign(BHalign.left);
        bGridPaneEx2.setValign(BValign.top);
        bGridPaneEx2.setColumnGap(10.0);
        bGridPaneEx2.setRowGap(10.0);
        bGridPaneEx2.setWidget((BWidget)this.bLStatic1, 0, 0);
        bGridPaneEx2.setWidget((BWidget)this.bLStatic2, 1, 0);
        bGridPaneEx2.setWidget((BWidget)this.bLStatic3, 2, 0);
        bGridPaneEx2.setWidget((BWidget)this.bLStatic4, 3, 0);
        bGridPaneEx2.setWidget((BWidget)this.bLStatic5, 4, 0);
        bGridPaneEx2.setWidget((BWidget)this.bIEdit1, 0, 1);
        bGridPaneEx2.setWidget((BWidget)this.bIEdit2, 1, 1);
        bGridPaneEx2.setWidget((BWidget)this.bIEdit3, 2, 1);
        bGridPaneEx2.setWidget((BWidget)this.bIEdit4, 3, 1);
        bGridPaneEx2.setWidget((BWidget)this.bIEdit5, 4, 1);
        bGridPaneEx2.setWidget((BWidget)this.bLUnit1, 0, 2);
        bGridPaneEx2.setWidget((BWidget)this.bLUnit2, 1, 2);
        bGridPaneEx2.setWidget((BWidget)this.bLUnit3, 2, 2);
        bGridPaneEx2.setWidget((BWidget)this.bLUnit4, 3, 2);
        bGridPaneEx2.setWidget((BWidget)this.bLUnit5, 4, 2);
        this.bBCalibrateStatusBtn = new BButton("Calibrate");
        this.bBStartStopBtn = new BButton("Start");
        this.bBHelpBtn = new BButton((Command)new BHelpCommand(this.getShell()), true, false);
        this.bStatusText = new BTextEditorPane(20, 50);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPaneEx);
        bBorderPane.setBorder(BBorder.make((int)1));
        bBorderPane.setLabel((BWidget)new BLabel("Action"));
        bBorderPane.setContent((BWidget)bGridPaneEx);
        BBorderPane bBorderPane2 = new BBorderPane((BWidget)bGridPaneEx2);
        bBorderPane2.setBorder(BBorder.make((int)1));
        bBorderPane2.setLabel((BWidget)new BLabel("Flow setpoints"));
        BFlowPane bFlowPane = new BFlowPane();
        bFlowPane.setAlign(BHalign.right);
        this.bBCalibrateStatusBtn.setHalign(BHalign.right);
        this.bBStartStopBtn.setHalign(BHalign.right);
        bFlowPane.add("calibbutt", (BValue)this.bBCalibrateStatusBtn);
        bFlowPane.add("StartStopBtn", (BValue)this.bBStartStopBtn);
        BGridPaneEx bGridPaneEx3 = new BGridPaneEx(1, 2, 150, 200);
        bGridPaneEx3.setColumnGap(20.0);
        bGridPaneEx3.setColumnWidth(1, 300);
        bGridPaneEx3.setRowAlign(BValign.top);
        bGridPaneEx3.setHalign(BHalign.left);
        bGridPaneEx3.setWidget((BWidget)bBorderPane, 0, 0);
        bGridPaneEx3.setWidget((BWidget)bBorderPane2, 0, 1);
        BGridPaneEx bGridPaneEx4 = new BGridPaneEx(1, 1, 470, 120);
        bGridPaneEx4.setWidget((BWidget)this.bStatusText, 0, 0);
        this.bStatusText.getEditor().setEditable(false);
        bGridPaneEx4.setHalign(BHalign.left);
        BGridPane bGridPane = new BGridPane(1);
        BFlowPane bFlowPane2 = new BFlowPane();
        bFlowPane2.setAlign(BHalign.right);
        this.butClose.setHalign(BHalign.right);
        this.bBHelpBtn.setHalign(BHalign.right);
        bFlowPane2.add("Close", (BValue)this.butClose);
        bFlowPane2.add("Help", (BValue)this.bBHelpBtn);
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)this);
        Type type = bWbShell.getType();
        if (bWbShell instanceof BNiagaraWbFrame) {
            this.bBHelpBtn.setEnabled(true);
        } else {
            this.bBHelpBtn.setEnabled(false);
        }
        bGridPane.add("grid1", (BValue)bGridPaneEx3);
        bGridPane.add("buttonPane", (BValue)bFlowPane);
        bGridPane.add("StatusPane", (BValue)bGridPaneEx4);
        bGridPane.add("buttonPane1", (BValue)bFlowPane2);
        this.bBHelpBtn.setText("Help");
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnAlign(BHalign.right);
        bGridPane.setRowAlign(BValign.top);
        return bGridPane;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.bIdleTimerTaskOn = true;
        this.bRebootTimerTaskOn = false;
        this.bActionBasedTimerTaskOn = false;
        this.nFlowCalType = 3;
        this.bITmpEdit = new BIntegerTextField[5];
        this.bITmpStatic = new BLabel[5];
        this.bITmpUnit = new BLabel[5];
        this.butClose = new BButton("Close");
        this.pFlowOffsetVal1 = 0L;
        this.pFlowOffsetVal2 = 0L;
        this.bCalComplete = false;
        this.nStableCount = 0;
        this.nCounter = 0;
        this.nMinOrMaxFlow = 0;
        this.nDamperSpeed = 0;
        this.nButtonState = 0;
        this.nMaxFlow = 0;
        this.nMinFlow = 0;
        this.nDamperDrive = new int[10];
        this.nMaxAct = 0;
        this.nMaxAppr = 0;
        this.nMinAct = 0;
        this.nMinAppr = 0;
        this.nZeroAct = 0;
        this.nZeroAppr = 0;
        this.nDamperPos = 0;
        this.nNvoDataMode = 0;
        this.nNvoDataMode1 = 0;
        this.nManOverrideState = 0;
        this.nElapsedTime = 0;
        this.nZeroCalibFlag = 0;
        this.nUnitConversion = 0;
        this.compArray = new BLonComponent[7];
        this.compNameArray = new String[]{"Fld3PtCal", "DuctArea", "MaxFlow", "MinFlow", "Config", "Aux2SetPt", "FlowVoltOffsetS12"};
    }

    public BVavAirBalanceDlg(BWidget bWidget, String string, boolean bl, BExcel10VAV bExcel10VAV) {
        super(bWidget, string, bl);
        this.this();
        BAXUtil.getBrandAndFeature(bExcel10VAV, false);
        if ("Browser".equalsIgnoreCase(bExcel10VAV.getWorkbenchLicenseType())) {
            bExcel10VAV.getStationLicenseInfo();
        }
        if (!bExcel10VAV.isHoneywellWizardLicensed().getBoolean()) {
            throw new FeatureNotLicensedException("AXWizards are not licensed for this machine");
        }
        System.out.println("In the constructor");
        this.content = this.buildDialog();
        this.setContent((BWidget)this.content);
        this.bObjVav = bExcel10VAV;
        if (this.bObjVav == null) {
            System.out.println("Device is null");
        } else {
            System.out.println("Device is not null");
        }
        new WidgetSubscriber(){

            public final void actionPerformed(BWidgetEvent bWidgetEvent) {
                BVavAirBalanceDlg.this.close();
            }
        }.subscribe((BComponent)this.butClose);
        this.nUnitConversion = Nre.unitConversion;
        System.out.println("nUnitConversion is " + this.nUnitConversion);
        if (this.nUnitConversion == 0) {
            this.nUnitConversion = 2;
        }
        BButton2Sbr bButton2Sbr = new BButton2Sbr();
        bButton2Sbr.subscribe((BComponent)this.bBStartStopBtn);
        BButton1Sbr bButton1Sbr = new BButton1Sbr();
        bButton1Sbr.subscribe((BComponent)this.bBCalibrateStatusBtn);
        int n = 0;
        while (n < 7) {
            System.out.println(this.compNameArray[n]);
            this.compArray[n] = (BLonComponent)this.bObjVav.get(this.compNameArray[n]);
            if (this.compArray[n] == null) {
                System.out.println("CompArray is null");
            } else {
                this.compArray[n].lease(1, 20000L);
            }
            ++n;
        }
        System.out.println("Before addToCommandGroup");
        this.addToCommandGroup();
        System.out.println("After addToCommandGroup");
    }

    static {
        Class clazz = class$com$honeywell$londevices$axwizard$ui$VAV$BVavAirBalanceDlg;
        if (clazz == null) {
            clazz = class$com$honeywell$londevices$axwizard$ui$VAV$BVavAirBalanceDlg = BVavAirBalanceDlg.class("[Lcom.honeywell.londevices.axwizard.ui.VAV.BVavAirBalanceDlg;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        FACT_F2_M2 = 0.0929f;
        FACT_FPM_MPS = 0.00508f;
        FACT_LPS_FT3PM = 2.1186f;
        bAXUtil = new BAXUtil("local:|module://lonhoneywellAXWizards/com/honeywell/londevices/axwizard/ui/VAV/VavEnumDefs.xml");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BIdleTimerTask
    extends TimerTask {
        public void run() {
            System.out.println("BIdleTimer" + this.scheduledExecutionTime());
            if (BVavAirBalanceDlg.this.bIdleTimerTaskOn && !BVavAirBalanceDlg.this.bActionBasedTimerTaskOn && BVavAirBalanceDlg.this.nFlowCalType != 3) {
                BVavAirBalanceDlg.this.readNvoCtlDataG();
                BVavAirBalanceDlg.this.nValue3 = BVavAirBalanceDlg.this.nValue2;
                BVavAirBalanceDlg.this.updateValuesToControls();
            }
        }

        BIdleTimerTask() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BRebootTimerTask
    extends TimerTask {
        public void run() {
            System.out.println("BRebootTimer" + this.scheduledExecutionTime());
            if (BVavAirBalanceDlg.this.bRebootTimerTaskOn) {
                if (!BVavAirBalanceDlg.this.readNvoDataMode()) {
                    BVavAirBalanceDlg.this.updateTheStatusWindow("Communication error: Controller is not responding.");
                    return;
                }
                if (BVavAirBalanceDlg.this.nNvoDataMode != 14) {
                    BVavAirBalanceDlg.this.updateTheStatusWindow("Controller rebooted.Calibration enabled.");
                    BVavAirBalanceDlg.this.bRebootTimerTaskOn = false;
                    BVavAirBalanceDlg.this.cancelTimerTask(BVavAirBalanceDlg.this.bRebootTimerTask);
                    BVavAirBalanceDlg.this.bBStartStopBtn.setEnabled(true);
                    BVavAirBalanceDlg.this.enableDisableOptions(true);
                    if (BVavAirBalanceDlg.this.nFlowCalType == 3) {
                        BVavAirBalanceDlg.this.bRadioSetpt.setSelected(true);
                    }
                    BVavAirBalanceDlg.this.readVavMiscZeroCalibFlag();
                    switch (BVavAirBalanceDlg.this.nZeroCalibFlag) {
                        case 0: {
                            BVavAirBalanceDlg.this.enableDisableControls(0);
                            break;
                        }
                        case 1: {
                            BVavAirBalanceDlg.this.enableDisableControls(3);
                            break;
                        }
                        case 2: {
                            BVavAirBalanceDlg.this.enableDisableControls(4);
                            break;
                        }
                    }
                } else {
                    BVavAirBalanceDlg.this.updateTheStatusWindow("Controller rebooting.Please wait.....");
                }
                return;
            }
        }

        BRebootTimerTask() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BSetptTypeCommand
    extends ToggleCommand {
        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (!bl) {
                return;
            }
            BVavAirBalanceDlg.this.nFlowCalType = 3;
            boolean bl2 = false;
            int n = 0;
            while (n <= 4) {
                bl2 = n < 2;
                BVavAirBalanceDlg.this.bITmpEdit[n].setVisible(bl2);
                BVavAirBalanceDlg.this.bITmpEdit[n].setEnabled(bl2);
                BVavAirBalanceDlg.this.bITmpStatic[n].setVisible(bl2);
                BVavAirBalanceDlg.this.bITmpUnit[n].setVisible(bl2);
                ++n;
            }
            System.out.println("BSetpointCommand selected");
            BVavAirBalanceDlg.this.enableButton(BVavAirBalanceDlg.this.bBCalibrateStatusBtn, false);
            BVavAirBalanceDlg.this.changeBtnText(BVavAirBalanceDlg.this.bBStartStopBtn, "Set");
            BVavAirBalanceDlg.this.bITmpStatic[0].setText("Maximum Flow");
            BVavAirBalanceDlg.this.bITmpStatic[1].setText("Minimum Flow");
            String string = BVavAirBalanceDlg.this.nUnitConversion == 1 ? "l/s" : "cfm";
            BVavAirBalanceDlg.this.bLUnit1.setText(string);
            BVavAirBalanceDlg.this.bLUnit2.setText(string);
            BVavAirBalanceDlg.this.bLUnit1.setVisible(true);
            BVavAirBalanceDlg.this.bLUnit2.setVisible(true);
            BVavAirBalanceDlg.this.readMaxAndMinFlowFromCtrl();
            BVavAirBalanceDlg.this.nValue1 = BVavAirBalanceDlg.this.nMaxFlow;
            BVavAirBalanceDlg.this.nValue2 = BVavAirBalanceDlg.this.nMinFlow;
            BVavAirBalanceDlg.this.updateValuesToControls();
        }

        public BSetptTypeCommand(BWidget bWidget, String string) {
            super(bWidget, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BActionBasedTimerTask
    extends TimerTask {
        public void run() {
            switch (BVavAirBalanceDlg.this.nFlowCalType) {
                case 0: {
                    BVavAirBalanceDlg.this.HandleTimer(0);
                    break;
                }
                case 1: {
                    BVavAirBalanceDlg.this.HandleTimer(1);
                    break;
                }
                case 2: {
                    BVavAirBalanceDlg.this.HandleZeroFlowSelection();
                    break;
                }
            }
        }

        BActionBasedTimerTask() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BMaxTypeCommand
    extends ToggleCommand {
        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (!bl) {
                return;
            }
            System.out.println("Max selected");
            if (BVavAirBalanceDlg.this.bActionBasedTimerTaskOn) {
                BVavAirBalanceDlg.this.updateTheStatusWindow("Calibration is Continuing. Please Stop and select the option.");
                return;
            }
            BVavAirBalanceDlg.this.nValue1 = 0;
            BVavAirBalanceDlg.this.nValue2 = 0;
            BVavAirBalanceDlg.this.updateValuesToControls();
            BVavAirBalanceDlg.this.nFlowCalType = 0;
            int n = 0;
            while (n <= 4) {
                BVavAirBalanceDlg.this.bITmpEdit[n].setVisible(true);
                BVavAirBalanceDlg.this.bITmpEdit[n].setEnabled(false);
                BVavAirBalanceDlg.this.bITmpStatic[n].setVisible(true);
                BVavAirBalanceDlg.this.bITmpUnit[n].setVisible(true);
                ++n;
            }
            BVavAirBalanceDlg.this.enableButton(BVavAirBalanceDlg.this.bBCalibrateStatusBtn, false);
            BVavAirBalanceDlg.this.changeBtnText(BVavAirBalanceDlg.this.bBStartStopBtn, "Start");
            BVavAirBalanceDlg.this.bITmpStatic[0].setText("Flow Setpoint");
            BVavAirBalanceDlg.this.bITmpStatic[1].setText("Displayed Flow");
            String string = BVavAirBalanceDlg.this.nUnitConversion == 1 ? "l/s" : "cfm";
            BVavAirBalanceDlg.this.bLUnit1.setText(string);
            BVavAirBalanceDlg.this.bLUnit2.setText(string);
            BVavAirBalanceDlg.this.bLUnit3.setText(string);
            BVavAirBalanceDlg.this.readNvoCtlDataG();
            BVavAirBalanceDlg.this.nValue3 = BVavAirBalanceDlg.this.nValue2;
            BVavAirBalanceDlg.this.updateValuesToControls();
        }

        public BMaxTypeCommand(BWidget bWidget, String string) {
            super(bWidget, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BMinTypeCommand
    extends ToggleCommand {
        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (!bl) {
                return;
            }
            if (BVavAirBalanceDlg.this.bActionBasedTimerTaskOn) {
                BVavAirBalanceDlg.this.updateTheStatusWindow("Calibration is Continuing. Please Stop and select the option.");
                return;
            }
            BVavAirBalanceDlg.this.nValue1 = 0;
            BVavAirBalanceDlg.this.nValue2 = 0;
            BVavAirBalanceDlg.this.nFlowCalType = 1;
            int n = 0;
            while (n <= 4) {
                BVavAirBalanceDlg.this.bITmpEdit[n].setVisible(true);
                BVavAirBalanceDlg.this.bITmpEdit[n].setEnabled(false);
                BVavAirBalanceDlg.this.bITmpStatic[n].setVisible(true);
                BVavAirBalanceDlg.this.bITmpUnit[n].setVisible(true);
                ++n;
            }
            BVavAirBalanceDlg.this.enableButton(BVavAirBalanceDlg.this.bBCalibrateStatusBtn, false);
            BVavAirBalanceDlg.this.changeBtnText(BVavAirBalanceDlg.this.bBStartStopBtn, "Start");
            BVavAirBalanceDlg.this.bITmpStatic[0].setText("Flow Setpoint");
            BVavAirBalanceDlg.this.bITmpStatic[1].setText("Displayed Flow");
            String string = BVavAirBalanceDlg.this.nUnitConversion == 1 ? "l/s" : "cfm";
            BVavAirBalanceDlg.this.bLUnit1.setText(string);
            BVavAirBalanceDlg.this.bLUnit2.setText(string);
            BVavAirBalanceDlg.this.bLUnit3.setText(string);
            BVavAirBalanceDlg.this.readNvoCtlDataG();
            BVavAirBalanceDlg.this.nValue3 = BVavAirBalanceDlg.this.nValue2;
            BVavAirBalanceDlg.this.updateValuesToControls();
            System.out.println("Min selected");
        }

        public BMinTypeCommand(BWidget bWidget, String string) {
            super(bWidget, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BZeroTypeCommand
    extends ToggleCommand {
        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (!bl) {
                return;
            }
            BVavAirBalanceDlg.this.nFlowCalType = 2;
            boolean bl2 = false;
            int n = 0;
            while (n <= 4) {
                bl2 = n != 0 && n != 2;
                BVavAirBalanceDlg.this.bITmpEdit[n].setVisible(bl2);
                BVavAirBalanceDlg.this.bITmpEdit[n].setEnabled(false);
                BVavAirBalanceDlg.this.bITmpStatic[n].setVisible(bl2);
                BVavAirBalanceDlg.this.bITmpUnit[n].setVisible(bl2);
                ++n;
            }
            System.out.println("BZeroTypeCommand selected");
            BVavAirBalanceDlg.this.enableButton(BVavAirBalanceDlg.this.bBCalibrateStatusBtn, false);
            BVavAirBalanceDlg.this.changeBtnText(BVavAirBalanceDlg.this.bBStartStopBtn, "Start");
            BVavAirBalanceDlg.this.bITmpStatic[1].setText("Displayed Flow");
            String string = BVavAirBalanceDlg.this.nUnitConversion == 1 ? "l/s" : "cfm";
            BVavAirBalanceDlg.this.bLUnit1.setText(string);
            BVavAirBalanceDlg.this.readNvoCtlDataG();
            BVavAirBalanceDlg.this.nValue3 = BVavAirBalanceDlg.this.nValue2;
            BVavAirBalanceDlg.this.updateValuesToControls();
        }

        public BZeroTypeCommand(BWidget bWidget, String string) {
            super(bWidget, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BResetTypeCommand
    extends ToggleCommand {
        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (BVavAirBalanceDlg.this.bActionBasedTimerTaskOn) {
                BVavAirBalanceDlg.this.updateTheStatusWindow("Calibration is Continuing. Please Stop and select the option.");
                return;
            }
            if (bl && BDialog.confirm(null, (Object)"Reset air flow calibration to factory defaults?") == 4 && BDialog.confirm(null, (Object)"Warning: All air flow calibration will be lost ! Proceed?") == 4) {
                BExcel10VAV cfr_ignored_0 = BVavAirBalanceDlg.this.bObjVav;
                BVavAirBalanceDlg.this.bObjVav.invoke(BExcel10VAV.readCPFromDeviceAndUpdateDB, (BValue)BString.make((String)"Fld3PtCal"), null);
                BVavContainer.g_NVUtil.setNV((BLonComponent)BVavAirBalanceDlg.this.bObjVav.get("Fld3PtCal"));
                BVavContainer.g_NVUtil.networkConfig.lease(1);
                BVavContainer.g_NVUtil.setInNative("siCalActualLoS3", 0.0f, 0, true);
                BVavContainer.g_NVUtil.setInNative("siCalApparentLoS3", 0.0f, 0, true);
                BVavContainer.g_NVUtil.setInNative("siCalActualMidS3", 820.0f, 0, true);
                BVavContainer.g_NVUtil.setInNative("siCalApparentMidS3", 820.0f, 0, true);
                BVavContainer.g_NVUtil.setInNative("siCalActualHiS3", 3500.0f, 0, true);
                BVavContainer.g_NVUtil.setInNative("siCalApparentHiS3", 3500.0f, 0, true);
                BVavAirBalanceDlg.this.updateTheStatusWindow("Reset success");
                BVavAirBalanceDlg.this.writeVavMiscZeroCalibFlag(0);
                BVavAirBalanceDlg.this.enableDisableControls(0);
                BVavAirBalanceDlg.this.nFlowCalType = 3;
            }
            switch (BVavAirBalanceDlg.this.nFlowCalType) {
                case 0: {
                    BVavAirBalanceDlg.this.bRadioMax.requestFocus();
                    break;
                }
                case 1: {
                    BVavAirBalanceDlg.this.bRadioMin.requestFocus();
                    break;
                }
                case 2: {
                    BVavAirBalanceDlg.this.bRadioZero.requestFocus();
                    break;
                }
                case 3: {
                    BVavAirBalanceDlg.this.bRadioSetpt.requestFocus();
                    break;
                }
            }
        }

        public BResetTypeCommand(BWidget bWidget, String string) {
            super(bWidget, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BHelpCommand
    extends Command {
        public CommandArtifact doInvoke() {
            WbMain.openHelp((BWbShell)BWbShell.getWbShell((BWidget)BVavAirBalanceDlg.this.bBHelpBtn), (BOrd)BOrd.make((String)"local:|module://docHoneywell/doc/VAVCalibration.html"));
            return null;
        }

        BHelpCommand(BWidgetShell bWidgetShell) {
            super((BWidget)bWidgetShell, BVavAirBalanceDlg.this.getLexicon(), "Help");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BButton2Sbr
    extends BAXSubscriber {
        public void actionPerformed(BWidgetEvent bWidgetEvent) {
            if (BVavAirBalanceDlg.this.nButtonState == 1) {
                System.out.println("Calibration is on and the user pressed Stop");
                BVavAirBalanceDlg.this.stopCalibrationAndUpdateBtnStatus();
                BVavAirBalanceDlg.this.nButtonState = 0;
                BVavAirBalanceDlg.this.bIEdit3.setEnabled(false);
                return;
            }
            BVavAirBalanceDlg.this.fDuctArea = BVavAirBalanceDlg.this.getDuctArea();
            switch (BVavAirBalanceDlg.this.nFlowCalType) {
                case 0: {
                    BVavAirBalanceDlg.this.initiateCalibration(0);
                    break;
                }
                case 1: {
                    BVavAirBalanceDlg.this.initiateCalibration(1);
                    break;
                }
                case 2: {
                    System.out.println("In zero calibration, DuctArea is " + BVavAirBalanceDlg.this.fDuctArea);
                    BVavAirBalanceDlg.this.doZeroCalibration();
                    break;
                }
                case 3: {
                    BVavAirBalanceDlg.this.handleSetptSelection();
                    break;
                }
            }
        }

        BButton2Sbr() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BButton1Sbr
    extends BAXSubscriber {
        public void actionPerformed(BWidgetEvent bWidgetEvent) {
            if (BVavAirBalanceDlg.this.nButtonState == 1) {
                BVavAirBalanceDlg.this.initiateCalibration(BVavAirBalanceDlg.this.nFlowCalType);
            }
        }

        BButton1Sbr() {
        }
    }
}

