/*
 * Decompiled with CFR 0.152.
 */
package com.honeywell.londevices.axwizard.ui.UV;

import com.honeywell.framework.BStep;
import com.honeywell.framework.BStepModifiedEvent;
import com.honeywell.framework.StepContainerException;
import com.honeywell.londevices.axwizard.ui.UV.BPowerFrequencyEnum;
import com.honeywell.londevices.axwizard.ui.UV.BUVConfigView;
import com.honeywell.londevices.utilities.BFloatTextField;
import com.honeywell.londevices.utilities.BNVUtil;
import com.honeywell.londevices.xl10controller.UV.BExcel10UnitVent;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BUVOutputPane
extends BPane {
    private static int totalOutputs = 8;
    static int heatFloating = 4;
    static int heatPwm = 3;
    static int coolFloating = 4;
    static int coolPwm = 3;
    static int econFloating = 2;
    static int econPwm = 1;
    public static final Type TYPE;
    BLabel lbFanSpeed;
    BLabel lbHeating;
    BLabel lbCooling;
    BLabel lbEconomizer;
    BLabel lbMotorSpeed;
    BLabel lbOptionalPoint;
    BLabel lbPwmSetting;
    BLabel lbPeriod;
    BLabel lbZeroScale;
    BLabel lbFullScale;
    BLabel lbHeatingUnit;
    BLabel lbCoolingUnit;
    BLabel lbEconomizerUnit;
    BLabel lbPeriodUnit;
    BLabel lbZeroScaleUnit;
    BLabel lbFullScaleUnit;
    BListDropDown[] ddOutput;
    BListDropDown ddFanSpeed;
    BListDropDown ddHeating;
    BListDropDown ddCooling;
    BListDropDown ddEconomizer;
    BListDropDown[] ddOptional;
    BListDropDown ddPowerFrequency;
    BFloatTextField txfHeating;
    BFloatTextField txfCooling;
    BFloatTextField txfEconomizer;
    BFloatTextField txfPeriod;
    BFloatTextField txfZeroScale;
    BFloatTextField txfFullScale;
    WidgetSubscriber doSubscriber;
    BConfigParameter io;
    BConfigParameter config;
    BConfigParameter aux1SetPt;
    BExcel10UnitVent deviceObject;
    BUVConfigView parent;
    int totalConfigured;
    int lastConfiguredOption;
    String[] enumOptions;
    public String[][] enumText;
    String[] optionalOption;
    String[][] optionalText;
    BLonEnum[] digitalOutPut;
    BLonInteger powerFrequency;
    BPane pwmWidget;
    BWidget displayWidget;
    static /* synthetic */ Class class$com$honeywell$londevices$axwizard$ui$UV$BUVOutputPane;
    static /* synthetic */ Class class$com$honeywell$londevices$axwizard$ui$UV$BPowerFrequencyEnum;

    public BWidget getDisplayWidget() {
        return this.displayWidget;
    }

    public void reset() {
        try {
            Object object;
            System.out.println("outputpane reset called");
            System.out.println("deviceObj = " + this.deviceObject.toString());
            this.io = (BConfigParameter)this.deviceObject.get("IoSelect");
            BNVUtil bNVUtil = new BNVUtil((BLonComponent)this.io, null);
            int n = Integer.parseInt(bNVUtil.getValue("FiftySixtyHz", 0));
            System.out.println("SelectedOrd" + n);
            BPowerFrequencyEnum bPowerFrequencyEnum = BPowerFrequencyEnum.make(n);
            BEnumRange bEnumRange = bPowerFrequencyEnum.getRange();
            int[] nArray = bEnumRange.getOrdinals();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == bPowerFrequencyEnum.getOrdinal()) {
                    this.ddPowerFrequency.setSelectedIndex(n2);
                }
                ++n2;
            }
            this.intializeDOs();
            this.totalConfigured = 0;
            n2 = 0;
            while (n2 < this.digitalOutPut.length) {
                System.out.println("calling setDigitalOutput from reset");
                System.out.println(this.io.get("DigitalOut" + (n2 + 1)).toString());
                object = "doUnused";
                if (!((String)object).equals(this.io.get("DigitalOut" + (n2 + 1)).toString())) {
                    ++this.totalConfigured;
                }
                this.setDigitalOutput(n2, (BLonEnum)this.io.get("DigitalOut" + (n2 + 1)));
                ++n2;
            }
            System.out.println("totalConfigured = " + this.totalConfigured);
            this.setDropDown(0, 4, this.ddFanSpeed);
            this.setDropDown(4, 9, this.ddHeating);
            this.setDropDown(9, 14, this.ddCooling);
            this.setDropDown(14, 17, this.ddEconomizer);
            this.setOptionalOptions();
            boolean bl = false;
            if (this.ddHeating.getSelectedIndex() == heatPwm || this.ddCooling.getSelectedIndex() == coolPwm || this.ddEconomizer.getSelectedIndex() == econPwm) {
                bl = true;
            }
            this.showPWM(bl);
            this.config = (BConfigParameter)this.deviceObject.get("Config");
            BNVUtil bNVUtil2 = new BNVUtil((BLonComponent)this.config, null);
            this.txfHeating.setText(bNVUtil2.getValue("HeatMtrTime", this.parent.unitConversion));
            this.txfHeating.setPrecisionCheck(bNVUtil2.getPrecision("HeatMtrTime", this.parent.unitConversion));
            this.lbHeatingUnit.setText(bNVUtil2.getUnit("HeatMtrTime", this.parent.unitConversion).toString());
            this.txfCooling.setText(bNVUtil2.getValue("CoolMtrTime", this.parent.unitConversion));
            this.txfCooling.setPrecisionCheck(bNVUtil2.getPrecision("CoolMtrTime", this.parent.unitConversion));
            this.lbCoolingUnit.setText(bNVUtil2.getUnit("CoolMtrTime", this.parent.unitConversion).toString());
            this.txfEconomizer.setText(bNVUtil2.getValue("EconMtrTime", this.parent.unitConversion));
            this.txfEconomizer.setPrecisionCheck(bNVUtil2.getPrecision("EconMtrTime", this.parent.unitConversion));
            this.lbEconomizerUnit.setText(bNVUtil2.getUnit("EconMtrTime", this.parent.unitConversion).toString());
            this.aux1SetPt = (BConfigParameter)this.deviceObject.get("Aux1SetPt");
            object = new BNVUtil((BLonComponent)this.aux1SetPt, null);
            this.txfPeriod.setText(((BNVUtil)((Object)object)).getValue("PwmPeriod", this.parent.unitConversion));
            this.txfPeriod.setPrecisionCheck(((BNVUtil)((Object)object)).getPrecision("PwmPeriod", this.parent.unitConversion));
            this.lbPeriodUnit.setText(((BNVUtil)((Object)object)).getUnit("PwmPeriod", this.parent.unitConversion).toString());
            this.txfZeroScale.setText(((BNVUtil)((Object)object)).getValue("Pwm0Pcnt", this.parent.unitConversion));
            this.txfZeroScale.setPrecisionCheck(((BNVUtil)((Object)object)).getPrecision("Pwm0Pcnt", this.parent.unitConversion));
            this.lbZeroScaleUnit.setText(((BNVUtil)((Object)object)).getUnit("Pwm0Pcnt", this.parent.unitConversion).toString());
            this.txfFullScale.setText(((BNVUtil)((Object)object)).getValue("Pwm100Pcnt", this.parent.unitConversion));
            this.txfFullScale.setPrecisionCheck(((BNVUtil)((Object)object)).getPrecision("Pwm100Pcnt", this.parent.unitConversion));
            this.lbFullScaleUnit.setText(((BNVUtil)((Object)object)).getUnit("Pwm100Pcnt", this.parent.unitConversion).toString());
            boolean bl2 = false;
            if (this.ddHeating.getSelectedIndex() == heatFloating) {
                bl2 = true;
            }
            this.showHeatMtr(bl2);
            boolean bl3 = false;
            if (this.ddCooling.getSelectedIndex() == coolFloating) {
                bl3 = true;
            }
            this.showCoolMtr(bl3);
            boolean bl4 = false;
            if (this.ddEconomizer.getSelectedIndex() == econFloating) {
                bl4 = true;
            }
            this.showEconMtr(bl4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BDialog.message(null, (Object)this.getTextFromLexicon("UVOutputPane.ResetErr"));
        }
    }

    public void load() throws StepContainerException {
    }

    public void unload() throws StepContainerException {
        int n;
        this.validatePage();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.totalConfigured > totalOutputs) {
            throw new StepContainerException(this.getTextFromLexicon("UVOutputPane.MaxError"));
        }
        this.intializeDOs();
        n2 = 0;
        while (n2 < this.enumOptions.length) {
            if (this.ddFanSpeed.getSelectedItem().equals(this.enumOptions[n2])) {
                n = 0;
                while (n < this.enumText[n2].length) {
                    this.setDigitalOutput(n8, this.enumText[n2][n]);
                    ++n8;
                    ++n;
                }
                break;
            }
            ++n2;
        }
        System.out.println("digitalOutputIndex1 = " + n8);
        n3 = 0;
        while (n3 < this.enumOptions.length) {
            if (this.ddHeating.getSelectedItem().equals(this.enumOptions[n3])) {
                n = 0;
                while (n < this.enumText[n3].length) {
                    this.setDigitalOutput(n8, this.enumText[n3][n]);
                    ++n8;
                    ++n;
                }
                break;
            }
            ++n3;
        }
        System.out.println("digitalOutputIndex2 = " + n8);
        n4 = 0;
        while (n4 < this.enumOptions.length) {
            if (this.ddCooling.getSelectedItem().equals(this.enumOptions[n4])) {
                n = 0;
                while (n < this.enumText[n4].length) {
                    this.setDigitalOutput(n8, this.enumText[n4][n]);
                    ++n8;
                    ++n;
                }
                break;
            }
            ++n4;
        }
        System.out.println("digitalOutputIndex3 = " + n8);
        n5 = 0;
        while (n5 < this.enumOptions.length) {
            if (this.ddEconomizer.getSelectedItem().equals(this.enumOptions[n5])) {
                n = 0;
                while (n < this.enumText[n5].length) {
                    this.setDigitalOutput(n8, this.enumText[n5][n]);
                    ++n8;
                    ++n;
                }
                break;
            }
            ++n5;
        }
        System.out.println("digitalOutputIndex4 = " + n8);
        n6 = 0;
        while (n6 < this.ddOptional.length) {
            n7 = 0;
            while (n7 < this.optionalOption.length) {
                if (this.ddOptional[n6].getSelectedItem().equals(this.optionalOption[n7]) && !this.optionalOption[n7].equals("Unused")) {
                    this.setDigitalOutput(n8, this.optionalText[n7][0]);
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        System.out.println("digitalOutputIndex5 =" + n8);
        if (n8 > totalOutputs) {
            throw new StepContainerException(this.getTextFromLexicon("UVOutputPane.MaxError"));
        }
        this.totalConfigured = n8;
    }

    public void saveIt() {
        try {
            BNVUtil bNVUtil = new BNVUtil((BLonComponent)this.config, null);
            BNVUtil bNVUtil2 = new BNVUtil((BLonComponent)this.io, null);
            BNVUtil bNVUtil3 = new BNVUtil((BLonComponent)this.aux1SetPt, null);
            int n = this.ddPowerFrequency.getSelectedIndex();
            Class clazz = class$com$honeywell$londevices$axwizard$ui$UV$BPowerFrequencyEnum;
            if (clazz == null) {
                clazz = class$com$honeywell$londevices$axwizard$ui$UV$BPowerFrequencyEnum = BUVOutputPane.class("[Lcom.honeywell.londevices.axwizard.ui.UV.BPowerFrequencyEnum;", false);
            }
            BEnumRange bEnumRange = BEnumRange.make((Type)Sys.loadType((Class)clazz));
            int[] nArray = bEnumRange.getOrdinals();
            bNVUtil2.setInNative("FiftySixtyHz", nArray[n], 0);
            if (this.txfCooling.isEnabled()) {
                bNVUtil.setInNative("CoolMtrTime", Float.valueOf(this.txfCooling.getText()).floatValue(), this.parent.unitConversion);
            }
            if (this.txfEconomizer.isEnabled()) {
                bNVUtil.setInNative("EconMtrTime", Float.valueOf(this.txfEconomizer.getText()).floatValue(), this.parent.unitConversion);
            }
            if (this.txfHeating.isEnabled()) {
                bNVUtil.setInNative("HeatMtrTime", Float.valueOf(this.txfHeating.getText()).floatValue(), this.parent.unitConversion);
            }
            if (this.txfFullScale.isEnabled()) {
                bNVUtil3.setInNative("Pwm100Pcnt", Float.valueOf(this.txfFullScale.getText()).floatValue(), this.parent.unitConversion);
            }
            if (this.txfZeroScale.isEnabled()) {
                bNVUtil3.setInNative("Pwm0Pcnt", Float.valueOf(this.txfZeroScale.getText()).floatValue(), this.parent.unitConversion);
            }
            if (this.txfPeriod.isEnabled()) {
                bNVUtil3.setInNative("PwmPeriod", Float.valueOf(this.txfPeriod.getText()).floatValue(), this.parent.unitConversion);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BDialog.message(null, (Object)this.getTextFromLexicon("UVOutputPane.SaveErr"));
        }
    }

    String ConstructErrorMsg(String string, float f, float f2) {
        String string2 = this.getTextFromLexicon(string) + ' ' + this.getTextFromLexicon("should lie between") + ' ' + f + ' ' + this.getTextFromLexicon("and") + ' ' + f2;
        return string2;
    }

    public boolean validatePage() throws StepContainerException {
        float f;
        float f2;
        float f3;
        System.out.println("Output's validate page called");
        this.config = (BConfigParameter)this.deviceObject.get("Config");
        BNVUtil bNVUtil = new BNVUtil((BLonComponent)this.config, null);
        String string = "Success";
        boolean bl = false;
        if (this.txfHeating.isEnabled()) {
            f3 = Float.parseFloat(bNVUtil.getLowerLimit("HeatMtrTime", this.parent.unitConversion));
            f2 = Float.parseFloat(bNVUtil.getUpperLimit("HeatMtrTime", this.parent.unitConversion));
            f = Float.valueOf(this.txfHeating.getText()).floatValue();
            if (f < f3 || f > f2) {
                string = this.ConstructErrorMsg("UVOutputPane.HeatMtrTime", f3, f2);
                bl = true;
                this.txfHeating.requestFocus();
            }
        }
        if (this.txfCooling.isEnabled()) {
            f3 = Float.parseFloat(bNVUtil.getLowerLimit("CoolMtrTime", this.parent.unitConversion));
            f2 = Float.parseFloat(bNVUtil.getUpperLimit("CoolMtrTime", this.parent.unitConversion));
            f = Float.valueOf(this.txfCooling.getText()).floatValue();
            if (f < f3 || f > f2) {
                string = this.ConstructErrorMsg("UVOutputPane.CoolMtrTime", f3, f2);
                bl = true;
                this.txfCooling.requestFocus();
            }
        }
        if (this.txfEconomizer.isEnabled()) {
            f3 = Float.parseFloat(bNVUtil.getLowerLimit("EconMtrTime", this.parent.unitConversion));
            f2 = Float.parseFloat(bNVUtil.getUpperLimit("EconMtrTime", this.parent.unitConversion));
            f = Float.valueOf(this.txfEconomizer.getText()).floatValue();
            if (f < f3 || f > f2) {
                string = this.ConstructErrorMsg("UVOutputPane.EconMtrTime", f3, f2);
                bl = true;
                this.txfEconomizer.requestFocus();
            }
        }
        f3 = Float.valueOf(this.txfPeriod.getText()).floatValue();
        f2 = Float.valueOf(this.txfZeroScale.getText()).floatValue();
        f = Float.valueOf(this.txfFullScale.getText()).floatValue();
        this.aux1SetPt = (BConfigParameter)this.deviceObject.get("Aux1SetPt");
        BNVUtil bNVUtil2 = new BNVUtil((BLonComponent)this.aux1SetPt, null);
        float f4 = Float.parseFloat(bNVUtil2.getLowerLimit("PwmPeriod", this.parent.unitConversion));
        float f5 = Float.parseFloat(bNVUtil2.getUpperLimit("PwmPeriod", this.parent.unitConversion));
        if (this.txfFullScale.isEnabled() && (f < f2 || f > f3)) {
            string = f2 > f3 ? this.ConstructErrorMsg("UVOutputPane.lbFullScale", f4, f3) : this.ConstructErrorMsg("UVOutputPane.lbFullScale", f2, f3);
            bl = true;
            this.txfFullScale.requestFocus();
        }
        if (this.txfZeroScale.isEnabled() && (f2 < f4 || f2 > f)) {
            string = f > f3 ? this.ConstructErrorMsg("UVOutputPane.lbZeroScale", f4, f3) : this.ConstructErrorMsg("UVOutputPane.lbZeroScale", f4, f);
            bl = true;
            this.txfZeroScale.requestFocus();
        }
        if (this.txfPeriod.isEnabled() && (f3 < f4 || f3 > f5)) {
            string = this.ConstructErrorMsg("UVOutputPane.lbPeriod", f4, f5);
            bl = true;
            this.txfPeriod.requestFocus();
        }
        if (bl) {
            StepContainerException stepContainerException = new StepContainerException(string);
            throw stepContainerException;
        }
        return true;
    }

    public BLonEnum[] getDOs() {
        return this.digitalOutPut;
    }

    private final void setOptionalOptions() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = 0;
        while (n3 < this.digitalOutPut.length && n < this.ddOptional.length) {
            n2 = 0;
            while (n2 < this.optionalOption.length) {
                if (this.digitalOutPut[n3].getDataAsString().equals(this.optionalText[n2][0]) && !this.digitalOutPut[n3].getDataAsString().equals("doUnused")) {
                    this.ddOptional[n].setEnabled(true);
                    this.ddOptional[n].setSelectedIndex(n2);
                    this.lastConfiguredOption = n++;
                    break;
                }
                ++n2;
            }
            ++n3;
        }
        boolean bl = false;
        if (this.totalConfigured <= totalOutputs) {
            bl = true;
        }
        this.setNextOptionEnable(bl);
    }

    public void intializeDOs() {
        int n = 0;
        while (n < this.digitalOutPut.length) {
            this.digitalOutPut[n] = BLonEnum.make((BEnum)((BLonEnum)this.io.get("DigitalOut" + (n + 1))).getEnum().getRange().get(this.enumText[20][0]));
            System.out.println("*******digitalOutPut from Config.bog******** =  " + this.digitalOutPut[n].getDataAsString());
            ++n;
        }
    }

    private final void setDropDown(int n, int n2, BListDropDown bListDropDown) {
        boolean bl = true;
        int n3 = n;
        while (n3 < n2) {
            bl = true;
            int n4 = 0;
            while (n4 < this.enumText[n3].length && bl) {
                int n5 = 0;
                while (n5 < this.digitalOutPut.length) {
                    if (this.getDigitalOutput(n5).getDataAsString().equalsIgnoreCase(this.enumText[n3][n4])) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    ++n5;
                }
                ++n4;
            }
            if (bl) {
                bListDropDown.setSelectedIndex(n3 - n);
            }
            ++n3;
        }
        bListDropDown.repaint();
    }

    public int getTotalDOConfigured() {
        return this.totalConfigured;
    }

    public BLonEnum getDigitalOutput(int n) {
        return this.digitalOutPut[n];
    }

    public void setDigitalOutput(int n, String string) {
        this.setDigitalOutput(n, BLonEnum.make((BEnum)this.digitalOutPut[n].getEnum().getRange().get(string)));
    }

    public void setDigitalOutput(int n, BLonEnum bLonEnum) {
        this.digitalOutPut[n] = bLonEnum;
    }

    public void setNextOptionEnable(boolean bl) {
        System.out.println("lastConfiguredOption =" + this.lastConfiguredOption);
        System.out.println("enable =" + bl);
        if (this.lastConfiguredOption < 2) {
            if (bl) {
                this.ddOptional[this.lastConfiguredOption + 1].setSelectedIndex(this.optionalOption.length - 1);
                this.ddOptional[this.lastConfiguredOption + 1].setEnabled(true);
            } else {
                int n = this.lastConfiguredOption + 1;
                while (n < this.ddOptional.length) {
                    this.ddOptional[n].setSelectedIndex(this.optionalOption.length - 1);
                    this.ddOptional[n].setEnabled(false);
                    ++n;
                }
            }
        }
    }

    private final void addItems(BList bList, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            bList.addItem((Object)this.enumOptions[n3]);
            ++n3;
        }
        bList.setSelectedIndex(0);
    }

    private final void showHeatMtr(boolean bl) {
        this.txfHeating.setEnabled(bl);
    }

    private final void showPWM(boolean bl) {
        this.txfPeriod.setEnabled(bl);
        this.txfZeroScale.setEnabled(bl);
        this.txfFullScale.setEnabled(bl);
    }

    private final void showCoolMtr(boolean bl) {
        this.txfCooling.setEnabled(bl);
    }

    private final void showEconMtr(boolean bl) {
        this.txfEconomizer.setEnabled(bl);
    }

    public BWidget createMiddlePane() {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        bGridPane.setRowGap(30.0);
        bGridPane.add("outputConfigPane", (BValue)this.createOutputConfigPane());
        bGridPane.add("OptionalPwmPane", (BValue)this.createOptionalPwmPane());
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, 10.0, 20.0, 20.0, 20.0);
        return bBorderPane;
    }

    private final String getTextFromLexicon(String string) {
        return this.getLexicon().getText(string);
    }

    public BWidget createOutputConfigPane() {
        this.lbFanSpeed = new BLabel(this.getTextFromLexicon("UVOutputPane.lbFanSpeed"));
        this.lbFanSpeed.setHalign(BHalign.right);
        this.lbHeating = new BLabel(this.getTextFromLexicon("UVOutputPane.lbHeating"));
        this.lbHeating.setHalign(BHalign.right);
        this.lbCooling = new BLabel(this.getTextFromLexicon("UVOutputPane.lbCooling"));
        this.lbCooling.setHalign(BHalign.right);
        this.lbEconomizer = new BLabel(this.getTextFromLexicon("UVOutputPane.lbEconomizer"));
        this.lbMotorSpeed = new BLabel(this.getTextFromLexicon("UVOutputPane.lbMotorSpeed"));
        BFlowPane[] bFlowPaneArray = new BFlowPane[3];
        int n = 0;
        while (n < bFlowPaneArray.length) {
            bFlowPaneArray[n] = new BFlowPane();
            ++n;
        }
        n = 0;
        this.txfHeating = new BFloatTextField("", 10);
        bFlowPaneArray[n].add("Heating", (BValue)this.txfHeating);
        this.lbHeatingUnit = new BLabel(this.getTextFromLexicon("UVOutputPane.lbSec"));
        bFlowPaneArray[n++].add("HeatLabelSec", (BValue)this.lbHeatingUnit);
        this.txfCooling = new BFloatTextField("", 10);
        bFlowPaneArray[n].add("Cooling", (BValue)this.txfCooling);
        this.lbCoolingUnit = new BLabel(this.getTextFromLexicon("UVOutputPane.lbSec"));
        bFlowPaneArray[n++].add("CoolLabelSec", (BValue)this.lbCoolingUnit);
        this.txfEconomizer = new BFloatTextField("", 10);
        bFlowPaneArray[n].add("Economizer", (BValue)this.txfEconomizer);
        this.lbEconomizerUnit = new BLabel(this.getTextFromLexicon("UVOutputPane.lbSec"));
        bFlowPaneArray[n++].add("EconLabelSec", (BValue)this.lbEconomizerUnit);
        BCanvasPane[] bCanvasPaneArray = new BCanvasPane[4];
        n = 0;
        while (n < bCanvasPaneArray.length) {
            bCanvasPaneArray[n] = new BCanvasPane();
            bCanvasPaneArray[n].setViewSize(BSize.make((double)140.0, (double)20.0));
            ++n;
        }
        n = 0;
        this.ddFanSpeed = new BListDropDown();
        bCanvasPaneArray[n++].add("FanSpeed", (BValue)this.ddFanSpeed);
        this.ddHeating = new BListDropDown();
        bCanvasPaneArray[n++].add("Heating", (BValue)this.ddHeating);
        this.ddCooling = new BListDropDown();
        bCanvasPaneArray[n++].add("Cooling", (BValue)this.ddCooling);
        this.ddEconomizer = new BListDropDown();
        bCanvasPaneArray[n++].add("Economizer", (BValue)this.ddEconomizer);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add("ControllerType", (BValue)new BLabel(this.getTextFromLexicon("lbUVControllerType")));
        bGridPane.add("txfControllerType", (BValue)new BFloatTextField("W7753A", 8, false));
        this.ddPowerFrequency = new BListDropDown();
        BList bList = this.ddPowerFrequency.getList();
        Class clazz = class$com$honeywell$londevices$axwizard$ui$UV$BPowerFrequencyEnum;
        if (clazz == null) {
            clazz = class$com$honeywell$londevices$axwizard$ui$UV$BPowerFrequencyEnum = BUVOutputPane.class("[Lcom.honeywell.londevices.axwizard.ui.UV.BPowerFrequencyEnum;", false);
        }
        BEnumRange bEnumRange = BEnumRange.make((Type)Sys.loadType((Class)clazz));
        int[] nArray = bEnumRange.getOrdinals();
        n = 0;
        while (n < nArray.length) {
            bList.addItem((Object)bEnumRange.getDisplayTag(nArray[n], null));
            ++n;
        }
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.add("lbPowerFrequency", (BValue)new BLabel("Power Frequency"));
        bGridPane2.add("ddPowerFrequency", (BValue)this.ddPowerFrequency);
        BGridPane bGridPane3 = new BGridPane(2);
        bGridPane3.setValign(BValign.top);
        bGridPane3.setColumnGap(135.0);
        bGridPane3.setRowGap(10.0);
        bGridPane3.add("gridControltype", (BValue)bGridPane);
        bGridPane3.add("gridPowerFreq", (BValue)bGridPane2);
        BGridPane bGridPane4 = new BGridPane(2);
        bGridPane4.setUniformColumnWidth(false);
        bGridPane4.setColumnGap(30.0);
        bGridPane4.setRowGap(20.0);
        n = 0;
        bGridPane4.add("lbFanSpeed", (BValue)this.lbFanSpeed);
        bGridPane4.add("ddFanSpeed", (BValue)bCanvasPaneArray[n++]);
        bGridPane4.add("lbHeating", (BValue)this.lbHeating);
        bGridPane4.add("ddHeating", (BValue)bCanvasPaneArray[n++]);
        bGridPane4.add("lbCooling", (BValue)this.lbCooling);
        bGridPane4.add("ddCooling", (BValue)bCanvasPaneArray[n++]);
        bGridPane4.add("lbEconomizer", (BValue)this.lbEconomizer);
        bGridPane4.add("ddEconomizer", (BValue)bCanvasPaneArray[n++]);
        int n2 = 0;
        BGridPane bGridPane5 = new BGridPane(2);
        bGridPane5.add("lbHeatMtr", (BValue)new BLabel(this.getTextFromLexicon("UVOutputPane.lbHeating")));
        bGridPane5.add("txfHeating", (BValue)bFlowPaneArray[n2++]);
        bGridPane5.add("lbCoolMtr", (BValue)new BLabel(this.getTextFromLexicon("UVOutputPane.lbCooling")));
        bGridPane5.add("txfCooling", (BValue)bFlowPaneArray[n2++]);
        bGridPane5.add("lbEconMtr", (BValue)new BLabel(this.getTextFromLexicon("UVOutputPane.lbEconomizer")));
        bGridPane5.add("txfEconomizer", (BValue)bFlowPaneArray[n2++]);
        bGridPane5.setRowGap(20.0);
        bGridPane5.setColumnGap(10.0);
        bGridPane5.setValign(BValign.top);
        bGridPane5.setHalign(BHalign.left);
        BCanvasPane bCanvasPane = new BCanvasPane();
        bCanvasPane.setViewSize(BSize.make((double)175.0, (double)105.0));
        bCanvasPane.add("gpMotorSettings", (BValue)bGridPane5);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bCanvasPane, this.lbMotorSpeed);
        bBorderPane.setPadding(BInsets.make((double)40.0, (double)5, (double)5, (double)20.0));
        BGridPane bGridPane6 = new BGridPane(2);
        bGridPane6.add("opConfigGrid", (BValue)bGridPane4);
        bGridPane6.add("bpMotorSettings", (BValue)bBorderPane);
        bGridPane6.setColumnGap(45.0);
        bGridPane6.setValign(BValign.top);
        bGridPane6.setHalign(BHalign.left);
        BGridPane bGridPane7 = new BGridPane(1);
        bGridPane7.setRowGap(30.0);
        bGridPane7.add("upperPane", (BValue)bGridPane3);
        bGridPane7.add("lowerPane", (BValue)bGridPane6);
        bGridPane7.setValign(BValign.top);
        bGridPane7.setHalign(BHalign.left);
        BListDropDown[] bListDropDownArray = new BListDropDown[]{this.ddFanSpeed, this.ddHeating, this.ddCooling, this.ddEconomizer};
        this.ddOutput = bListDropDownArray;
        return bGridPane7;
    }

    public BWidget createOptionalPwmPane() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setUniformRowHeight(true);
        bGridPane.setColumnGap(40.0);
        bGridPane.add("optionalPane", (BValue)this.createOptionalPane());
        this.pwmWidget = this.createPwmPane();
        bGridPane.add("pwmPane", (BValue)this.pwmWidget);
        return bGridPane;
    }

    public BWidget createOptionalPane() {
        this.ddOptional = new BListDropDown[3];
        BCanvasPane[] bCanvasPaneArray = new BCanvasPane[this.ddOptional.length];
        int n = 0;
        n = 0;
        while (n < bCanvasPaneArray.length) {
            this.ddOptional[n] = new BListDropDown();
            bCanvasPaneArray[n] = new BCanvasPane();
            bCanvasPaneArray[n].setViewSize(BSize.make((double)120.0, (double)20.0));
            bCanvasPaneArray[n].add("optional", (BValue)this.ddOptional[n]);
            ++n;
        }
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setValign(BValign.top);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setRowGap(20.0);
        bGridPane.setColumnGap((double)5);
        n = 0;
        while (n < bCanvasPaneArray.length) {
            bGridPane.add("label" + n, (BValue)new BLabel(new String("" + (n + 1) + '.')));
            bGridPane.add("ddOptional" + n, (BValue)bCanvasPaneArray[n]);
            ++n;
        }
        this.lbOptionalPoint = new BLabel(this.getTextFromLexicon("UVOutputPane.lbOptionalPoint"));
        BCanvasPane bCanvasPane = new BCanvasPane();
        bCanvasPane.setViewSize(BSize.make((double)195.0, (double)100.0));
        bCanvasPane.add("optionalGridPane", (BValue)bGridPane);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bCanvasPane, this.lbOptionalPoint);
        bBorderPane.setPadding(BInsets.make((double)20.0, (double)20.0, (double)20.0, (double)10.0));
        return bBorderPane;
    }

    public BPane createPwmPane() {
        this.lbPeriod = new BLabel(this.getTextFromLexicon("UVOutputPane.lbPeriod"));
        this.lbFullScale = new BLabel(this.getTextFromLexicon("UVOutputPane.lbFullScale"));
        this.lbZeroScale = new BLabel(this.getTextFromLexicon("UVOutputPane.lbZeroScale"));
        this.txfFullScale = new BFloatTextField("", 10);
        this.txfPeriod = new BFloatTextField("", 10);
        this.txfZeroScale = new BFloatTextField("", 10);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setValign(BValign.top);
        bGridPane.setHalign(BHalign.center);
        bGridPane.setRowGap(20.0);
        bGridPane.setColumnGap(10.0);
        bGridPane.add("lbPeriod", (BValue)this.lbPeriod);
        BFlowPane bFlowPane = new BFlowPane();
        bFlowPane.add("txfPeriod", (BValue)this.txfPeriod);
        this.lbPeriodUnit = new BLabel(this.getTextFromLexicon("UVOutputPane.lbSec"));
        bFlowPane.add("lbSecPeriod", (BValue)this.lbPeriodUnit);
        bGridPane.add("pwmFlow1", (BValue)bFlowPane);
        bGridPane.add("lbZeroScale", (BValue)this.lbZeroScale);
        BFlowPane bFlowPane2 = new BFlowPane();
        bFlowPane2.add("txfZeroScale", (BValue)this.txfZeroScale);
        this.lbZeroScaleUnit = new BLabel(this.getTextFromLexicon("UVOutputPane.lbSec"));
        bFlowPane2.add("lbSecZeroScale", (BValue)this.lbZeroScaleUnit);
        bGridPane.add("pwmFlow2", (BValue)bFlowPane2);
        bGridPane.add("lbFullScale", (BValue)this.lbFullScale);
        BFlowPane bFlowPane3 = new BFlowPane();
        bFlowPane3.add("txfFullScale", (BValue)this.txfFullScale);
        this.lbFullScaleUnit = new BLabel(this.getTextFromLexicon("UVOutputPane.lbSec"));
        bFlowPane3.add("lbSecFullScale", (BValue)this.lbFullScaleUnit);
        bGridPane.add("pwmFlow3", (BValue)bFlowPane3);
        this.lbPwmSetting = new BLabel(this.getTextFromLexicon("UVOutputPane.lbPWMSetting"));
        BCanvasPane bCanvasPane = new BCanvasPane();
        bCanvasPane.setViewSize(BSize.make((double)175.0, (double)100.0));
        bCanvasPane.add("pwmGrid", (BValue)bGridPane);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bCanvasPane, this.lbPwmSetting);
        bBorderPane.setPadding(BInsets.make((double)20.0, (double)20.0, (double)20.0, (double)10.0));
        return bBorderPane;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.totalConfigured = 0;
        this.lastConfiguredOption = -1;
        this.enumOptions = new String[]{"No_Fan", "One_Speed", "Two_Speed", "Three_Speed", "No_Heating", "Heating_Stage_1", "Heating_Stage_2", "Heating_PWM", "Heating_Floating", "No_Cooling", "Cooling_Stage_1", "Cooling_Stage_2", "Cooling_PWM", "Cooling_Floating", "Econo_None_Pkgd", "Econo_PWM", "Econo_Floating", "Status_Occupied", "Aux_Econ1", "Free1", "Unused"};
        this.enumText = new String[][]{new String[0], {"DOFanStage1"}, {"DOFanStage1", "DOFanStage2"}, {"DOFanStage1", "DOFanStage2", "DOFanStage3"}, new String[0], {"DOHeat1"}, {"DOHeat1", "DOHeat2"}, {"DOHeatPwm"}, {"DOHeatOpen", "DOHeatClose"}, new String[0], {"DOCoo1"}, {"DOCoo1", "DOCool2"}, {"DOCoolPwm"}, {"DOCoolOpen", "DOCoolClose"}, new String[0], {"DOEconPwm"}, {"DOEconOpen", "DOEconClose"}, {"DOOccupancyStatus"}, {"DOAuxEcon"}, {"DOFree1"}, {"doUnused"}};
        this.optionalOption = new String[]{"Status_Occupied", "Aux_Econ1", "Free1", "Unused"};
        this.optionalText = new String[][]{{"DOOccupancyStatus"}, {"DOAuxEcon"}, {"DOFree1"}, {"doUnused"}};
        this.digitalOutPut = new BLonEnum[8];
    }

    public BUVOutputPane(BExcel10UnitVent bExcel10UnitVent, BUVConfigView bUVConfigView) {
        BList bList;
        this.this();
        try {
            this.deviceObject = bExcel10UnitVent;
            this.parent = bUVConfigView;
            if (bExcel10UnitVent == null) {
                System.out.println("uvDevice is null");
            }
            this.displayWidget = this.createMiddlePane();
            bList = this.ddFanSpeed.getList();
            this.addItems(bList, 0, 4);
            bList = this.ddHeating.getList();
            this.addItems(bList, 4, 9);
            bList = this.ddCooling.getList();
            this.addItems(bList, 9, 14);
            bList = this.ddEconomizer.getList();
            this.addItems(bList, 14, 17);
            OptionalSubscriber[] optionalSubscriberArray = new OptionalSubscriber[this.ddOptional.length];
            int n = 0;
            n = 0;
            while (n < this.ddOptional.length) {
                bList = this.ddOptional[n].getList();
                int n2 = 0;
                while (n2 < this.optionalOption.length) {
                    bList.addItem((Object)this.optionalOption[n2]);
                    ++n2;
                }
                this.ddOptional[n].setSelectedIndex(this.optionalOption.length - 1);
                this.ddOptional[n].setEnabled(false);
                optionalSubscriberArray[n] = new OptionalSubscriber(n);
                optionalSubscriberArray[n].subscribe((BComponent)this.ddOptional[n].getList());
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BDialog.message(null, (Object)this.getTextFromLexicon("UVOutputPane.ConstructionErr"));
        }
        new WidgetSubscriber(){

            public final void actionPerformed(BWidgetEvent bWidgetEvent) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                boolean bl = false;
                int n7 = 0;
                try {
                    n = 0;
                    while (n < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddFanSpeed.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n])) {
                            n7 = BUVOutputPane.this.enumText[n].length;
                            break;
                        }
                        ++n;
                    }
                    n2 = 0;
                    while (n2 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddHeating.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n2])) {
                            n7 += BUVOutputPane.this.enumText[n2].length;
                            break;
                        }
                        ++n2;
                    }
                    n3 = 0;
                    while (n3 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddCooling.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n3])) {
                            n7 += BUVOutputPane.this.enumText[n3].length;
                            break;
                        }
                        ++n3;
                    }
                    n4 = 0;
                    while (n4 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddEconomizer.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n4])) {
                            n7 += BUVOutputPane.this.enumText[n4].length;
                            break;
                        }
                        ++n4;
                    }
                    n5 = 0;
                    while (n5 < BUVOutputPane.this.ddOptional.length) {
                        n6 = 0;
                        while (n6 < BUVOutputPane.this.optionalOption.length) {
                            if (BUVOutputPane.this.ddOptional[n5].getSelectedItem().equals(BUVOutputPane.this.optionalOption[n6]) && !BUVOutputPane.this.optionalOption[n6].equals("Unused")) {
                                ++n7;
                                break;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    System.out.println("OutputConfigured = " + n7);
                    if (n7 > totalOutputs) {
                        BUVOutputPane.this.ddFanSpeed.setSelectedItem((Object)BUVOutputPane.this.enumOptions[0]);
                        BDialog.message((BWidget)BUVOutputPane.this.ddFanSpeed, (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.MaxError"));
                    } else {
                        BUVOutputPane.this.totalConfigured = n7;
                        System.out.println("totalConfigured = " + BUVOutputPane.this.totalConfigured);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    BDialog.message((BWidget)BUVOutputPane.this.ddFanSpeed, (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.FanSpeedErr"));
                }
            }
        }.subscribe((BComponent)this.ddFanSpeed.getList());
        new WidgetSubscriber(){

            public final void actionPerformed(BWidgetEvent bWidgetEvent) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                boolean bl = false;
                int n7 = 0;
                try {
                    n = 0;
                    while (n < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddFanSpeed.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n])) {
                            n7 = BUVOutputPane.this.enumText[n].length;
                            break;
                        }
                        ++n;
                    }
                    n2 = 0;
                    while (n2 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddHeating.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n2])) {
                            n7 += BUVOutputPane.this.enumText[n2].length;
                            break;
                        }
                        ++n2;
                    }
                    n3 = 0;
                    while (n3 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddCooling.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n3])) {
                            n7 += BUVOutputPane.this.enumText[n3].length;
                            break;
                        }
                        ++n3;
                    }
                    n4 = 0;
                    while (n4 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddEconomizer.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n4])) {
                            n7 += BUVOutputPane.this.enumText[n4].length;
                            break;
                        }
                        ++n4;
                    }
                    n5 = 0;
                    while (n5 < BUVOutputPane.this.ddOptional.length) {
                        n6 = 0;
                        while (n6 < BUVOutputPane.this.optionalOption.length) {
                            if (BUVOutputPane.this.ddOptional[n5].getSelectedItem().equals(BUVOutputPane.this.optionalOption[n6]) && !BUVOutputPane.this.optionalOption[n6].equals("Unused")) {
                                ++n7;
                                break;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    System.out.println("OutputConfigured = " + n7);
                    if (n7 > totalOutputs) {
                        BUVOutputPane.this.ddHeating.setSelectedItem((Object)BUVOutputPane.this.enumOptions[4]);
                        boolean bl2 = false;
                        if (BUVOutputPane.this.ddHeating.getSelectedIndex() == heatPwm || BUVOutputPane.this.ddCooling.getSelectedIndex() == coolPwm || BUVOutputPane.this.ddEconomizer.getSelectedIndex() == econPwm) {
                            bl2 = true;
                        }
                        BUVOutputPane.this.showPWM(bl2);
                        BDialog.message((BWidget)BUVOutputPane.this.ddHeating, (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.MaxError"));
                    } else {
                        BUVOutputPane.this.totalConfigured = n7;
                        System.out.println("totalconfig = " + BUVOutputPane.this.totalConfigured);
                        BUVOutputPane.this.txfHeating.setEnabled(((BList)bWidgetEvent.getWidget()).getSelectedItem().equals(BUVOutputPane.this.enumOptions[8]));
                        boolean bl3 = false;
                        if (BUVOutputPane.this.ddHeating.getSelectedIndex() == heatPwm || BUVOutputPane.this.ddCooling.getSelectedIndex() == coolPwm || BUVOutputPane.this.ddEconomizer.getSelectedIndex() == econPwm) {
                            bl3 = true;
                        }
                        BUVOutputPane.this.showPWM(bl3);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    BDialog.message((BWidget)BUVOutputPane.this.ddHeating, (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.HeatingErr"));
                }
            }
        }.subscribe((BComponent)this.ddHeating.getList());
        new WidgetSubscriber(){

            public final void actionPerformed(BWidgetEvent bWidgetEvent) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                boolean bl = false;
                int n7 = 0;
                try {
                    n = 0;
                    while (n < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddFanSpeed.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n])) {
                            n7 = BUVOutputPane.this.enumText[n].length;
                            break;
                        }
                        ++n;
                    }
                    n2 = 0;
                    while (n2 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddHeating.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n2])) {
                            n7 += BUVOutputPane.this.enumText[n2].length;
                            break;
                        }
                        ++n2;
                    }
                    n3 = 0;
                    while (n3 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddCooling.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n3])) {
                            n7 += BUVOutputPane.this.enumText[n3].length;
                            break;
                        }
                        ++n3;
                    }
                    n4 = 0;
                    while (n4 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddEconomizer.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n4])) {
                            n7 += BUVOutputPane.this.enumText[n4].length;
                            break;
                        }
                        ++n4;
                    }
                    n5 = 0;
                    while (n5 < BUVOutputPane.this.ddOptional.length) {
                        n6 = 0;
                        while (n6 < BUVOutputPane.this.optionalOption.length) {
                            if (BUVOutputPane.this.ddOptional[n5].getSelectedItem().equals(BUVOutputPane.this.optionalOption[n6]) && !BUVOutputPane.this.optionalOption[n6].equals("Unused")) {
                                ++n7;
                                break;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    System.out.println("OutputConfigured = " + n7);
                    if (n7 > totalOutputs) {
                        BUVOutputPane.this.ddCooling.setSelectedItem((Object)BUVOutputPane.this.enumOptions[9]);
                        boolean bl2 = false;
                        if (BUVOutputPane.this.ddHeating.getSelectedIndex() == heatPwm || BUVOutputPane.this.ddCooling.getSelectedIndex() == coolPwm || BUVOutputPane.this.ddEconomizer.getSelectedIndex() == econPwm) {
                            bl2 = true;
                        }
                        BUVOutputPane.this.showPWM(bl2);
                        BDialog.message((BWidget)BUVOutputPane.this.ddCooling, (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.MaxError"));
                    } else {
                        BUVOutputPane.this.totalConfigured = n7;
                        BUVOutputPane.this.txfCooling.setEnabled(((BList)bWidgetEvent.getWidget()).getSelectedItem().equals(BUVOutputPane.this.enumOptions[13]));
                        boolean bl3 = false;
                        if (BUVOutputPane.this.ddHeating.getSelectedIndex() == heatPwm || BUVOutputPane.this.ddCooling.getSelectedIndex() == coolPwm || BUVOutputPane.this.ddEconomizer.getSelectedIndex() == econPwm) {
                            bl3 = true;
                        }
                        BUVOutputPane.this.showPWM(bl3);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    BDialog.message((BWidget)BUVOutputPane.this.ddCooling, (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.CoolingErr"));
                }
            }
        }.subscribe((BComponent)this.ddCooling.getList());
        new WidgetSubscriber(){

            public final void actionPerformed(BWidgetEvent bWidgetEvent) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                boolean bl = false;
                int n7 = 0;
                try {
                    n = 0;
                    while (n < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddFanSpeed.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n])) {
                            n7 = BUVOutputPane.this.enumText[n].length;
                            break;
                        }
                        ++n;
                    }
                    n2 = 0;
                    while (n2 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddHeating.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n2])) {
                            n7 += BUVOutputPane.this.enumText[n2].length;
                            break;
                        }
                        ++n2;
                    }
                    n3 = 0;
                    while (n3 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddCooling.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n3])) {
                            n7 += BUVOutputPane.this.enumText[n3].length;
                            break;
                        }
                        ++n3;
                    }
                    n4 = 0;
                    while (n4 < BUVOutputPane.this.enumOptions.length) {
                        if (BUVOutputPane.this.ddEconomizer.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n4])) {
                            n7 += BUVOutputPane.this.enumText[n4].length;
                            break;
                        }
                        ++n4;
                    }
                    n5 = 0;
                    while (n5 < BUVOutputPane.this.ddOptional.length) {
                        n6 = 0;
                        while (n6 < BUVOutputPane.this.optionalOption.length) {
                            if (BUVOutputPane.this.ddOptional[n5].getSelectedItem().equals(BUVOutputPane.this.optionalOption[n6]) && !BUVOutputPane.this.optionalOption[n6].equals("Unused")) {
                                ++n7;
                                break;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    System.out.println("OutputConfigured = " + n7);
                    if (n7 > totalOutputs) {
                        BUVOutputPane.this.ddEconomizer.setSelectedItem((Object)BUVOutputPane.this.enumOptions[14]);
                        boolean bl2 = false;
                        if (BUVOutputPane.this.ddHeating.getSelectedIndex() == heatPwm || BUVOutputPane.this.ddCooling.getSelectedIndex() == coolPwm || BUVOutputPane.this.ddEconomizer.getSelectedIndex() == econPwm) {
                            bl2 = true;
                        }
                        BUVOutputPane.this.showPWM(bl2);
                        BDialog.message((BWidget)BUVOutputPane.this.ddEconomizer, (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.MaxError"));
                    } else {
                        BUVOutputPane.this.totalConfigured = n7;
                        BUVOutputPane.this.txfEconomizer.setEnabled(((BList)bWidgetEvent.getWidget()).getSelectedItem().equals(BUVOutputPane.this.enumOptions[16]));
                        boolean bl3 = false;
                        if (BUVOutputPane.this.ddHeating.getSelectedIndex() == heatPwm || BUVOutputPane.this.ddCooling.getSelectedIndex() == coolPwm || BUVOutputPane.this.ddEconomizer.getSelectedIndex() == econPwm) {
                            bl3 = true;
                        }
                        BUVOutputPane.this.showPWM(bl3);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    BDialog.message((BWidget)BUVOutputPane.this.ddEconomizer, (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.EconErr"));
                }
            }
        }.subscribe((BComponent)this.ddEconomizer.getList());
        bList = new FireModifiedSubscriber[5];
        int n = 0;
        while (n < 5) {
            bList[n] = new FireModifiedSubscriber(n);
            ++n;
        }
        bList[0].subscribe((BComponent)this.ddFanSpeed.getList());
        bList[1].subscribe((BComponent)this.ddHeating.getList());
        bList[2].subscribe((BComponent)this.ddCooling.getList());
        bList[3].subscribe((BComponent)this.ddEconomizer.getList());
        n = 0;
        while (n < this.ddOptional.length) {
            bList[4].subscribe((BComponent)this.ddOptional[n].getList());
            ++n;
        }
    }

    static {
        Class clazz = class$com$honeywell$londevices$axwizard$ui$UV$BUVOutputPane;
        if (clazz == null) {
            clazz = class$com$honeywell$londevices$axwizard$ui$UV$BUVOutputPane = BUVOutputPane.class("[Lcom.honeywell.londevices.axwizard.ui.UV.BUVOutputPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class OptionalSubscriber
    extends WidgetSubscriber {
        int index;

        public void actionPerformed(BWidgetEvent bWidgetEvent) {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            n = 0;
            while (n < BUVOutputPane.this.ddOptional.length) {
                if (this.index != n && BUVOutputPane.this.ddOptional[this.index].getSelectedItem().equals(BUVOutputPane.this.ddOptional[n].getSelectedItem()) && !BUVOutputPane.this.ddOptional[this.index].getSelectedItem().equals("Unused")) {
                    BUVOutputPane.this.ddOptional[this.index].setSelectedIndex(BUVOutputPane.this.optionalOption.length - 1);
                    BDialog.error((BWidget)BUVOutputPane.this.ddOptional[this.index], (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.DuplicateError"));
                    bl = true;
                    break;
                }
                ++n;
            }
            if (BUVOutputPane.this.ddOptional[this.index].getSelectedItem().equals(BUVOutputPane.this.optionalOption[BUVOutputPane.this.optionalOption.length - 1])) {
                BUVOutputPane.this.lastConfiguredOption = this.index;
                switch (this.index) {
                    case 0: {
                        BUVOutputPane.this.ddOptional[1].setSelectedIndex(BUVOutputPane.this.optionalOption.length - 1);
                    }
                    case 1: {
                        BUVOutputPane.this.ddOptional[2].setSelectedIndex(BUVOutputPane.this.optionalOption.length - 1);
                        BUVOutputPane.this.setNextOptionEnable(false);
                    }
                }
            } else {
                System.out.println("You clicked on " + this.index);
                BUVOutputPane.this.lastConfiguredOption = this.index;
                n = 0;
                while (n < BUVOutputPane.this.enumOptions.length) {
                    if (BUVOutputPane.this.ddFanSpeed.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n])) {
                        n7 = BUVOutputPane.this.enumText[n].length;
                        break;
                    }
                    ++n;
                }
                n2 = 0;
                while (n2 < BUVOutputPane.this.enumOptions.length) {
                    if (BUVOutputPane.this.ddHeating.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n2])) {
                        n7 += BUVOutputPane.this.enumText[n2].length;
                        break;
                    }
                    ++n2;
                }
                n3 = 0;
                while (n3 < BUVOutputPane.this.enumOptions.length) {
                    if (BUVOutputPane.this.ddCooling.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n3])) {
                        n7 += BUVOutputPane.this.enumText[n3].length;
                        break;
                    }
                    ++n3;
                }
                n4 = 0;
                while (n4 < BUVOutputPane.this.enumOptions.length) {
                    if (BUVOutputPane.this.ddEconomizer.getSelectedItem().equals(BUVOutputPane.this.enumOptions[n4])) {
                        n7 += BUVOutputPane.this.enumText[n4].length;
                        break;
                    }
                    ++n4;
                }
                n5 = 0;
                while (n5 <= this.index) {
                    n6 = 0;
                    while (n6 < BUVOutputPane.this.optionalOption.length) {
                        if (BUVOutputPane.this.ddOptional[this.index].getSelectedItem().equals(BUVOutputPane.this.optionalOption[n6]) && !BUVOutputPane.this.optionalOption[n6].equals("Unused")) {
                            ++n7;
                            break;
                        }
                        ++n6;
                    }
                    ++n5;
                }
                System.out.println("OutputConfigured = " + n7);
                System.out.println("value of index = " + this.index);
                if (n7 > totalOutputs) {
                    BUVOutputPane.this.ddOptional[this.index].setSelectedIndex(BUVOutputPane.this.optionalOption.length - 1);
                    BDialog.message((BWidget)BUVOutputPane.this.ddOptional[this.index], (Object)BUVOutputPane.this.getTextFromLexicon("UVOutputPane.MaxError"));
                } else {
                    BUVOutputPane.this.totalConfigured = n7;
                    System.out.println("totalConfigured = " + BUVOutputPane.this.totalConfigured);
                    boolean bl2 = false;
                    if (BUVOutputPane.this.totalConfigured <= totalOutputs) {
                        bl2 = true;
                    }
                    BUVOutputPane.this.setNextOptionEnable(bl2);
                }
            }
        }

        public OptionalSubscriber(int n) {
            this.index = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FireModifiedSubscriber
    extends WidgetSubscriber {
        private static final int nDischargeTempPt3000Index = 2;
        private static final int nDischargeTemp20KntcIndex = 6;
        private static final int nHeatCoolFloatingIndex = 4;
        private static final int nHeatCoolPwmIndex = 3;
        int index;
        int[] modifiedSteps;

        public void actionPerformed(BWidgetEvent bWidgetEvent) {
            BStep[] bStepArray = BUVOutputPane.this.parent.getSteps();
            if (1 == this.index || 2 == this.index) {
                if (!(2 != BUVOutputPane.this.parent.uvInputPaneObj.lddRI1.getSelectedIndex() && 2 != BUVOutputPane.this.parent.uvInputPaneObj.lddRI2.getSelectedIndex() && 6 != BUVOutputPane.this.parent.uvInputPaneObj.lddRI1.getSelectedIndex() && 6 != BUVOutputPane.this.parent.uvInputPaneObj.lddRI2.getSelectedIndex() || 4 != BUVOutputPane.this.ddHeating.getSelectedIndex() && 4 != BUVOutputPane.this.ddCooling.getSelectedIndex() && 3 != BUVOutputPane.this.ddHeating.getSelectedIndex() && 3 != BUVOutputPane.this.ddCooling.getSelectedIndex())) {
                    this.modifiedSteps = new int[3];
                    this.modifiedSteps[0] = 8;
                    this.modifiedSteps[1] = 9;
                    this.modifiedSteps[2] = 2;
                    System.out.println("modifiedsteps Length = 3");
                } else {
                    this.modifiedSteps = new int[2];
                    this.modifiedSteps[0] = 8;
                    this.modifiedSteps[1] = 9;
                    System.out.println("modifiedsteps Length = 2a");
                }
            } else {
                this.modifiedSteps = new int[2];
                this.modifiedSteps[0] = 8;
                this.modifiedSteps[1] = 9;
                System.out.println("modifiedsteps Length = 2b");
            }
            bStepArray[0].fireStepModified(new BStepModifiedEvent(this.modifiedSteps));
        }

        private final /* synthetic */ void this() {
            this.index = 0;
        }

        public FireModifiedSubscriber(int n) {
            this.this();
            this.index = n;
        }
    }
}

