/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Stack;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BAbstractPollService;
import javax.baja.driver.util.BIPollable;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BPollScheduler
extends BAbstractPollService
implements Runnable {
    public static final Property fastRate = BPollScheduler.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L), (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property normalRate = BPollScheduler.newProperty((int)0, (BValue)BRelTime.make((long)5000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L), (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property slowRate = BPollScheduler.newProperty((int)0, (BValue)BRelTime.make((long)30000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L), (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property statisticsStart = BPollScheduler.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property averagePoll = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property busyTime = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property totalPolls = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property dibsPolls = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property fastPolls = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property normalPolls = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property slowPolls = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property dibsCount = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property fastCount = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property normalCount = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property slowCount = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property fastCycleTime = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property normalCycleTime = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Property slowCycleTime = BPollScheduler.newProperty((int)3, (String)"-", null);
    public static final Action resetStatistics = BPollScheduler.newAction((int)128, null);
    public static final Type TYPE;
    static final DecimalFormat timeFormat;
    boolean isAlive;
    Thread thread;
    long start;
    long totalPollTime;
    int totalPollCount;
    double average;
    Stack dibs;
    int dibsPollTotal;
    int dibsSizeTotal;
    Object lock;
    int statsCount;
    Bucket fast;
    Bucket norm;
    Bucket slow;
    static /* synthetic */ Class class$javax$baja$driver$util$BPollScheduler;

    public BRelTime getFastRate() {
        return (BRelTime)this.get(fastRate);
    }

    public void setFastRate(BRelTime bRelTime) {
        this.set(fastRate, (BValue)bRelTime, null);
    }

    public BRelTime getNormalRate() {
        return (BRelTime)this.get(normalRate);
    }

    public void setNormalRate(BRelTime bRelTime) {
        this.set(normalRate, (BValue)bRelTime, null);
    }

    public BRelTime getSlowRate() {
        return (BRelTime)this.get(slowRate);
    }

    public void setSlowRate(BRelTime bRelTime) {
        this.set(slowRate, (BValue)bRelTime, null);
    }

    public BAbsTime getStatisticsStart() {
        return (BAbsTime)this.get(statisticsStart);
    }

    public void setStatisticsStart(BAbsTime bAbsTime) {
        this.set(statisticsStart, (BValue)bAbsTime, null);
    }

    public String getAveragePoll() {
        return this.getString(averagePoll);
    }

    public void setAveragePoll(String string) {
        this.setString(averagePoll, string, null);
    }

    public String getBusyTime() {
        return this.getString(busyTime);
    }

    public void setBusyTime(String string) {
        this.setString(busyTime, string, null);
    }

    public String getTotalPolls() {
        return this.getString(totalPolls);
    }

    public void setTotalPolls(String string) {
        this.setString(totalPolls, string, null);
    }

    public String getDibsPolls() {
        return this.getString(dibsPolls);
    }

    public void setDibsPolls(String string) {
        this.setString(dibsPolls, string, null);
    }

    public String getFastPolls() {
        return this.getString(fastPolls);
    }

    public void setFastPolls(String string) {
        this.setString(fastPolls, string, null);
    }

    public String getNormalPolls() {
        return this.getString(normalPolls);
    }

    public void setNormalPolls(String string) {
        this.setString(normalPolls, string, null);
    }

    public String getSlowPolls() {
        return this.getString(slowPolls);
    }

    public void setSlowPolls(String string) {
        this.setString(slowPolls, string, null);
    }

    public String getDibsCount() {
        return this.getString(dibsCount);
    }

    public void setDibsCount(String string) {
        this.setString(dibsCount, string, null);
    }

    public String getFastCount() {
        return this.getString(fastCount);
    }

    public void setFastCount(String string) {
        this.setString(fastCount, string, null);
    }

    public String getNormalCount() {
        return this.getString(normalCount);
    }

    public void setNormalCount(String string) {
        this.setString(normalCount, string, null);
    }

    public String getSlowCount() {
        return this.getString(slowCount);
    }

    public void setSlowCount(String string) {
        this.setString(slowCount, string, null);
    }

    public String getFastCycleTime() {
        return this.getString(fastCycleTime);
    }

    public void setFastCycleTime(String string) {
        this.setString(fastCycleTime, string, null);
    }

    public String getNormalCycleTime() {
        return this.getString(normalCycleTime);
    }

    public void setNormalCycleTime(String string) {
        this.setString(normalCycleTime, string, null);
    }

    public String getSlowCycleTime() {
        return this.getString(slowCycleTime);
    }

    public void setSlowCycleTime(String string) {
        this.setString(slowCycleTime, string, null);
    }

    public void resetStatistics() {
        this.invoke(resetStatistics, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void poll(BIPollable bIPollable) {
        long l = Clock.ticks();
        try {
            this.doPoll(bIPollable);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        long l2 = Clock.ticks();
        ++this.totalPollCount;
        this.totalPollTime += l2 - l;
        this.average = (double)this.totalPollTime / (double)this.totalPollCount;
    }

    public abstract void doPoll(BIPollable var1) throws Exception;

    public void started() {
        if (Sys.isStationStarted()) {
            this.startThread();
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.startThread();
    }

    public void stopped() {
        this.stopThread();
    }

    public void startThread() {
        this.doResetStatistics();
        this.stopThread();
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, "Poll:" + this.getParent().getName());
        this.thread.start();
    }

    public void stopThread() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void run() {
        long l = Clock.ticks() + 10000L;
        while (this.isAlive) {
            try {
                if (!this.getPollEnabled()) {
                    Thread.sleep(1000L);
                    continue;
                }
                this.pollDibs();
                this.pollQueues();
                long l2 = this.computeSleep();
                if (l2 > 0L) {
                    Thread.sleep(l2);
                }
                if (Clock.ticks() <= l) continue;
                this.checkBucketConfig();
                this.updateStats();
                l = Clock.ticks() + 10000L;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void pollDibs() {
        while (true) {
            BIPollable bIPollable = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.dibs.empty()) {
                    return;
                }
                bIPollable = (BIPollable)this.dibs.pop();
                ++this.dibsPollTotal;
            }
            this.poll(bIPollable);
        }
    }

    private final void pollQueues() {
        this.pollQueue(this.fast);
        this.pollQueue(this.norm);
        this.pollQueue(this.slow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void pollQueue(Bucket bucket) {
        long l;
        int n;
        BIPollable bIPollable;
        block9: {
            if (bucket.nextTicks > Clock.ticks() + (long)5) {
                return;
            }
            bIPollable = null;
            n = 0;
            Object object = this.lock;
            synchronized (object) {
                block8: {
                    int n2 = bucket.index;
                    n = bucket.q.size();
                    if (n <= 0) break block8;
                    if (n2 >= n) {
                        n2 = 0;
                        ++bucket.cycleTotal;
                    }
                    bIPollable = (BIPollable)bucket.q.get(n2);
                    bucket.index = n2 + 1;
                    break block9;
                }
                ++bucket.cycleTotal;
            }
        }
        long l2 = 0L;
        if (bIPollable != null) {
            l = Clock.ticks();
            this.poll(bIPollable);
            l2 = Clock.ticks() - l;
            ++bucket.pollTotal;
        }
        long l3 = l = ((BRelTime)this.get(bucket.rateProp)).getMillis();
        if (n > 0) {
            double d = l;
            double d2 = n;
            l3 = (long)((d - d2 * (double)l2) / d2);
        } else {
            l3 = 1000L;
        }
        bucket.nextTicks = Clock.ticks() + l3;
    }

    private final long computeSleep() {
        long l = Clock.ticks();
        long l2 = 1000L;
        l2 = Math.min(this.fast.nextTicks - l, l2);
        l2 = Math.min(this.norm.nextTicks - l, l2);
        l2 = Math.min(this.slow.nextTicks - l, l2);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void checkBucketConfig() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            BPollScheduler.reSort(this.fast.q, arrayList, arrayList2, arrayList3);
            BPollScheduler.reSort(this.norm.q, arrayList, arrayList2, arrayList3);
            BPollScheduler.reSort(this.slow.q, arrayList, arrayList2, arrayList3);
            this.fast.q = arrayList;
            this.norm.q = arrayList2;
            this.slow.q = arrayList3;
            return;
        }
    }

    private static final void reSort(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            BIPollable bIPollable = (BIPollable)arrayList.get(n2);
            switch (bIPollable.getPollFrequency().getOrdinal()) {
                case 0: {
                    arrayList2.add(bIPollable);
                    break;
                }
                case 1: {
                    arrayList3.add(bIPollable);
                    break;
                }
                case 2: {
                    arrayList4.add(bIPollable);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++n2;
        }
    }

    public void doResetStatistics() {
        this.totalPollTime = 0L;
        this.totalPollCount = 0;
        this.average = 0.0;
        this.statsCount = 0;
        this.dibsPollTotal = 0;
        this.dibsSizeTotal = 0;
        this.fast.reset();
        this.norm.reset();
        this.slow.reset();
        this.start = Clock.ticks();
        this.setStatisticsStart(Clock.time());
        this.updateStats();
    }

    private final void updateStats() {
        long l = Clock.ticks();
        long l2 = l - this.start;
        ++this.statsCount;
        this.setAveragePoll(timeFormat.format(this.average));
        if (this.totalPollTime > 0L) {
            this.setBusyTime((int)(100.0 * ((double)this.totalPollTime / (double)l2)) + "% (" + this.duration(this.totalPollTime) + '/' + this.duration(l2) + ')');
        }
        this.setTotalPolls(this.count(this.totalPollCount) + " over " + this.duration(this.totalPollTime));
        this.setDibsPolls(this.toPollTotal(this.dibsPollTotal));
        this.setFastPolls(this.toPollTotal(this.fast.pollTotal));
        this.setNormalPolls(this.toPollTotal(this.norm.pollTotal));
        this.setSlowPolls(this.toPollTotal(this.slow.pollTotal));
        this.setDibsCount(this.toCount(this.dibs.size(), this.dibsSizeTotal));
        this.dibsSizeTotal += this.dibs.size();
        this.setFastCount(this.toCount(this.fast.q.size(), this.fast.sizeTotal));
        this.fast.sizeTotal += this.fast.q.size();
        this.setNormalCount(this.toCount(this.norm.q.size(), this.norm.sizeTotal));
        this.norm.sizeTotal += this.norm.q.size();
        this.setSlowCount(this.toCount(this.slow.q.size(), this.slow.sizeTotal));
        this.slow.sizeTotal += this.slow.q.size();
        this.setFastCycleTime(this.toCycle(this.fast, l2));
        this.setNormalCycleTime(this.toCycle(this.norm, l2));
        this.setSlowCycleTime(this.toCycle(this.slow, l2));
    }

    private final String toPollTotal(int n) {
        int n2 = this.totalPollCount;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 0) {
            stringBuffer.append('-');
        } else {
            stringBuffer.append((int)(100.0 * (double)n / (double)n2));
        }
        stringBuffer.append("% (").append(this.count(n)).append('/').append(this.count(n2)).append(')');
        return stringBuffer.toString();
    }

    private final String toCount(int n, int n2) {
        return "current=" + n + " average=" + n2 / this.statsCount;
    }

    private final String toCycle(Bucket bucket, long l) {
        int n = bucket.cycleTotal;
        if (n == 0) {
            return "-";
        }
        return "average = " + l / (long)n + "ms";
    }

    private final String count(int n) {
        if (n < 10000) {
            return String.valueOf(n);
        }
        return String.valueOf(n / 1000) + 'k';
    }

    private final String duration(long l) {
        if (l < 10000L) {
            return String.valueOf(l) + "ms";
        }
        return String.valueOf(l / 1000L) + "sec";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void subscribe(BIPollable bIPollable) {
        Object object = this.lock;
        synchronized (object) {
            this.dibs.push(bIPollable);
            switch (bIPollable.getPollFrequency().getOrdinal()) {
                case 0: {
                    this.fast.q.add(bIPollable);
                    break;
                }
                case 1: {
                    this.norm.q.add(bIPollable);
                    break;
                }
                case 2: {
                    this.slow.q.add(bIPollable);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unsubscribe(BIPollable bIPollable) {
        Object object = this.lock;
        synchronized (object) {
            int n = 0;
            while (n < this.dibs.size()) {
                if (this.dibs.get(n) == bIPollable) {
                    this.dibs.remove(n);
                    break;
                }
                ++n;
            }
            if (this.fast.remove(bIPollable)) {
                return true;
            }
            if (this.norm.remove(bIPollable)) {
                return true;
            }
            return this.slow.remove(bIPollable);
            {
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.dibs = new Stack();
        this.lock = new Object();
        this.fast = new Bucket(fastRate);
        this.norm = new Bucket(normalRate);
        this.slow = new Bucket(slowRate);
    }

    public BPollScheduler() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$driver$util$BPollScheduler;
        if (clazz == null) {
            clazz = class$javax$baja$driver$util$BPollScheduler = BPollScheduler.class("[Ljavax.baja.driver.util.BPollScheduler;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        timeFormat = new DecimalFormat("0.0#ms");
    }

    static class Bucket {
        Property rateProp;
        ArrayList q = new ArrayList();
        int index;
        long nextTicks;
        int pollTotal;
        int sizeTotal;
        int cycleTotal;

        boolean remove(BIPollable bIPollable) {
            int n = this.q.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.q.get(n2) == bIPollable) {
                    this.q.remove(n2);
                    return true;
                }
                ++n2;
            }
            return false;
        }

        void reset() {
            this.index = 0;
            this.nextTicks = 0L;
            this.pollTotal = 0;
            this.sizeTotal = 0;
            this.cycleTotal = 0;
        }

        Bucket(Property property) {
            this.rateProp = property;
        }
    }
}

