/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.util;

import com.tridium.util.ThrowableUtil;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.util.BDescriptorDeviceExt;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDescriptor
extends BComponent
implements BIStatus {
    public static final Property status = BDescriptor.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property state = BDescriptor.newProperty((int)1, (BValue)BDescriptorState.idle, null);
    public static final Property enabled = BDescriptor.newProperty((int)0, (boolean)true, null);
    public static final Property executionTime = BDescriptor.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make()), null);
    public static final Property lastAttempt = BDescriptor.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property lastSuccess = BDescriptor.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property lastFailure = BDescriptor.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property faultCause = BDescriptor.newProperty((int)3, (String)"", null);
    public static final Action execute = BDescriptor.newAction((int)16, null);
    public static final Type TYPE;
    static TypeInfo archiveType;
    static TypeInfo schedExportType;
    static TypeInfo schedImportType;
    private BDevice device;
    private BDescriptorDeviceExt deviceExt;
    private boolean fatalFault;
    private BDeviceNetwork network;
    private int oldStatus;
    static /* synthetic */ Class class$javax$baja$driver$util$BDescriptor;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public BDescriptorState getState() {
        return (BDescriptorState)this.get(state);
    }

    public void setState(BDescriptorState bDescriptorState) {
        this.set(state, (BValue)bDescriptorState, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BTimeTrigger getExecutionTime() {
        return (BTimeTrigger)this.get(executionTime);
    }

    public void setExecutionTime(BTimeTrigger bTimeTrigger) {
        this.set(executionTime, (BValue)bTimeTrigger, null);
    }

    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    public void setLastAttempt(BAbsTime bAbsTime) {
        this.set(lastAttempt, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastSuccess() {
        return (BAbsTime)this.get(lastSuccess);
    }

    public void setLastSuccess(BAbsTime bAbsTime) {
        this.set(lastSuccess, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastFailure() {
        return (BAbsTime)this.get(lastFailure);
    }

    public void setLastFailure(BAbsTime bAbsTime) {
        this.set(lastFailure, (BValue)bAbsTime, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BDevice getDevice() {
        if (this.device != null) {
            return this.device;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public final BDescriptorDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public final BDeviceNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public void executeOk() {
        this.setFaultCause("");
        this.setLastSuccess(Clock.time());
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public void executeFail() {
        this.executeFail("");
    }

    public void executeFail(String string) {
        if (string == null) {
            string = "";
        }
        this.setLastFailure(Clock.time());
        this.setFaultCause(string);
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public void executeFail(Throwable throwable) {
        this.executeFail(throwable == null ? "" : ThrowableUtil.dumpToString((Throwable)throwable, (int)1));
    }

    public void executeInProgress() {
        this.setState(BDescriptorState.inProgress);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == execute) {
            if (this.isUnoperational()) {
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            return this.postExecute(action, bValue, context);
        }
        return super.post(action, bValue, context);
    }

    protected abstract IFuture postExecute(Action var1, BValue var2, Context var3);

    public abstract void doExecute();

    public boolean isUnoperational() {
        boolean bl = false;
        if (this.fatalFault || this.isDisabled() || this.isDown()) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final void updateStatus() {
        BStatus bStatus;
        int n = this.getStatus().getBits();
        BStatus bStatus2 = bStatus = this.device == null ? BStatus.ok : this.device.getStatus();
        n = !this.getEnabled() || bStatus.isDisabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = bStatus.isDown() ? (n |= 4) : (n &= 0xFFFFFFFB);
        n = this.isFatalFault() || !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) || bStatus.isFault() ? (n |= 2) : (n &= 0xFFFFFFFD);
        if (n == this.oldStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private final void checkFatalFault() {
        Object object;
        BDeviceExt bDeviceExt = null;
        BDevice bDevice = null;
        BDeviceNetwork bDeviceNetwork = null;
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BDescriptorDeviceExt) {
                bDeviceExt = (BDescriptorDeviceExt)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        if (bDeviceExt == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under DescriptorDeviceExt");
            return;
        }
        bDevice = bDeviceExt.getDevice();
        if (bDevice == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under Device");
            return;
        }
        if (bDevice.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Device fault: " + bDevice.getFaultCause());
            return;
        }
        bDeviceNetwork = bDevice.getNetwork();
        if (bDeviceNetwork == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under DeviceNetwork");
            return;
        }
        if (bDeviceNetwork.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + bDeviceNetwork.getFaultCause());
            return;
        }
        String string = this.getLicenseLimitKey();
        if (string != null && (object = bDeviceNetwork.fw(501, string, null, null, null)) != null) {
            this.fatalFault = true;
            this.setFaultCause(object.toString());
            return;
        }
        this.network = bDeviceNetwork;
        this.device = bDevice;
        this.deviceExt = bDeviceExt;
        this.setFaultCause("");
        if (this.network == null || this.device == null || this.deviceExt == null) {
            throw new IllegalStateException();
        }
    }

    private final String getLicenseLimitKey() {
        Type type = this.getType();
        if (archiveType != null && type.is(archiveType)) {
            return "history.limit";
        }
        if (schedImportType != null && type.is(schedImportType)) {
            return "schedule.limit";
        }
        if (schedExportType != null && type.is(schedExportType)) {
            return "schedule.limit";
        }
        return null;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 2: {
                this.fwChanged((Property)object);
                break;
            }
            case 23: {
                this.fwStationStarted();
                break;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwStarted() {
        this.checkFatalFault();
        this.updateStatus();
        this.add(null, (BValue)new BLink(this.getExecutionTime().getOrdInSession(), "fireTrigger", "execute", true), 6);
        if (Sys.isStationStarted()) {
            this.fwStationStarted();
        }
    }

    private final void fwStationStarted() {
        if (this.getState() != BDescriptorState.idle) {
            this.setState(BDescriptorState.idle);
            this.execute();
        }
    }

    private final void fwStopped() {
        Property property = this.getProperty("triggerLink");
        if (property != null) {
            this.remove(property);
        }
        this.network = null;
        this.device = null;
        this.deviceExt = null;
    }

    private final void fwChanged(Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        } else if (property == executionTime) {
            this.add(null, (BValue)new BLink(this.getExecutionTime().getOrdInSession(), "fireTrigger", "execute", true), 6);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldStatus = 16;
    }

    public BDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$driver$util$BDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$driver$util$BDescriptor = BDescriptor.class("[Ljavax.baja.driver.util.BDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        try {
            archiveType = Sys.getRegistry().getType("driver:ArchiveDescriptor");
        }
        catch (Exception exception) {}
        try {
            schedExportType = Sys.getRegistry().getType("schedule:ScheduleExport");
        }
        catch (Exception exception) {}
        try {
            schedImportType = Sys.getRegistry().getType("schedule:ScheduleImportExt");
        }
        catch (Exception exception) {}
    }
}

