/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.history;

import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class ImportModel
extends ArchiveModel {
    static final Lexicon histLex = Lexicon.make((String)"history");

    public int getSubscribeDepth() {
        return 2;
    }

    public Type[] getIncludeTypes() {
        BObject bObject;
        BArchiveManager bArchiveManager = (BArchiveManager)this.getManager();
        if (bArchiveManager.supportsArchiveFolders() && (bObject = bArchiveManager.getCurrentValue()) instanceof BIArchiveFolder) {
            BIArchiveFolder bIArchiveFolder = (BIArchiveFolder)bObject;
            Type type = bIArchiveFolder.getArchiveFolderType();
            return new Type[]{BHistoryImport.TYPE, type};
        }
        return new Type[]{BHistoryImport.TYPE};
    }

    public MgrTypeInfo[] getNewTypes() {
        return MgrTypeInfo.makeArray((Type)BHistoryImport.TYPE);
    }

    public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
        BHistoryImport bHistoryImport = (BHistoryImport)super.newInstance(mgrTypeInfo);
        BComponent bComponent = bHistoryImport.getConfigOverrides();
        bComponent.add("capacity", (BValue)BCapacity.UNLIMITED, 0);
        bComponent.add("fullPolicy", (BValue)BFullPolicy.roll, 0);
        return bHistoryImport;
    }

    protected MgrColumn[] makeColumns() {
        MgrColumn[] mgrColumnArray = super.makeColumns();
        MgrColumn[] mgrColumnArray2 = new MgrColumn[mgrColumnArray.length + 2];
        System.arraycopy(mgrColumnArray, 0, mgrColumnArray2, 0, mgrColumnArray.length);
        mgrColumnArray2[mgrColumnArray2.length - 2] = new ConfigColumn("capacity", histLex.getText("HistoryConfig.capacity"), 3, (BValue)BCapacity.UNLIMITED);
        mgrColumnArray2[mgrColumnArray2.length - 1] = new ConfigColumn("fullPolicy", histLex.getText("HistoryConfig.fullPolicy"), 3, (BValue)BFullPolicy.roll);
        return mgrColumnArray2;
    }

    public ImportModel(BHistoryImportManager bHistoryImportManager) {
        super(bHistoryImportManager);
    }

    public static class ConfigColumn
    extends MgrColumn {
        String propName;
        BValue defaultValue;

        public Object get(Object object) {
            BHistoryImport bHistoryImport = (BHistoryImport)object;
            return bHistoryImport.getConfigOverrides().get(this.propName);
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BValue bValue = (BValue)this.get(mgrEditRow.getTarget());
            if (bValue == null) {
                bValue = this.defaultValue;
            }
            return bValue.newCopy();
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BHistoryImport bHistoryImport = (BHistoryImport)mgrEditRow.getTarget();
            BComponent bComponent = bHistoryImport.getConfigOverrides();
            Property property = bComponent.getProperty(this.propName);
            if (property == null) {
                bComponent.add(this.propName, bValue);
            } else {
                bComponent.set(property, bValue, context);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BValue bValue = mgrEditRowArray[0].getCell(n);
            Property property = BHistoryImport.configOverrides;
            BFacets bFacets = property.getFacets();
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue, (Context)bFacets);
            if (bWbEditor != null && bWbEditor.getClass() == bWbFieldEditor.getClass()) {
                bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            }
            bWbFieldEditor.loadValue((BObject)bValue, (Context)bFacets);
            return bWbFieldEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            BValue bValue = (BValue)bWbFieldEditor.saveValue();
            int n2 = 0;
            while (n2 < mgrEditRowArray.length) {
                mgrEditRowArray[n2].setCell(n, bValue);
                ++n2;
            }
        }

        public ConfigColumn(String string, String string2, int n, BValue bValue) {
            super(string2, n);
            this.propName = string;
            this.defaultValue = bValue;
        }
    }
}

