/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point.conv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLinearConversion
extends BProxyConversion {
    public static final BLinearConversion DEFAULT = new BLinearConversion(1.0, 0.0);
    public static final Type TYPE;
    private double scale;
    private double offset;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$driver$point$conv$BLinearConversion;

    public static final BLinearConversion make(double d, double d2) {
        if (d == 1.0 && d2 == 0.0) {
            return DEFAULT;
        }
        return (BLinearConversion)new BLinearConversion(d, d2).intern();
    }

    public final double getScale() {
        return this.scale;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final void convertDeviceToProxy(BProxyExt bProxyExt, BStatusValue bStatusValue, BStatusValue bStatusValue2) throws Exception {
        if (bStatusValue instanceof BStatusNumeric) {
            this.convert(bProxyExt, (BStatusNumeric)bStatusValue, (BStatusNumeric)bStatusValue2, true);
        } else {
            bStatusValue2.copyFrom((BComplex)bStatusValue);
        }
    }

    public final void convertProxyToDevice(BProxyExt bProxyExt, BStatusValue bStatusValue, BStatusValue bStatusValue2) throws Exception {
        if (bStatusValue instanceof BStatusNumeric) {
            this.convert(bProxyExt, (BStatusNumeric)bStatusValue, (BStatusNumeric)bStatusValue2, false);
        } else {
            bStatusValue2.copyFrom((BComplex)bStatusValue);
        }
    }

    private final void convert(BProxyExt bProxyExt, BStatusNumeric bStatusNumeric, BStatusNumeric bStatusNumeric2, boolean bl) {
        double d = bStatusNumeric.getValue();
        double d2 = bl ? d * this.scale + this.offset : (d - this.offset) / this.scale;
        bStatusNumeric2.setStatus(bStatusNumeric.getStatus());
        bStatusNumeric2.setValue(d2);
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            long l = 23L + Double.doubleToRawLongBits(this.offset);
            l = l * 37L + Double.doubleToRawLongBits(this.scale);
            this.hashCode = (int)(l >>> 32) ^ (int)l;
        }
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (object instanceof BLinearConversion) {
            BLinearConversion bLinearConversion = (BLinearConversion)((Object)object);
            boolean bl = false;
            if (this.scale == bLinearConversion.scale && this.offset == bLinearConversion.offset) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TYPE.getDisplayName(context));
        if (this.scale != 1.0) {
            stringBuffer.append(" *").append(BDouble.toString((double)this.scale, (Context)context));
        }
        if (this.offset < 0.0) {
            stringBuffer.append(' ').append(BDouble.toString((double)this.offset, (Context)context));
        } else if (this.offset > 0.0) {
            stringBuffer.append(" +").append(BDouble.toString((double)this.offset, (Context)context));
        }
        return stringBuffer.toString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.scale);
        dataOutput.writeDouble(this.offset);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BLinearConversion.make(dataInput.readDouble(), dataInput.readDouble());
    }

    public final String encodeToString() {
        return BDouble.encode((double)this.scale) + ';' + BDouble.encode((double)this.offset);
    }

    public final BObject decodeFromString(String string) throws IOException {
        int n = string.indexOf(59);
        return BLinearConversion.make(BDouble.decode((String)string.substring(0, n)), BDouble.decode((String)string.substring(n + 1)));
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
    }

    private BLinearConversion(double d, double d2) {
        this.this();
        this.scale = d;
        this.offset = d2;
    }

    static {
        Class clazz = class$javax$baja$driver$point$conv$BLinearConversion;
        if (clazz == null) {
            clazz = class$javax$baja$driver$point$conv$BLinearConversion = BLinearConversion.class("[Ljavax.baja.driver.point.conv.BLinearConversion;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

