/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point;

import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BITunable;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tuning {
    private static final BIcon icon = BIcon.std((String)"wrench.png");
    static final int FATAL = 1;
    static final int DOWN = 2;
    static final int DISABLED = 4;
    static final int STOP = 8;
    static final int DESIRED_SUB = 16;
    static final int UNOPERATIONAL = 15;
    static final int STATE = 31;
    static final int SUBSCRIBED = 32;
    static final int WRITE_PENDING = 64;
    static final Log log = Log.getLog((String)"driver.tuning");
    static long writeOnDelay = 5000L;
    BITunable parent;
    String cachedPolicyName;
    BTuningPolicy cachedPolicy;
    int packed;
    long readTicks;
    long writeTicks;
    long writeDesiredTicks;
    Context writeDesiredContext;

    /*
     * Unable to fully structure code
     */
    public final BDeviceNetwork getNetwork() {
        var1_1 = (BComplex)this.parent;
        if (!(var1_1 instanceof BProxyExt)) ** GOTO lbl7
        return ((BProxyExt)var1_1).getNetwork();
lbl-1000:
        // 1 sources

        {
            if (var1_1 instanceof BDeviceNetwork) {
                return (BDeviceNetwork)var1_1;
            }
            var1_1 = var1_1.getParent();
lbl7:
            // 2 sources

            ** while (var1_1 != null)
        }
lbl8:
        // 1 sources

        return null;
    }

    public final BTuningPolicyMap getPolicyMap() {
        BTuningPolicyMap bTuningPolicyMap = (BTuningPolicyMap)this.getNetwork().get("tuningPolicies");
        if (bTuningPolicyMap != null) {
            return bTuningPolicyMap;
        }
        throw new IllegalStateException("Network missing tuningPolicies property");
    }

    public BTuningPolicy getPolicy() {
        String string = this.parent.getTuningPolicyName();
        if (this.cachedPolicy == null || this.cachedPolicyName != string) {
            BTuningPolicyMap bTuningPolicyMap = this.getPolicyMap();
            this.cachedPolicyName = string;
            BValue bValue = bTuningPolicyMap.get(this.cachedPolicyName);
            if (bValue instanceof BTuningPolicy) {
                this.cachedPolicy = (BTuningPolicy)bValue;
            } else {
                log.warning("TuningPolicy not found: " + this.cachedPolicyName);
                this.cachedPolicy = bTuningPolicyMap.getDefaultPolicy();
            }
        }
        return this.cachedPolicy;
    }

    public final BITunable getTunable() {
        return this.parent;
    }

    public final long getLastReadTicks() {
        return this.readTicks;
    }

    public final long getLastWriteTicks() {
        return this.writeTicks;
    }

    public final BAbsTime getLastReadTime() {
        if (this.readTicks == 0L) {
            return BAbsTime.NULL;
        }
        return BAbsTime.make((long)(System.currentTimeMillis() - (Clock.ticks() - this.readTicks)));
    }

    public final BAbsTime getLastWriteTime() {
        if (this.writeTicks == 0L) {
            return BAbsTime.NULL;
        }
        return BAbsTime.make((long)(System.currentTimeMillis() - (Clock.ticks() - this.writeTicks)));
    }

    public String toString(Context context) {
        String string = this.parent.getTuningPolicyName();
        if (string.equals("defaultPolicy")) {
            return BTuningPolicyMap.defaultPolicy.getDefaultDisplayName(context);
        }
        return SlotPath.unescape((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transition() {
        if (this.processId() == 0) {
            this.registerForProcessing();
        }
        BITunable bITunable = this.getTunable();
        boolean bl = false;
        boolean bl2 = false;
        Tuning tuning = this;
        synchronized (tuning) {
            boolean bl3;
            boolean bl4;
            int n = Tuning.toState(bITunable);
            int n2 = this.state();
            if (n == n2) {
                return;
            }
            this.state(n);
            if (Tuning.isOperational(n) && bITunable.getMode().isWrite()) {
                BTuningPolicy bTuningPolicy = this.getPolicy();
                if (Tuning.isDownToUp(n2, n) && bTuningPolicy.getWriteOnUp()) {
                    this.writeDesiredTicks = Clock.ticks() + writeOnDelay;
                    this.writeDesiredContext = BTuningPolicy.writeOnUpContext;
                } else if (Tuning.isDisabledToEnabled(n2, n) && bTuningPolicy.getWriteOnEnabled()) {
                    this.writeDesiredTicks = Clock.ticks() + writeOnDelay;
                    this.writeDesiredContext = BTuningPolicy.writeOnEnabledContext;
                } else if (Tuning.isStopToStart(n2, n) && bTuningPolicy.getWriteOnStart()) {
                    this.writeDesiredTicks = Clock.ticks() + writeOnDelay;
                    this.writeDesiredContext = BTuningPolicy.writeOnStartContext;
                }
            }
            if ((bl4 = this.subscribed()) != (bl3 = Tuning.shouldBeSubscribed(n))) {
                this.subscribed(bl3);
                if (bl3) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl34 : MonitorExitStatement: MONITOREXIT : var4_4
            if (bl) {
                this.readSubscribed();
            }
            if (bl2) {
                this.readUnsubscribed();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeDesired() {
        Tuning tuning = this;
        synchronized (tuning) {
            if (!Tuning.isOperational(this.state())) {
                return;
            }
            long l = this.getPolicy().getMinWriteTime().getMillis();
            if (l > 0L) {
                if (this.writeDesiredTicks < 0L) {
                    this.writeDesiredTicks = Clock.ticks();
                }
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
            this.write(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readOk() {
        Tuning tuning = this;
        synchronized (tuning) {
            this.readTicks = Clock.ticks();
            return;
        }
    }

    public void readFail() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeOk() {
        Tuning tuning = this;
        synchronized (tuning) {
            this.writePending(false);
            this.writeTicks = Clock.ticks();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeFail() {
        Tuning tuning = this;
        synchronized (tuning) {
            this.writePending(false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void write(Context context) {
        BITunable bITunable = this.getTunable();
        Tuning tuning = this;
        synchronized (tuning) {
            if (this.writePending()) return;
            if (!Tuning.isOperational(this.state())) return;
            if (!bITunable.getMode().isWrite()) {
                return;
            }
            this.writePending(true);
            this.writeDesiredTicks = -1;
            this.writeDesiredContext = null;
        }
        try {
            boolean bl = bITunable.write(context);
            if (bl) return;
            Tuning tuning2 = this;
            synchronized (tuning2) {
                this.writePending(false);
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.writePending(false);
            bITunable.writeFail("write(): " + throwable);
        }
    }

    void readSubscribed() {
        try {
            this.getTunable().readSubscribed(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.getTunable().readFail("readSubscribed(): " + throwable);
        }
    }

    void readUnsubscribed() {
        try {
            this.getTunable().readUnsubscribed(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void stale() {
        try {
            this.getTunable().setStale(true, null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void registerForProcessing() {
        try {
            BTuningPolicyMap bTuningPolicyMap = this.getPolicyMap();
            if (bTuningPolicyMap != null) {
                this.processId(bTuningPolicyMap.register(this));
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean process() {
        if (!((BComponent)this.parent).isMounted()) {
            return false;
        }
        BTuningPolicy bTuningPolicy = this.getPolicy();
        long l = bTuningPolicy.getMinWriteTime().getMillis();
        long l2 = bTuningPolicy.getMaxWriteTime().getMillis();
        long l3 = bTuningPolicy.getStaleTime().getMillis();
        long l4 = Clock.ticks();
        boolean bl = false;
        Context context = null;
        Tuning tuning = this;
        synchronized (tuning) {
            long l5;
            if (this.writeDesiredTicks != (long)-1 && this.writeDesiredTicks <= l4) {
                if (l4 - this.writeTicks >= l) {
                    bl = true;
                    context = this.writeDesiredContext;
                }
            } else if (l2 > 0L && l4 - this.writeTicks >= l2) {
                bl = true;
                context = BTuningPolicy.maxWriteTimeContext;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl22 : MonitorExitStatement: MONITOREXIT : var12_8
            if (bl) {
                this.write(context);
            }
            if (l3 > 0L && l4 - (l5 = this.parent.getMode().isWriteonly() ? this.writeTicks : this.readTicks) > l3) {
                this.stale();
            }
            return true;
        }
    }

    static int toState(BITunable bITunable) {
        BStatus bStatus = bITunable.getStatus();
        boolean bl = bITunable.isFatalFault();
        boolean bl2 = bStatus.isDown();
        boolean bl3 = bStatus.isDisabled();
        boolean bl4 = false;
        if (!bITunable.isRunning() || !Sys.atSteadyState()) {
            bl4 = true;
        }
        boolean bl5 = bl4;
        boolean bl6 = bITunable.isSubscribedDesired();
        int n = 0;
        n = Tuning.set(n, 1, bl);
        n = Tuning.set(n, 2, bl2);
        n = Tuning.set(n, 4, bl3);
        n = Tuning.set(n, 8, bl5);
        n = Tuning.set(n, 16, bl6);
        return n;
    }

    static boolean get(int n, int n2) {
        boolean bl = false;
        if ((n & n2) != 0) {
            bl = true;
        }
        return bl;
    }

    static int set(int n, int n2, boolean bl) {
        if (bl) {
            return n |= n2;
        }
        return n &= ~n2;
    }

    static boolean isOperational(int n) {
        boolean bl = false;
        if ((n & 0xF) == 0) {
            bl = true;
        }
        return bl;
    }

    static boolean isDownToUp(int n, int n2) {
        boolean bl = false;
        if (Tuning.get(n, 2) && !Tuning.get(n2, 2)) {
            bl = true;
        }
        return bl;
    }

    static boolean isDisabledToEnabled(int n, int n2) {
        boolean bl = false;
        if (Tuning.get(n, 4) && !Tuning.get(n2, 4)) {
            bl = true;
        }
        return bl;
    }

    static boolean isStopToStart(int n, int n2) {
        boolean bl = false;
        if (Tuning.get(n, 8) && !Tuning.get(n2, 8)) {
            bl = true;
        }
        return bl;
    }

    static boolean shouldBeSubscribed(int n) {
        boolean bl = false;
        if (n == 16) {
            bl = true;
        }
        return bl;
    }

    static String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Tuning.get(n, 1)) {
            stringBuffer.append("fatal ");
        }
        if (Tuning.get(n, 2)) {
            stringBuffer.append("down ");
        }
        if (Tuning.get(n, 4)) {
            stringBuffer.append("disabled ");
        }
        if (Tuning.get(n, 8)) {
            stringBuffer.append("stop ");
        }
        if (Tuning.get(n, 16)) {
            stringBuffer.append("desiredSub ");
        }
        return "{" + stringBuffer.toString().trim() + '}';
    }

    public BIcon getIcon() {
        return icon;
    }

    final int state() {
        return this.packed & 0x1F;
    }

    final void state(int n) {
        this.packed = this.packed & 0xFFFFFFE0 | n;
    }

    final boolean subscribed() {
        boolean bl = false;
        if ((this.packed & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    final void subscribed(boolean bl) {
        this.packed = bl ? (this.packed |= 0x20) : (this.packed &= 0xFFFFFFDF);
    }

    final boolean writePending() {
        boolean bl = false;
        if ((this.packed & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    final void writePending(boolean bl) {
        this.packed = bl ? (this.packed |= 0x40) : (this.packed &= 0xFFFFFFBF);
    }

    final int processId() {
        return this.packed >> 8 & 0xFFFFFF;
    }

    final void processId(int n) {
        if (n > 0xFFFFFF) {
            throw new IllegalStateException();
        }
        this.packed = this.packed & 0xFF | n << 8;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        spyWriter.trTitle((Object)"Tuning", 2);
        if (this.parent instanceof BComplex) {
            spyWriter.prop((Object)"parent", (Object)((BComplex)this.parent).getDisplayName(null));
        }
        spyWriter.prop((Object)"parent.isRunning", this.parent.isRunning());
        spyWriter.prop((Object)"parent.status", (Object)this.parent.getStatus());
        spyWriter.prop((Object)"parent.isSubscribedDesired", this.parent.isSubscribedDesired());
        spyWriter.prop((Object)"parent.mode", (Object)this.parent.getMode());
        spyWriter.prop((Object)"cachedPolicyName", (Object)this.cachedPolicyName);
        spyWriter.prop((Object)"state", (Object)Tuning.toString(this.packed));
        spyWriter.prop((Object)"isOperational", Tuning.isOperational(this.packed));
        spyWriter.prop((Object)"subscribed", this.subscribed());
        spyWriter.prop((Object)"writePending", this.writePending());
        spyWriter.prop((Object)"processId", this.processId());
        spyWriter.prop((Object)"readTicks", (Object)Tuning.timestr(this.readTicks));
        spyWriter.prop((Object)"writeTicks", (Object)Tuning.timestr(this.writeTicks));
        spyWriter.prop((Object)"writeDesiredTicks", (Object)Tuning.timestr(this.writeDesiredTicks));
        spyWriter.prop((Object)"writeDesiredContext", (Object)this.writeDesiredContext);
        spyWriter.endProps();
    }

    static String timestr(long l) {
        if (l == 0L) {
            return "null";
        }
        long l2 = Clock.ticks();
        long l3 = l2 - l;
        if (l3 < 1000L) {
            return l3 + "ms";
        }
        return l3 / 1000L + "sec";
    }

    private final /* synthetic */ void this() {
        this.writeDesiredTicks = -1;
    }

    public Tuning(BITunable bITunable) {
        this.this();
        this.parent = bITunable;
        this.state(8);
    }
}

