/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ping;

import java.util.HashMap;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.ping.BIPingable;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPingMonitor
extends BComponent
implements Runnable {
    public static final Property pingEnabled = BPingMonitor.newProperty((int)0, (boolean)true, null);
    public static final Property pingFrequency = BPingMonitor.newProperty((int)0, (BValue)BRelTime.make((long)300000L), null);
    public static final Property alarmOnFailure = BPingMonitor.newProperty((int)0, (boolean)true, null);
    public static final Property startupAlarmDelay = BPingMonitor.newProperty((int)0, (BValue)BRelTime.make((long)300000L), null);
    public static final Action enable = BPingMonitor.newAction((int)0, null);
    public static final Action disable = BPingMonitor.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final boolean UPDATE_TICKS_ON_PING;
    boolean isAlive;
    long startupTicks;
    Thread thread;
    static /* synthetic */ Class class$javax$baja$driver$ping$BPingMonitor;

    public boolean getPingEnabled() {
        return this.getBoolean(pingEnabled);
    }

    public void setPingEnabled(boolean bl) {
        this.setBoolean(pingEnabled, bl, null);
    }

    public BRelTime getPingFrequency() {
        return (BRelTime)this.get(pingFrequency);
    }

    public void setPingFrequency(BRelTime bRelTime) {
        this.set(pingFrequency, (BValue)bRelTime, null);
    }

    public boolean getAlarmOnFailure() {
        return this.getBoolean(alarmOnFailure);
    }

    public void setAlarmOnFailure(boolean bl) {
        this.setBoolean(alarmOnFailure, bl, null);
    }

    public BRelTime getStartupAlarmDelay() {
        return (BRelTime)this.get(startupAlarmDelay);
    }

    public void setStartupAlarmDelay(BRelTime bRelTime) {
        this.set(startupAlarmDelay, (BValue)bRelTime, null);
    }

    public void enable() {
        this.invoke(enable, null, null);
    }

    public void disable() {
        this.invoke(disable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDeviceNetwork getNetwork() {
        return (BDeviceNetwork)this.getParent();
    }

    public BIPingable[] getPingables() {
        BDevice[] bDeviceArray = this.getNetwork().getDevices();
        BIPingable[] bIPingableArray = new BIPingable[bDeviceArray.length + 1];
        bIPingableArray[0] = this.getNetwork();
        System.arraycopy(bDeviceArray, 0, bIPingableArray, 1, bDeviceArray.length);
        return bIPingableArray;
    }

    public void started() throws Exception {
        super.started();
        if (Sys.atSteadyState()) {
            this.startThread();
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.startThread();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopThread();
    }

    void startThread() {
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, "Ping:" + this.getParent().getName());
        this.thread.start();
    }

    void stopThread() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    public void run() {
        this.startupTicks = Clock.ticks();
        block2: while (this.isAlive) {
            try {
                Thread.sleep(1000L);
                if (!this.getPingEnabled()) continue;
                long l = this.getPingFrequency().getMillis();
                long l2 = Clock.ticks();
                BIPingable[] bIPingableArray = this.getPingables();
                int n = 0;
                while (n < bIPingableArray.length) {
                    if (!this.getPingEnabled()) continue block2;
                    BIPingable bIPingable = bIPingableArray[n];
                    if (this.isPingEnabled(bIPingable) && l2 > bIPingable.getHealth().lastAttemptTicks + l) {
                        if (UPDATE_TICKS_ON_PING) {
                            bIPingable.getHealth().lastAttemptTicks = l2;
                        }
                        bIPingable.doPing();
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                if (!this.isAlive) continue;
                throwable.printStackTrace();
            }
        }
    }

    public boolean isPingEnabled(BIPingable bIPingable) {
        BStatus bStatus = bIPingable.getStatus();
        if (bStatus.isDisabled()) {
            return false;
        }
        return !bStatus.isFault();
    }

    public void pingOk(BIPingable bIPingable) {
        if (bIPingable.getHealth().getAlarm()) {
            bIPingable.getHealth().setAlarm(false);
            this.alarmToNormal(bIPingable);
        }
    }

    public void pingFail(BIPingable bIPingable) {
        if (this.getAlarmOnFailure()) {
            if (bIPingable.getHealth().getAlarm()) {
                return;
            }
            long l = this.getStartupAlarmDelay().getMillis();
            long l2 = Clock.ticks();
            if (l2 <= this.startupTicks + l) {
                return;
            }
            bIPingable.getHealth().setAlarm(true);
            this.alarmToOffnormal(bIPingable);
        }
    }

    void alarmToOffnormal(BIPingable bIPingable) {
        boolean bl = false;
        try {
            AlarmSupport alarmSupport = this.getAlarmSupport(bIPingable);
            bl = alarmSupport.isAckRequired(BSourceState.offnormal);
            alarmSupport.newOffnormalAlarm(bIPingable.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n = bIPingable.getStatus().getBits();
        n |= 8;
        if (bl) {
            n |= 0x80;
        }
        bIPingable.setStatus(BStatus.make((int)n));
    }

    void alarmToNormal(BIPingable bIPingable) {
        try {
            HashMap hashMap = new HashMap();
            this.getAlarmSupport(bIPingable).toNormal(bIPingable.getAlarmSourceInfo().makeAlarmData(BSourceState.normal), null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        bIPingable.setStatus(BStatus.make((BStatus)bIPingable.getStatus(), (int)8, (boolean)false));
    }

    BBoolean alarmAck(BIPingable bIPingable, BAlarmRecord bAlarmRecord) {
        try {
            this.getAlarmSupport(bIPingable).ackAlarm(bAlarmRecord);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        bIPingable.setStatus(BStatus.make((BStatus)bIPingable.getStatus(), (int)128, (boolean)false));
        return BBoolean.TRUE;
    }

    AlarmSupport getAlarmSupport(BIPingable bIPingable) {
        AlarmSupport alarmSupport = (AlarmSupport)((BObject)bIPingable).fw(502);
        alarmSupport.setAlarmClass(bIPingable.getAlarmSourceInfo().getAlarmClass());
        return alarmSupport;
    }

    public void doEnable() {
        this.setPingEnabled(true);
    }

    public void doDisable() {
        this.setPingEnabled(false);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.startupTicks = 0L;
    }

    public BPingMonitor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$driver$ping$BPingMonitor;
        if (clazz == null) {
            clazz = class$javax$baja$driver$ping$BPingMonitor = BPingMonitor.class("[Ljavax.baja.driver.ping.BPingMonitor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"monitor.png");
        UPDATE_TICKS_ON_PING = Boolean.valueOf(System.getProperty("niagara.updateTicksOnPing", "false"));
    }
}

