/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ping;

import javax.baja.alarm.BAlarmRecord;
import javax.baja.driver.ping.BIPingable;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPingHealth
extends BStruct {
    public static final Property down = BPingHealth.newProperty((int)1, (boolean)false, null);
    public static final Property alarm = BPingHealth.newProperty((int)1, (boolean)false, null);
    public static final Property lastOkTime = BPingHealth.newProperty((int)65537, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastFailTime = BPingHealth.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastFailCause = BPingHealth.newProperty((int)1, (String)"", null);
    public static final Type TYPE;
    private static final BIcon icon;
    long lastAttemptTicks;
    static /* synthetic */ Class class$javax$baja$driver$ping$BPingHealth;

    public boolean getDown() {
        return this.getBoolean(down);
    }

    public void setDown(boolean bl) {
        this.setBoolean(down, bl, null);
    }

    public boolean getAlarm() {
        return this.getBoolean(alarm);
    }

    public void setAlarm(boolean bl) {
        this.setBoolean(alarm, bl, null);
    }

    public BAbsTime getLastOkTime() {
        return (BAbsTime)this.get(lastOkTime);
    }

    public void setLastOkTime(BAbsTime bAbsTime) {
        this.set(lastOkTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastFailTime() {
        return (BAbsTime)this.get(lastFailTime);
    }

    public void setLastFailTime(BAbsTime bAbsTime) {
        this.set(lastFailTime, (BValue)bAbsTime, null);
    }

    public String getLastFailCause() {
        return this.getString(lastFailCause);
    }

    public void setLastFailCause(String string) {
        this.setString(lastFailCause, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BIPingable getParentPingable() {
        return (BIPingable)this.getParent();
    }

    public boolean inFailure() {
        boolean bl = false;
        if (this.getLastFailTime().getMillis() >= this.getLastOkTime().getMillis()) {
            bl = true;
        }
        return bl;
    }

    public void pingOk() {
        this.lastAttemptTicks = Clock.ticks();
        long l = System.currentTimeMillis();
        long l2 = l - l % 60000L;
        BAbsTime bAbsTime = l2 <= this.getLastFailTime().getMillis() ? BAbsTime.make((long)l) : BAbsTime.make((long)l2);
        this.setLastOkTime(bAbsTime);
        BIPingable bIPingable = this.getParentPingable();
        if (this.getDown()) {
            this.setDown(false);
            bIPingable.updateStatus();
        }
        bIPingable.getMonitor().pingOk(bIPingable);
    }

    public void pingFail(String string) {
        this.lastAttemptTicks = Clock.ticks();
        long l = System.currentTimeMillis();
        long l2 = l - l % 60000L;
        BAbsTime bAbsTime = l2 <= this.getLastOkTime().getMillis() ? BAbsTime.make((long)l) : BAbsTime.make((long)l2);
        this.setLastFailTime(bAbsTime);
        this.setLastFailCause(string == null ? "" : string);
        BIPingable bIPingable = this.getParentPingable();
        if (!this.getDown()) {
            this.setDown(true);
            bIPingable.updateStatus();
        }
        try {
            bIPingable.getMonitor().pingFail(bIPingable);
        }
        catch (Exception exception) {}
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        BIPingable bIPingable = this.getParentPingable();
        return bIPingable.getMonitor().alarmAck(bIPingable, bAlarmRecord);
    }

    public String toString(Context context) {
        if (this.inFailure()) {
            return "Fail [" + this.getLastFailTime().toString(context) + "] " + this.getLastFailCause();
        }
        return "Ok [" + this.getLastOkTime().toString(context) + ']';
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastAttemptTicks = 0L;
    }

    public BPingHealth() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$driver$ping$BPingHealth;
        if (clazz == null) {
            clazz = class$javax$baja$driver$ping$BPingHealth = BPingHealth.class("[Ljavax.baja.driver.ping.BPingHealth;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"monitor.png");
    }
}

