/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.history;

import javax.baja.driver.history.BArchiveDescriptor;
import javax.baja.driver.history.BHistoryNetworkExt;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.history.BIHistoryPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHistoryImport
extends BArchiveDescriptor
implements BIHistoryPollable,
BIPollableHistorySource {
    public static final Property onDemandPollEnabled = BHistoryImport.newProperty((int)0, (boolean)true, null);
    public static final Property onDemandPollFrequency = BHistoryImport.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property configOverrides = BHistoryImport.newProperty((int)0, (BValue)new BComponent(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final Context asyncHistoryPoll;
    public static final Context syncHistoryPoll;
    BHistoryNetworkExt ext;
    int historySubscribeCounter;
    Object syncObj;
    static /* synthetic */ Class class$javax$baja$driver$history$BHistoryImport;

    public boolean getOnDemandPollEnabled() {
        return this.getBoolean(onDemandPollEnabled);
    }

    public void setOnDemandPollEnabled(boolean bl) {
        this.setBoolean(onDemandPollEnabled, bl, null);
    }

    public BPollFrequency getOnDemandPollFrequency() {
        return (BPollFrequency)this.get(onDemandPollFrequency);
    }

    public void setOnDemandPollFrequency(BPollFrequency bPollFrequency) {
        this.set(onDemandPollFrequency, (BValue)bPollFrequency, null);
    }

    public BComponent getConfigOverrides() {
        return (BComponent)this.get(configOverrides);
    }

    public void setConfigOverrides(BComponent bComponent) {
        this.set(configOverrides, (BValue)bComponent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        while (bComponent != null && !(bComponent instanceof BIArchiveFolder)) {
            bComponent = (BComponent)bComponent.getParent();
        }
        if (bComponent == null) {
            return false;
        }
        try {
            boolean bl = false;
            if (((BIArchiveFolder)bComponent).getImportDescriptorType() != null) {
                bl = true;
            }
            return bl;
        }
        catch (IllegalStateException illegalStateException) {
            return true;
        }
    }

    public BHistoryConfig makeLocalConfig(BHistoryConfig bHistoryConfig) {
        BValue bValue;
        Property property;
        BHistoryConfig bHistoryConfig2 = (BHistoryConfig)bHistoryConfig.newCopy(true);
        BComponent bComponent = this.getConfigOverrides();
        Property[] propertyArray = bComponent.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            property = propertyArray[n];
            bValue = bComponent.get(property).newCopy(true);
            Property property2 = bHistoryConfig2.getProperty(property.getName());
            if (property2 == null) {
                bHistoryConfig2.add(property.getName(), bValue, bComponent.getFlags((Slot)property), bComponent.getSlotFacets((Slot)property), null);
            } else {
                bHistoryConfig2.set(property2, bValue);
            }
            ++n;
        }
        try {
            BOrd bOrd = this.getSourceOrd();
            property = bHistoryConfig2.getSource();
            if (property.size() < 1) {
                bHistoryConfig2.setSource(BOrdList.make((BOrd)bOrd));
            } else if (!property.get(property.size() - 1).equals((Object)bOrd)) {
                bValue = BOrdList.add((BOrdList)property, (BOrd)bOrd);
                bHistoryConfig2.setSource((BOrdList)bValue);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bHistoryConfig2;
    }

    private final BOrd getSourceOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return this.getSlotPathOrd();
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return this.getSlotPathOrd();
        }
        return BOrd.make((BOrd)bOrd, (BOrd)this.getSlotPathOrd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unsubscribed() {
        Object object = this.syncObj;
        synchronized (object) {
            this.historySubscribeCounter = 0;
            if (this.ext != null) {
                this.ext.getOnDemandPollScheduler().unsubscribe(this);
            }
            return;
        }
    }

    public void poll() {
        if (this.getOnDemandPollEnabled() && !this.isUnoperational() && this.historySubscribeCounter > 0) {
            this.invoke(execute, null, asyncHistoryPoll);
        }
    }

    public boolean historyPollingEnabled() {
        if (!this.getOnDemandPollEnabled()) {
            return false;
        }
        BHistoryNetworkExt bHistoryNetworkExt = this.getHistoryNetworkExt();
        if (bHistoryNetworkExt == null) {
            return false;
        }
        BPollScheduler bPollScheduler = bHistoryNetworkExt.getOnDemandPollScheduler();
        if (!this.isRunning()) {
            bPollScheduler.lease();
        }
        return bPollScheduler.getPollEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateHistorySubscriptionCount(int n) {
        int n2;
        block9: {
            n2 = 0;
            boolean bl = false;
            Object object = this.syncObj;
            synchronized (object) {
                int n3 = this.historySubscribeCounter;
                this.historySubscribeCounter += n;
                if (this.historySubscribeCounter < 0) {
                    this.historySubscribeCounter = 0;
                } else if (n3 == 0 && this.historySubscribeCounter > 0 && this.isRunning()) {
                    this.ext = this.getHistoryNetworkExt();
                    if (this.ext != null) {
                        BPollScheduler bPollScheduler = this.ext.getOnDemandPollScheduler();
                        if (this.getOnDemandPollEnabled() && !this.isUnoperational() && bPollScheduler.getPollEnabled() && this.historySubscribeCounter > 0) {
                            bl = true;
                        }
                        bPollScheduler.subscribe(this);
                    }
                }
                if (this.historySubscribeCounter == 0 && this.ext != null) {
                    this.ext.getOnDemandPollScheduler().unsubscribe(this);
                }
                n2 = this.historySubscribeCounter;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl22 : MonitorExitStatement: MONITOREXIT : var4_4
                if (!bl) break block9;
            }
            this.invoke(execute, null, syncHistoryPoll);
        }
        return n2;
    }

    public BPollFrequency getPollFrequency() {
        return this.getOnDemandPollFrequency();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        spyWriter.trTitle((Object)"HistoryImport", 2);
        spyWriter.prop((Object)"historySubscriptionCount", (Object)("" + this.historySubscribeCounter));
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ext = null;
        this.historySubscribeCounter = 0;
        this.syncObj = new Object();
    }

    public BHistoryImport() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$driver$history$BHistoryImport;
        if (clazz == null) {
            clazz = class$javax$baja$driver$history$BHistoryImport = BHistoryImport.class("[Ljavax.baja.driver.history.BHistoryImport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://driver/com/tridium/driver/ui/history/importHistory.png");
        asyncHistoryPoll = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "Context.asyncHistoryPoll";
            }
        };
        syncHistoryPoll = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "Context.syncHistoryPoll";
            }
        };
    }
}

