/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver;

import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.BNetworkExt;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.license.BILicensed;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDeviceNetwork
extends BComponent
implements BIDeviceFolder,
BIStatus,
BIPingable,
BILicensed {
    public static final Property status = BDeviceNetwork.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property enabled = BDeviceNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property faultCause = BDeviceNetwork.newProperty((int)67, (String)"", null);
    public static final Property health = BDeviceNetwork.newProperty((int)65, (BValue)new BPingHealth(), null);
    public static final Property alarmSourceInfo = BDeviceNetwork.newProperty((int)0, (BValue)BDeviceNetwork.initAlarmSourceInfo(), null);
    public static final Property monitor = BDeviceNetwork.newProperty((int)0, (BValue)new BPingMonitor(), null);
    public static final Action ping = BDeviceNetwork.newAction((int)16, null);
    public static final Action ackAlarm = BDeviceNetwork.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static HashMap globalLimits;
    private Log log;
    private int oldStatus;
    private boolean fatalFault;
    private boolean configFault;
    private boolean descendantsStarted;
    private HashMap limits;
    private AlarmSupport alarmSupport;
    static /* synthetic */ Class class$javax$baja$driver$BDeviceNetwork;
    static /* synthetic */ Class class$javax$baja$driver$BNetworkExt;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    public void setHealth(BPingHealth bPingHealth) {
        this.set(health, (BValue)bPingHealth, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo bAlarmSourceInfo) {
        this.set(alarmSourceInfo, (BValue)bAlarmSourceInfo, null);
    }

    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    public void setMonitor(BPingMonitor bPingMonitor) {
        this.set(monitor, (BValue)bPingMonitor, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract Type getDeviceType();

    public abstract Type getDeviceFolderType();

    public final BDeviceNetwork getNetwork() {
        return this;
    }

    public final BNetworkExt[] getNetworkExts() {
        Class clazz = class$javax$baja$driver$BNetworkExt;
        if (clazz == null) {
            clazz = class$javax$baja$driver$BNetworkExt = BDeviceNetwork.class("[Ljavax.baja.driver.BNetworkExt;", false);
        }
        return (BNetworkExt[])this.getChildren(clazz);
    }

    public BDevice[] getDevices() {
        ArrayList arrayList = new ArrayList();
        this.getDevices(this, this.getDeviceType(), arrayList);
        return arrayList.toArray(new BDevice[arrayList.size()]);
    }

    private final void getDevices(BComponent bComponent, Type type, ArrayList arrayList) {
        SlotCursor slotCursor = bComponent.loadSlots().getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = slotCursor.get().asComponent();
            if (bComponent2.getType().is(type)) {
                arrayList.add(bComponent2);
                continue;
            }
            this.getDevices(bComponent2, type, arrayList);
        }
    }

    public final boolean isDescendantsStarted() {
        return this.descendantsStarted;
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        boolean bl = false;
        if (!this.getEnabled() || this.getStatus().isDisabled()) {
            bl = true;
        }
        return bl;
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final void updateStatus() {
        int n = this.getStatus().getBits();
        n = !this.getEnabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = this.getHealth().getDown() ? (n |= 4) : (n &= 0xFFFFFFFB);
        n = this.fatalFault | this.configFault ? (n |= 2) : (n &= 0xFFFFFFFD);
        if (n == this.oldStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
        BNetworkExt[] bNetworkExtArray = this.getNetworkExts();
        int n2 = 0;
        while (n2 < bNetworkExtArray.length) {
            try {
                bNetworkExtArray[n2].updateStatus();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n2;
        }
        BDevice[] bDeviceArray = this.getDevices();
        int n3 = 0;
        while (n3 < bDeviceArray.length) {
            try {
                bDeviceArray[n3].updateStatus();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n3;
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void configFail(String string) {
        this.configFault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(string);
        this.updateStatus();
    }

    public final void configFatal(String string) {
        this.fatalFault = true;
        this.setFaultCause(string);
        this.updateStatus();
    }

    public Feature getLicenseFeature() {
        return null;
    }

    private final void checkLicense(String string) {
        try {
            if (string != null) {
                this.fatalFault = true;
                this.getLog().error("Exceeded network limit for " + string);
                this.setFaultCause("Exceeded network limit for " + string);
                return;
            }
            Feature feature = this.getLicenseFeature();
            if (feature == null) {
                return;
            }
            feature.check();
            String string2 = feature.getVendorName() + ':' + feature.getFeatureName();
            string2 = TextUtil.toLowerCase((String)string2);
            this.limits = (HashMap)globalLimits.get(string2);
            if (this.limits != null) {
                return;
            }
            this.limits = new HashMap();
            globalLimits.put(string2, this.limits);
            String[] stringArray = feature.list();
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                if (string3.endsWith(".limit")) {
                    String string4 = feature.get(string3);
                    int n2 = Integer.MAX_VALUE;
                    if (string4 != null && !TextUtil.toLowerCase((String)string4).equals("none")) {
                        n2 = Integer.parseInt(string4);
                    }
                    LicenseLimit licenseLimit = new LicenseLimit();
                    licenseLimit.key = string3;
                    licenseLimit.used = 0;
                    licenseLimit.limit = n2;
                    this.limits.put(string3, licenseLimit);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.fatalFault = true;
            this.getLog().error("Unlicensed: " + this.toPathString(), (Throwable)exception);
            this.setFaultCause("Unlicensed: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getLicenseCount(String string) {
        if (this.limits == null) {
            return 0;
        }
        HashMap hashMap = this.limits;
        synchronized (hashMap) {
            LicenseLimit licenseLimit = (LicenseLimit)this.limits.get(string);
            if (licenseLimit == null) {
                return 0;
            }
            return licenseLimit.used;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String checkLicenseLimit(String string) {
        if (this.limits == null) {
            return null;
        }
        HashMap hashMap = this.limits;
        synchronized (hashMap) {
            LicenseLimit licenseLimit = (LicenseLimit)this.limits.get(string);
            if (licenseLimit == null) {
                return "Unlicensed: " + string;
            }
            ++licenseLimit.used;
            if (licenseLimit.used > licenseLimit.limit) {
                return "Exceeded " + licenseLimit.key + " of " + licenseLimit.limit;
            }
            return null;
        }
    }

    protected IFuture postPing() {
        try {
            this.doPing();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public void doPing() throws Exception {
        this.pingOk();
    }

    public void pingOk() {
        this.getHealth().pingOk();
    }

    public void pingFail(String string) {
        this.getHealth().pingFail(string);
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        return this.getHealth().doAckAlarm(bAlarmRecord);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)ping)) {
            return this.postPing();
        }
        return super.post(action, bValue, context);
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)object);
                break;
            }
            case 501: {
                return this.checkLicenseLimit((String)object);
            }
            case 503: {
                return new Integer(this.getLicenseCount((String)object));
            }
            case 21: {
                ((ResourceReport)object).add("network", 100000);
                break;
            }
            case 502: {
                return this.alarmSupport;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwStarted() {
        this.checkLicense(Metrics.incrementNetwork((BComplex)this));
        this.updateStatus();
    }

    private final void fwDescendantsStarted() {
        this.updateStatus();
        this.descendantsStarted = true;
    }

    private final void fwChanged(Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled)) {
            this.updateStatus();
        }
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = Log.getLog((String)this.getType().getModule().getModuleName());
        }
        return this.log;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        if (this.limits != null) {
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)"License Limits", 3);
            spyWriter.w((Object)"<tr>").th((Object)"Feature").th((Object)"Used").th((Object)"Limit").w((Object)"</tr>\n");
            Iterator iterator = this.limits.values().iterator();
            while (iterator.hasNext()) {
                LicenseLimit licenseLimit = (LicenseLimit)iterator.next();
                String string = licenseLimit.limit == Integer.MAX_VALUE ? "none" : "" + licenseLimit.limit;
                spyWriter.tr((Object)licenseLimit.key, (Object)("" + licenseLimit.used), (Object)string);
            }
            spyWriter.endTable();
        }
        super.spy(spyWriter);
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        Class clazz = class$javax$baja$nav$BINavNode;
        if (clazz == null) {
            clazz = class$javax$baja$nav$BINavNode = BDeviceNetwork.class("[Ljavax.baja.nav.BINavNode;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bINavNodeArray.length) {
            BComponent bComponent = (BComponent)bINavNodeArray[n];
            if (!bComponent.getPropertyInParent().isFrozen()) {
                array.add((Object)bComponent);
            }
            ++n;
        }
        return (BINavNode[])array.trim();
    }

    static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo bAlarmSourceInfo = new BAlarmSourceInfo();
        bAlarmSourceInfo.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bAlarmSourceInfo.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        bAlarmSourceInfo.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return bAlarmSourceInfo;
    }

    public AgentList getAgents(Context context) {
        TypeInfo typeInfo = Sys.getRegistry().getType("driver:DeviceManager");
        AgentList agentList = super.getAgents(context);
        int n = 0;
        while (n < agentList.size()) {
            if (agentList.get(n).getAgentType().is(typeInfo)) {
                return agentList;
            }
            ++n;
        }
        agentList.add(typeInfo.getAgentInfo());
        return agentList;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldStatus = 0;
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, "");
    }

    public BDeviceNetwork() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$driver$BDeviceNetwork;
        if (clazz == null) {
            clazz = class$javax$baja$driver$BDeviceNetwork = BDeviceNetwork.class("[Ljavax.baja.driver.BDeviceNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"deviceNetwork.png");
        globalLimits = new HashMap();
    }

    static class LicenseLimit {
        String key;
        int limit;
        int used;

        LicenseLimit() {
        }
    }
}

