/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver;

import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceReport;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.log.Log;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDevice
extends BComponent
implements BIStatus,
BIPingable {
    public static final Property status = BDevice.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property enabled = BDevice.newProperty((int)0, (boolean)true, null);
    public static final Property faultCause = BDevice.newProperty((int)67, (String)"", null);
    public static final Property health = BDevice.newProperty((int)65, (BValue)new BPingHealth(), null);
    public static final Property alarmSourceInfo = BDevice.newProperty((int)0, (BValue)BDevice.initAlarmSourceInfo(), null);
    public static final Action ping = BDevice.newAction((int)16, null);
    public static final Action ackAlarm = BDevice.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    protected static final BIcon icon;
    private Log log;
    private int oldStatus;
    private BDeviceNetwork network;
    private boolean fatalFault;
    private boolean configFault;
    private AlarmSupport alarmSupport;
    static /* synthetic */ Class class$javax$baja$driver$BDevice;
    static /* synthetic */ Class class$javax$baja$driver$BDeviceExt;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    public void setHealth(BPingHealth bPingHealth) {
        this.set(health, (BValue)bPingHealth, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo bAlarmSourceInfo) {
        this.set(alarmSourceInfo, (BValue)bAlarmSourceInfo, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract Type getNetworkType();

    public final BDeviceNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public final BDeviceExt[] getDeviceExts() {
        Class clazz = class$javax$baja$driver$BDeviceExt;
        if (clazz == null) {
            clazz = class$javax$baja$driver$BDeviceExt = BDevice.class("[Ljavax.baja.driver.BDeviceExt;", false);
        }
        return (BDeviceExt[])this.getChildren(clazz);
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final void updateStatus() {
        BStatus bStatus;
        int n = this.getStatus().getBits();
        BStatus bStatus2 = bStatus = this.network == null ? BStatus.ok : this.network.getStatus();
        n = !this.getEnabled() || bStatus.isDisabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = this.getHealth().getDown() || bStatus.isDown() ? (n |= 4) : (n &= 0xFFFFFFFB);
        n = this.fatalFault || this.configFault || bStatus.isFault() ? (n |= 2) : (n &= 0xFFFFFFFD);
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
        BDeviceExt[] bDeviceExtArray = this.getDeviceExts();
        int n2 = 0;
        while (n2 < bDeviceExtArray.length) {
            try {
                bDeviceExtArray[n2].updateStatus();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n2;
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void configFail(String string) {
        this.configFault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(string);
        this.updateStatus();
    }

    public final void configFatal(String string) {
        this.fatalFault = true;
        this.setFaultCause(string);
        this.updateStatus();
    }

    private final void checkFatalFault(String string) {
        Object object;
        if (string != null) {
            this.fatalFault = true;
            this.getLog().error("Exceeded device limit for " + string);
            this.setFaultCause("Exceeded device limit for " + string);
            return;
        }
        BDeviceNetwork bDeviceNetwork = null;
        if (this.fatalFault) {
            return;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BDeviceNetwork) {
                bDeviceNetwork = (BDeviceNetwork)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        if (bDeviceNetwork == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under DeviceNetwork");
            return;
        }
        if (!bDeviceNetwork.getType().is(this.getNetworkType())) {
            this.fatalFault = true;
            this.setFaultCause("Parent DeviceNetwork " + bDeviceNetwork.getType() + " is not " + this.getNetworkType());
            return;
        }
        if (bDeviceNetwork.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + bDeviceNetwork.getFaultCause());
            return;
        }
        if (this.getType().is(bDeviceNetwork.getDeviceType()) && (object = bDeviceNetwork.fw(501, "device.limit", null, null, null)) != null) {
            this.fatalFault = true;
            this.setFaultCause(object.toString());
            return;
        }
        this.network = bDeviceNetwork;
        this.setFaultCause("");
    }

    protected abstract IFuture postPing();

    public abstract void doPing() throws Exception;

    public BPingMonitor getMonitor() {
        return this.getNetwork().getMonitor();
    }

    public void pingOk() {
        this.getHealth().pingOk();
    }

    public void pingFail(String string) {
        this.getHealth().pingFail(string);
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        return this.getHealth().doAckAlarm(bAlarmRecord);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)ping)) {
            return this.postPing();
        }
        return super.post(action, bValue, context);
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 14: {
                this.fwDescendantsStopped();
                break;
            }
            case 2: {
                this.fwChanged((Property)object);
                break;
            }
            case 21: {
                ((ResourceReport)object).add("device", 5000);
                break;
            }
            case 502: {
                return this.alarmSupport;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwStarted() {
        this.checkFatalFault(Metrics.incrementDevice((BComplex)this));
    }

    private final void fwDescendantsStopped() {
        this.network = null;
    }

    private final void fwDescendantsStarted() {
        this.updateStatus();
    }

    private final void fwChanged(Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        }
    }

    public Log getLog() {
        if (this.log == null) {
            try {
                this.log = Log.getLog((String)(this.getNetwork().getLog().getLogName() + '.' + this.getName()));
            }
            catch (Exception exception) {
                this.log = Log.getLog((String)this.getType().getTypeName());
            }
        }
        return this.log;
    }

    static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo bAlarmSourceInfo = new BAlarmSourceInfo();
        bAlarmSourceInfo.setSourceName(BFormat.make((String)"%parent.parent.displayName% %parent.displayName%"));
        bAlarmSourceInfo.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        bAlarmSourceInfo.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return bAlarmSourceInfo;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldStatus = 0;
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, "");
    }

    public BDevice() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$driver$BDevice;
        if (clazz == null) {
            clazz = class$javax$baja$driver$BDevice = BDevice.class("[Ljavax.baja.driver.BDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"device.png");
    }
}

