/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil.points;

import com.vykon.vykonProUtil.points.BAbsNumericOverride;
import javax.baja.control.BNumericPoint;
import javax.baja.control.util.BNumericOverride;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAbsNumericWritableCommand
extends BComponent {
    public static final Property pointOrd = BAbsNumericWritableCommand.newProperty((int)64, (BValue)BOrd.NULL, null);
    public static final Property defaultTime = BAbsNumericWritableCommand.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property facets = BAbsNumericWritableCommand.newProperty((int)7, (BValue)BFacets.makeNumeric(), null);
    public static final Property fallback = BAbsNumericWritableCommand.newProperty((int)7, (double)0.0, null);
    public static final Property out = BAbsNumericWritableCommand.newProperty((int)7, (double)0.0, null);
    public static final Action emergencyOverride = BAbsNumericWritableCommand.newAction((int)0, (BValue)BDouble.DEFAULT, null);
    public static final Action emergencyAuto = BAbsNumericWritableCommand.newAction((int)0, null);
    public static final Action override = BAbsNumericWritableCommand.newAction((int)256, (BValue)new BNumericOverride(), null);
    public static final Action auto = BAbsNumericWritableCommand.newAction((int)256, null);
    public static final Action set = BAbsNumericWritableCommand.newAction((int)256, (BValue)BDouble.DEFAULT, null);
    public static final Action absOverride = BAbsNumericWritableCommand.newAction((int)256, (BValue)new BAbsNumericOverride(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    BNumericPoint slave;
    PointSubscriber pointSub;
    static /* synthetic */ Class class$com$vykon$vykonProUtil$points$BAbsNumericWritableCommand;

    public BOrd getPointOrd() {
        return (BOrd)this.get(pointOrd);
    }

    public void setPointOrd(BOrd bOrd) {
        this.set(pointOrd, (BValue)bOrd, null);
    }

    public BRelTime getDefaultTime() {
        return (BRelTime)this.get(defaultTime);
    }

    public void setDefaultTime(BRelTime bRelTime) {
        this.set(defaultTime, (BValue)bRelTime, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public double getFallback() {
        return this.getDouble(fallback);
    }

    public void setFallback(double d) {
        this.setDouble(fallback, d, null);
    }

    public double getOut() {
        return this.getDouble(out);
    }

    public void setOut(double d) {
        this.setDouble(out, d, null);
    }

    public void emergencyOverride(BDouble bDouble) {
        this.invoke(emergencyOverride, (BValue)bDouble, null);
    }

    public void emergencyAuto() {
        this.invoke(emergencyAuto, null, null);
    }

    public void override(BNumericOverride bNumericOverride) {
        this.invoke(override, (BValue)bNumericOverride, null);
    }

    public void auto() {
        this.invoke(auto, null, null);
    }

    public void set(BDouble bDouble) {
        this.invoke(set, (BValue)bDouble, null);
    }

    public void absOverride(BAbsNumericOverride bAbsNumericOverride) {
        this.invoke(absOverride, (BValue)bAbsNumericOverride, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stopped() {
        this.pointSub.unsubscribeAll();
        this.pointSub = null;
    }

    public void stationStarted() {
        this.initPoint();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == pointOrd) {
            this.initPoint();
        }
    }

    private final void initPoint() {
        this.isRunning();
        if (this.getPointOrd() != BOrd.NULL) {
            try {
                this.slave = (BNumericPoint)this.getPointOrd().resolve((BObject)this).get();
                if (this.slave.get("fallback") != null) {
                    double d = ((BStatusNumeric)this.slave.get("fallback")).getValue();
                    this.setFallback(d);
                }
                this.setOut(this.slave.getOut().getValue());
                if (this.slave.get("facets") != null) {
                    this.setFacets((BFacets)this.slave.get("facets"));
                }
                this.pointSub = new PointSubscriber();
                this.pointSub.subscribe((BComponent)this.slave);
            }
            catch (Exception exception) {
                System.out.println(this.getSlotPath() + " couldn't resolve point ord");
                System.out.println(exception);
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == override || slot == emergencyOverride || slot == set || slot == absOverride) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doEmergencyOverride(BDouble bDouble, Context context) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyOverride").asAction(), (BValue)bDouble, context);
    }

    public void doEmergencyAuto(Context context) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyAuto").asAction(), null, context);
    }

    public void doOverride(BNumericOverride bNumericOverride, Context context) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("override").asAction(), (BValue)bNumericOverride, context);
    }

    public void doAuto(Context context) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("auto").asAction(), null, context);
    }

    public void doSet(BDouble bDouble, Context context) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("set").asAction(), (BValue)bDouble, context);
    }

    public void doAbsOverride(BAbsNumericOverride bAbsNumericOverride, Context context) {
        if (this.slave == null) {
            return;
        }
        BAbsTime bAbsTime = Clock.time();
        BAbsTime bAbsTime2 = BAbsTime.NULL;
        double d = 0.0;
        if (bAbsNumericOverride != null && bAbsNumericOverride.get("expireTime") != null) {
            bAbsTime2 = bAbsNumericOverride.getExpireTime();
        }
        if (bAbsNumericOverride != null && bAbsNumericOverride.get("value") != null) {
            d = bAbsNumericOverride.getValue();
        }
        long l = 0L;
        if (bAbsTime != BAbsTime.NULL && bAbsTime2 != BAbsTime.NULL) {
            l = bAbsNumericOverride.getExpireTime().getMillis() - bAbsTime.getMillis();
        }
        BRelTime bRelTime = null;
        bRelTime = l <= 0L ? BRelTime.make((long)0L) : BRelTime.make((long)l);
        BNumericOverride bNumericOverride = new BNumericOverride(bRelTime, d);
        this.slave.invoke(this.slave.getSlot("override").asAction(), (BValue)bNumericOverride, context);
    }

    public BValue getActionParameterDefault(Action action) {
        BDouble bDouble = null;
        if (action == set) {
            bDouble = BDouble.make((double)this.getFallback());
        } else if (action == override || action == emergencyOverride || action == absOverride) {
            bDouble = BDouble.make((double)this.getOut());
        }
        if (bDouble != null) {
            BNumber bNumber;
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = bDouble.getDouble();
            BFacets bFacets = this.getFacets();
            BNumber bNumber2 = (BNumber)bFacets.getFacet("min");
            if (bNumber2 != null) {
                d = bNumber2.getDouble();
            }
            if ((bNumber = (BNumber)bFacets.getFacet("max")) != null) {
                d2 = bNumber.getDouble();
            }
            if (bNumber2 != null && d3 < d) {
                bDouble = bNumber2;
            } else if (bNumber != null && d3 > d2) {
                bDouble = bNumber;
            }
        }
        if (action == emergencyOverride || action == set) {
            return bDouble;
        }
        if (action == override) {
            BNumericOverride bNumericOverride = new BNumericOverride(bDouble.getDouble());
            bNumericOverride.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return bNumericOverride;
        }
        if (action == absOverride) {
            BAbsTime bAbsTime = Clock.time().add(this.getDefaultTime());
            BAbsNumericOverride bAbsNumericOverride = new BAbsNumericOverride(bAbsTime, bDouble.getDouble());
            bAbsNumericOverride.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return bAbsNumericOverride;
        }
        return super.getActionParameterDefault(action);
    }

    BRelTime getMaxOverrideDuration() {
        BRelTime bRelTime = BRelTime.DEFAULT;
        try {
            BFacets bFacets = this.getFacets();
            BObject bObject = bFacets.get("maxOverrideDuration");
            if (bObject instanceof BRelTime) {
                bRelTime = (BRelTime)bObject;
            } else {
                BStation bStation = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)this);
                if (!bStation.isRunning()) {
                    bStation.loadSlots();
                    bStation.lease();
                }
                bFacets = (BFacets)bStation.get("sysInfo");
                bRelTime = (BRelTime)bFacets.get("maxOverrideDuration", (BObject)bRelTime);
            }
        }
        catch (Exception exception) {}
        return bRelTime;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.slave = null;
        this.pointSub = null;
    }

    public BAbsNumericWritableCommand() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonProUtil$points$BAbsNumericWritableCommand;
        if (clazz == null) {
            clazz = class$com$vykon$vykonProUtil$points$BAbsNumericWritableCommand = BAbsNumericWritableCommand.class("[Lcom.vykon.vykonProUtil.points.BAbsNumericWritableCommand;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"control/numericPoint.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PointSubscriber
    extends Subscriber {
        public void event(BComponentEvent bComponentEvent) {
            int n = bComponentEvent.getId();
            if (n == 0) {
                if (bComponentEvent.getSlotName().equals("fallback")) {
                    double d = ((BStatusNumeric)BAbsNumericWritableCommand.this.slave.get("fallback")).getValue();
                    BAbsNumericWritableCommand.this.setFallback(d);
                }
                if (bComponentEvent.getSlotName().equals("out")) {
                    BAbsNumericWritableCommand.this.setOut(BAbsNumericWritableCommand.this.slave.getOut().getValue());
                }
                if (bComponentEvent.getSlotName().equals("facets")) {
                    BAbsNumericWritableCommand.this.setFacets(BAbsNumericWritableCommand.this.slave.getFacets());
                }
            }
        }

        private PointSubscriber() {
        }
    }
}

