/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.example.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.baja.file.FileUtil;
import javax.baja.util.PatternFilter;

public class JarTool {
    public static void usage() {
        System.out.println("usage:");
        System.out.println("  JarTool strip <jar> <pattern>");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            JarTool.usage();
            return;
        }
        String string = stringArray[0];
        if (string.equals("strip")) {
            if (stringArray.length < 3) {
                JarTool.usage();
                return;
            }
            int n = JarTool.strip(0, new File(stringArray[1]), new PatternFilter(stringArray[2]));
            System.out.println("Processed " + n + " files.");
        } else {
            JarTool.usage();
        }
    }

    public static int strip(int n, File file, PatternFilter patternFilter) throws Exception {
        if (!file.exists()) {
            System.out.println("ERROR: File not found: " + file);
            return n;
        }
        if (file.isDirectory()) {
            System.out.println("Recursing '" + file + "'...");
            File[] fileArray = file.listFiles();
            int n2 = 0;
            while (fileArray != null && n2 < fileArray.length) {
                n = JarTool.strip(n, fileArray[n2], patternFilter);
                ++n2;
            }
            return n;
        }
        String string = file.getName();
        String string2 = "";
        int n3 = string.lastIndexOf(46);
        if (n3 > 0) {
            string2 = string.substring(n3 + 1);
        }
        if (!string2.equalsIgnoreCase("jar") && !string2.equalsIgnoreCase("zip")) {
            return n;
        }
        System.out.println("Processing '" + file + "'...");
        File file2 = new File(file.getParent(), string + ".strip");
        ZipFile zipFile = new ZipFile(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string3 = zipEntry.getName();
            if (patternFilter.accept(string3)) {
                System.out.println("  Strip: '" + string3 + '\'');
                continue;
            }
            zipOutputStream.putNextEntry(new ZipEntry(string3));
            long l = zipEntry.getSize();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            FileUtil.pipe((InputStream)inputStream, (long)l, (OutputStream)zipOutputStream);
            inputStream.close();
            zipOutputStream.closeEntry();
        }
        zipFile.close();
        zipOutputStream.close();
        FileUtil.delete((File)file);
        if (!file2.renameTo(file)) {
            throw new IOException("rename failed");
        }
        System.out.println("  Processed.");
        return n + 1;
    }
}

