/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.example.modbus.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.example.modbus.messages.ModbusMessage;
import com.tridium.example.modbus.messages.ModbusOutputStream;
import com.tridium.example.modbus.messages.ModbusReceivedMessage;
import com.tridium.example.modbus.messages.WriteHoldingRegisterResponse;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

public class WriteHoldingRegisterMessage
extends ModbusMessage {
    private int registerAddress;
    private int value;

    public void write(OutputStream outputStream) {
        try {
            ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
            modbusOutputStream.write(this.deviceAddress);
            modbusOutputStream.write(this.functionCode);
            modbusOutputStream.writeInt(this.registerAddress);
            modbusOutputStream.writeInt(this.value);
            modbusOutputStream.writeLRC();
            outputStream.write(modbusOutputStream.toAsciiHexByteArray());
        }
        catch (Exception exception) {}
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        ModbusReceivedMessage modbusReceivedMessage = (ModbusReceivedMessage)receivedMessage;
        WriteHoldingRegisterResponse writeHoldingRegisterResponse = new WriteHoldingRegisterResponse(this);
        writeHoldingRegisterResponse.readResponse(modbusReceivedMessage.getBytes(), modbusReceivedMessage.getLength());
        return writeHoldingRegisterResponse;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n  Modbus Register Address = " + this.registerAddress);
        stringBuffer.append("\n  Modbus Value = " + this.value);
        try {
            ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
            modbusOutputStream.write(this.deviceAddress);
            modbusOutputStream.write(this.functionCode);
            modbusOutputStream.writeInt(this.registerAddress);
            modbusOutputStream.writeInt(this.value);
            modbusOutputStream.writeLRC();
            stringBuffer.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])modbusOutputStream.toAsciiHexByteArray()));
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public WriteHoldingRegisterMessage(int n, int n2, int n3) {
        super(n, 6);
        this.registerAddress = n2;
        this.value = n3;
    }
}

