/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.example.modbus.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.example.modbus.messages.ModbusMessage;
import com.tridium.example.modbus.messages.ModbusOutputStream;
import com.tridium.example.modbus.messages.ModbusReceivedMessage;
import com.tridium.example.modbus.messages.WriteCoilResponse;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WriteCoilMessage
extends ModbusMessage {
    private int coilAddress;
    private int value;

    public void write(OutputStream outputStream) {
        try {
            ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
            modbusOutputStream.write(this.deviceAddress);
            modbusOutputStream.write(this.functionCode);
            modbusOutputStream.writeInt(this.coilAddress);
            modbusOutputStream.writeInt(this.value);
            modbusOutputStream.writeLRC();
            outputStream.write(modbusOutputStream.toAsciiHexByteArray());
        }
        catch (Exception exception) {}
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        ModbusReceivedMessage modbusReceivedMessage = (ModbusReceivedMessage)receivedMessage;
        WriteCoilResponse writeCoilResponse = new WriteCoilResponse(this);
        writeCoilResponse.readResponse(modbusReceivedMessage.getBytes(), modbusReceivedMessage.getLength());
        return writeCoilResponse;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n  Modbus Coil Address = " + this.coilAddress);
        stringBuffer.append("\n  Modbus Value = " + this.value);
        try {
            ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
            modbusOutputStream.write(this.deviceAddress);
            modbusOutputStream.write(this.functionCode);
            modbusOutputStream.writeInt(this.coilAddress);
            modbusOutputStream.writeInt(this.value);
            modbusOutputStream.writeLRC();
            stringBuffer.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])modbusOutputStream.toAsciiHexByteArray()));
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.value = 0;
    }

    public WriteCoilMessage(int n, int n2, boolean bl) {
        super(n, 5);
        this.this();
        this.coilAddress = n2;
        this.value = bl ? 65280 : 0;
    }
}

