/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.example.modbus.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.example.modbus.messages.ModbusMessage;
import com.tridium.example.modbus.messages.ModbusOutputStream;
import com.tridium.example.modbus.messages.ModbusReceivedMessage;
import com.tridium.example.modbus.messages.ReadHoldingRegisterResponse;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

public class ReadHoldingRegisterMessage
extends ModbusMessage {
    private int registerAddress;
    private int count;

    public void write(OutputStream outputStream) {
        try {
            ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
            modbusOutputStream.write(this.deviceAddress);
            modbusOutputStream.write(this.functionCode);
            modbusOutputStream.writeInt(this.registerAddress);
            modbusOutputStream.writeInt(this.count);
            modbusOutputStream.writeLRC();
            outputStream.write(modbusOutputStream.toAsciiHexByteArray());
        }
        catch (Exception exception) {}
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        ModbusReceivedMessage modbusReceivedMessage = (ModbusReceivedMessage)receivedMessage;
        ReadHoldingRegisterResponse readHoldingRegisterResponse = new ReadHoldingRegisterResponse(this);
        readHoldingRegisterResponse.readResponse(modbusReceivedMessage.getBytes(), modbusReceivedMessage.getLength());
        return readHoldingRegisterResponse;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n  Modbus Register Address = " + this.registerAddress);
        stringBuffer.append("\n  Modbus Count = " + this.count);
        try {
            ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
            modbusOutputStream.write(this.deviceAddress);
            modbusOutputStream.write(this.functionCode);
            modbusOutputStream.writeInt(this.registerAddress);
            modbusOutputStream.writeInt(this.count);
            modbusOutputStream.writeLRC();
            stringBuffer.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])modbusOutputStream.toAsciiHexByteArray()));
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public ReadHoldingRegisterMessage(int n, int n2, int n3) {
        super(n, 3);
        this.registerAddress = n2;
        this.count = n3;
    }
}

