/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.example.modbus.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.example.modbus.messages.ModbusMessage;
import com.tridium.example.modbus.messages.ModbusOutputStream;
import com.tridium.example.modbus.messages.ModbusReceivedMessage;
import com.tridium.example.modbus.messages.ReadCoilResponse;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

public class ReadCoilMessage
extends ModbusMessage {
    private int coilAddress;
    private int count;

    public void write(OutputStream outputStream) {
        try {
            ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
            modbusOutputStream.write(this.deviceAddress);
            modbusOutputStream.write(this.functionCode);
            modbusOutputStream.writeInt(this.coilAddress);
            modbusOutputStream.writeInt(this.count);
            modbusOutputStream.writeLRC();
            outputStream.write(modbusOutputStream.toAsciiHexByteArray());
        }
        catch (Exception exception) {}
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        ModbusReceivedMessage modbusReceivedMessage = (ModbusReceivedMessage)receivedMessage;
        ReadCoilResponse readCoilResponse = new ReadCoilResponse(this);
        readCoilResponse.readResponse(modbusReceivedMessage.getBytes(), modbusReceivedMessage.getLength());
        return readCoilResponse;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n  Modbus Coil Address = " + this.coilAddress);
        stringBuffer.append("\n  Modbus Count = " + this.count);
        try {
            ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
            modbusOutputStream.write(this.deviceAddress);
            modbusOutputStream.write(this.functionCode);
            modbusOutputStream.writeInt(this.coilAddress);
            modbusOutputStream.writeInt(this.count);
            modbusOutputStream.writeLRC();
            stringBuffer.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])modbusOutputStream.toAsciiHexByteArray()));
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public ReadCoilMessage(int n, int n2, int n3) {
        super(n, 1);
        this.coilAddress = n2;
        this.count = n3;
    }
}

