/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.point;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.BAndoverNetwork;
import com.tridium.andoverAC256.enums.BAndoverReadEnabledStateEnum;
import com.tridium.andoverAC256.enums.BAndoverSendDisableEnum;
import com.tridium.andoverAC256.messages.AndoverDataResponse;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverReceivedMessage;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.andoverAC256.point.BAndoverPointDeviceExt;
import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.basicdriver.util.BasicWriteAsyncRequest;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAndoverProxyExt
extends BBasicProxyExt
implements BIBasicPollable,
AndoverMessageConst {
    public static final Property assignedName = BAndoverProxyExt.newProperty((int)0, (String)"", null);
    public static final Property rawValue = BAndoverProxyExt.newProperty((int)7, (String)"", null);
    public static final Property pointOrigin = BAndoverProxyExt.newProperty((int)1, (String)"unknown", null);
    public static final Property pointNotes = BAndoverProxyExt.newProperty((int)0, (String)"", null);
    public static final Property sendDisableCommand = BAndoverProxyExt.newProperty((int)0, (BValue)BAndoverSendDisableEnum.onEveryWrite, null);
    public static final Property readEnabledState = BAndoverProxyExt.newProperty((int)0, (BValue)BAndoverReadEnabledStateEnum.onEveryRead, null);
    public static final Property nativeEnableState = BAndoverProxyExt.newProperty((int)3, (boolean)false, null);
    public static final Property pollFrequency = BAndoverProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Type TYPE;
    protected boolean overflow;
    boolean enabledStateHasBeenRead;
    boolean disableCommandHasBeenSent;
    static /* synthetic */ Class class$com$tridium$andoverAC256$point$BAndoverProxyExt;

    public String getAssignedName() {
        return this.getString(assignedName);
    }

    public void setAssignedName(String string) {
        this.setString(assignedName, string, null);
    }

    public String getRawValue() {
        return this.getString(rawValue);
    }

    public void setRawValue(String string) {
        this.setString(rawValue, string, null);
    }

    public String getPointOrigin() {
        return this.getString(pointOrigin);
    }

    public void setPointOrigin(String string) {
        this.setString(pointOrigin, string, null);
    }

    public String getPointNotes() {
        return this.getString(pointNotes);
    }

    public void setPointNotes(String string) {
        this.setString(pointNotes, string, null);
    }

    public BAndoverSendDisableEnum getSendDisableCommand() {
        return (BAndoverSendDisableEnum)this.get(sendDisableCommand);
    }

    public void setSendDisableCommand(BAndoverSendDisableEnum bAndoverSendDisableEnum) {
        this.set(sendDisableCommand, (BValue)bAndoverSendDisableEnum, null);
    }

    public BAndoverReadEnabledStateEnum getReadEnabledState() {
        return (BAndoverReadEnabledStateEnum)this.get(readEnabledState);
    }

    public void setReadEnabledState(BAndoverReadEnabledStateEnum bAndoverReadEnabledStateEnum) {
        this.set(readEnabledState, (BValue)bAndoverReadEnabledStateEnum, null);
    }

    public boolean getNativeEnableState() {
        return this.getBoolean(nativeEnableState);
    }

    public void setNativeEnableState(boolean bl) {
        this.setBoolean(nativeEnableState, bl, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void poll() {
        AndoverReceivedMessage andoverReceivedMessage;
        AndoverGenericRequest andoverGenericRequest;
        if (this.isTraceOn()) {
            this.getAcLog().trace(this.getName() + " :poll for " + this.getAssignedName());
        }
        if (!this.isValid()) {
            return;
        }
        if (this.device().getCurrentDomain() != 0 && this.device().setDomain(0) != 0) {
            this.readFail("domain not set to 0 on read data attempt");
            return;
        }
        if (this.needToReadEnabledState()) {
            andoverGenericRequest = new AndoverGenericRequest("P DIS " + this.getAssignedName() + '\n', 12);
            andoverReceivedMessage = (AndoverStringResponse)this.network().sendSync(andoverGenericRequest);
            if (andoverReceivedMessage != null) {
                if (!andoverReceivedMessage.isError()) {
                    boolean bl = false;
                    if (andoverReceivedMessage.getMessage().indexOf("Enabled") != -1) {
                        bl = true;
                    }
                    this.setNativeEnableState(bl);
                    this.enabledStateHasBeenRead = true;
                }
            } else {
                this.device().ping();
            }
        }
        andoverGenericRequest = new AndoverGenericRequest("P " + this.getAssignedName() + '\n', 4);
        andoverReceivedMessage = (AndoverDataResponse)this.network().sendSync(andoverGenericRequest);
        if (andoverReceivedMessage != null) {
            if (!andoverReceivedMessage.isError()) {
                this.getAcLog().trace("Read Succeeded!");
                this.setValue((AndoverDataResponse)andoverReceivedMessage);
            } else {
                this.getAcLog().trace("Read Response is Error!");
                this.readFail(andoverReceivedMessage.getError());
            }
        } else {
            this.getAcLog().trace("Read Failed - no response!");
            this.readFail("No Response");
            this.device().ping();
        }
    }

    public boolean isValid() {
        boolean bl = false;
        if (this.getAssignedName() != null) {
            bl = true;
        }
        boolean bl2 = false;
        if (this.getAssignedName().trim() != "") {
            bl2 = true;
        }
        return bl | bl2;
    }

    public void setValue(AndoverDataResponse andoverDataResponse) {
    }

    public void started() throws Exception {
        super.started();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)assignedName)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
            this.enabledStateHasBeenRead = false;
            this.disableCommandHasBeenSent = false;
        }
    }

    public boolean sendCommand(String string) {
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest(string, 12);
        AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.network().sendSync(andoverGenericRequest);
        if (andoverStringResponse == null || andoverStringResponse.isError()) {
            if (this.isTraceOn()) {
                this.getAcLog().error("command not successful: " + string);
            }
            if (andoverStringResponse == null) {
                this.device().ping();
            }
            return false;
        }
        if (this.isTraceOn()) {
            this.getAcLog().trace(andoverStringResponse.toString());
        }
        return true;
    }

    public boolean write(Context context) throws Exception {
        if (this.getMode() != BReadWriteMode.readonly) {
            BStatusValue bStatusValue = this.getWriteValue();
            BBasicNetwork bBasicNetwork = (BBasicNetwork)this.getNetwork();
            if (bStatusValue.getStatus().isNull()) {
                try {
                    bBasicNetwork.postWrite(new Runnable(){

                        public final void run() {
                            BAndoverProxyExt.this.doAuto();
                        }
                    });
                }
                catch (Exception exception) {
                    this.writeFail("posting Enable command failed" + exception);
                    bBasicNetwork.getLog().error(this.getSlotPath().toString() + "post Auto failed", (Throwable)exception);
                }
            } else {
                if (bBasicNetwork.getLog().isTraceOn()) {
                    bBasicNetwork.getLog().trace("Write <" + this + "> " + bStatusValue);
                }
                try {
                    bBasicNetwork.postWrite((Runnable)new BasicWriteAsyncRequest((BBasicProxyExt)this, bStatusValue));
                }
                catch (Exception exception) {
                    this.writeFail("posting Write Failed," + exception);
                    bBasicNetwork.getLog().error("Could not post write for " + this.getParent().getName(), (Throwable)exception);
                }
            }
        }
        return false;
    }

    public void doAuto() {
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("EN " + this.getAssignedName() + '\n', 12);
        AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.network().sendSync(andoverGenericRequest);
        if (andoverStringResponse != null && !andoverStringResponse.isError()) {
            this.setNativeEnableState(true);
            this.enabledStateHasBeenRead = true;
        }
    }

    public void doWrite(BStatusValue bStatusValue) {
        bStatusValue.getStatus().isNull();
        if (bStatusValue == null) {
            this.updateOutput(this.getWriteValue());
        } else {
            this.updateOutput(bStatusValue);
        }
        if (this.getParentPoint().isSubscribed()) {
            this.poll();
        }
    }

    private final boolean updateOutput(BStatusValue bStatusValue) {
        if (this.needToSendDisableCommand() && this.sendCommand("DIS " + this.getAssignedName() + '\n')) {
            this.disableCommandHasBeenSent = true;
        }
        String string = null;
        if (bStatusValue instanceof BStatusBoolean) {
            boolean bl = ((BStatusBoolean)bStatusValue).getValue();
            if (bl) {
                string = "ON";
            }
            if (!bl) {
                string = "OFF";
            }
        } else if (bStatusValue instanceof BStatusNumeric) {
            double d = ((BStatusNumeric)bStatusValue).getValue();
            Float f = new Float(d);
            string = this.formatFloatString(f);
        } else if (bStatusValue instanceof BStatusString) {
            string = ((BStatusString)bStatusValue).getValue();
        } else if (bStatusValue instanceof BStatusEnum) {
            string = Integer.toString(((BStatusEnum)bStatusValue).getEnum().getOrdinal());
        } else {
            this.writeFail("unsupported data type");
            return false;
        }
        if (string == null) {
            this.writeFail("cannot write null to device");
            return false;
        }
        AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("MOD " + string + ' ' + this.getAssignedName() + '\n', 12);
        AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.network().sendSync(andoverGenericRequest);
        if (andoverStringResponse == null) {
            this.writeFail("device time out");
            this.device().ping();
            return false;
        }
        if (andoverStringResponse.isError()) {
            this.writeFail(andoverStringResponse.getErrorMsg());
            return false;
        }
        this.writeOk(bStatusValue);
        return true;
    }

    public Type getDeviceExtType() {
        return BAndoverPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void readSubscribed(Context context) throws Exception {
        if (this.isTraceOn()) {
            this.getAcLog().trace(this + ".readSubscribed() on " + this);
        }
        this.enabledStateHasBeenRead = false;
        this.network().getPollScheduler().subscribe((BIPollable)this);
    }

    public void readUnsubscribed(Context context) throws Exception {
        if (this.isTraceOn()) {
            this.getAcLog().trace(this + ".readUnsubscribed() on " + this);
        }
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
    }

    public void writeData(BStatusValue bStatusValue) {
        this.doWrite(bStatusValue);
    }

    protected String formatFloatString(Float f) {
        int n = f.intValue();
        float f2 = f.floatValue();
        String string = f.toString();
        if (n > 9999) {
            this.overflow = true;
            return "9999";
        }
        if (n < -9999) {
            this.overflow = true;
            return "-9999";
        }
        this.overflow = false;
        if (Math.abs(n) >= 1000) {
            n = Math.round(f2);
            Integer n2 = new Integer(n);
            return n2.toString();
        }
        if (Math.abs(n) >= 100) {
            n = Math.round(f2 * 10.0f);
            Integer n3 = new Integer(n);
            string = n3.toString();
            string = string.substring(0, string.length() - 1) + '.' + string.substring(string.length() - 1, string.length());
            return string;
        }
        if (Math.abs(n) >= 10) {
            n = Math.round(f2 * 100.0f);
            Integer n4 = new Integer(n);
            string = n4.toString();
            string = string.substring(0, string.length() - 2) + '.' + string.substring(string.length() - 2, string.length());
            return string;
        }
        if (Math.abs(n) > 0) {
            n = Math.round(f2 * 1000.0f);
            Integer n5 = new Integer(n);
            string = n5.toString();
            string = string.substring(0, string.length() - 3) + '.' + string.substring(string.length() - 3, string.length());
            return string;
        }
        n = Math.round(f2 * 10000.0f);
        Integer n6 = new Integer(n);
        if (n6 == 0) {
            return "0";
        }
        string = n6.toString();
        int n7 = string.length();
        switch (n7) {
            case 1: {
                string = "0.000" + string;
                break;
            }
            case 2: {
                if (f2 < 0.0f) {
                    string = "-.000" + string.substring(1);
                    break;
                }
                string = "0.00" + string;
                break;
            }
            case 3: {
                if (f2 < 0.0f) {
                    string = "-.00" + string.substring(1);
                    break;
                }
                string = "0.0" + string;
                break;
            }
            case 4: {
                if (f2 < 0.0f) {
                    string = "-.0" + string.substring(1);
                    break;
                }
                string = "0." + string;
                break;
            }
            case 5: {
                string = "-." + string.substring(1);
                break;
            }
        }
        return string;
    }

    public boolean needToSendDisableCommand() {
        if (this.getSendDisableCommand() == BAndoverSendDisableEnum.never) {
            return false;
        }
        if (this.getSendDisableCommand() == BAndoverSendDisableEnum.onEveryWrite) {
            return true;
        }
        if (this.getSendDisableCommand() == BAndoverSendDisableEnum.onlyOnFirstWrite) {
            return this.disableCommandHasBeenSent ^ true;
        }
        return true;
    }

    public boolean needToReadEnabledState() {
        if (this.getReadEnabledState() == BAndoverReadEnabledStateEnum.never) {
            return false;
        }
        if (this.getReadEnabledState() == BAndoverReadEnabledStateEnum.onEveryRead) {
            return true;
        }
        if (this.getReadEnabledState() == BAndoverReadEnabledStateEnum.onlyOnFirstRead) {
            return this.enabledStateHasBeenRead ^ true;
        }
        return true;
    }

    protected BAndoverDevice device() {
        return (BAndoverDevice)this.getDevice();
    }

    protected BAndoverNetwork network() {
        return this.device().andoverNetwork();
    }

    protected boolean isTraceOn() {
        return this.getAcLog().isTraceOn();
    }

    protected Log getAcLog() {
        return this.device().andoverNetwork().getAcLog();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.overflow = false;
        this.enabledStateHasBeenRead = false;
        this.disableCommandHasBeenSent = false;
    }

    public BAndoverProxyExt(String string) {
        this.this();
        if (string != null && string != "") {
            this.setAssignedName(string);
        }
    }

    static {
        Class clazz = class$com$tridium$andoverAC256$point$BAndoverProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$andoverAC256$point$BAndoverProxyExt = BAndoverProxyExt.class("[Lcom.tridium.andoverAC256.point.BAndoverProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

