/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.datatypes.BAndoverSetOptionsConfig;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAndoverSetOptionsJob
extends BJob
implements AndoverMessageConst,
Runnable {
    public static final Type TYPE;
    private BAndoverDevice device;
    private BAndoverSetOptionsConfig config;
    static /* synthetic */ Class class$com$tridium$andoverAC256$job$BAndoverSetOptionsJob;

    public Type getType() {
        return TYPE;
    }

    public void doRun(Context context) {
        this.device.andoverNetwork().dispatch(this);
    }

    public void doCancel(Context context) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    public void run() {
        try {
            AndoverStringResponse andoverStringResponse;
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru AndoverDevice.submitSetOptionsJob()");
            }
            this.log().message("Set Options -> Start dedicated process...");
            int n = this.setDomain(0);
            if (n != 0) {
                this.failed(new Throwable("ERROR: CANNOT SET DOMAIN 0, ABORTING..."));
                return;
            }
            this.device.setDriverState(2);
            this.log().message("Set Options -> Sending command...");
            String string = "OPTION\n";
            do {
                AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest(string, 12);
                andoverStringResponse = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, this.device.andoverNetwork().getResponseTimeout(), 0);
                if (andoverStringResponse == null) {
                    this.device.setDriverState(1);
                    andoverGenericRequest = new AndoverGenericRequest("'", 12);
                    this.device.andoverNetwork().getComm().transmitNoResponse((Message)andoverGenericRequest);
                    this.setDomain(0);
                    this.failed(new Throwable("no response to querry command: " + string));
                    return;
                }
                if (!andoverStringResponse.message.endsWith("?")) continue;
                if (andoverStringResponse.message.indexOf("Console Port Speed") != -1) {
                    string = "" + this.config.getConsolePortSpeed().getOrdinal() + '\n';
                    this.progress(10);
                    continue;
                }
                if (andoverStringResponse.message.indexOf("Console Inactivity") != -1) {
                    string = this.config.getConsoleInactivityAutoLogoff() ? "E\n" : "D\n";
                    this.progress(20);
                    continue;
                }
                if (andoverStringResponse.message.indexOf("Console Message Buffering") != -1) {
                    string = this.config.getConsoleMessageBuffering() ? "E\n" : "D\n";
                    this.progress(30);
                    continue;
                }
                if (andoverStringResponse.message.indexOf("S-Port Speed") != -1) {
                    string = "" + this.config.getSPortSpeed().getOrdinal() + '\n';
                    this.progress(40);
                    continue;
                }
                if (andoverStringResponse.message.indexOf("S-Port Inactivity") != -1) {
                    string = this.config.getSPortInactivityAutoLogoff() ? "E\n" : "D\n";
                    this.progress(50);
                    continue;
                }
                if (andoverStringResponse.message.indexOf("S-Port Message Buffering") != -1) {
                    string = this.config.getSPortMessageBuffering() ? "E\n" : "D\n";
                    this.progress(60);
                    continue;
                }
                if (andoverStringResponse.message.indexOf("Master I.D. Number") != -1) {
                    string = "" + this.config.getMasterIDNumber() + '\n';
                    this.progress(70);
                    continue;
                }
                if (andoverStringResponse.message.indexOf("X-Bus Speed") != -1) {
                    string = "" + this.config.getXBusSpeed().getOrdinal() + '\n';
                    this.progress(80);
                    continue;
                }
                if (andoverStringResponse.message.indexOf("L-Bus Speed") != -1) {
                    string = "" + this.config.getLBusSpeed().getOrdinal() + '\n';
                    this.progress(90);
                    continue;
                }
                if (andoverStringResponse.message.indexOf("ACNET Speed") != -1) {
                    string = "" + this.config.getAcnetSpeed().getOrdinal() + '\n';
                    this.progress(100);
                    continue;
                }
                string = "\n";
            } while (andoverStringResponse.message.endsWith("?"));
            if (!andoverStringResponse.message.endsWith(">")) {
                this.failed(new Throwable("ERROR: set options command failed - no return to R prompt"));
                this.device.setDriverState(1);
                this.setDomain(0);
                return;
            }
            this.log().message("QUERY_MODE: set options command is finished");
            this.device.setDriverState(1);
            this.setDomain(0);
            this.success();
        }
        catch (Exception exception) {
            this.device.setDriverState(1);
            exception.printStackTrace();
            this.failed(exception);
        }
    }

    private final int setDomain(int n) {
        if (!this.device.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest andoverGenericRequest = new AndoverGenericRequest("DOM " + n + '\n', 12);
            AndoverStringResponse andoverStringResponse = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)andoverGenericRequest, BRelTime.makeSeconds((int)10), 0);
            if (andoverStringResponse == null) {
                this.log().message("    ERROR: could not set to domain " + n);
                return -1;
            }
            if (andoverStringResponse.isError()) {
                this.log().message("    ERROR: could not set to domain " + n);
                return -1;
            }
            this.device.setCurrentDomain(andoverStringResponse.getDomain());
            return andoverStringResponse.getDomain();
        }
        catch (Exception exception) {
            this.log().message("ERROR setting domain to " + n + ": " + exception);
            return -1;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAndoverSetOptionsJob() {
    }

    public BAndoverSetOptionsJob(BAndoverDevice bAndoverDevice, BAndoverSetOptionsConfig bAndoverSetOptionsConfig) {
        this.device = bAndoverDevice;
        this.config = bAndoverSetOptionsConfig;
    }

    static {
        Class clazz = class$com$tridium$andoverAC256$job$BAndoverSetOptionsJob;
        if (clazz == null) {
            clazz = class$com$tridium$andoverAC256$job$BAndoverSetOptionsJob = BAndoverSetOptionsJob.class("[Lcom.tridium.andoverAC256.job.BAndoverSetOptionsJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

