/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.ui.region;

import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.datatypes.BDownloadRegionParams;
import com.tridium.aapup.datatypes.BPupRegionRecord;
import com.tridium.aapup.datatypes.BUploadRegionParams;
import com.tridium.aapup.job.BPupDownloadRegionJob;
import com.tridium.aapup.job.BPupLearnRegionsJob;
import com.tridium.aapup.job.BPupUploadRegionJob;
import com.tridium.aapup.util.AaPupSplUtil;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import java.io.IOException;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupRegionManager
extends BWbComponentView {
    public static final Type TYPE;
    static final UiLexicon lexicon;
    static final BImage icon;
    static BOrd defaultDir;
    BJobBar jobBar;
    BTable table;
    DiscoverRegions cmdDiscoverRegions;
    DownloadProgram cmdDownloadProgram;
    UploadProgram cmdUploadProgram;
    FreeRegion cmdFreeRegion;
    UnlockRegion cmdUnlockRegion;
    BPupDevice device;
    BPupRegionRecord[] recs;
    boolean discRegionsJobComplete;
    boolean downloadJobComplete;
    boolean uploadJobComplete;
    Vector discoveredRegions;
    static /* synthetic */ Class class$com$tridium$aapup$ui$region$BPupRegionManager;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.device = (BPupDevice)bObject;
        this.reload();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        DiscoverRegions discoverRegions = this.cmdDiscoverRegions;
        BJob bJob = discoverRegions.getJob();
        boolean bl = false;
        if (bJob != null) {
            bl = true;
        }
        boolean bl2 = false;
        if (bComponentEvent.getSourceComponent() == bJob) {
            bl2 = true;
        }
        if (bl & bl2) {
            String string;
            if (bComponentEvent.getId() == 5 && (string = bComponentEvent.getSlotName()) == "regionLearned") {
                BPupRegionRecord bPupRegionRecord = (BPupRegionRecord)bComponentEvent.getValue();
                this.discoveredRegions.addElement(bPupRegionRecord);
                this.reload();
            }
            if (bJob.getJobState().isComplete() && !this.discRegionsJobComplete) {
                this.discRegionsJobComplete = true;
                this.reload();
            }
            return;
        }
        DownloadProgram downloadProgram = this.cmdDownloadProgram;
        BJob bJob2 = downloadProgram.getJob();
        boolean bl3 = false;
        if (bJob2 != null) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (bComponentEvent.getSourceComponent() == bJob2) {
            bl4 = true;
        }
        if (bl3 & bl4) {
            if (bJob2.getJobState().isComplete() && !this.downloadJobComplete) {
                this.downloadJobComplete = true;
                this.reload();
            }
            return;
        }
        UploadProgram uploadProgram = this.cmdUploadProgram;
        BJob bJob3 = uploadProgram.getJob();
        boolean bl5 = false;
        if (bJob3 != null) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (bComponentEvent.getSourceComponent() == bJob3) {
            bl6 = true;
        }
        if (bl5 & bl6) {
            if (bJob3.getJobState().isComplete() && !this.uploadJobComplete) {
                this.uploadJobComplete = true;
                this.reload();
            }
            return;
        }
        if (bComponentEvent.getSourceComponent() == this.device) {
            if (bComponentEvent.getId() == 5) {
                String string = bComponentEvent.getSlotName();
                if (string == "tableUpdated") {
                    this.reload();
                } else if (string == "regionChanged") {
                    this.cmdDiscoverRegions.invoke();
                }
            }
            return;
        }
    }

    public void reload() {
        this.recs = new BPupRegionRecord[this.discoveredRegions.size()];
        this.discoveredRegions.copyInto((Object[])this.recs);
        this.table.getModel().updateTable();
        this.updateCommands();
    }

    private final void disableCommands() {
        this.cmdDiscoverRegions.setEnabled(false);
        this.cmdDownloadProgram.setEnabled(false);
        this.cmdUploadProgram.setEnabled(false);
        this.cmdFreeRegion.setEnabled(false);
        this.cmdUnlockRegion.setEnabled(false);
    }

    private final void updateCommands() {
        boolean bl = false;
        if (this.cmdDiscoverRegions.getJob() != null) {
            bl = true;
        }
        boolean bl2 = bl & (this.discRegionsJobComplete ^ true);
        boolean bl3 = false;
        if (this.cmdDownloadProgram.getJob() != null) {
            bl3 = true;
        }
        boolean bl4 = bl3 & (this.downloadJobComplete ^ true);
        boolean bl5 = false;
        if (this.cmdUploadProgram.getJob() != null) {
            bl5 = true;
        }
        boolean bl6 = bl5 & (this.uploadJobComplete ^ true);
        if (bl2 || bl4 || bl6) {
            this.disableCommands();
            return;
        }
        int n = this.table.getSelection().getRowCount();
        int n2 = this.table.getModel().getRowCount();
        this.cmdDiscoverRegions.setEnabled(true);
        boolean bl7 = false;
        if (n2 > 0) {
            bl7 = true;
        }
        this.cmdDownloadProgram.setEnabled(bl7);
        if (n == 1) {
            int n3 = this.table.getSelection().getRow();
            BString bString = (BString)this.table.getModel().getValueAt(n3, 6);
            BBoolean bBoolean = (BBoolean)this.table.getModel().getValueAt(n3, 9);
            boolean bl8 = false;
            if (bString.getString() != "") {
                bl8 = true;
            }
            this.cmdUploadProgram.setEnabled(bl8);
            boolean bl9 = false;
            if (bString.getString() != "") {
                bl9 = true;
            }
            this.cmdFreeRegion.setEnabled(bl9);
            this.cmdUnlockRegion.setEnabled(bBoolean.getBoolean());
        } else {
            this.cmdUploadProgram.setEnabled(false);
            this.cmdFreeRegion.setEnabled(false);
            this.cmdUnlockRegion.setEnabled(false);
        }
    }

    static FilePath toFilePath(BOrd bOrd) {
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = 0;
        while (n < ordQueryArray.length) {
            if (ordQueryArray[n] instanceof FilePath) {
                return (FilePath)ordQueryArray[n];
            }
            ++n;
        }
        throw new IllegalStateException();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cmdDiscoverRegions = new DiscoverRegions((BWidget)this);
        this.cmdDownloadProgram = new DownloadProgram((BWidget)this);
        this.cmdUploadProgram = new UploadProgram((BWidget)this);
        this.cmdFreeRegion = new FreeRegion((BWidget)this);
        this.cmdUnlockRegion = new UnlockRegion((BWidget)this);
        this.discRegionsJobComplete = false;
        this.downloadJobComplete = false;
        this.uploadJobComplete = false;
        this.discoveredRegions = new Vector();
    }

    public BPupRegionManager() {
        this.this();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5, (double)0.0, (double)5));
        bBorderPane.setFill(Theme.widget().getWindowBackground());
        bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
        this.table = new BTable((TableModel)new Model());
        this.table.setMultipleSelection(false);
        this.table.setSelection((TableSelection)new Selection());
        BTitlePane bTitlePane = BTitlePane.makePane((String)lexicon.getText("region.manager.title"), (BTable)this.table);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnCount(5);
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdDiscoverRegions));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdDownloadProgram));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdUploadProgram));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdFreeRegion));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdUnlockRegion));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)bBorderPane, BInsets.make((double)0.0, (double)0.0, (double)5, (double)0.0)));
        bEdgePane.setCenter((BWidget)bTitlePane);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)bEdgePane);
        this.registerForComponentEvents((BComponent)this.table);
    }

    static {
        Class clazz = class$com$tridium$aapup$ui$region$BPupRegionManager;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$ui$region$BPupRegionManager = BPupRegionManager.class("[Lcom.tridium.aapup.ui.region.BPupRegionManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$aapup$ui$region$BPupRegionManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$aapup$ui$region$BPupRegionManager = BPupRegionManager.class("[Lcom.tridium.aapup.ui.region.BPupRegionManager;", false);
        }
        lexicon = new UiLexicon(clazz2);
        icon = BImage.make((String)"module://icons/x16/backup.png");
        defaultDir = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DiscoverRegions
    extends Command {
        private BJob job;

        public CommandArtifact doInvoke() throws Exception {
            BOrd bOrd = BPupRegionManager.this.device.submitLearnRegionsJob(BInteger.make((int)BPupRegionManager.this.device.getUnitNumber()));
            BPupRegionManager.this.discoveredRegions.removeAllElements();
            BPupRegionManager.this.device.getComponentSpace().sync();
            this.job = (BPupLearnRegionsJob)bOrd.get((BObject)BPupRegionManager.this.device);
            BPupRegionManager.this.registerForComponentEvents((BComponent)this.job);
            this.job.lease();
            BPupRegionManager.this.jobBar.load(this.job);
            BPupRegionManager.this.discRegionsJobComplete = false;
            BPupRegionManager.this.disableCommands();
            return null;
        }

        public BJob getJob() {
            return this.job;
        }

        DiscoverRegions(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "region.manager.discoverRegions");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DownloadProgram
    extends Command {
        private BJob job;

        public CommandArtifact doInvoke() throws Exception {
            BFileChooser bFileChooser;
            if (defaultDir == null) {
                bFileChooser = new FilePath("!spl_backups");
                defaultDir = BOrd.make((OrdQuery)bFileChooser);
            }
            bFileChooser = BFileChooser.makeSave((BWidget)this.getOwner());
            bFileChooser.setCurrentDirectory(defaultDir);
            bFileChooser.setConfirmOverwrite(false);
            bFileChooser.addFilter((IFileFilter)new ExtFileFilter("PLB Files", new String[]{"plb", "PLB"}));
            BOrd bOrd = bFileChooser.show();
            if (bOrd == null) {
                return null;
            }
            BDownloadRegionParams bDownloadRegionParams = new BDownloadRegionParams();
            bDownloadRegionParams.setSplFile(bOrd);
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            String string = FileUtil.getBase((String)bIFile.getFileName());
            String string2 = string.length() > 8 ? string.substring(0, 8) : string;
            bDownloadRegionParams.setRegionName(string2);
            BDownloadRegionParams bDownloadRegionParams2 = (BDownloadRegionParams)BWbFieldEditor.dialog((BWidget)BPupRegionManager.this, (String)lexicon.get("region.manager.download.regionPromptTitle"), (BObject)bDownloadRegionParams);
            if (bDownloadRegionParams2 == null) {
                return null;
            }
            BPupRegionManager.this.device.getComponentSpace().sync();
            BPupRegionManager.this.device.lease(2, 60000L);
            try {
                bDownloadRegionParams2.setSplBlob(AaPupSplUtil.getSplBlob(bDownloadRegionParams2.getSplFile()));
            }
            catch (UnresolvedException unresolvedException) {
            }
            catch (IOException iOException) {}
            BPupRegionManager.this.device.setSplFile(bOrd);
            BOrd bOrd2 = BPupRegionManager.this.device.submitDownloadSplJob(bDownloadRegionParams2);
            BPupRegionManager.this.device.getComponentSpace().sync();
            this.job = (BPupDownloadRegionJob)bOrd2.get((BObject)BPupRegionManager.this.device);
            BPupRegionManager.this.registerForComponentEvents((BComponent)this.job);
            BPupRegionManager.this.jobBar.load(this.job);
            BPupRegionManager.this.downloadJobComplete = false;
            BPupRegionManager.this.table.getSelection().deselectAll();
            this.job.lease();
            return null;
        }

        public BJob getJob() {
            return this.job;
        }

        DownloadProgram(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "region.manager.download");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UploadProgram
    extends Command {
        private BPupUploadRegionJob job;

        public CommandArtifact doInvoke() throws Exception {
            BFileChooser bFileChooser;
            int n = BPupRegionManager.this.table.getSelection().getRow();
            BString bString = (BString)BPupRegionManager.this.table.getModel().getValueAt(n, 6);
            BInteger bInteger = (BInteger)BPupRegionManager.this.table.getModel().getValueAt(n, 4);
            BInteger bInteger2 = (BInteger)BPupRegionManager.this.table.getModel().getValueAt(n, 7);
            BUploadRegionParams bUploadRegionParams = new BUploadRegionParams();
            bUploadRegionParams.setRegionName(bString.getString());
            bUploadRegionParams.setRegionNumber(bInteger.getInt());
            bUploadRegionParams.setRegionSize(bInteger2.getInt());
            String string = "Upload of " + bString.getString() + ".PLB";
            if (defaultDir == null) {
                bFileChooser = new FilePath("!spl_backups");
                defaultDir = BOrd.make((OrdQuery)bFileChooser);
            }
            bFileChooser = BFileChooser.makeSave((BWidget)this.getOwner());
            bFileChooser.setCurrentDirectory(defaultDir);
            bFileChooser.setDefaultFileName(string);
            bFileChooser.addFilter((IFileFilter)new ExtFileFilter("PLB Files", new String[]{"plb", "PLB"}));
            BOrd bOrd = bFileChooser.show();
            if (bOrd == null) {
                return null;
            }
            defaultDir = bFileChooser.getCurrentDirectory();
            BFoxSession bFoxSession = (BFoxSession)BOrd.toSession((BObject)BPupRegionManager.this.device);
            int n2 = bFoxSession.getConnection().session().getRemoteId();
            bUploadRegionParams.setPostSessionId(n2);
            bUploadRegionParams.setPostPath(BPupRegionManager.toFilePath(bOrd).getBody());
            BOrd bOrd2 = BPupRegionManager.this.device.submitUploadRegionJob(bUploadRegionParams);
            BPupRegionManager.this.device.getComponentSpace().sync();
            this.job = (BPupUploadRegionJob)bOrd2.get((BObject)BPupRegionManager.this.device);
            BPupRegionManager.this.registerForComponentEvents((BComponent)this.job);
            BPupRegionManager.this.jobBar.load((BJob)this.job);
            BPupRegionManager.this.uploadJobComplete = false;
            BPupRegionManager.this.table.getSelection().deselectAll();
            return null;
        }

        public void setJob(BJob bJob) {
            this.job = (BPupUploadRegionJob)bJob;
        }

        public BJob getJob() {
            return this.job;
        }

        UploadProgram(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "region.manager.upload");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FreeRegion
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            int[] nArray = BPupRegionManager.this.table.getSelection().getRows();
            if (nArray.length != 1) {
                return null;
            }
            BInteger bInteger = (BInteger)BPupRegionManager.this.table.getModel().getValueAt(nArray[0], 4);
            int n = BDialog.confirm((BWidget)BPupRegionManager.this, (Object)("Free region " + bInteger.getInt() + " ?"));
            if (n == 8) {
                return null;
            }
            BPupRegionManager.this.device.lease();
            BPupRegionManager.this.device.freeRegion(bInteger);
            return null;
        }

        FreeRegion(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "region.manager.freeRegion");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UnlockRegion
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            int n = BPupRegionManager.this.table.getSelection().getRow();
            BInteger bInteger = (BInteger)BPupRegionManager.this.table.getModel().getValueAt(n, 4);
            int n2 = BDialog.confirm((BWidget)BPupRegionManager.this, (Object)("Unlock region " + bInteger.getInt() + " ?"));
            if (n2 == 8) {
                return null;
            }
            BPupRegionManager.this.device.getComponentSpace().sync();
            BPupRegionManager.this.device.lease(2, 60000L);
            BPupRegionManager.this.device.unlockRegion(bInteger);
            return null;
        }

        UnlockRegion(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "region.manager.unlockRegion");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TableModel {
        public int getRowCount() {
            return BPupRegionManager.this.recs.length;
        }

        public int getColumnCount() {
            return 10;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BPupRegionRecord.unitNumber.getDefaultDisplayName(null);
                }
                case 1: {
                    return BPupRegionRecord.serialNumber.getDefaultDisplayName(null);
                }
                case 2: {
                    return BPupRegionRecord.controllerType.getDefaultDisplayName(null);
                }
                case 3: {
                    return BPupRegionRecord.firmwareVersion.getDefaultDisplayName(null);
                }
                case 4: {
                    return BPupRegionRecord.regionNumber.getDefaultDisplayName(null);
                }
                case 5: {
                    return BPupRegionRecord.regionType.getDefaultDisplayName(null);
                }
                case 6: {
                    return BPupRegionRecord.regionName.getDefaultDisplayName(null);
                }
                case 7: {
                    return BPupRegionRecord.regionSize.getDefaultDisplayName(null);
                }
                case 8: {
                    return BPupRegionRecord.availableBufferSize.getDefaultDisplayName(null);
                }
                case 9: {
                    return BPupRegionRecord.regionLock.getDefaultDisplayName(null);
                }
            }
            return "???";
        }

        public Object getValueAt(int n, int n2) {
            BPupRegionRecord bPupRegionRecord = BPupRegionManager.this.recs[n];
            switch (n2) {
                case 0: {
                    return BInteger.make((int)bPupRegionRecord.getUnitNumber());
                }
                case 1: {
                    return BInteger.make((int)bPupRegionRecord.getSerialNumber());
                }
                case 2: {
                    return BInteger.make((int)bPupRegionRecord.getControllerType());
                }
                case 3: {
                    return BDouble.toString((double)bPupRegionRecord.getFirmwareVersion(), (Context)BFacets.makeNumeric((int)2));
                }
                case 4: {
                    return BInteger.make((int)bPupRegionRecord.getRegionNumber());
                }
                case 5: {
                    return BInteger.make((int)bPupRegionRecord.getRegionType());
                }
                case 6: {
                    return BString.make((String)bPupRegionRecord.getRegionName());
                }
                case 7: {
                    return BInteger.make((int)bPupRegionRecord.getRegionSize());
                }
                case 8: {
                    return BInteger.make((int)bPupRegionRecord.getAvailableBufferSize());
                }
                case 9: {
                    return BBoolean.make((boolean)bPupRegionRecord.getRegionLock());
                }
            }
            return "???";
        }

        public BImage getRowIcon(int n) {
            return icon;
        }

        public void updateTable() {
            super.updateTable();
        }

        Model() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Selection
    extends TableSelection {
        public void updateTable() {
            super.updateTable();
            BPupRegionManager.this.updateCommands();
        }

        Selection() {
        }
    }
}

