/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.point;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;
import com.tridium.aapup.messages.PupWriteAttributeMessage;
import com.tridium.aapup.messages.PupWriteTextAttributeMessage;
import com.tridium.aapup.point.BPupProxyExt;
import javax.baja.control.BStringPoint;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupStringProxyExt
extends BPupProxyExt
implements AaPupConst {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$aapup$point$BPupStringProxyExt;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BStringPoint;
    }

    public void setValue(PupResponse pupResponse) {
        BString bString;
        PupResponse pupResponse2;
        if (pupResponse instanceof PupNumericDataResponse) {
            pupResponse2 = (PupNumericDataResponse)pupResponse;
            bString = ((PupNumericDataResponse)pupResponse2).getString();
            this.setAttributeValue(((PupNumericDataResponse)pupResponse2).getString().getString());
        } else if (pupResponse instanceof PupTextDataResponse) {
            pupResponse2 = (PupTextDataResponse)pupResponse;
            bString = ((PupTextDataResponse)pupResponse2).getString();
            this.setAttributeValue(bString.getString());
        } else {
            this.readFail("message type incorrect");
            return;
        }
        pupResponse2 = (BStatusString)this.getReadValue().newCopy();
        pupResponse2.setValue(bString.getString());
        this.readOk((BStatusValue)pupResponse2);
    }

    boolean updateOutput(BStatusValue bStatusValue) {
        PupResponse pupResponse;
        Object object;
        if (!this.prewriteAttribute()) {
            this.writeFail("unable to set override or manual");
            return false;
        }
        String string = "";
        if (!(bStatusValue instanceof BStatusString)) {
            this.writeFail("attempt to write string data to non-string point");
            return false;
        }
        string = ((BStatusString)bStatusValue).getValue();
        if (this.getAttributeType() == 223 || this.getAttributeType() == 256) {
            object = (BStatusString)this.getParentPoint().getOutStatusValue();
            if (string.equals(object.getValue())) {
                return true;
            }
            PupWriteTextAttributeMessage pupWriteTextAttributeMessage = new PupWriteTextAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), string);
            pupResponse = (PupResponse)this.pupNetwork().sendSync(pupWriteTextAttributeMessage);
        } else {
            double d;
            try {
                d = this.convertStringToNumeric(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.writeFail("cannot convert string to number");
                return false;
            }
            PupWriteAttributeMessage pupWriteAttributeMessage = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), this.getAttributeType(), d);
            pupResponse = (PupResponse)this.pupNetwork().sendSync(pupWriteAttributeMessage);
        }
        if (!this.isValidWriteResponse(pupResponse)) {
            return false;
        }
        if (pupResponse instanceof PupAckResponse) {
            this.getPupLog().trace("Write Succeeded on " + this);
            this.writeOk(bStatusValue);
            return true;
        }
        if (pupResponse instanceof PupErrorResponse) {
            object = (PupErrorResponse)pupResponse;
            this.getPupLog().trace("Received error response writing " + this);
            this.writeFail(((PupErrorResponse)object).getError());
            return false;
        }
        this.getPupLog().trace("Received invalid message type writing " + this);
        this.writeFail("invalid message type");
        return false;
    }

    private final double convertStringToNumeric(String string) throws NumberFormatException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException3) {
                    return Float.parseFloat(string);
                }
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$aapup$point$BPupStringProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$point$BPupStringProxyExt = BPupStringProxyExt.class("[Lcom.tridium.aapup.point.BPupStringProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

