/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.InvalidEnumException;
import javax.baja.util.Lexicon;

public class PupTextDataResponse
extends PupResponse
implements AaPupConst {
    private static Lexicon lex = Lexicon.make((String)"aapup");
    String attributeName = this.getIn().readAttributeName();
    String text = this.getIn().readText();

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getText() {
        return this.text;
    }

    public boolean isFirst() {
        return this.getIn().isFirst();
    }

    public boolean isLast() {
        return this.getIn().isLast();
    }

    public boolean onlyAttribute() {
        return this.getIn().isFirst() & this.getIn().isLast();
    }

    public BDouble getDouble() {
        try {
            Long l = Long.valueOf(this.text);
            return BDouble.make((double)l.doubleValue());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(this.text);
                return BDouble.make((double)d);
            }
            catch (NumberFormatException numberFormatException2) {
                return BDouble.make((double)Double.NaN);
            }
        }
    }

    public BBoolean getBoolean(BFacets bFacets) {
        if (bFacets != null) {
            BString bString = (BString)bFacets.get("trueText");
            BString bString2 = (BString)bFacets.get("falseText");
            if (bString != null && bString2 != null) {
                if (this.text.equalsIgnoreCase(bString.getString())) {
                    return BBoolean.TRUE;
                }
                if (this.text.equalsIgnoreCase(bString2.getString())) {
                    return BBoolean.FALSE;
                }
            }
        }
        if (lex.getText("point.boolean.define." + this.text) == "1") {
            return BBoolean.TRUE;
        }
        if (lex.getText("point.boolean.define." + this.text) == "0") {
            return BBoolean.FALSE;
        }
        if (this.text.equalsIgnoreCase("true")) {
            return BBoolean.TRUE;
        }
        if (this.text.equalsIgnoreCase("one")) {
            return BBoolean.TRUE;
        }
        if (this.text.equalsIgnoreCase("1")) {
            return BBoolean.TRUE;
        }
        if (this.text.equalsIgnoreCase("positive")) {
            return BBoolean.TRUE;
        }
        if (this.text.equalsIgnoreCase("on")) {
            return BBoolean.TRUE;
        }
        return BBoolean.FALSE;
    }

    public BEnum getEnum(BFacets bFacets) {
        if (bFacets != null) {
            BEnum bEnum;
            BEnumRange bEnumRange = (BEnumRange)bFacets.get("range");
            try {
                bEnum = bEnumRange.get(this.text);
            }
            catch (InvalidEnumException invalidEnumException) {
                BDouble bDouble = this.getDouble();
                if (bDouble.getDouble() == Double.NaN) {
                    return null;
                }
                return bEnumRange.get((int)bDouble.getDouble());
            }
            return bEnum;
        }
        return null;
    }

    public BString getString() {
        return BString.make((String)this.text);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PupAckResponse:() from " + this.getIn().getUnitNumber() + '\n').append("  attributeName:" + this.attributeName + '\n').append("     is first attribute:" + this.isFirst()).append("     is last attribute :" + this.isLast()).append("  text         :" + this.text);
        return stringBuffer.toString();
    }

    public PupTextDataResponse(PupReceivedMessage pupReceivedMessage) {
        super(pupReceivedMessage);
    }
}

