/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupRegionDataResponse;
import com.tridium.aapup.messages.PupResponse;

public class PupReadRegionDataMessage
extends PupMessage
implements AaPupConst {
    private int regionNumber;
    private int offset;
    private int numBytes;

    public int getRegionNumber() {
        return this.regionNumber;
    }

    public void setRegionNumber(int n) {
        this.regionNumber = n;
        if (n < 0) {
            this.regionNumber = 0;
        }
        if (n > 255) {
            this.regionNumber = 255;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public void setoffset(int n) {
        this.offset = n;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public void setNumBytes(int n) {
        this.numBytes = n;
    }

    void writeBytes(PupOutputStream pupOutputStream) {
        pupOutputStream.write(10);
        pupOutputStream.write(5);
        pupOutputStream.write(this.regionNumber);
        pupOutputStream.writeInt(this.offset);
        pupOutputStream.writeInt(this.numBytes);
    }

    PupResponse getResponse(PupReceivedMessage pupReceivedMessage) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (pupReceivedMessage.getData()[4] == -128) {
            return new PupErrorResponse(pupReceivedMessage);
        }
        if (pupReceivedMessage.getData()[4] == -124) {
            return new PupRegionDataResponse(pupReceivedMessage);
        }
        return new PupErrorResponse(pupReceivedMessage);
    }

    public String toString() {
        return "PupReadRegionDataMessage::unit:" + this.unitNumber + " regionNumber:" + this.regionNumber + " offset:" + this.offset + " bytes to read" + this.numBytes;
    }

    public PupReadRegionDataMessage(int n, int n2, int n3, int n4) {
        super(n);
        this.regionNumber = n2;
        this.offset = n3;
        this.numBytes = n4;
    }
}

