/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;

public class PupFreeRegionMessage
extends PupMessage
implements AaPupConst {
    private int regionNumber;
    private boolean action;

    public int getRegionNumber() {
        return this.regionNumber;
    }

    public void setRegionNumber(int n) {
        this.regionNumber = n;
        if (n < 0) {
            this.regionNumber = 0;
        }
        if (n > 255) {
            this.regionNumber = 255;
        }
    }

    public boolean getAction() {
        return this.action;
    }

    public void setAction(boolean bl) {
        this.action = bl;
    }

    void writeBytes(PupOutputStream pupOutputStream) {
        pupOutputStream.write(7);
        pupOutputStream.write(29);
        pupOutputStream.write(this.regionNumber);
        pupOutputStream.write(this.action ? 1 : 0);
    }

    PupResponse getResponse(PupReceivedMessage pupReceivedMessage) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (pupReceivedMessage.getData()[4] == -128) {
            return new PupErrorResponse(pupReceivedMessage);
        }
        if (pupReceivedMessage.getData()[4] == -127) {
            return new PupAckResponse(pupReceivedMessage);
        }
        return new PupErrorResponse(pupReceivedMessage);
    }

    public String toString() {
        return "PupFreeRegionMessage::unit:" + this.unitNumber + " regionNumber:" + this.regionNumber + " action:" + (this.action ? "free region" : " unlock region");
    }

    public PupFreeRegionMessage(int n, int n2, boolean bl) {
        super(n);
        this.regionNumber = n2;
        this.action = bl;
    }
}

