/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.util.IntHashMap;
import javax.baja.util.Lexicon;

public class PupErrorResponse
extends PupResponse {
    private static final IntHashMap errMap = new IntHashMap();
    private static Lexicon lex = Lexicon.make((String)"aapup");
    int errorNumber = this.getIn().readInt();
    String errorText = this.getIn().readText();

    public int getErrorNumber() {
        return this.errorNumber;
    }

    public String getText() {
        if (this.errorText == null) {
            return "";
        }
        return this.errorText;
    }

    public String getError() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(errMap.get(this.getErrorNumber()));
        if (this.getText() != "") {
            stringBuffer.append("\n").append(this.getText());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ErrorResponse:() from " + this.getIn().getUnitNumber() + '\n').append("  errorCode  :" + this.errorNumber + '\n').append("  description:" + this.codeToString(this.errorNumber) + '\n').append("  errorText  :" + this.errorText);
        return stringBuffer.toString();
    }

    public String codeToString(int n) {
        String string = (String)errMap.get(this.errorNumber);
        if (string != null) {
            return string;
        }
        return "Unknown error code";
    }

    public PupErrorResponse(PupReceivedMessage pupReceivedMessage) {
        super(pupReceivedMessage);
    }

    static {
        errMap.put((int)((char)-1), (Object)lex.getText("errPUP.generalNAK"));
        errMap.put(65534, (Object)lex.getText("errPUP.commandNotSupported"));
        errMap.put(65533, (Object)lex.getText("errPUP.noSuchChannel"));
        errMap.put(65532, (Object)lex.getText("errPUP.noSuchAttribute"));
        errMap.put(65531, (Object)lex.getText("errPUP.valueNotAccepted"));
        errMap.put(65530, (Object)lex.getText("errPUP.noRegionNamesAvailable"));
        errMap.put(65529, (Object)lex.getText("errPUP.noSuchRegion"));
        errMap.put(65528, (Object)lex.getText("errPUP.regionInUse"));
        errMap.put(65527, (Object)lex.getText("errPUP.invalidRegionOffset"));
        errMap.put(65526, (Object)lex.getText("errPUP.bufferOverrun"));
        errMap.put(65525, (Object)lex.getText("errPUP.textOverrun"));
        errMap.put(65291, (Object)lex.getText("errPUP.incompatableKernel"));
        errMap.put(65290, (Object)lex.getText("errPUP.flashI2cReadFailure"));
        errMap.put(65289, (Object)lex.getText("errPUP.flashI2cWriteFailure"));
        errMap.put(65288, (Object)lex.getText("errPUP.flashI2cInitFailure"));
        errMap.put(65287, (Object)lex.getText("errPUP.flashCRCFailure"));
        errMap.put(65286, (Object)lex.getText("errPUP.flashRejectionError"));
        errMap.put(65285, (Object)lex.getText("errPUP.flashSubsystemError"));
        errMap.put(65284, (Object)lex.getText("errPUP.flashWriteEraseError"));
        errMap.put(65283, (Object)lex.getText("errPUP.flashProtectionError"));
        errMap.put(65282, (Object)lex.getText("errPUP.flashPacketSequenceError"));
        errMap.put(65281, (Object)lex.getText("errPUP.flashPacketError"));
    }
}

