/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BUploadRegionParams;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupReadRegionDataMessage;
import com.tridium.aapup.messages.PupRegionDataResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileStore;
import java.io.OutputStream;
import javax.baja.file.FilePath;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupUploadRegionJob
extends BSimpleJob
implements AaPupConst {
    public static final Type TYPE;
    String host;
    FilePath path;
    String user;
    private BPupNetwork network;
    private BPupDevice device;
    private BUploadRegionParams params;
    static /* synthetic */ Class class$com$tridium$aapup$job$BPupUploadRegionJob;

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        Object object;
        boolean bl = true;
        if (this.device == null) {
            throw new IllegalStateException("Must submit thru PupDevice.submitUploadRegionJob()");
        }
        int n = this.params.getPostSessionId();
        FoxSession foxSession = Fox.getSession((int)n);
        if (foxSession == null) {
            throw new Exception("Invalid fox session id: " + n);
        }
        BFoxConnection bFoxConnection = (BFoxConnection)foxSession.conn();
        BFileChannel bFileChannel = bFoxConnection.getChannels().getFileChannel();
        this.host = foxSession.getRemoteHost();
        this.path = new FilePath(this.params.getPostPath());
        this.user = context == null ? "unknown" : String.valueOf(context.getUser());
        this.logMessage("Host: " + this.host);
        this.logMessage("Path: " + this.path);
        this.logMessage("User: " + this.user);
        int n2 = this.params.getRegionNumber();
        System.out.println("uploading region number " + n2);
        String string = this.params.getRegionName();
        int n3 = this.params.getRegionSize();
        String string2 = "";
        byte[] byArray = new byte[n3];
        int n4 = this.device.getUnitNumber();
        if (!this.isAlive()) {
            return;
        }
        this.logMessage("Preparing to upload region " + this.params.getRegionName() + " to file " + this.params.getPostPath());
        this.progress(0);
        PupResponse pupResponse = (PupResponse)this.network.sendSync(new PupHelloMessage(this.device.getSerialNumber() | 0x8000));
        if (pupResponse != null && pupResponse.getIn().verifyChecksum() && pupResponse instanceof PupAckResponse) {
            n4 = this.device.getSerialNumber() | 0x8000;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = n3 - n6;
            if (n7 > 512) {
                n7 = 512;
            }
            if ((pupResponse = (PupResponse)this.network.sendSync(new PupReadRegionDataMessage(n4, n2, n6, n7), BRelTime.make((long)(this.network.getResponseTimeout().getMillis() * (long)3)), this.network.getRetryCount())) != null) {
                if (pupResponse.getIn().verifyChecksum()) {
                    if (pupResponse instanceof PupRegionDataResponse) {
                        object = (PupRegionDataResponse)pupResponse;
                        System.out.println("  --regRsp.getBytes().length:" + ((PupRegionDataResponse)object).getBytes().length);
                        System.out.println("  --regRsp.getOffset():" + ((PupRegionDataResponse)object).getOffset());
                        n5 = ((PupRegionDataResponse)object).getBytes().length;
                        try {
                            System.arraycopy(((PupRegionDataResponse)object).getBytes(), 0, byArray, ((PupRegionDataResponse)object).getOffset(), n5);
                            bl = false;
                        }
                        catch (Exception exception) {
                            System.out.println("failed arraycopy");
                            exception.printStackTrace();
                            this.failed(new Throwable("error writing region data: " + string2));
                            return;
                        }
                        n6 += n5;
                    }
                    if (pupResponse instanceof PupErrorResponse) {
                        PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
                        string2 = pupErrorResponse.getError();
                    } else {
                        string2 = "incorrect response message type";
                    }
                } else {
                    string2 = "bad checksum";
                }
            } else {
                string2 = "no response";
            }
            if (!bl) continue;
            this.failed(new Throwable("error writing region data: " + string2));
            return;
        }
        this.progress(90);
        this.logMessage("finished uploading region:" + n2 + '(' + string + ')');
        bFileChannel.makeFile(null, this.path);
        object = bFileChannel.write(new BFoxFileStore(null, this.path));
        ((OutputStream)object).write(byArray);
        ((OutputStream)object).close();
        this.logMessage("saved region:" + n2 + '(' + string + ") to file ");
        this.progress(100);
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.network != null) {
            int n = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Upload Region Job:" + string);
            this.network.getLog().setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPupUploadRegionJob() {
    }

    public BPupUploadRegionJob(BPupDevice bPupDevice, BUploadRegionParams bUploadRegionParams) {
        this.device = bPupDevice;
        this.params = bUploadRegionParams;
        this.network = bPupDevice.pupNetwork();
    }

    static {
        Class clazz = class$com$tridium$aapup$job$BPupUploadRegionJob;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$job$BPupUploadRegionJob = BPupUploadRegionJob.class("[Lcom.tridium.aapup.job.BPupUploadRegionJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

