/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BPupRegionRecord;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupLookupNamedRegionMessage;
import com.tridium.aapup.messages.PupRegionNameResponse;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupLearnRegionsJob
extends BSimpleJob
implements AaPupConst {
    public static final Property learnedRegions = BPupLearnRegionsJob.newProperty((int)0, (BValue)new BFolder(), null);
    public static final Topic regionLearned = BPupLearnRegionsJob.newTopic((int)0, null);
    public static final Type TYPE;
    private BPupNetwork network;
    private BPupDevice device;
    private int unitNumber;
    private int controllerType;
    private int numRegions;
    private int sn;
    private double version;
    static /* synthetic */ Class class$com$tridium$aapup$job$BPupLearnRegionsJob;

    public BFolder getLearnedRegions() {
        return (BFolder)this.get(learnedRegions);
    }

    public void setLearnedRegions(BFolder bFolder) {
        this.set(learnedRegions, (BValue)bFolder, null);
    }

    public void fireRegionLearned(BValue bValue) {
        this.fire(regionLearned, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        boolean bl = true;
        if (this.network == null) {
            throw new IllegalStateException("Must submit thru PupNetwork.submitDeviceDiscoveryJob()");
        }
        if (!this.isAlive()) {
            return;
        }
        this.logMessage("Scanning address " + this.unitNumber + "...");
        PupResponse pupResponse = (PupResponse)this.network.sendSync(new PupHelloMessage(this.unitNumber));
        if (pupResponse != null && pupResponse.getIn().verifyChecksum() && pupResponse instanceof PupAckResponse) {
            PupAckResponse pupAckResponse = (PupAckResponse)pupResponse;
            this.numRegions = pupAckResponse.getNumberOfRegions();
            bl = false;
        }
        if (bl) {
            this.failed(new Throwable("error reading number of regions"));
            return;
        }
        this.logMessage("device " + this.unitNumber + " has " + this.numRegions + " regions");
        this.progress(10);
        this.device.getRegions().removeAll();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        int n = 0;
        String string = "";
        int n2 = 0;
        while (n2 < this.numRegions) {
            n = 90 * n2 / this.numRegions + 10;
            this.progress(n);
            bl = true;
            pupResponse = (PupResponse)this.network.sendSync(new PupLookupNamedRegionMessage(this.device.getSerialNumber() | 0x8000, n2));
            if (pupResponse != null && pupResponse.getIn().verifyChecksum() && pupResponse instanceof PupRegionNameResponse) {
                PupRegionNameResponse pupRegionNameResponse = (PupRegionNameResponse)pupResponse;
                bl = false;
                BPupRegionRecord bPupRegionRecord = new BPupRegionRecord();
                bPupRegionRecord.setUnitNumber(this.unitNumber);
                bPupRegionRecord.setSerialNumber(this.sn);
                bPupRegionRecord.setControllerType(this.controllerType);
                bPupRegionRecord.setFirmwareVersion(this.version);
                bPupRegionRecord.setRegionNumber(pupRegionNameResponse.getRegionNumber());
                bPupRegionRecord.setRegionType(pupRegionNameResponse.getRegionType());
                string = pupRegionNameResponse.getRegionName();
                bPupRegionRecord.setRegionName(string);
                bPupRegionRecord.setRegionSize(pupRegionNameResponse.getRegionSize());
                bPupRegionRecord.setRegionLock(pupRegionNameResponse.isLocked());
                bPupRegionRecord.setAvailableBufferSize(pupRegionNameResponse.getRegionAvailableBufferSize());
                this.getLearnedRegions().add(null, (BValue)bPupRegionRecord);
                this.fireRegionLearned((BValue)bPupRegionRecord);
            }
            if (bl) {
                this.failed(new Throwable("error reading region name"));
                return;
            }
            this.logMessage("region:" + n2 + " device:" + this.unitNumber + " firmware:" + this.version + " name:" + string);
            ++n2;
        }
        this.progress(100);
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.network != null) {
            int n = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Learn Regions Job:" + string);
            this.network.getLog().setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPupLearnRegionsJob() {
    }

    public BPupLearnRegionsJob(BPupDevice bPupDevice, int n) {
        this.device = bPupDevice;
        this.network = bPupDevice.pupNetwork();
        this.unitNumber = n;
    }

    static {
        Class clazz = class$com$tridium$aapup$job$BPupLearnRegionsJob;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$job$BPupLearnRegionsJob = BPupLearnRegionsJob.class("[Lcom.tridium.aapup.job.BPupLearnRegionsJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

