/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BDownloadRegionParams;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupCreateNamedRegionMessage;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupFreeRegionMessage;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupRegionNameResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupWriteRegionDataMessage;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.io.ByteBuffer;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBlob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupDownloadRegionJob
extends BSimpleJob
implements AaPupConst {
    public static final Type TYPE;
    private BPupNetwork network;
    private BPupDevice device;
    private BDownloadRegionParams params;
    static /* synthetic */ Class class$com$tridium$aapup$job$BPupDownloadRegionJob;

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        PupErrorResponse pupErrorResponse;
        boolean bl = true;
        if (this.device == null) {
            throw new IllegalStateException("Must submit thru PupDevice.submitDeviceDiscoveryJob()");
        }
        byte[] byArray = this.getSplBytes();
        int n = 0;
        String string = "";
        int n2 = 0;
        String string2 = "";
        if (!this.isAlive()) {
            return;
        }
        this.logMessage("Creating region " + this.params.getRegionName() + " and will download from file " + this.params.getSplFile());
        int n3 = this.device.getUnitNumber();
        PupResponse pupResponse = (PupResponse)this.network.sendSync(new PupHelloMessage(this.device.getSerialNumber() | 0x8000));
        if (pupResponse != null && pupResponse.getIn().verifyChecksum() && pupResponse instanceof PupAckResponse) {
            n3 = this.device.getSerialNumber() | 0x8000;
        }
        if ((pupResponse = (PupResponse)this.network.sendSync(new PupCreateNamedRegionMessage(n3, this.params.getRegionName(), this.params.getRegionType(), byArray.length))) != null && pupResponse.getIn().verifyChecksum() && pupResponse instanceof PupRegionNameResponse) {
            PupRegionNameResponse pupRegionNameResponse = (PupRegionNameResponse)pupResponse;
            n = pupRegionNameResponse.getRegionNumber();
            string = pupRegionNameResponse.getRegionName();
            n2 = pupRegionNameResponse.getRegionAvailableBufferSize();
            bl = false;
        }
        if (bl) {
            this.failed(new Throwable("error creating region " + this.params.getRegionName() + " in device" + this.device.getUnitNumber()));
            return;
        }
        this.logMessage("created region " + this.params.getRegionName() + " in device" + this.device.getUnitNumber());
        this.progress(10);
        if ((n2 /= 2) > 512) {
            n2 = 512;
        }
        int n4 = byArray.length / n2;
        if (byArray.length % n2 > 0) {
            ++n4;
        }
        this.logMessage("sending " + byArray.length + " bytes, using buffer size " + n2);
        int n5 = 0;
        while (n5 < n4) {
            bl = true;
            byte[] byArray2 = (n5 + 1) * n2 <= byArray.length ? new byte[n2] : new byte[byArray.length % n2];
            System.arraycopy(byArray, n5 * n2, byArray2, 0, byArray2.length);
            pupResponse = (PupResponse)this.network.sendSync(new PupWriteRegionDataMessage(n3, n, n5 * n2, byArray2), BRelTime.make((long)(this.network.getResponseTimeout().getMillis() * (long)3)), 0);
            if (pupResponse != null) {
                if (pupResponse.getIn().verifyChecksum()) {
                    if (pupResponse instanceof PupAckResponse) {
                        bl = false;
                        this.logMessage("buffer " + n5 + " of size " + byArray2.length + " sent successfully");
                    }
                    if (pupResponse instanceof PupErrorResponse) {
                        pupErrorResponse = (PupErrorResponse)pupResponse;
                        string2 = pupErrorResponse.getError();
                    }
                } else {
                    string2 = "bad checksum";
                }
            } else {
                string2 = "no response";
            }
            if (bl) {
                this.failed(new Throwable("error writing region data: " + string2));
                return;
            }
            ++n5;
        }
        this.progress(90);
        this.logMessage("finished downloading region:" + n + '(' + string + ')');
        pupResponse = (PupResponse)this.network.sendSync(new PupFreeRegionMessage(this.device.getUnitNumber(), n, false));
        if (pupResponse != null) {
            if (pupResponse.getIn().verifyChecksum()) {
                if (pupResponse instanceof PupAckResponse) {
                    bl = false;
                }
                if (pupResponse instanceof PupErrorResponse) {
                    pupErrorResponse = (PupErrorResponse)pupResponse;
                    string2 = pupErrorResponse.getError();
                }
            } else {
                string2 = "bad checksum";
            }
        } else {
            string2 = "no response";
        }
        if (bl) {
            this.failed(new Throwable("error unlocking region: " + string2));
            return;
        }
        this.logMessage("unlocked region:" + n + '(' + string + ')');
        this.device.fireRegionChanged((BValue)BString.make((String)""));
        this.progress(100);
    }

    private final byte[] getSplBytes() throws IOException {
        BBlob bBlob = this.params.getSplBlob();
        if (bBlob == null || bBlob.copyBytes().length == 0) {
            this.logMessage("blob is null, checking to see if it is a station file ord");
            BOrd bOrd = this.params.getSplFile();
            if (bOrd != null) {
                this.logMessage("found station file ord");
                BIFile bIFile = (BIFile)bOrd.resolve().get();
                InputStream inputStream = bIFile.getInputStream();
                ByteBuffer byteBuffer = new ByteBuffer(inputStream.available());
                byteBuffer.readToEnd(inputStream);
                return byteBuffer.toByteArray();
            }
            throw new IllegalStateException("Oops...forgot to pass enough info about the firmware file to station VM.");
        }
        this.logMessage("file data is from blob");
        return bBlob.copyBytes();
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.network != null) {
            int n = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Download Region Job:" + string);
            this.network.getLog().setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPupDownloadRegionJob() {
    }

    public BPupDownloadRegionJob(BPupDevice bPupDevice, BDownloadRegionParams bDownloadRegionParams) {
        this.device = bPupDevice;
        this.params = bDownloadRegionParams;
        this.network = bPupDevice.pupNetwork();
    }

    static {
        Class clazz = class$com$tridium$aapup$job$BPupDownloadRegionJob;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$job$BPupDownloadRegionJob = BPupDownloadRegionJob.class("[Lcom.tridium.aapup.job.BPupDownloadRegionJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

