/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.PupException;
import com.tridium.aapup.datatypes.BPupPointDiscoveryConfig;
import com.tridium.aapup.job.BPupDiscoveryPoint;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupReadAttributeMessage;
import com.tridium.aapup.messages.PupReadChannelsMessage;
import com.tridium.aapup.messages.PupReadChannelsResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.TextUtil;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupDiscoverPointsJob
extends BSimpleJob
implements AaPupConst {
    public static final Property learnedPoints = BPupDiscoverPointsJob.newProperty((int)0, (BValue)new BFolder(), null);
    public static final Topic channelLearned = BPupDiscoverPointsJob.newTopic((int)0, null);
    public static final Type TYPE;
    private BPupDevice device;
    private BPupPointDiscoveryConfig config;
    private Vector channelMap;
    static /* synthetic */ Class class$com$tridium$aapup$job$BPupDiscoverPointsJob;

    public BFolder getLearnedPoints() {
        return (BFolder)this.get(learnedPoints);
    }

    public void setLearnedPoints(BFolder bFolder) {
        this.set(learnedPoints, (BValue)bFolder, null);
    }

    public void fireChannelLearned(BValue bValue) {
        this.fire(channelLearned, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        try {
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru PupDevice.submitPointDiscoveryJob()");
            }
            this.channelMap = new Vector();
            int n = this.config.getCm();
            int n2 = this.config.getCt();
            if (n2 == -1 || n == -1) {
                n2 = this.learnCt();
                n = this.learnCm();
                if (n2 == -1 || n == -1) {
                    this.logMessage("Error, controller type not determined");
                    this.progress(100);
                    this.failed(new Throwable("controller type not determined"));
                    return;
                }
                this.device.setControllerDescription(this.device.pupNetwork().getControllerDescription(n, n2));
            }
            if (this.supportsReadChannelsCommand(n, n2)) {
                this.getChannelMapByLearning();
            } else {
                this.getChannelMapFromXml(n, n2);
            }
            this.learnChannels();
        }
        catch (Throwable throwable) {
            this.failed(throwable);
        }
    }

    private final int learnCm() {
        int n = -1;
        PupResponse pupResponse = (PupResponse)this.device.pupNetwork().sendSync(new PupReadAttributeMessage(this.device.getUnitNumber(), 65280, "CM"));
        if (pupResponse != null && pupResponse.getIn().verifyChecksum()) {
            if (pupResponse.getIn().getUnitNumber() != this.device.getUnitNumber()) {
                this.logMessage("DiscoverPointsJob Error: Request to unit " + this.device.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                return n;
            }
            if (pupResponse instanceof PupNumericDataResponse) {
                PupNumericDataResponse pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
                n = pupNumericDataResponse.getDouble().getInt();
                this.device.setManufacturer(n);
                this.config.setCm(n);
            }
        }
        return n;
    }

    private final int learnCt() {
        int n = -1;
        PupResponse pupResponse = (PupResponse)this.device.pupNetwork().sendSync(new PupReadAttributeMessage(this.device.getUnitNumber(), 65280, "CT"));
        if (pupResponse != null && pupResponse.getIn().verifyChecksum()) {
            if (pupResponse.getIn().getUnitNumber() != this.device.getUnitNumber()) {
                this.logMessage("DiscoverPointsJob Error: Request to unit " + this.device.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                return n;
            }
            if (pupResponse instanceof PupNumericDataResponse) {
                PupNumericDataResponse pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
                n = pupNumericDataResponse.getDouble().getInt();
                this.device.setControllerType(n);
                this.config.setCt(n);
            }
        }
        return n;
    }

    private final void getChannelMapByLearning() throws Exception {
        int n = this.readChannel(0);
        this.logMessage("device " + this.device.getUnitNumber() + " has " + n + " channels");
        int n2 = 1;
        while (n2 != n) {
            block7: {
                String string;
                int n3;
                try {
                    n3 = this.readChannel(n2);
                }
                catch (PupException pupException) {
                    this.logMessage("error discovering the channel number for channel index " + n2 + ',' + pupException.toString());
                    break block7;
                }
                try {
                    string = this.readChannelDescription(n3);
                }
                catch (PupException pupException) {
                    string = Integer.toHexString(n3).toUpperCase();
                }
                this.logMessage(" -- index " + n2 + " is channel " + Integer.toHexString(n3) + " desc:" + string);
                if (string.trim().length() < 2) {
                    string = Integer.toHexString(n3).toUpperCase();
                }
                String string2 = this.createPointNamePrefix(string);
                this.logMessage("   -- prefix:" + string2);
                this.channelMap.add(new Channel(n3, string, string2));
                if (!this.isAlive()) {
                    return;
                }
            }
            ++n2;
        }
    }

    private final void learnChannels() {
        block11: {
            try {
                int n = this.channelMap.size();
                if (n <= 0) break block11;
                int n2 = 0;
                while (n2 < n) {
                    Channel channel = (Channel)this.channelMap.elementAt(n2);
                    if (channel.getChannel() <= this.config.getMaxChannel() && channel.getChannel() >= this.config.getMinChannel()) {
                        this.logMessage("Learning " + this.device.getUnitNumber() + '[' + channel.toString() + ']');
                        try {
                            this.learnChannel(channel, "  ", false, (BComponent)this.getLearnedPoints());
                        }
                        catch (InterruptedException interruptedException) {
                            this.logMessage("canceled by user before job completion");
                            return;
                        }
                        catch (Exception exception) {
                            if (channel.getChannel() > 61952 && channel.getChannel() < 62208) {
                                try {
                                    this.learnChannel(channel, "$$", false, (BComponent)this.getLearnedPoints());
                                }
                                catch (Exception exception2) {
                                    this.logMessage("error while learning attributes in channel " + Integer.toHexString(channel.getChannel()) + ", learn may be incomplete..., " + exception2.toString());
                                }
                            }
                            this.logMessage("error while learning attributes in channel " + Integer.toHexString(channel.getChannel()) + ", learn may be incomplete..., " + exception.toString());
                        }
                        this.progress((n2 + 1) * 100 / n);
                        if (!this.isAlive()) {
                            return;
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void learnChannel(Channel channel, String string, boolean bl, BComponent bComponent) throws Exception {
        int n = channel.getChannel();
        String string2 = channel.getDesc();
        String string3 = channel.getPrefix();
        PupReadAttributeMessage pupReadAttributeMessage = new PupReadAttributeMessage(this.device.getUnitNumber(), n, string);
        pupReadAttributeMessage.setFetchNextFlag(bl);
        PupResponse pupResponse = (PupResponse)this.device.pupNetwork().sendSync(pupReadAttributeMessage);
        if (pupResponse == null) throw new PupException("no response " + channel);
        if (!pupResponse.getIn().verifyChecksum()) throw new PupException("bad checksum " + channel);
        if (pupResponse.getIn().getUnitNumber() != this.device.getUnitNumber()) {
            throw new PupException("DiscoverPointsJob Error: Request to unit " + this.device.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
        }
        if (pupResponse instanceof PupNumericDataResponse) {
            PupNumericDataResponse pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
            String string4 = pupNumericDataResponse.getAttributeName();
            int n2 = pupNumericDataResponse.getDataType();
            BString bString = pupNumericDataResponse.getString();
            BPupDiscoveryPoint bPupDiscoveryPoint = new BPupDiscoveryPoint(n, string2, string4, n2, bString.toString(null), string3);
            bComponent.add(null, (BValue)bPupDiscoveryPoint);
            if (!pupNumericDataResponse.isLast()) {
                if (bComponent instanceof BPupDiscoveryPoint) {
                    try {
                        this.learnChannel(channel, string4, true, bComponent);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        throw interruptedException;
                    }
                    catch (Exception exception) {
                        this.logMessage("error:" + exception.toString());
                        return;
                    }
                } else {
                    try {
                        this.learnChannel(channel, string4, true, bPupDiscoveryPoint);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        throw interruptedException;
                    }
                    catch (Exception exception) {
                        this.logMessage("error:" + exception.toString());
                        return;
                    }
                }
            } else {
                this.fireChannelLearned((BValue)bComponent);
            }
            return;
        } else if (pupResponse instanceof PupTextDataResponse) {
            PupTextDataResponse pupTextDataResponse = (PupTextDataResponse)pupResponse;
            String string5 = pupTextDataResponse.getAttributeName();
            int n3 = 256;
            BPupDiscoveryPoint bPupDiscoveryPoint = new BPupDiscoveryPoint(n, string2, string5, n3, pupTextDataResponse.getText(), string3);
            bComponent.add(null, (BValue)bPupDiscoveryPoint);
            if (pupTextDataResponse.isLast()) return;
            if (bComponent instanceof BPupDiscoveryPoint) {
                this.learnChannel(channel, string5, true, bComponent);
                return;
            } else {
                this.learnChannel(channel, string5, true, bPupDiscoveryPoint);
            }
            return;
        } else {
            if (!(pupResponse instanceof PupErrorResponse)) throw new PupException("invalid response type " + channel + ' ' + pupResponse.toDebugString());
            PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
            throw new PupException("error response " + channel + pupErrorResponse.toString());
        }
    }

    private final boolean supportsReadChannelsCommand(int n, int n2) {
        try {
            BOrd bOrd = this.device.pupNetwork().getDeviceTypesFile();
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse();
            XElem[] xElemArray = xElem.elems("device");
            int n3 = 0;
            while (n3 < xElemArray.length) {
                int n4 = xElemArray[n3].geti("cm", 0);
                int n5 = xElemArray[n3].geti("ct", 0);
                if (n4 == n && n5 == n2) {
                    return xElemArray[n3].getb("rdChCmd", false);
                }
                ++n3;
            }
        }
        catch (Exception exception) {}
        return true;
    }

    private final void getChannelMapFromXml(int n, int n2) {
        try {
            BOrd bOrd = this.device.pupNetwork().getDeviceTypesFile();
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse();
            XElem[] xElemArray = xElem.elems("device");
            int n3 = 0;
            while (n3 < xElemArray.length) {
                int n4 = xElemArray[n3].geti("cm", 0);
                int n5 = xElemArray[n3].geti("ct", 0);
                if (n4 == n && n5 == n2) {
                    XElem[] xElemArray2 = xElemArray[n3].elems("channel");
                    int n6 = 0;
                    while (n6 < xElemArray2.length) {
                        try {
                            String string = xElemArray2[n6].get("address", "0x00");
                            int n7 = Integer.parseInt(string, 16);
                            String string2 = xElemArray2[n6].get("desc", "generic channel");
                            String string3 = xElemArray2[n6].get("prefix", "");
                            this.channelMap.add(new Channel(n7, string2, string3));
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        ++n6;
                    }
                    return;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final int readChannel(int n) throws Exception {
        PupReadChannelsMessage pupReadChannelsMessage = new PupReadChannelsMessage(this.device.getUnitNumber(), n);
        PupResponse pupResponse = (PupResponse)this.device.pupNetwork().sendSync(pupReadChannelsMessage);
        if (pupResponse != null) {
            if (pupResponse.getIn().verifyChecksum()) {
                if (pupResponse.getIn().getUnitNumber() != this.device.getUnitNumber()) {
                    throw new PupException("DiscoverPointsJob: Request to unit " + this.device.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                }
                if (pupResponse instanceof PupReadChannelsResponse) {
                    PupReadChannelsResponse pupReadChannelsResponse = (PupReadChannelsResponse)pupResponse;
                    int n2 = pupReadChannelsResponse.getIndex();
                    int n3 = pupReadChannelsResponse.getData();
                    if (n2 != n) {
                        throw new PupException("cannot learn channel " + n + ": returned index not equal to requested index");
                    }
                    return n3;
                }
                if (pupResponse instanceof PupErrorResponse) {
                    PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
                    throw new PupException("cannot learn channel " + n + ':' + pupErrorResponse.toString());
                }
                throw new PupException("cannot learn channel " + n + ": invalid response message type");
            }
            throw new PupException("cannot learn channel " + n + ": checksum error");
        }
        throw new PupException("cannot learn channel " + n + ": no response");
    }

    private final String readChannelDescription(int n) throws Exception {
        PupReadAttributeMessage pupReadAttributeMessage = new PupReadAttributeMessage(this.device.getUnitNumber(), n, "ON");
        PupResponse pupResponse = (PupResponse)this.device.pupNetwork().sendSync(pupReadAttributeMessage);
        if (pupResponse != null) {
            if (pupResponse.getIn().verifyChecksum()) {
                if (pupResponse.getIn().getUnitNumber() != this.device.getUnitNumber()) {
                    throw new PupException("DiscoverPointsJob Error: Request to unit " + this.device.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                }
                if (pupResponse instanceof PupTextDataResponse) {
                    PupTextDataResponse pupTextDataResponse = (PupTextDataResponse)pupResponse;
                    return pupTextDataResponse.getText();
                }
                if (pupResponse instanceof PupErrorResponse) {
                    PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
                    throw new PupException("device:" + this.device.getUnitNumber() + ", cannot learn description of channel " + Integer.toHexString(n) + ':' + pupErrorResponse.toString());
                }
                throw new PupException("device:" + this.device.getUnitNumber() + ",cannot learn description of channel " + Integer.toHexString(n) + ": invalid response message type");
            }
            throw new PupException("device:" + this.device.getUnitNumber() + ",cannot learn description of channel " + Integer.toHexString(n) + ": checksum error");
        }
        throw new PupException("device:" + this.device.getUnitNumber() + ",cannot learn description of channel " + Integer.toHexString(n) + ": no response");
    }

    /*
     * Unable to fully structure code
     */
    private final String createPointNamePrefix(String var1_1) {
        if (var1_1.length() == 4) {
            try {
                Integer.parseInt(var1_1, 16);
                return "Chan" + var1_1.toUpperCase();
            }
            catch (NumberFormatException v0) {}
        }
        var1_1 = TextUtil.toFriendly((String)var1_1);
        var3_2 = new StringBuffer();
        var4_3 = new StringTokenizer(var1_1);
        block4: while (var4_3.hasMoreTokens()) {
            block8: {
                var2_4 = var4_3.nextToken();
                try {
                    Integer.parseInt(var1_1, 10);
                    Integer.parseInt(var1_1, 16);
                    var3_2.append(var2_4.toUpperCase());
                    continue;
                }
                catch (Exception v1) {
                    if (var2_4.length() <= 3) break block8;
                    var3_2.append(TextUtil.capitalize((String)var2_4.substring(0, 3)));
                    var5_5 = 3;
                    ** while (var5_5 < var2_4.length())
                }
lbl-1000:
                // 1 sources

                {
                    if (Character.isDigit(var2_4.charAt(var5_5))) {
                        var3_2.append(var2_4.charAt(var5_5));
                    }
                    ++var5_5;
                    continue;
lbl31:
                    // 1 sources

                    continue block4;
                }
            }
            var3_2.append(TextUtil.capitalize((String)var2_4));
        }
        return var3_2.toString();
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.device.pupNetwork() != null) {
            int n = this.device.pupNetwork().getLog().getSeverity();
            this.device.pupNetwork().getLog().setSeverity(1);
            this.device.pupNetwork().getLog().message("Discover Points Job:" + string);
            this.device.pupNetwork().getLog().setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPupDiscoverPointsJob() {
    }

    public BPupDiscoverPointsJob(BPupDevice bPupDevice, BPupPointDiscoveryConfig bPupPointDiscoveryConfig) {
        this.device = bPupDevice;
        this.config = bPupPointDiscoveryConfig;
    }

    static {
        Class clazz = class$com$tridium$aapup$job$BPupDiscoverPointsJob;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$job$BPupDiscoverPointsJob = BPupDiscoverPointsJob.class("[Lcom.tridium.aapup.job.BPupDiscoverPointsJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Channel {
        int channel;
        String desc;
        String prefix;

        int getChannel() {
            return this.channel;
        }

        String getDesc() {
            return this.desc;
        }

        String getPrefix() {
            return this.prefix;
        }

        public String toString() {
            return "channel:" + Integer.toHexString(this.channel) + ':' + this.desc + ':' + this.prefix;
        }

        Channel(int n, String string, String string2) {
            this.channel = n;
            this.desc = string;
            this.prefix = string2;
        }
    }
}

