/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BPupDeviceDiscoveryConfig;
import com.tridium.aapup.enums.BPupPeerTypeEnum;
import com.tridium.aapup.job.BPupDiscoveryDevice;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupReadAttributeMessage;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupDiscoverDevicesJob
extends BSimpleJob
implements AaPupConst {
    public static final Property learnedDevices = BPupDiscoverDevicesJob.newProperty((int)0, (BValue)new BFolder(), null);
    public static final Topic deviceLearned = BPupDiscoverDevicesJob.newTopic((int)0, null);
    public static final Type TYPE;
    private BPupNetwork network;
    private int startAddress;
    private int stopAddress;
    private BPupPeerTypeEnum peerType;
    private int controllerType;
    private int manufacturer;
    private boolean isVersion8;
    boolean useSerialNumber;
    static /* synthetic */ Class class$com$tridium$aapup$job$BPupDiscoverDevicesJob;

    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    public void setLearnedDevices(BFolder bFolder) {
        this.set(learnedDevices, (BValue)bFolder, null);
    }

    public void fireDeviceLearned(BValue bValue) {
        this.fire(deviceLearned, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        if (this.network == null) {
            throw new IllegalStateException("Must submit thru PupNetwork.submitDeviceDiscoveryJob()");
        }
        if (this.network.isFatalFault()) {
            throw new IllegalStateException(this.network.getFaultCause());
        }
        int n = 0;
        BRelTime bRelTime = BRelTime.make((long)100L);
        if (this.startAddress > this.stopAddress) {
            return;
        }
        if (this.useSerialNumber) {
            this.logMessage("Beginning s/n scan of serial numbers " + this.startAddress + " thru " + this.stopAddress);
        } else {
            this.logMessage("Beginning unit number scan of unit numbers " + this.startAddress + " thru " + this.stopAddress);
        }
        int n2 = this.startAddress;
        while (n2 < this.stopAddress + 1) {
            if (!this.isAlive()) {
                this.logMessage("discovery ended at " + (this.useSerialNumber ? "s/n " : "unit number ") + n2);
                break;
            }
            if (n2 % 1000 == 0) {
                this.logMessage("Scanning " + n2 + " and up...");
            }
            int n3 = this.useSerialNumber ? n2 | 0x8000 : n2;
            this.peerType = BPupPeerTypeEnum.unknown;
            this.controllerType = 0;
            PupAckResponse pupAckResponse = (PupAckResponse)this.network.sendSync(new PupHelloMessage(n3), bRelTime, n);
            if (pupAckResponse != null) {
                if (pupAckResponse.getIn().verifyChecksum()) {
                    PupNumericDataResponse pupNumericDataResponse;
                    this.logMessage("Found PUP device at " + (this.useSerialNumber ? "s/n " : "unit ") + n2);
                    this.isVersion8 = pupAckResponse.isVersion8Supported();
                    int n4 = pupAckResponse.getIn().getUnitNumber();
                    this.manufacturer = -1;
                    PupResponse pupResponse = (PupResponse)this.network.sendSync(new PupReadAttributeMessage(n4, 65280, "CM"), bRelTime, n);
                    if (pupResponse != null && pupResponse.getIn().verifyChecksum() && pupResponse instanceof PupNumericDataResponse) {
                        pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
                        this.manufacturer = pupNumericDataResponse.getDouble().getInt();
                    }
                    this.controllerType = 0;
                    pupResponse = (PupResponse)this.network.sendSync(new PupReadAttributeMessage(n4, 65280, "CT"), bRelTime, n);
                    if (pupResponse != null && pupResponse.getIn().verifyChecksum() && pupResponse instanceof PupNumericDataResponse) {
                        pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
                        this.controllerType = pupNumericDataResponse.getDouble().getInt();
                    }
                    this.peerType = BPupPeerTypeEnum.unknown;
                    pupResponse = (PupResponse)this.network.sendSync(new PupReadAttributeMessage(n4, 65280, "TP"), bRelTime, n);
                    if (pupResponse != null && pupResponse.getIn().verifyChecksum()) {
                        PupErrorResponse pupErrorResponse;
                        if (pupResponse instanceof PupNumericDataResponse) {
                            pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
                            this.peerType = BPupPeerTypeEnum.make(pupNumericDataResponse.getDouble().getInt());
                        } else if (pupResponse instanceof PupErrorResponse && (pupErrorResponse = (PupErrorResponse)pupResponse).getErrorNumber() == 65532) {
                            this.peerType = BPupPeerTypeEnum.slave;
                        }
                    }
                    String string = this.network.getControllerDescription(this.manufacturer, this.controllerType);
                    BPupDiscoveryDevice bPupDiscoveryDevice = new BPupDiscoveryDevice(n4, this.manufacturer, this.controllerType, string, this.peerType, this.isVersion8);
                    this.getLearnedDevices().add(null, (BValue)bPupDiscoveryDevice);
                    this.fireDeviceLearned((BValue)bPupDiscoveryDevice);
                } else {
                    this.logMessage("bad checksum at " + (this.useSerialNumber ? "s/n " : "unit ") + n2 + "...");
                }
            }
            int n5 = (int)((double)(n2 - this.startAddress + 1) * 100.0 / (double)(this.stopAddress - this.startAddress + 1));
            this.progress(n5);
            ++n2;
        }
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.network != null) {
            int n = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Discover Devices Job:" + string);
            this.network.getLog().setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isVersion8 = false;
        this.useSerialNumber = false;
    }

    public BPupDiscoverDevicesJob() {
        this.this();
    }

    public BPupDiscoverDevicesJob(BPupNetwork bPupNetwork, BPupDeviceDiscoveryConfig bPupDeviceDiscoveryConfig) {
        this.this();
        this.network = bPupNetwork;
        this.startAddress = bPupDeviceDiscoveryConfig.getStartAddress();
        this.stopAddress = bPupDeviceDiscoveryConfig.getStopAddress();
        this.useSerialNumber = bPupDeviceDiscoveryConfig.getSearchBy();
    }

    static {
        Class clazz = class$com$tridium$aapup$job$BPupDiscoverDevicesJob;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$job$BPupDiscoverDevicesJob = BPupDiscoverDevicesJob.class("[Lcom.tridium.aapup.job.BPupDiscoverDevicesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

