/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.BPupRegionsFolder;
import com.tridium.aapup.datatypes.BDownloadRegionParams;
import com.tridium.aapup.datatypes.BPupPointDiscoveryConfig;
import com.tridium.aapup.datatypes.BUploadRegionParams;
import com.tridium.aapup.enums.BPingMessageSelectionEnum;
import com.tridium.aapup.enums.BPupPeerTypeEnum;
import com.tridium.aapup.job.BPupDiscoverPointsJob;
import com.tridium.aapup.job.BPupDownloadRegionJob;
import com.tridium.aapup.job.BPupLearnRegionsJob;
import com.tridium.aapup.job.BPupUploadRegionJob;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupAcknowledgeTransactionMessage;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupFreeRegionMessage;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupReadAttributeMessage;
import com.tridium.aapup.messages.PupReportExceptionMessage;
import com.tridium.aapup.messages.PupReportExceptionResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTimeSyncMessage;
import com.tridium.aapup.point.BPupPointDeviceExt;
import com.tridium.basicdriver.BBasicDevice;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupDevice
extends BBasicDevice
implements AaPupConst,
BIAlarmSource {
    public static final Property unitNumber = BPupDevice.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)((char)-1)));
    public static final Property manufacturer = BPupDevice.newProperty((int)1, (int)-1, null);
    public static final Property controllerType = BPupDevice.newProperty((int)1, (int)-1, null);
    public static final Property serialNumber = BPupDevice.newProperty((int)1, (int)0, null);
    public static final Property controllerDescription = BPupDevice.newProperty((int)1, (String)"", null);
    public static final Property peerType = BPupDevice.newProperty((int)1, (BValue)BPupPeerTypeEnum.slave, null);
    public static final Property allowTokenPassingToThisDevice = BPupDevice.newProperty((int)0, (boolean)true, null);
    public static final Property version = BPupDevice.newProperty((int)1, (boolean)false, (BFacets)BFacets.makeBoolean((String)"version 8 supported", (String)"version 8 not supported"));
    public static final Property pingMessageType = BPupDevice.newProperty((int)0, (BValue)BPingMessageSelectionEnum.reportExceptionMessage, null);
    public static final Property nativeAlarmSourceInfo = BPupDevice.newProperty((int)0, (BValue)new BAlarmSourceInfo(), null);
    public static final Property regions = BPupDevice.newProperty((int)6, (BValue)new BPupRegionsFolder(), null);
    public static final Property points = BPupDevice.newProperty((int)0, (BValue)new BPupPointDeviceExt(), null);
    public static final Property splFile = BPupDevice.newProperty((int)4, (BValue)BOrd.make((String)"local:|file:/default.plb"), null);
    public static final Property allowTimeSync = BPupDevice.newProperty((int)0, (boolean)true, null);
    public static final Action submitPointDiscoveryJob = BPupDevice.newAction((int)4, (BValue)new BPupPointDiscoveryConfig(), null);
    public static final Action submitLearnRegionsJob = BPupDevice.newAction((int)4, (BValue)BInteger.make((int)-1), null);
    public static final Action submitDownloadSplJob = BPupDevice.newAction((int)4, (BValue)new BDownloadRegionParams(), null);
    public static final Action submitUploadRegionJob = BPupDevice.newAction((int)4, (BValue)new BUploadRegionParams(), null);
    public static final Action genTestAlm = BPupDevice.newAction((int)4, null);
    public static final Action syncTime = BPupDevice.newAction((int)0, null);
    public static final Action freeRegion = BPupDevice.newAction((int)4, (BValue)BInteger.make((int)-1), null);
    public static final Action unlockRegion = BPupDevice.newAction((int)4, (BValue)BInteger.make((int)-1), null);
    public static final Action readDeviceValues = BPupDevice.newAction((int)0, null);
    public static final Topic regionChanged = BPupDevice.newTopic((int)0, null);
    public static final Type TYPE;
    public static Lexicon LEXICON;
    private int oldUnitNumber;
    private AlarmSupport alarmSupport;
    static /* synthetic */ Class class$com$tridium$aapup$BPupDevice;

    public int getUnitNumber() {
        return this.getInt(unitNumber);
    }

    public void setUnitNumber(int n) {
        this.setInt(unitNumber, n, null);
    }

    public int getManufacturer() {
        return this.getInt(manufacturer);
    }

    public void setManufacturer(int n) {
        this.setInt(manufacturer, n, null);
    }

    public int getControllerType() {
        return this.getInt(controllerType);
    }

    public void setControllerType(int n) {
        this.setInt(controllerType, n, null);
    }

    public int getSerialNumber() {
        return this.getInt(serialNumber);
    }

    public void setSerialNumber(int n) {
        this.setInt(serialNumber, n, null);
    }

    public String getControllerDescription() {
        return this.getString(controllerDescription);
    }

    public void setControllerDescription(String string) {
        this.setString(controllerDescription, string, null);
    }

    public BPupPeerTypeEnum getPeerType() {
        return (BPupPeerTypeEnum)this.get(peerType);
    }

    public void setPeerType(BPupPeerTypeEnum bPupPeerTypeEnum) {
        this.set(peerType, (BValue)bPupPeerTypeEnum, null);
    }

    public boolean getAllowTokenPassingToThisDevice() {
        return this.getBoolean(allowTokenPassingToThisDevice);
    }

    public void setAllowTokenPassingToThisDevice(boolean bl) {
        this.setBoolean(allowTokenPassingToThisDevice, bl, null);
    }

    public boolean getVersion() {
        return this.getBoolean(version);
    }

    public void setVersion(boolean bl) {
        this.setBoolean(version, bl, null);
    }

    public BPingMessageSelectionEnum getPingMessageType() {
        return (BPingMessageSelectionEnum)this.get(pingMessageType);
    }

    public void setPingMessageType(BPingMessageSelectionEnum bPingMessageSelectionEnum) {
        this.set(pingMessageType, (BValue)bPingMessageSelectionEnum, null);
    }

    public BAlarmSourceInfo getNativeAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(nativeAlarmSourceInfo);
    }

    public void setNativeAlarmSourceInfo(BAlarmSourceInfo bAlarmSourceInfo) {
        this.set(nativeAlarmSourceInfo, (BValue)bAlarmSourceInfo, null);
    }

    public BPupRegionsFolder getRegions() {
        return (BPupRegionsFolder)this.get(regions);
    }

    public void setRegions(BPupRegionsFolder bPupRegionsFolder) {
        this.set(regions, (BValue)bPupRegionsFolder, null);
    }

    public BPupPointDeviceExt getPoints() {
        return (BPupPointDeviceExt)this.get(points);
    }

    public void setPoints(BPupPointDeviceExt bPupPointDeviceExt) {
        this.set(points, (BValue)bPupPointDeviceExt, null);
    }

    public BOrd getSplFile() {
        return (BOrd)this.get(splFile);
    }

    public void setSplFile(BOrd bOrd) {
        this.set(splFile, (BValue)bOrd, null);
    }

    public boolean getAllowTimeSync() {
        return this.getBoolean(allowTimeSync);
    }

    public void setAllowTimeSync(boolean bl) {
        this.setBoolean(allowTimeSync, bl, null);
    }

    public BOrd submitPointDiscoveryJob(BPupPointDiscoveryConfig bPupPointDiscoveryConfig) {
        return (BOrd)this.invoke(submitPointDiscoveryJob, (BValue)bPupPointDiscoveryConfig, null);
    }

    public BOrd submitLearnRegionsJob(BInteger bInteger) {
        return (BOrd)this.invoke(submitLearnRegionsJob, (BValue)bInteger, null);
    }

    public BOrd submitDownloadSplJob(BDownloadRegionParams bDownloadRegionParams) {
        return (BOrd)this.invoke(submitDownloadSplJob, (BValue)bDownloadRegionParams, null);
    }

    public BOrd submitUploadRegionJob(BUploadRegionParams bUploadRegionParams) {
        return (BOrd)this.invoke(submitUploadRegionJob, (BValue)bUploadRegionParams, null);
    }

    public void genTestAlm() {
        this.invoke(genTestAlm, null, null);
    }

    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    public void freeRegion(BInteger bInteger) {
        this.invoke(freeRegion, (BValue)bInteger, null);
    }

    public void unlockRegion(BInteger bInteger) {
        this.invoke(unlockRegion, (BValue)bInteger, null);
    }

    public void readDeviceValues() {
        this.invoke(readDeviceValues, null, null);
    }

    public void fireRegionChanged(BValue bValue) {
        this.fire(regionChanged, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getAllowTokenPassingToThisDevice() && this.pupNetwork().getTokenPassConfig().getTokenPassingEnabled()) {
            this.pupNetwork().getPeerList().addRecord(this.getUnitNumber(), this.getPeerType());
        }
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getNativeAlarmSourceInfo());
        this.oldUnitNumber = this.getUnitNumber();
        this.readDeviceValues();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == unitNumber) {
            this.readDeviceValues();
        }
        if (property == unitNumber || property == peerType) {
            this.pupNetwork().getPeerList().removeRecord(this.oldUnitNumber);
            this.oldUnitNumber = this.getUnitNumber();
            if (this.getAllowTokenPassingToThisDevice() && this.pupNetwork().getTokenPassConfig().getTokenPassingEnabled()) {
                this.pupNetwork().getPeerList().addRecord(this.getUnitNumber(), this.getPeerType());
            }
        }
        if (property == allowTokenPassingToThisDevice) {
            if (this.getAllowTokenPassingToThisDevice()) {
                if (this.pupNetwork().getTokenPassConfig().getTokenPassingEnabled()) {
                    this.pupNetwork().getPeerList().addRecord(this.getUnitNumber(), this.getPeerType());
                }
            } else {
                this.pupNetwork().getPeerList().removeRecord(this.getUnitNumber());
            }
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.pupNetwork().getPeerList().removeRecord(this.getUnitNumber());
    }

    public Type getNetworkType() {
        return BPupNetwork.TYPE;
    }

    public BPupNetwork pupNetwork() {
        return (BPupNetwork)this.getNetwork();
    }

    public Log getPupLog() {
        return this.pupNetwork().getPupLog();
    }

    public BOrd doSubmitPointDiscoveryJob(BPupPointDiscoveryConfig bPupPointDiscoveryConfig, Context context) {
        return new BPupDiscoverPointsJob(this, bPupPointDiscoveryConfig).submit(context);
    }

    public BOrd doSubmitLearnRegionsJob(BInteger bInteger, Context context) {
        return new BPupLearnRegionsJob(this, bInteger.getInt()).submit(context);
    }

    public BOrd doSubmitDownloadSplJob(BDownloadRegionParams bDownloadRegionParams) {
        if (bDownloadRegionParams == null) {
            return null;
        }
        return new BPupDownloadRegionJob(this, bDownloadRegionParams).submit(null);
    }

    public BOrd doSubmitUploadRegionJob(BUploadRegionParams bUploadRegionParams) {
        if (bUploadRegionParams == null) {
            return null;
        }
        return new BPupUploadRegionJob(this, bUploadRegionParams).submit(null);
    }

    public void doPing() {
        this.getPupLog().trace("doPing " + this.getUnitNumber());
        switch (this.getPingMessageType().getOrdinal()) {
            case 0: {
                boolean bl = true;
                while (bl) {
                    PupReportExceptionMessage pupReportExceptionMessage = new PupReportExceptionMessage(this.getUnitNumber());
                    PupResponse pupResponse = (PupResponse)this.pupNetwork().sendSync(pupReportExceptionMessage);
                    if (pupResponse != null) {
                        if (pupResponse.getIn().verifyChecksum()) {
                            PupResponse pupResponse2;
                            if (pupResponse.getIn().getUnitNumber() != this.getUnitNumber()) {
                                this.getPupLog().error("Ping: Request to unit " + this.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                                this.pingFail("Requested unit " + this.getUnitNumber() + " but received " + pupResponse.getIn().getUnitNumber());
                                return;
                            }
                            this.getPupLog().trace("Read Succeeded!");
                            if (pupResponse instanceof PupReportExceptionResponse) {
                                pupResponse2 = (PupReportExceptionResponse)pupResponse;
                                this.getPupLog().trace("ping " + this.getUnitNumber() + ":transaction = " + ((PupReportExceptionResponse)pupResponse2).getTransactionNumber());
                                if (((PupReportExceptionResponse)pupResponse2).getTransactionNumber() == 0) {
                                    bl = false;
                                    this.pingOk();
                                    return;
                                }
                                this.generateAlarm((PupReportExceptionResponse)pupResponse2);
                                continue;
                            }
                            if (pupResponse instanceof PupErrorResponse) {
                                pupResponse2 = (PupErrorResponse)pupResponse;
                                this.getPupLog().trace("Received error response pinging " + this.getUnitNumber());
                                this.pingFail(((PupErrorResponse)pupResponse2).getError());
                                return;
                            }
                            this.getPupLog().trace("Received invalid message type pinging " + this.getUnitNumber());
                            this.pingFail("invalid message type");
                            return;
                        }
                        this.getPupLog().trace("Checksum Error pinging " + this.getUnitNumber());
                        this.pingFail("Bad Checksum");
                        return;
                    }
                    this.getPupLog().trace("Ping Failed - no response pinging " + this.getUnitNumber());
                    this.pingFail("No Response");
                    return;
                }
                return;
            }
            case 1: {
                PupHelloMessage pupHelloMessage = new PupHelloMessage(this.getUnitNumber());
                PupResponse pupResponse = (PupResponse)this.pupNetwork().sendSync(pupHelloMessage);
                if (pupResponse != null) {
                    if (pupResponse.getIn().verifyChecksum()) {
                        if (pupResponse.getIn().getUnitNumber() != this.getUnitNumber()) {
                            this.getPupLog().error("Ping: Request to unit " + this.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                            this.pingFail("Requested unit " + this.getUnitNumber() + " but received " + pupResponse.getIn().getUnitNumber());
                            return;
                        }
                        this.getPupLog().trace("Read Succeeded!");
                        if (pupResponse instanceof PupAckResponse) {
                            this.getPupLog().trace("ping " + this.getUnitNumber());
                            this.pingOk();
                            return;
                        }
                        this.getPupLog().trace("Received invalid message type pinging " + this.getUnitNumber());
                        this.pingFail("invalid message type");
                        return;
                    }
                    this.getPupLog().trace("Checksum Error pinging " + this.getUnitNumber());
                    this.pingFail("Bad Checksum");
                    return;
                }
                this.getPupLog().trace("Ping Failed - no response pinging " + this.getUnitNumber());
                this.pingFail("No Response");
                return;
            }
            case 2: {
                PupReadAttributeMessage pupReadAttributeMessage = new PupReadAttributeMessage(this.getUnitNumber(), 65280, "ID");
                PupResponse pupResponse = (PupResponse)this.pupNetwork().sendSync(pupReadAttributeMessage);
                if (pupResponse != null) {
                    if (pupResponse.getIn().verifyChecksum()) {
                        if (pupResponse.getIn().getUnitNumber() != this.getUnitNumber()) {
                            this.getPupLog().error("Ping: Request to unit " + this.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                            this.pingFail("Requested unit " + this.getUnitNumber() + " but received " + pupResponse.getIn().getUnitNumber());
                            return;
                        }
                        this.getPupLog().trace("Read Succeeded!");
                        if (pupResponse instanceof PupNumericDataResponse) {
                            this.getPupLog().trace("ping " + this.getUnitNumber());
                            this.pingOk();
                            return;
                        }
                        if (pupResponse instanceof PupErrorResponse) {
                            PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
                            this.getPupLog().trace("Received error response pinging " + this.getUnitNumber());
                            this.pingFail(pupErrorResponse.getError());
                            return;
                        }
                        this.getPupLog().trace("Received invalid message type pinging " + this.getUnitNumber());
                        this.pingFail("invalid message type");
                        return;
                    }
                    this.getPupLog().trace("Checksum Error pinging " + this.getUnitNumber());
                    this.pingFail("Bad Checksum");
                    return;
                }
                this.getPupLog().trace("Ping Failed - no response pinging " + this.getUnitNumber());
                this.pingFail("No Response");
                return;
            }
        }
        this.pingFail("no message type for ping");
    }

    public void pingOk() {
        if (this.isDown()) {
            this.doSyncTime();
            this.doReadDeviceValues();
        }
        super.pingOk();
    }

    public void doGenTestAlm() {
        System.out.println("new test alarm");
        boolean bl = true;
        PupReportExceptionResponse pupReportExceptionResponse = new PupReportExceptionResponse(bl);
        System.out.println(pupReportExceptionResponse);
        System.out.println("calculated checksum:" + pupReportExceptionResponse.getIn().getCalculatedChecksum());
        this.generateAlarm(pupReportExceptionResponse);
    }

    public void doSyncTime() {
        if (this.getAllowTimeSync()) {
            this.getPupLog().trace("doSyncTime");
            PupTimeSyncMessage pupTimeSyncMessage = new PupTimeSyncMessage(this.getUnitNumber(), BAbsTime.now());
            pupTimeSyncMessage.setHoliday(this.pupNetwork().getHoliday().getBoolean());
            this.pupNetwork().sendSync(pupTimeSyncMessage);
        }
    }

    public void doUnlockRegion(BInteger bInteger) {
        final int n = bInteger.getInt();
        this.getPupLog().trace("doUnlockRegion:" + bInteger.getInt());
        this.pupNetwork().post(new Runnable(){

            public final void run() {
                PupFreeRegionMessage pupFreeRegionMessage = new PupFreeRegionMessage(BPupDevice.this.getUnitNumber(), n, false);
                PupResponse pupResponse = (PupResponse)BPupDevice.this.pupNetwork().sendSync(pupFreeRegionMessage);
                if (pupResponse.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().error("Unlock Region: Request to unit " + BPupDevice.this.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                    return;
                }
                if (pupResponse instanceof PupAckResponse) {
                    BPupDevice.this.getPupLog().message("successfully unlocked region " + n);
                } else {
                    BPupDevice.this.getPupLog().error("unable to unlock region " + n);
                }
                BPupDevice.this.fireRegionChanged((BValue)BString.make((String)""));
            }
        });
    }

    public void doFreeRegion(BInteger bInteger) {
        final int n = bInteger.getInt();
        this.getPupLog().trace("doFreeRegion:" + bInteger.getInt());
        this.pupNetwork().post(new Runnable(){

            public final void run() {
                PupFreeRegionMessage pupFreeRegionMessage = new PupFreeRegionMessage(BPupDevice.this.getUnitNumber(), n, true);
                PupResponse pupResponse = (PupResponse)BPupDevice.this.pupNetwork().sendSync(pupFreeRegionMessage);
                if (pupResponse != null) {
                    if (pupResponse.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                        BPupDevice.this.getPupLog().error("Free Region: Request to unit " + BPupDevice.this.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                    } else if (pupResponse instanceof PupAckResponse) {
                        BPupDevice.this.getPupLog().message("successfully freed region " + n);
                    } else {
                        BPupDevice.this.getPupLog().error("unable to free region " + n);
                    }
                }
                BPupDevice.this.fireRegionChanged((BValue)BString.make((String)""));
            }
        });
    }

    public void doReadDeviceValues() {
        this.getPupLog().trace("doReadDeviceValues:" + this.getUnitNumber());
        this.pupNetwork().post(new Runnable(){

            public final void run() {
                PupNumericDataResponse pupNumericDataResponse;
                PupResponse pupResponse = (PupResponse)BPupDevice.this.pupNetwork().sendSync(new PupReadAttributeMessage(BPupDevice.this.getUnitNumber(), 65280, "CT"));
                if (pupResponse == null) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":no response while determining controller type, defaulting to -1");
                    BPupDevice.this.setControllerType(-1);
                } else if (!pupResponse.getIn().verifyChecksum()) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":checksum error while determining controller type, defaulting to -1");
                    BPupDevice.this.setControllerType(-1);
                } else if (pupResponse.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":while determining controller type, responding unit number " + pupResponse.getIn().getUnitNumber() + " does not equal requested unit number " + BPupDevice.this.getUnitNumber());
                    BPupDevice.this.setControllerType(-1);
                } else if (pupResponse instanceof PupNumericDataResponse) {
                    pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
                    BPupDevice.this.setControllerType(pupNumericDataResponse.getDouble().getInt());
                    BPupDevice.this.getPupLog().message("unit " + BPupDevice.this.getUnitNumber() + ":controller type = " + BPupDevice.this.getControllerType());
                } else {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":invalid response type determining controller type, defaulting to -1");
                    BPupDevice.this.setControllerType(-1);
                }
                pupResponse = (PupResponse)BPupDevice.this.pupNetwork().sendSync(new PupReadAttributeMessage(BPupDevice.this.getUnitNumber(), 65280, "CM"));
                if (pupResponse == null) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":no response while determining manufactuer, defaulting to -1");
                    BPupDevice.this.setManufacturer(-1);
                } else if (!pupResponse.getIn().verifyChecksum()) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":checksum error while determining manufactuer, defaulting to -1");
                    BPupDevice.this.setManufacturer(-1);
                } else if (pupResponse.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":while determining manuf, responding unit number " + pupResponse.getIn().getUnitNumber() + " does not equal requested unit number " + BPupDevice.this.getUnitNumber());
                    BPupDevice.this.setManufacturer(-1);
                } else if (pupResponse instanceof PupNumericDataResponse) {
                    pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
                    BPupDevice.this.setManufacturer(pupNumericDataResponse.getDouble().getInt());
                    BPupDevice.this.getPupLog().message("device " + BPupDevice.this.getUnitNumber() + " manufacturer = " + BPupDevice.this.getManufacturer());
                } else {
                    BPupDevice.this.getPupLog().error("warning - " + BPupDevice.this.getUnitNumber() + ":unable to determine manufacturer, defaulting to -1");
                    BPupDevice.this.setManufacturer(-1);
                }
                int n = BPupDevice.this.getControllerType() < 100 ? 32768 : 65280;
                pupResponse = (PupResponse)BPupDevice.this.pupNetwork().sendSync(new PupReadAttributeMessage(BPupDevice.this.getUnitNumber(), n, "SN"));
                if (pupResponse == null) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":no response while determining sn, defaulting to 0");
                    BPupDevice.this.setSerialNumber(0);
                } else if (!pupResponse.getIn().verifyChecksum()) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":checksum error while determining sn, defaulting to 0");
                    BPupDevice.this.setSerialNumber(0);
                } else if (pupResponse.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":while determining sn, responding unit number " + pupResponse.getIn().getUnitNumber() + " does not equal requested unit number " + BPupDevice.this.getUnitNumber());
                    BPupDevice.this.setSerialNumber(0);
                } else if (pupResponse instanceof PupNumericDataResponse) {
                    pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
                    BPupDevice.this.setSerialNumber(pupNumericDataResponse.getDouble().getInt() & Short.MAX_VALUE);
                } else {
                    BPupDevice.this.getPupLog().error("warning - " + BPupDevice.this.getUnitNumber() + ":unable to determine serial number, defaulting to 0");
                    BPupDevice.this.setSerialNumber(0);
                }
                BPupDevice.this.getPupLog().message("device " + BPupDevice.this.getUnitNumber() + " serial number = " + BPupDevice.this.getSerialNumber());
                BPupDevice.this.setControllerDescription(BPupDevice.this.pupNetwork().getControllerDescription(BPupDevice.this.getManufacturer(), BPupDevice.this.getControllerType()));
                pupResponse = (PupResponse)BPupDevice.this.pupNetwork().sendSync(new PupReadAttributeMessage(BPupDevice.this.getUnitNumber(), 65280, "TP"));
                if (pupResponse == null) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":no response while determining peer type, defaulting to slave");
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                } else if (!pupResponse.getIn().verifyChecksum()) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":checksum error while determining peer type, defaulting to slave");
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                } else if (pupResponse.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                    BPupDevice.this.getPupLog().error("unit " + BPupDevice.this.getUnitNumber() + ":while determining peer type, responding unit number " + pupResponse.getIn().getUnitNumber() + " does not equal requested unit number " + BPupDevice.this.getUnitNumber());
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                } else if (pupResponse instanceof PupNumericDataResponse) {
                    pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.make(pupNumericDataResponse.getDouble().getInt()));
                    BPupDevice.this.getPupLog().message("unit " + BPupDevice.this.getUnitNumber() + ":peer type = " + (Object)((Object)BPupDevice.this.getPeerType()));
                } else if (pupResponse instanceof PupErrorResponse) {
                    PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
                    if (pupErrorResponse.getErrorNumber() == 65532) {
                        BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                        BPupDevice.this.getPupLog().message("unit " + BPupDevice.this.getUnitNumber() + ":peer type = " + (Object)((Object)BPupDevice.this.getPeerType()));
                    } else {
                        BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                        BPupDevice.this.getPupLog().message("unit " + BPupDevice.this.getUnitNumber() + ":error response = " + pupErrorResponse.getErrorNumber() + " ,defaulting to slave");
                    }
                } else {
                    BPupDevice.this.getPupLog().error("warning - unit " + BPupDevice.this.getUnitNumber() + ":unable to determine peer type, defaulting to slave");
                    BPupDevice.this.setPeerType(BPupPeerTypeEnum.slave);
                }
            }
        });
    }

    public void generateAlarm(PupReportExceptionResponse pupReportExceptionResponse) {
        String[] stringArray = new String[2];
        BIDataValue[] bIDataValueArray = new BIDataValue[2];
        String string = "unit:" + this.getUnitNumber() + " class:" + pupReportExceptionResponse.getExceptionClass() + " channel:" + Integer.toHexString(pupReportExceptionResponse.getExceptionChannel()) + " cause:" + pupReportExceptionResponse.getCause() + " desc:" + pupReportExceptionResponse.getExceptionText();
        stringArray[0] = "transaction";
        bIDataValueArray[0] = BInteger.make((int)pupReportExceptionResponse.getTransactionNumber());
        stringArray[1] = "msgText";
        bIDataValueArray[1] = BString.make((String)string);
        BFacets bFacets = BFacets.make((String[])stringArray, (BIDataValue[])bIDataValueArray);
        try {
            if (pupReportExceptionResponse.isReturnToNormal()) {
                this.alarmSupport.toNormal(bFacets);
            } else {
                this.alarmSupport.newOffnormalAlarm(bFacets);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        this.getPupLog().trace("doAckAlarm:" + bAlarmRecord);
        BObject bObject = bAlarmRecord.getAlarmFacet("transaction");
        if (bObject == null) {
            return super.doAckAlarm(bAlarmRecord);
        }
        this.pupNetwork().post(new AlarmTransactionAck(this.pupNetwork(), bAlarmRecord, this));
        return BBoolean.make((boolean)false);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPupDevice() {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    static {
        Class clazz = class$com$tridium$aapup$BPupDevice;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$BPupDevice = BPupDevice.class("[Lcom.tridium.aapup.BPupDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        LEXICON = Lexicon.make((String)"aapup");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AlarmTransactionAck
    implements Runnable {
        BPupDevice source;
        BAlarmRecord alarmRecord;
        BPupNetwork basicNet;
        BRelTime responseTimeout;
        int retryCount;

        public void run() {
            if (this.source == null) {
                return;
            }
            BFacets bFacets = this.alarmRecord.getAlarmData();
            BInteger bInteger = (BInteger)bFacets.get("transaction");
            PupAcknowledgeTransactionMessage pupAcknowledgeTransactionMessage = new PupAcknowledgeTransactionMessage(this.source.getUnitNumber(), bInteger.getInt());
            PupResponse pupResponse = (PupResponse)this.basicNet.sendSync(pupAcknowledgeTransactionMessage, this.responseTimeout, this.retryCount);
            if (pupResponse == null) {
                BPupDevice.this.getPupLog().error("Ack Alarm: no response, unit number " + BPupDevice.this.getUnitNumber());
                return;
            }
            if (pupResponse.getIn().getUnitNumber() != BPupDevice.this.getUnitNumber()) {
                BPupDevice.this.getPupLog().trace("Ack Alarm: Request to unit " + BPupDevice.this.getUnitNumber() + " but received from " + pupResponse.getIn().getUnitNumber());
                return;
            }
            if (pupResponse instanceof PupAckResponse) {
                try {
                    BPupDevice.this.alarmSupport.ackAlarm(this.alarmRecord);
                }
                catch (Exception exception) {
                    BPupDevice.this.getPupLog().error("unable to acknowlege exception from device " + this.source.getUnitNumber() + " ,tranaction=" + bInteger.getInt());
                }
                return;
            }
            if (pupResponse instanceof PupErrorResponse) {
                PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
                if (pupErrorResponse.getErrorNumber() == 65534) {
                    BPupDevice.this.getPupLog().trace("device " + this.source.getUnitNumber() + " does not support native alarm ack");
                    try {
                        BPupDevice.this.alarmSupport.ackAlarm(this.alarmRecord);
                    }
                    catch (Exception exception) {
                        BPupDevice.this.getPupLog().error("unable to acknowlege exception from device " + this.source.getUnitNumber() + " ,tranaction=" + bInteger.getInt());
                    }
                    return;
                }
                BPupDevice.this.getPupLog().error("error response acking transaction from device " + this.source.getUnitNumber() + " ,tranaction=" + bInteger.getInt() + " ,error=" + pupErrorResponse.codeToString(pupErrorResponse.getErrorNumber()));
                return;
            }
            BPupDevice.this.getPupLog().error("invalid response acking transaction from device " + this.source.getUnitNumber() + " ,tranaction=" + bInteger.getInt());
        }

        public AlarmTransactionAck(BPupNetwork bPupNetwork, BAlarmRecord bAlarmRecord, BPupDevice bPupDevice2) {
            this.basicNet = bPupNetwork;
            this.alarmRecord = bAlarmRecord;
            this.source = bPupDevice2;
            this.responseTimeout = BPupDevice.this.pupNetwork().getResponseTimeout();
            this.retryCount = BPupDevice.this.pupNetwork().getRetryCount();
        }
    }
}

