/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dedicatedMicros.comm.req;

import com.tridium.ddfVideo.comm.req.BDdfHttpVideoStreamRequest;
import com.tridium.dedicatedMicros.IDedicatedVideoServer;
import com.tridium.dedicatedMicros.camera.BDedicatedCamera;
import com.tridium.dedicatedMicros.camera.BDedicatedCameraDeviceId;
import com.tridium.dedicatedMicros.comm.BDedicatedCommunicator;
import com.tridium.dedicatedMicros.comm.req.DedicatedHttpReq;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.net.UrlConnection;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDedicatedGetVideoStreamRequest
extends BDdfHttpVideoStreamRequest
implements DedicatedHttpReq {
    public static final Property successfulResponse = BDedicatedGetVideoStreamRequest.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    protected String ipAddress;
    static /* synthetic */ Class class$com$tridium$dedicatedMicros$comm$req$BDedicatedGetVideoStreamRequest;

    public boolean getSuccessfulResponse() {
        return this.getBoolean(successfulResponse);
    }

    public void setSuccessfulResponse(boolean bl) {
        this.setBoolean(successfulResponse, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected int getDmCameraNbr() {
        BDedicatedCameraDeviceId bDedicatedCameraDeviceId = (BDedicatedCameraDeviceId)this.getDeviceId();
        return bDedicatedCameraDeviceId.getCameraId();
    }

    protected void addLiveParametersToUrl(StringBuffer stringBuffer, IDedicatedVideoServer iDedicatedVideoServer, BPlaybackParams bPlaybackParams) {
        BVideoCompressionEnum bVideoCompressionEnum;
        int n;
        if (this.isMultistreamStream()) {
            n = this.getMultistreamStreamMask();
            stringBuffer.append("/display_pic.cgi?seq=").append(Integer.toString(n, 16));
        } else {
            n = this.getDmCameraNbr();
            stringBuffer.append("/display_pic.cgi?cam=").append(n);
        }
        long l = bPlaybackParams.getVideoFacets().geti("dmId", -1) & 0xFFFFFFFF;
        if (l != (long)-1) {
            stringBuffer.append("&id=" + l);
        }
        if ((bVideoCompressionEnum = bPlaybackParams.getCompression()) != BVideoCompressionEnum.high) {
            int n2;
            if (bPlaybackParams.getFrameRate() == BVideoFrameRateEnum.low) {
                n2 = iDedicatedVideoServer.getLoFrameRate();
            } else if (bPlaybackParams.getFrameRate() == BVideoFrameRateEnum.medium) {
                n2 = iDedicatedVideoServer.getMedFrameRate();
            } else if (bPlaybackParams.getFrameRate() == BVideoFrameRateEnum.high) {
                n2 = iDedicatedVideoServer.getHiFrameRate();
            } else {
                throw new BajaRuntimeException("Unsupported frameRate: " + bPlaybackParams.getFrameRate());
            }
            stringBuffer.append("&pps=").append(n2);
        }
    }

    protected static long getControlTimeStampUtc(BPlaybackParams bPlaybackParams) {
        BAbsTime bAbsTime = null;
        long l = -1;
        if (!bPlaybackParams.getTimeIndex().isNull()) {
            bAbsTime = bPlaybackParams.getTimeIndex();
            l = bAbsTime.getMillis() / 1000L;
        }
        return l;
    }

    protected void addReplayParametersToUrl(StringBuffer stringBuffer, BDedicatedCamera bDedicatedCamera, BPlaybackParams bPlaybackParams, long l) {
        BDedicatedCameraDeviceId bDedicatedCameraDeviceId = (BDedicatedCameraDeviceId)this.getDeviceId();
        stringBuffer.append("/replay_pic.cgi?cam=").append(bDedicatedCameraDeviceId.getCameraId());
        long l2 = bPlaybackParams.getVideoFacets().geti("dmId", -1) & 0xFFFFFFFF;
        if (l2 != (long)-1) {
            stringBuffer.append("&id=" + l2);
        }
        stringBuffer.append("&control=");
        switch (bPlaybackParams.getPlaybackType().getOrdinal()) {
            case 1: {
                stringBuffer.append("PLAY");
                if (l == (long)-1) break;
                stringBuffer.append("&time=" + l);
                break;
            }
            case 2: {
                stringBuffer.append("FFWD&ffmult=");
                stringBuffer.append(4 << bPlaybackParams.getPlaybackSpeed().getOrdinal());
                break;
            }
            case 3: {
                stringBuffer.append("FFWD&ffmult=");
                stringBuffer.append(-2 - bPlaybackParams.getPlaybackSpeed().getOrdinal());
                break;
            }
            case 4: {
                stringBuffer.append("RWND&ffmult=");
                stringBuffer.append(4 << bPlaybackParams.getPlaybackSpeed().getOrdinal());
                break;
            }
            case 5: {
                stringBuffer.append("RWND&ffmult=");
                stringBuffer.append(-2 - bPlaybackParams.getPlaybackSpeed().getOrdinal());
                break;
            }
            case 6: {
                stringBuffer.append("STOP");
                if (l == (long)-1) break;
                stringBuffer.append("&time=" + l);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported playback type: " + bPlaybackParams.getPlaybackType());
            }
        }
    }

    protected void addCommonParametersToUrl(StringBuffer stringBuffer, BPlaybackParams bPlaybackParams) {
        BVideoCompressionEnum bVideoCompressionEnum = bPlaybackParams.getCompression();
        if (bVideoCompressionEnum == BVideoCompressionEnum.high) {
            stringBuffer.append("&res=").append(bPlaybackParams.getResolution().getTag());
            stringBuffer.append("&format=mp4");
            stringBuffer.append("&txmode=binary");
        } else {
            stringBuffer.append("&res=").append(bPlaybackParams.getResolution().getTag());
            stringBuffer.append("&format=jfif");
        }
    }

    protected boolean isMultistreamStream() {
        return this.getPlaybackParams().getVideoSourceOrds().equals((Object)BOrdList.NULL) ^ true;
    }

    public int getMultistreamStreamMask() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        if (bIVideoSource instanceof BComponent) {
            BOrdList bOrdList = this.getPlaybackParams().getVideoSourceOrds();
            int n = 0;
            int n2 = 0;
            while (n2 < bOrdList.size()) {
                BOrd bOrd = bOrdList.get(n2);
                BDedicatedCamera bDedicatedCamera = (BDedicatedCamera)bOrd.get((BObject)((BComponent)bIVideoSource));
                BDedicatedCameraDeviceId bDedicatedCameraDeviceId = (BDedicatedCameraDeviceId)bDedicatedCamera.getDeviceId();
                int n3 = bDedicatedCameraDeviceId.getCameraId();
                int n4 = 1 << n3 - 1;
                n |= n4;
                ++n2;
            }
            if (n == 0) {
                throw new IllegalStateException("Expected the multistreamStreamMask not be zero. Please have my program fixed.");
            }
            return n;
        }
        throw new IllegalStateException("Expected for the videoSource to be a BComponent: " + bIVideoSource + " Please have my program fixed.");
    }

    public byte[] toByteArray() {
        BIVideoSource bIVideoSource = this.getVideoSource();
        if (bIVideoSource instanceof IDedicatedVideoServer) {
            IDedicatedVideoServer iDedicatedVideoServer = (IDedicatedVideoServer)bIVideoSource;
            BPlaybackParams bPlaybackParams = this.getPlaybackParams();
            StringBuffer stringBuffer = new StringBuffer("http://").append(this.ipAddress);
            long l = BDedicatedGetVideoStreamRequest.getControlTimeStampUtc(bPlaybackParams);
            switch (bPlaybackParams.getPlaybackType().getOrdinal()) {
                case 0: {
                    this.addLiveParametersToUrl(stringBuffer, iDedicatedVideoServer, bPlaybackParams);
                    break;
                }
                case 6: {
                    if (l == (long)-1) {
                        this.addLiveParametersToUrl(stringBuffer, iDedicatedVideoServer, bPlaybackParams);
                        stringBuffer.append("&fields=1");
                        break;
                    }
                    this.addReplayParametersToUrl(stringBuffer, (BDedicatedCamera)bIVideoSource, bPlaybackParams, l);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.addReplayParametersToUrl(stringBuffer, (BDedicatedCamera)bIVideoSource, bPlaybackParams, l);
                    break;
                }
                default: {
                    throw new BajaRuntimeException("Unrecognized playback type " + bPlaybackParams.getPlaybackType() + ". Please have my program fixed.");
                }
            }
            this.addCommonParametersToUrl(stringBuffer, bPlaybackParams);
            return stringBuffer.toString().getBytes();
        }
        throw new IllegalStateException("Expected for the video source to implement IDedicatedVideoServer: " + bIVideoSource + ". Please have my program fixed.");
    }

    protected String getDedicatedMicrosVideoBoundary(UrlConnection urlConnection) {
        String string = urlConnection.getResponseHeader("Content-type");
        if (string == null) {
            throw new BajaRuntimeException("Could not find the 'Content-type' encoded in HTTP video stream header. Please have the dedicatedMicros driver fixed.");
        }
        int n = string.indexOf("boundary=");
        if (n < 0) {
            return "";
        }
        int n2 = n + 9;
        return "\n--" + string.substring(n2) + '\n';
    }

    public boolean processHttpStream(UrlConnection urlConnection) {
        if (urlConnection.getStatusCode() == 200) {
            return super.processHttpStream(urlConnection);
        }
        throw new BajaRuntimeException("The HTTP Response Code for the recent HTTP request is unacceptable: " + urlConnection.getStatusCode() + " HTTP Message: " + urlConnection.getStatusMessage());
    }

    public void setCommunicator(BDedicatedCommunicator bDedicatedCommunicator) {
        this.ipAddress = bDedicatedCommunicator.getDvrIpAddressText();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$dedicatedMicros$comm$req$BDedicatedGetVideoStreamRequest;
        if (clazz == null) {
            clazz = class$com$tridium$dedicatedMicros$comm$req$BDedicatedGetVideoStreamRequest = BDedicatedGetVideoStreamRequest.class("[Lcom.tridium.dedicatedMicros.comm.req.BDedicatedGetVideoStreamRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

