/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dedicatedMicros.comm.req;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfReadRequest;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddfHttp.comm.BDdfHttpReceiver;
import com.tridium.dedicatedMicros.comm.BDedicatedCommunicator;
import com.tridium.dedicatedMicros.comm.req.DedicatedHttpReq;
import com.tridium.dedicatedMicros.comm.rsp.BDedicatedEventReadResponse;
import com.tridium.dedicatedMicros.comm.rsp.BDedicatedEventReadResponseA;
import com.tridium.dedicatedMicros.event.BDedicatedEventReadParams;
import com.tridium.dedicatedMicros.event.BDedicatedEventTypesEnum;
import java.math.BigInteger;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDedicatedEventReadRequest
extends BDdfReadRequest
implements BIDdfPingRequest,
DedicatedHttpReq {
    public static final Type TYPE;
    protected BDedicatedEventReadResponse firstResponse;
    protected IDdfPingable[] pingableSource;
    protected BigInteger unpluggedCameras;
    protected String dvrIpAddress;
    static /* synthetic */ Class class$com$tridium$dedicatedMicros$comm$req$BDedicatedEventReadRequest;

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        if (iDdfDataFrame instanceof BDdfHttpReceiver.DdfHttpReceiveFrame) {
            BDdfHttpReceiver.DdfHttpReceiveFrame ddfHttpReceiveFrame = (BDdfHttpReceiver.DdfHttpReceiveFrame)iDdfDataFrame;
            if (ddfHttpReceiveFrame.httpException != null) {
                throw new DdfResponseException((Throwable)ddfHttpReceiveFrame.httpException);
            }
        }
        if (this.firstResponse == null) {
            return this.processFirstResponse(iDdfDataFrame);
        }
        return this.processSecondResponse(iDdfDataFrame);
    }

    protected BDedicatedEventReadResponseA processFirstResponse(IDdfDataFrame iDdfDataFrame) {
        String string = new String(iDdfDataFrame.getFrameBytes(), 0, iDdfDataFrame.getFrameSize());
        BDedicatedEventReadParams bDedicatedEventReadParams = (BDedicatedEventReadParams)this.getReadParameters();
        BigInteger bigInteger = BigInteger.ZERO;
        if (bDedicatedEventReadParams.getEventTypeEnum() == BDedicatedEventTypesEnum.motionDetected) {
            String[] stringArray = TextUtil.splitAndTrim((String)string, (char)',');
            if (stringArray == null || stringArray.length == 0) {
                throw new BajaRuntimeException("Invalid HTTP Reply: " + string);
            }
            bigInteger = new BigInteger(stringArray[0], 10);
        } else if (bDedicatedEventReadParams.getEventTypeEnum() == BDedicatedEventTypesEnum.cameraFail) {
            bigInteger = new BigInteger(string, 16);
        } else {
            throw new BajaRuntimeException("Unsupported event type enum: " + bDedicatedEventReadParams.getEventTypeEnum().getDisplayTag(null) + "\nPlease have the driver updated to support it.");
        }
        this.firstResponse = new BDedicatedEventReadResponse(bigInteger);
        return new BDedicatedEventReadResponseA(this.dvrIpAddress);
    }

    protected BDedicatedEventReadResponse processSecondResponse(IDdfDataFrame iDdfDataFrame) {
        String string = new String(iDdfDataFrame.getFrameBytes(), 0, iDdfDataFrame.getFrameSize());
        try {
            long l = Long.parseLong(string) - (long)3;
            this.firstResponse.setCameraTime(BAbsTime.make((long)(l * 1000L)));
        }
        catch (Exception exception) {
            this.firstResponse.setCameraTime(BAbsTime.now());
            System.out.println("DedicatedEventReadRequest error invalid time (" + string + ')');
        }
        return this.firstResponse;
    }

    public byte[] toByteArray() {
        String string = "";
        BDedicatedEventReadParams bDedicatedEventReadParams = (BDedicatedEventReadParams)this.getReadParameters();
        if (bDedicatedEventReadParams.getEventTypeEnum() == BDedicatedEventTypesEnum.motionDetected) {
            string = "vmd_active";
        } else if (bDedicatedEventReadParams.getEventTypeEnum() == BDedicatedEventTypesEnum.cameraFail) {
            string = "cam_fail";
        } else {
            throw new BajaRuntimeException("Unsupported event type enum: " + bDedicatedEventReadParams.getEventTypeEnum().getDisplayTag(null) + "\nPlease have the driver updated to support it.");
        }
        String string2 = "http://" + this.dvrIpAddress + "/variable.cgi?variable=" + string;
        return string2.getBytes();
    }

    public boolean getAutoPingFailOnTimeout() {
        return true;
    }

    public boolean getAutoPingOk() {
        return true;
    }

    public boolean getAutoPingOkLate() {
        return true;
    }

    public IDdfPingable[] getPingableSource() {
        return this.pingableSource;
    }

    public void setPingableSource(IDdfPingable[] iDdfPingableArray) {
        this.pingableSource = iDdfPingableArray;
    }

    public boolean getAutoPingFailOnError() {
        return true;
    }

    public void setCommunicator(BDedicatedCommunicator bDedicatedCommunicator) {
        this.dvrIpAddress = bDedicatedCommunicator.getDvrIpAddressText();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pingableSource = null;
    }

    public BDedicatedEventReadRequest() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$dedicatedMicros$comm$req$BDedicatedEventReadRequest;
        if (clazz == null) {
            clazz = class$com$tridium$dedicatedMicros$comm$req$BDedicatedEventReadRequest = BDedicatedEventReadRequest.class("[Lcom.tridium.dedicatedMicros.comm.req.BDedicatedEventReadRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

