/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.transport.TransactionException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.GrandchildChangedContext;
import javax.baja.bacnet.util.MetaDataContext;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.bacnet.virtual.BBacnetVirtualGateway;
import javax.baja.bacnet.virtual.BBacnetVirtualObject;
import javax.baja.bacnet.virtual.BVirtualPropertyWrite;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetVirtualProperty
extends BVirtualComponent
implements BacnetConst,
BIBacnetPollable,
BIStatus {
    public static final Property propertyId = BBacnetVirtualProperty.newProperty((int)7, (int)85, null);
    public static final Property status = BBacnetVirtualProperty.newProperty((int)3, (BValue)BStatus.stale, null);
    public static final Property useFacets = BBacnetVirtualProperty.newProperty((int)7, (boolean)false, null);
    public static final Type TYPE;
    private static final int FATAL_FAULT = 1;
    private static final int STALE = 2;
    protected static final Lexicon lex;
    static Log log;
    public static final String VALUE = "value";
    protected static final String WRITE_ACTION_NAME;
    private static final String PROPERTY_ARRAY_INDEX = "propertyArrayIndex";
    static final String STATUS_TAG = "status";
    static final int STATUS_TAG_LEN = 7;
    static final String INDEX_TAG = "index=";
    static final int INDEX_TAG_LEN = 6;
    private static final int INVALID_MASK = 22;
    private static AsnInputStream asnIn;
    private PollListEntry[] ples;
    private int oldStatus;
    private int flags;
    private String readFault;
    private String writeFault;
    private boolean pollSubscribed;
    private boolean resolvingAddress;
    private Vector kidSubs;
    protected int DEFAULT_ARRAY_INDEX;
    private Object SUBSCRIPTION_LOCK;
    static /* synthetic */ Class class$javax$baja$bacnet$virtual$BBacnetVirtualProperty;
    static /* synthetic */ Class class$javax$baja$bacnet$util$PollListEntry;

    public int getPropertyId() {
        return this.getInt(propertyId);
    }

    public void setPropertyId(int n) {
        this.setInt(propertyId, n, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public boolean getUseFacets() {
        return this.getBoolean(useFacets);
    }

    public void setUseFacets(boolean bl) {
        this.setBoolean(useFacets, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.kidSubs = new Vector();
        this.updateStatus();
        if (this.getPropertyId() == 85) {
            if (this.object().getPrioritizedPoint()) {
                this.add(WRITE_ACTION_NAME, (BValue)new BVirtualPropertyWrite());
            } else {
                this.add(WRITE_ACTION_NAME, (BValue)new BVirtualPropertyWrite());
            }
        } else {
            this.add(WRITE_ACTION_NAME, (BValue)new BVirtualPropertyWrite());
        }
        this.setArrayIndex();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context == BacnetConst.noWrite) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)status)) {
            return;
        }
        if (log.isTraceOn()) {
            System.out.println("changed(" + property + ", " + context + ") on " + this.getName() + " in " + this.object());
        }
        if (property.getName().equals(VALUE)) {
            byte[] byArray = null;
            int n = -1;
            int n2 = -1;
            if (context instanceof GrandchildChangedContext) {
                GrandchildChangedContext grandchildChangedContext = (GrandchildChangedContext)context;
                n = grandchildChangedContext.getArrayIndex();
                byArray = grandchildChangedContext.getEncodedValue();
            } else {
                byArray = this.encodeValue(this.getValue());
                if (this.usePriority()) {
                    n2 = this.object().getWritePriority();
                }
            }
            this.write(n, byArray, n2);
        }
    }

    public void subscribed() {
        this.pollSubscribe();
    }

    public void unsubscribed() {
        this.stale(true);
        if (this.kidSubs.size() == 0) {
            this.pollUnsubscribe();
        }
        this.ples = null;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetVirtualObject;
    }

    public boolean isChildLegal(BComponent bComponent) {
        return true;
    }

    public String toString(Context context) {
        this.loadSlots();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getStatus().isNull()) {
            stringBuffer.append('-');
        } else {
            stringBuffer.append(this.valueToString(context));
        }
        stringBuffer.append(' ').append(this.getStatus().toString(context));
        return stringBuffer.toString();
    }

    public String debugString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append('=').append(this.getValue()).append(':').append(this.getStatus());
        if (this.getValue() instanceof BBacnetArray) {
            BBacnetArray bBacnetArray = (BBacnetArray)this.getValue();
            int n = bBacnetArray.getSize();
            if (n < 0) {
                stringBuffer.append(" size UNKNOWN");
            }
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(" [").append(n2).append("]=").append(bBacnetArray.getElement(n2));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().equals(VALUE) && this.getUseFacets() && this.object() != null) {
            return this.object().getFacets();
        }
        return slot.getFacets();
    }

    public BValue getValue() {
        return this.get(VALUE);
    }

    public void setValue(BValue bValue) {
        this.setValue(bValue, null);
    }

    public void setValue(BValue bValue, Context context) {
        Property property = this.getProperty(VALUE);
        if (property == null) {
            this.add(VALUE, bValue, 2, context);
        } else {
            this.set(property, bValue, context);
        }
    }

    protected String valueToString(Context context) {
        BValue bValue = this.getValue();
        if (bValue != null && this.object() != null) {
            return bValue.toString((Context)(this.getUseFacets() ? this.object().getFacets() : context));
        }
        return "null";
    }

    protected int getArrayIndex() {
        Property property = this.getProperty(PROPERTY_ARRAY_INDEX);
        if (property != null) {
            return this.getInt(property);
        }
        return this.DEFAULT_ARRAY_INDEX;
    }

    private final void setArrayIndex() {
        String string = SlotPath.unescape((String)this.getName());
        int n = string.indexOf(";");
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!string2.startsWith(INDEX_TAG)) continue;
                string2 = string2.substring(6);
                this.add(PROPERTY_ARRAY_INDEX, (BValue)BInteger.make((int)Integer.parseInt(string2)));
                break;
            }
        }
    }

    public BBacnetVirtualObject object() {
        return (BBacnetVirtualObject)this.getParent();
    }

    public void readOk(BValue bValue) {
        this.setValue(bValue, BacnetConst.noWrite);
        this.stale(false);
        this.readFault = null;
        this.writeFault = null;
        this.updateStatus();
    }

    public void writeOk() {
        this.writeFault = null;
        this.updateStatus();
    }

    public void writeFail(String string) {
        this.writeFault = string;
        this.updateStatus();
    }

    public void updateStatus() {
        this.updateStatus(0, null);
        this.checkSubscription();
    }

    public void updateStatus(int n, BFacets bFacets) {
        int n2 = this.getStatus().getBits();
        BStatus bStatus = this.getDeviceStatus();
        n2 = bStatus.isDisabled() ? (n2 |= 1) : (n2 &= 0xFFFFFFFE);
        n2 = bStatus.isDown() ? (n2 |= 4) : (n2 &= 0xFFFFFFFB);
        n2 = this.fatalFault() || this.readFault != null || this.writeFault != null || bStatus.isFault() ? (n2 |= 2) : (n2 &= 0xFFFFFFFD);
        n2 = this.stale() ? (n2 |= 0x10) : (n2 &= 0xFFFFFFEF);
        if (bFacets != null) {
            n2 = (n & 8) != 0 ? (n2 |= 8) : (n2 &= 0xFFFFFFF7);
        }
        if (this.oldStatus == (n2 |= n) && bFacets == null) {
            return;
        }
        BFacets bFacets2 = BFacets.NULL;
        if ((n2 & 0x16) == 0) {
            bFacets2 = BFacets.make((BFacets)this.getStatus().getFacets(), (BFacets)bFacets);
        }
        this.setStatus(BStatus.make((int)n2, (BFacets)bFacets2));
        this.oldStatus = n2;
    }

    public void childSubscribed(BComponent bComponent) {
        this.kidSubs.add(bComponent);
        if (this.kidSubs.size() == 1) {
            this.pollSubscribe();
        }
    }

    public void childUnsubscribed(BComponent bComponent) {
        this.kidSubs.remove(bComponent);
        if (this.kidSubs.size() == 0 && !this.isSubscribed()) {
            this.pollUnsubscribe();
        }
    }

    protected boolean usePriority() {
        boolean bl = false;
        if (this.getPropertyId() == 85) {
            bl = true;
        }
        return bl;
    }

    protected boolean auditWrites() {
        return ((BBacnetVirtualGateway)this.getVirtualGateway()).getAuditWrites();
    }

    protected String getAuditName() {
        return this.device().getName() + '/' + this.object().getName() + ':' + this.getName();
    }

    public String getReadFault() {
        return this.readFault;
    }

    public String getWriteFault() {
        return this.writeFault;
    }

    public BPollFrequency getPollFrequency() {
        BBacnetTuningPolicy bBacnetTuningPolicy;
        BBacnetVirtualObject bBacnetVirtualObject = this.object();
        if (bBacnetVirtualObject != null && (bBacnetTuningPolicy = bBacnetVirtualObject.getPolicy()) != null) {
            return bBacnetTuningPolicy.getPollFrequency();
        }
        return BPollFrequency.normal;
    }

    public BBacnetDevice device() {
        if (this.getVirtualGateway() == null) {
            return null;
        }
        return ((BBacnetVirtualGateway)this.getVirtualGateway()).device();
    }

    public int getPollableType() {
        return 3;
    }

    public boolean poll() {
        throw new UnsupportedOperationException();
    }

    public void readFail(String string) {
        this.readFault = string;
        this.oldStatus = -1;
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fromEncodedValue(byte[] byArray, BStatus bStatus, Context context) {
        if (log.isTraceOn()) {
            System.out.println("fromEncodedValue() on " + this.object() + '.' + this.getName() + ": ev=" + ByteArrayUtil.toHexString((byte[])byArray));
        }
        try {
            Context context2 = context.getBase();
            if (context2 instanceof MetaDataContext) {
                this.readMetaData(byArray, context, (MetaDataContext)context2);
                return;
            }
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(byArray);
                BValue bValue = BacnetVirtualUtil.readValue(asnIn, this.getValue());
                this.readOk(bValue);
                return;
            }
        }
        catch (Exception exception) {
            log.trace("Exception decoding value for " + this.getName() + ':' + exception + " ev=" + ByteArrayUtil.toHexString((byte[])byArray), (Throwable)exception);
            this.readFail(exception.toString());
        }
    }

    public PollListEntry[] getPollListEntries() {
        String string = SlotPath.unescape((String)this.getName());
        if (this.ples == null) {
            Class clazz = class$javax$baja$bacnet$util$PollListEntry;
            if (clazz == null) {
                clazz = class$javax$baja$bacnet$util$PollListEntry = BBacnetVirtualProperty.class("[Ljavax.baja.bacnet.util.PollListEntry;", false);
            }
            Array array = new Array(clazz);
            int n = -1;
            int n2 = string.indexOf(";");
            if (n2 > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    BacnetConst bacnetConst;
                    BBacnetObjectIdentifier bBacnetObjectIdentifier;
                    Object object;
                    String string2 = stringTokenizer.nextToken();
                    if (string2.startsWith(STATUS_TAG)) {
                        object = this.createObjectPropRef(string2);
                        if (object == null) continue;
                        bBacnetObjectIdentifier = ((BBacnetDeviceObjectPropertyReference)object).getDeviceId();
                        if (!((BBacnetDeviceObjectPropertyReference)object).isDeviceIdUsed() || bBacnetObjectIdentifier.hashCode() == this.device().getObjectId().hashCode()) {
                            array.add((Object)this.createPLE((BBacnetDeviceObjectPropertyReference)object, this.device(), string2));
                            continue;
                        }
                        bacnetConst = this.network().doLookupDeviceById(bBacnetObjectIdentifier);
                        if (bacnetConst != null) {
                            array.add((Object)this.createPLE((BBacnetDeviceObjectPropertyReference)object, (BBacnetDevice)bacnetConst, string2));
                            continue;
                        }
                        throw new IllegalStateException("Cannot find BACnet device for virtual component metadata:" + this + "  ref=" + object);
                    }
                    if (!string2.startsWith(INDEX_TAG)) continue;
                    object = string2.substring(6);
                    try {
                        n = Integer.parseInt((String)object);
                        bBacnetObjectIdentifier = null;
                        bBacnetObjectIdentifier = this.getValue();
                        if (!(bBacnetObjectIdentifier instanceof BBacnetArray)) continue;
                        bacnetConst = (BBacnetArray)((Object)bBacnetObjectIdentifier);
                        if (n == 0) {
                            this.setValue((BValue)BInteger.make((int)-1), BacnetConst.noWrite);
                            continue;
                        }
                        this.setValue((BValue)((BBacnetArray)bacnetConst).getArrayTypeSpec().getResolvedType().getInstance(), BacnetConst.noWrite);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.warning("NumberFormatException for VirtualBacnetProperty Index: " + (String)object, (Throwable)numberFormatException);
                    }
                }
            }
            array.add((Object)new PollListEntry(this.object().getObjectId(), this.getPropertyId(), n, this.device(), this));
            this.ples = (PollListEntry[])array.trim();
        }
        return this.ples;
    }

    private final PollListEntry createPLE(BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference, BBacnetDevice bBacnetDevice, String string) {
        return new PollListEntry(bBacnetDeviceObjectPropertyReference.getObjectId(), bBacnetDeviceObjectPropertyReference.getPropertyId(), bBacnetDeviceObjectPropertyReference.getPropertyArrayIndex(), bBacnetDevice, this, (Context)new MetaDataContext(string));
    }

    private final BBacnetDeviceObjectPropertyReference createObjectPropRef(String string) {
        BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = null;
        if (string == null || string.length() <= 7) {
            bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference();
            bBacnetDeviceObjectPropertyReference.setObjectId(this.object().getObjectId());
            bBacnetDeviceObjectPropertyReference.setPropertyId(111);
        } else {
            string = string.substring(7);
            bBacnetDeviceObjectPropertyReference = BBacnetDeviceObjectPropertyReference.fromString(string);
        }
        return bBacnetDeviceObjectPropertyReference;
    }

    void write(int n, byte[] byArray, int n2) {
        this.network().postWrite(new Write(this.getPropertyId(), n, byArray, n2));
    }

    void write(int n, BValue bValue, int n2) {
        byte[] byArray = this.encodeValue(bValue);
        this.write(n, byArray, n2);
    }

    protected BStatus getDeviceStatus() {
        if (this.device() == null) {
            return BStatus.nullStatus;
        }
        return this.device().getStatus();
    }

    protected BBacnetNetwork network() {
        return ((BBacnetVirtualGateway)this.getVirtualGateway()).network();
    }

    private final void readMetaData(byte[] byArray, Context context, MetaDataContext metaDataContext) throws AsnException {
        PollListEntry pollListEntry = (PollListEntry)context;
        BBacnetObjectIdentifier bBacnetObjectIdentifier = pollListEntry.getObjectId();
        String string = "";
        if (!this.object().getObjectId().equals((Object)bBacnetObjectIdentifier)) {
            string = bBacnetObjectIdentifier.toShortString() + '_';
        }
        int n = pollListEntry.getPropertyId();
        string = string + BBacnetPropertyIdentifier.tag(n);
        PropertyInfo propertyInfo = this.device().getPropertyInfo(pollListEntry.getObjectId().getObjectType(), n);
        BValue bValue = AsnUtil.asnToValue(propertyInfo, byArray);
        if (n == 111) {
            int n2 = 0;
            BBacnetBitString bBacnetBitString = (BBacnetBitString)bValue;
            boolean[] blArray = bBacnetBitString.getBits();
            if (blArray[0]) {
                n2 |= 8;
            }
            if (blArray[1]) {
                n2 |= 2;
            }
            if (blArray[2]) {
                n2 |= 0x20;
            }
            if (blArray[3]) {
                n2 |= 1;
            }
            this.updateStatus(n2, BFacets.make((String)string, (BIDataValue)BString.make((String)bValue.toString())));
        } else if (n == 36) {
            BEnum bEnum = (BEnum)bValue;
            int n3 = 0;
            if (BBacnetEventState.isFault(bEnum)) {
                n3 |= 2;
            } else if (BBacnetEventState.isOffnormal(bEnum)) {
                n3 |= 8;
            }
            this.updateStatus(n3, BFacets.make((String)string, (BIDataValue)BString.make((String)bValue.toString())));
        } else if (n == 103) {
            BEnum bEnum = (BEnum)bValue;
            int n4 = 0;
            if (bEnum.getOrdinal() != 0) {
                n4 |= 2;
            }
            this.updateStatus(n4, BFacets.make((String)string, (BIDataValue)BString.make((String)bValue.toString())));
        } else if (n == 81) {
            boolean bl = ((BBoolean)bValue).getBoolean();
            if (bl) {
                this.updateStatus(1, BFacets.make((String)"outOfService", (BIDataValue)BBoolean.TRUE));
            } else {
                this.updateStatus(0, BFacets.make((String)string, (BIDataValue)BBoolean.FALSE));
            }
        } else {
            this.updateStatus(0, BFacets.make((String)string, (BIDataValue)BString.make((String)bValue.toString())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pollSubscribe() {
        Object object = this.SUBSCRIPTION_LOCK;
        synchronized (object) {
            block3: {
                block4: {
                    if (this.pollSubscribed) break block3;
                    if (!this.device().isAddressValid()) break block4;
                    this.resolvingAddress = false;
                    BBacnetPoll bBacnetPoll = (BBacnetPoll)this.network().getPollService(this);
                    bBacnetPoll.subscribe(this);
                    this.pollSubscribed = true;
                    break block3;
                }
                this.resolvingAddress = true;
                this.device().checkAddress();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pollUnsubscribe() {
        Object object = this.SUBSCRIPTION_LOCK;
        synchronized (object) {
            if (this.pollSubscribed) {
                BBacnetPoll bBacnetPoll = (BBacnetPoll)this.network().getPollService(this);
                bBacnetPoll.unsubscribe(this);
                this.pollSubscribed = false;
            }
            this.resolvingAddress = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkSubscription() {
        Object object = this.SUBSCRIPTION_LOCK;
        synchronized (object) {
            if (this.resolvingAddress && this.resolvingAddress && this.device().isAddressValid()) {
                this.pollSubscribe();
            }
            return;
        }
    }

    byte[] encodeValue(BValue bValue) {
        byte[] byArray = null;
        PropertyInfo propertyInfo = this.device().getPropertyInfo(this.object().getObjectId().getObjectType(), this.getPropertyId());
        byArray = propertyInfo != null ? AsnUtil.toAsn(propertyInfo.getAsnType(), bValue) : AsnUtil.toAsn(bValue);
        return byArray;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        int n;
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetVirtualProperty", 2);
        spyWriter.prop((Object)"oldStatus", this.oldStatus);
        spyWriter.prop((Object)"flags", this.flags);
        spyWriter.prop((Object)"readFault", (Object)this.readFault);
        spyWriter.prop((Object)"writeFault", (Object)this.writeFault);
        if (this.ples != null) {
            spyWriter.prop((Object)"PollListEntries", this.ples.length);
            n = 0;
            while (n < this.ples.length) {
                spyWriter.prop((Object)("  " + n), (Object)this.ples[n]);
                ++n;
            }
        }
        spyWriter.prop((Object)"pollSubscribed", this.pollSubscribed);
        if (this.kidSubs != null) {
            spyWriter.prop((Object)"kidSubs", this.kidSubs.size());
            n = 0;
            Iterator iterator = this.kidSubs.iterator();
            while (iterator.hasNext()) {
                spyWriter.prop((Object)("  " + n++), iterator.next());
            }
        }
        spyWriter.endProps();
    }

    private final boolean fatalFault() {
        boolean bl = false;
        if ((this.flags & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    private final boolean stale() {
        boolean bl = false;
        if ((this.flags & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    private final void stale(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ples = null;
        this.oldStatus = 16;
        this.flags = 2;
        this.readFault = null;
        this.writeFault = null;
        this.pollSubscribed = false;
        this.resolvingAddress = false;
        this.DEFAULT_ARRAY_INDEX = 1;
        this.SUBSCRIPTION_LOCK = new Object();
    }

    public BBacnetVirtualProperty() {
        this.this();
    }

    public BBacnetVirtualProperty(int n, BValue bValue, String string, boolean bl) {
        this.this();
        this.setPropertyId(n);
        this.readFault = string;
        this.setUseFacets(bl);
        this.setValue(bValue);
    }

    static {
        Class clazz = class$javax$baja$bacnet$virtual$BBacnetVirtualProperty;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$virtual$BBacnetVirtualProperty = BBacnetVirtualProperty.class("[Ljavax.baja.bacnet.virtual.BBacnetVirtualProperty;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnet");
        log = Log.getLog((String)"bacnet.virtual");
        WRITE_ACTION_NAME = SlotPath.escape((String)lex.getText("BacnetVirtualProperty.set"));
        asnIn = new AsnInputStream();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Write
    implements Runnable {
        int propId;
        int propertyArrayIndex;
        byte[] encodedValue;
        int priority;

        public void run() {
            try {
                BBacnetVirtualProperty.this.network().getBacnetComm().writeProperty(BBacnetVirtualProperty.this.device().getAddress(), BBacnetVirtualProperty.this.object().getObjectId(), this.propId, this.propertyArrayIndex, this.encodedValue, this.priority);
                BBacnetVirtualProperty.this.writeOk();
            }
            catch (TransactionException transactionException) {
                BBacnetVirtualProperty.this.device().ping();
                log.warning("TransactionException writing " + BBacnetPropertyIdentifier.tag(this.propId) + " in " + this);
                BBacnetVirtualProperty.this.writeFail(transactionException.toString());
            }
            catch (BacnetException bacnetException) {
                bacnetException.printStackTrace();
                log.error("BacnetException writing " + BBacnetPropertyIdentifier.tag(this.propId) + " in " + this);
                BBacnetVirtualProperty.this.writeFail(bacnetException.toString());
            }
        }

        private final /* synthetic */ void this() {
            this.propertyArrayIndex = -1;
            this.encodedValue = null;
            this.priority = -1;
        }

        Write(int n, int n2, byte[] byArray, int n3) {
            this.this();
            if (n == 87) {
                this.propId = 85;
                this.priority = n2;
            } else {
                this.propId = n;
                this.propertyArrayIndex = n2;
                this.priority = n3;
            }
            this.encodedValue = byArray;
        }
    }
}

